/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.util;

import com.eucalyptus.records.Logs;
import com.eucalyptus.walrus.exceptions.WalrusException;
import com.eucalyptus.walrus.util.WalrusProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;

public class WalrusImageUtils {
    private static final Logger LOG = Logger.getLogger(WalrusImageUtils.class);

    public static void decryptImage(String encryptedImageName, String decryptedImageName, Cipher cipher) throws Exception {
        LOG.debug((Object)("Decrypting image file: " + decryptedImageName));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(decryptedImageName)));
        File inFile = new File(encryptedImageName);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inFile));
        int bytesRead = 0;
        byte[] bytes = new byte[8192];
        try {
            byte[] outBytes;
            while ((bytesRead = in.read(bytes)) > 0) {
                outBytes = cipher.update(bytes, 0, bytesRead);
                out.write(outBytes);
            }
            outBytes = cipher.doFinal();
            out.write(outBytes);
            LOG.debug((Object)("Done decrypting: " + encryptedImageName + " into " + decryptedImageName + " successfully"), null);
        }
        catch (IOException ex) {
            LOG.error((Object)("Failed decrypting image file " + encryptedImageName), (Throwable)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
            }
            try {
                in.close();
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assembleParts(String name, List<String> parts) {
        LOG.debug((Object)("Assembling parts for " + name));
        FileOutputStream fileOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileOutputStream = new FileOutputStream(new File(name));
            FileChannel out = fileOutputStream.getChannel();
            for (String partName : parts) {
                fileInputStream = new FileInputStream(new File(partName));
                FileChannel in = fileInputStream.getChannel();
                in.transferTo(0L, in.size(), out);
                in.close();
                fileInputStream.close();
            }
            out.close();
            fileOutputStream.close();
            LOG.debug((Object)("Part assembly for " + name + " completed successfully"));
        }
        catch (Exception ex) {
            LOG.debug((Object)("Part assembly for " + name + " failed"), (Throwable)ex);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
        }
    }

    public static void unzipImage(String decryptedImageName, String tarredImageName) throws Exception {
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(new File(decryptedImageName)));
        File outFile = new File(tarredImageName);
        ReadableByteChannel inChannel = Channels.newChannel(in);
        FileOutputStream fileOutputStream = new FileOutputStream(outFile);
        FileChannel outChannel = fileOutputStream.getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(102400);
        try {
            while (inChannel.read(buffer) != -1) {
                buffer.flip();
                outChannel.write(buffer);
                buffer.clear();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            outChannel.close();
            fileOutputStream.close();
            inChannel.close();
            in.close();
        }
    }

    public static long untarImage(String tarredImageName, String imageName) throws Exception {
        Tar tarrer = new Tar();
        tarrer.untar(tarredImageName, imageName);
        File outFile = new File(imageName);
        if (outFile.exists()) {
            return outFile.length();
        }
        throw new WalrusException("Could not untar image " + imageName);
    }

    private static class Tar {
        private Tar() {
        }

        public void untar(String tarFile, String outFile) {
            try {
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(new String[]{"/bin/tar", "xfO", tarFile});
                StreamConsumer error = new StreamConsumer(proc.getErrorStream());
                StreamConsumer output = new StreamConsumer(proc.getInputStream(), new File(outFile));
                error.start();
                output.start();
                int exitVal = proc.waitFor();
                output.join();
            }
            catch (Exception t) {
                LOG.error((Object)t);
            }
        }
    }

    private static class StreamConsumer
    extends Thread {
        private InputStream is;
        private File file;

        public StreamConsumer(InputStream is) {
            this.is = is;
        }

        public StreamConsumer(InputStream is, File file) {
            this(is);
            this.file = file;
        }

        @Override
        public void run() {
            FilterOutputStream outStream = null;
            try {
                int bytesRead;
                BufferedInputStream inStream = new BufferedInputStream(this.is);
                if (this.file != null) {
                    outStream = new BufferedOutputStream(new FileOutputStream(this.file));
                }
                byte[] bytes = new byte[WalrusProperties.IO_CHUNK_SIZE];
                while ((bytesRead = inStream.read(bytes)) > 0) {
                    if (outStream == null) continue;
                    ((BufferedOutputStream)outStream).write(bytes, 0, bytesRead);
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException ex) {
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e);
                    }
                }
                LOG.error((Object)ex);
            }
        }
    }
}

