/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.storage;

import com.eucalyptus.records.Logs;
import com.eucalyptus.storage.common.ChunkedDataFile;
import com.eucalyptus.storage.common.CompressedChunkedFile;
import com.eucalyptus.storage.common.fs.FileIO;
import com.eucalyptus.storage.common.fs.FileReader;
import com.eucalyptus.storage.common.fs.FileWriter;
import com.eucalyptus.system.BaseDirectory;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.walrus.StorageManager;
import com.eucalyptus.walrus.entities.PartInfo;
import com.eucalyptus.walrus.entities.WalrusInfo;
import com.eucalyptus.walrus.exceptions.WalrusException;
import com.eucalyptus.walrus.msgs.WalrusDataGetResponseType;
import edu.ucsb.eucalyptus.util.StreamConsumer;
import edu.ucsb.eucalyptus.util.SystemUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class FileSystemStorageManager
implements StorageManager {
    public static final String FILE_SEPARATOR = "/";
    public static final String lvmRootDirectory = "/dev";
    private static boolean initialized = false;
    public static final String EUCA_ROOT_WRAPPER = BaseDirectory.LIBEXEC.toString() + "/euca_rootwrap";
    public static final int MAX_LOOP_DEVICES = 256;
    private static Logger LOG = Logger.getLogger(FileSystemStorageManager.class);

    @Override
    public void checkPreconditions() throws EucalyptusCloudException {
        try {
            if (!new File(EUCA_ROOT_WRAPPER).exists()) {
                throw new EucalyptusCloudException("root wrapper (euca_rootwrap) does not exist");
            }
            String returnValue = this.getLvmVersion();
            if (returnValue.length() == 0) {
                throw new EucalyptusCloudException("Is lvm installed?");
            }
            LOG.info((Object)returnValue);
        }
        catch (EucalyptusCloudException ex) {
            String error = "Unable to run command: " + ex.getMessage();
            LOG.error((Object)error);
            throw new EucalyptusCloudException(error);
        }
    }

    @Override
    public boolean bucketExists(String bucket) {
        return new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket).exists();
    }

    @Override
    public boolean objectExists(String bucket, String object) {
        return new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket + FILE_SEPARATOR + object).exists();
    }

    @Override
    public void createBucket(String bucket) throws IOException {
        File bukkit = new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket);
        if (!bukkit.exists() && !bukkit.mkdirs()) {
            throw new IOException("Unable to create bucket: " + bucket);
        }
    }

    @Override
    public long getSize(String bucket, String object) {
        File objectFile = new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket + FILE_SEPARATOR + object);
        if (objectFile.exists()) {
            return objectFile.length();
        }
        return -1L;
    }

    @Override
    public void deleteBucket(String bucket) throws IOException {
        File bukkit = new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket);
        if (bukkit.exists() && !bukkit.delete()) {
            throw new IOException("Unable to delete bucket: " + bucket);
        }
    }

    @Override
    public void createObject(String bucket, String object) throws IOException {
        File objectFile = new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket + FILE_SEPARATOR + object);
        if (!objectFile.exists() && !objectFile.createNewFile()) {
            throw new IOException("Unable to create: " + objectFile.getAbsolutePath());
        }
    }

    @Override
    public FileIO prepareForRead(String bucket, String object) throws Exception {
        return new FileReader(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket + FILE_SEPARATOR + object);
    }

    @Override
    public FileIO prepareForWrite(String bucket, String object) throws Exception {
        return new FileWriter(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket + FILE_SEPARATOR + object);
    }

    @Override
    public int readObject(String bucket, String object, byte[] bytes, long offset) throws IOException {
        return this.readObject(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket + FILE_SEPARATOR + object, bytes, offset);
    }

    @Override
    public int readObject(String path, byte[] bytes, long offset) throws IOException {
        File objectFile = new File(path);
        if (!objectFile.exists()) {
            throw new IOException("Unable to read: " + path);
        }
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(objectFile));
        int bytesRead = 0;
        try {
            if (offset > 0L) {
                inputStream.skip(offset);
            }
            bytesRead = inputStream.read(bytes);
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
            }
        }
        return bytesRead;
    }

    @Override
    public void deleteObject(String bucket, String object) throws IOException {
        File objectFile = new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket + FILE_SEPARATOR + object);
        if (objectFile.exists() && !objectFile.delete()) {
            throw new IOException("Unable to delete: " + objectFile.getAbsolutePath());
        }
    }

    @Override
    public void deleteAbsoluteObject(String object) throws IOException {
        File objectFile = new File(object);
        if (objectFile.exists() && !objectFile.delete()) {
            throw new IOException("Unable to delete: " + object);
        }
    }

    @Override
    public void putObject(String bucket, String object, byte[] base64Data, boolean append) throws IOException {
        File objectFile = new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket + FILE_SEPARATOR + object);
        if (!objectFile.exists()) {
            objectFile.createNewFile();
        }
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(objectFile, append));
        try {
            outputStream.write(base64Data);
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
            }
        }
    }

    @Override
    public void renameObject(String bucket, String oldName, String newName) throws IOException {
        File oldObjectFile = new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket + FILE_SEPARATOR + oldName);
        File newObjectFile = new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket + FILE_SEPARATOR + newName);
        if (oldObjectFile.exists() && !oldObjectFile.renameTo(newObjectFile)) {
            throw new IOException("Unable to rename " + oldObjectFile.getAbsolutePath() + " to " + newObjectFile.getAbsolutePath());
        }
    }

    @Override
    public void copyObject(String sourceBucket, String sourceObject, String destinationBucket, String destinationObject) throws IOException {
        File newObjectFile;
        File oldObjectFile = new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + sourceBucket + FILE_SEPARATOR + sourceObject);
        if (!oldObjectFile.equals(newObjectFile = new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + destinationBucket + FILE_SEPARATOR + destinationObject))) {
            FileInputStream fileInputStream = null;
            AbstractInterruptibleChannel fileIn = null;
            FileOutputStream fileOutputStream = null;
            AbstractInterruptibleChannel fileOut = null;
            try {
                fileInputStream = new FileInputStream(oldObjectFile);
                fileIn = fileInputStream.getChannel();
                fileOutputStream = new FileOutputStream(newObjectFile);
                fileOut = fileOutputStream.getChannel();
                ((FileChannel)fileIn).transferTo(0L, ((FileChannel)fileIn).size(), (WritableByteChannel)((Object)fileOut));
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
                throw ex;
            }
            finally {
                try {
                    if (fileIn != null) {
                        fileIn.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
                try {
                    if (fileOut != null) {
                        fileOut.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyMultipartObject(List<PartInfo> parts, String destinationBucket, String destinationObject) throws Exception {
        block31: {
            Iterator<PartInfo> partIterator = null;
            if (parts != null && (partIterator = parts.iterator()) != null && partIterator.hasNext()) {
                try {
                    File newObjectFile = new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + destinationBucket + FILE_SEPARATOR + destinationObject);
                    FileInputStream fileInputStream = null;
                    AbstractInterruptibleChannel fileIn = null;
                    FileOutputStream fileOutputStream = null;
                    FileChannel fileOut = null;
                    try {
                        fileOutputStream = new FileOutputStream(newObjectFile);
                        fileOut = fileOutputStream.getChannel();
                        PartInfo part = null;
                        File partFile = null;
                        do {
                            part = partIterator.next();
                            partFile = new File(WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + part.getBucketName() + FILE_SEPARATOR + part.getObjectName());
                            fileInputStream = new FileInputStream(partFile);
                            fileIn = fileInputStream.getChannel();
                            ((FileChannel)fileIn).transferTo(0L, ((FileChannel)fileIn).size(), fileOut);
                            try {
                                fileIn.close();
                                fileIn = null;
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Failed to close channel", (Throwable)e);
                            }
                            try {
                                fileInputStream.close();
                                fileInputStream = null;
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Failed to close stream", (Throwable)e);
                            }
                            partFile = null;
                            part = null;
                        } while (partIterator.hasNext());
                        break block31;
                    }
                    finally {
                        if (fileIn != null) {
                            try {
                                fileIn.close();
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Failed to close channel", (Throwable)e);
                            }
                        }
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Failed to close stream", (Throwable)e);
                            }
                        }
                        if (fileOut != null) {
                            try {
                                fileOut.close();
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Failed to close channel", (Throwable)e);
                            }
                        }
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Failed to close stream", (Throwable)e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to copy multipart source object to " + destinationObject), (Throwable)e);
                    throw e;
                }
            }
            LOG.warn((Object)("No parts to copy content from and create " + destinationObject));
        }
    }

    @Override
    public String getObjectPath(String bucket, String object) {
        return WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket + FILE_SEPARATOR + object;
    }

    public long getObjectSize(String bucket, String object) {
        String absoluteObjectPath = WalrusInfo.getWalrusInfo().getStorageDir() + FILE_SEPARATOR + bucket + FILE_SEPARATOR + object;
        File objectFile = new File(absoluteObjectPath);
        if (objectFile.exists()) {
            return objectFile.length();
        }
        return -1L;
    }

    private String removeLoopback(String loDevName) throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{EUCA_ROOT_WRAPPER, "losetup", "-d", loDevName});
    }

    private int losetup(String absoluteFileName, String loDevName) {
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(new String[]{EUCA_ROOT_WRAPPER, "losetup", loDevName, absoluteFileName});
            StreamConsumer error = new StreamConsumer(proc.getErrorStream());
            StreamConsumer output = new StreamConsumer(proc.getInputStream());
            error.start();
            output.start();
            int errorCode = proc.waitFor();
            output.join();
            LOG.info((Object)("losetup " + loDevName + " " + absoluteFileName));
            LOG.info((Object)output.getReturnValue());
            LOG.info((Object)error.getReturnValue());
            return errorCode;
        }
        catch (Exception t) {
            LOG.error((Object)t);
            return -1;
        }
    }

    private String findFreeLoopback() throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{EUCA_ROOT_WRAPPER, "losetup", "-f"}).replaceAll("\n", "");
    }

    private String removeLogicalVolume(String lvName) throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{EUCA_ROOT_WRAPPER, "lvremove", "-f", lvName});
    }

    private String reduceVolumeGroup(String vgName, String pvName) throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{EUCA_ROOT_WRAPPER, "vgreduce", vgName, pvName});
    }

    private String removePhysicalVolume(String loDevName) throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{EUCA_ROOT_WRAPPER, "pvremove", loDevName});
    }

    private String createVolumeFromLv(String lvName, String volumeKey) throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{EUCA_ROOT_WRAPPER, "dd", "if=" + lvName, "of=" + volumeKey, "bs=1M"});
    }

    private String enableLogicalVolume(String lvName) throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{EUCA_ROOT_WRAPPER, "lvchange", "-ay", lvName});
    }

    private String disableLogicalVolume(String lvName) throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{EUCA_ROOT_WRAPPER, "lvchange", "-an", lvName});
    }

    private String removeVolumeGroup(String vgName) throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{EUCA_ROOT_WRAPPER, "vgremove", vgName});
    }

    private String getLvmVersion() throws EucalyptusCloudException {
        return SystemUtil.run((String[])new String[]{EUCA_ROOT_WRAPPER, "lvm", "version"});
    }

    public String createLoopback(String fileName) throws EucalyptusCloudException {
        String loDevName;
        int number_of_retries = 0;
        int status = -1;
        do {
            if ((loDevName = this.findFreeLoopback()).length() <= 0) continue;
            status = this.losetup(fileName, loDevName);
        } while (number_of_retries++ < 256 && status != 0);
        if (status != 0) {
            throw new EucalyptusCloudException("Could not create loopback device for " + fileName + ". Please check the max loop value and permissions");
        }
        return loDevName;
    }

    @Override
    public void enable() throws EucalyptusCloudException {
    }

    @Override
    public void disable() throws EucalyptusCloudException {
    }

    @Override
    public void stop() throws EucalyptusCloudException {
    }

    @Override
    public void check() throws EucalyptusCloudException {
    }

    @Override
    public void start() throws EucalyptusCloudException {
    }

    @Override
    public void getObject(String bucketName, String objectName, WalrusDataGetResponseType response, Long size, Boolean isCompressed) throws WalrusException {
        try {
            RandomAccessFile raf = new RandomAccessFile(new File(this.getObjectPath(bucketName, objectName)), "r");
            isCompressed = isCompressed == null ? false : isCompressed;
            Object file = isCompressed != false ? new CompressedChunkedFile(raf, size.longValue()) : new ChunkedDataFile(raf, 0L, size.longValue(), 8192);
            ArrayList<CompressedChunkedFile> dataStreams = new ArrayList<CompressedChunkedFile>();
            dataStreams.add((CompressedChunkedFile)file);
            response.setDataInputStream(dataStreams);
        }
        catch (IOException ex) {
            throw new WalrusException(ex.getMessage());
        }
    }

    @Override
    public void getObject(String bucketName, String objectName, WalrusDataGetResponseType response, Long byteRangeStart, Long byteRangeEnd, Boolean isCompressed) throws WalrusException {
        try {
            RandomAccessFile raf = new RandomAccessFile(new File(this.getObjectPath(bucketName, objectName)), "r");
            isCompressed = isCompressed == null ? false : isCompressed;
            Object file = isCompressed != false ? new CompressedChunkedFile(raf, byteRangeStart.longValue(), byteRangeEnd.longValue(), (int)Math.min(byteRangeEnd - byteRangeStart, 8192L)) : new ChunkedDataFile(raf, byteRangeStart.longValue(), (long)((int)(byteRangeEnd - byteRangeStart)), (int)Math.min(byteRangeEnd - byteRangeStart, 8192L));
            ArrayList<CompressedChunkedFile> dataStreams = new ArrayList<CompressedChunkedFile>();
            dataStreams.add((CompressedChunkedFile)file);
            response.setDataInputStream(dataStreams);
        }
        catch (IOException ex) {
            throw new WalrusException(ex.getMessage());
        }
    }

    @Override
    public void getMultipartObject(WalrusDataGetResponseType reply, List<PartInfo> parts, Boolean isCompressed) throws WalrusException {
        try {
            ArrayList<CompressedChunkedFile> dataStreams = new ArrayList<CompressedChunkedFile>();
            for (PartInfo part : parts) {
                isCompressed = isCompressed == null ? false : isCompressed;
                RandomAccessFile raf = new RandomAccessFile(new File(this.getObjectPath(part.getBucketName(), part.getObjectName())), "r");
                Object file = isCompressed != false ? new CompressedChunkedFile(raf, part.getSize().longValue()) : new ChunkedDataFile(raf, 0L, part.getSize().longValue(), 8192);
                dataStreams.add((CompressedChunkedFile)file);
            }
            reply.setDataInputStream(dataStreams);
        }
        catch (IOException ex) {
            throw new WalrusException(ex.getMessage());
        }
    }

    @Override
    public void getMultipartObject(WalrusDataGetResponseType reply, List<PartInfo> parts, Boolean isCompressed, Long byteRangeStart, Long byteRangeEnd) throws WalrusException {
        try {
            ArrayList<CompressedChunkedFile> dataStreams = new ArrayList<CompressedChunkedFile>();
            isCompressed = isCompressed == null ? false : isCompressed;
            Long requestedSize = byteRangeEnd - byteRangeStart + 1L;
            Iterator<PartInfo> partIterator = parts.iterator();
            PartInfo part = null;
            Long rangeElapsed = -1L;
            Long startMarker = 0L;
            while (partIterator.hasNext()) {
                part = partIterator.next();
                rangeElapsed = rangeElapsed + part.getSize();
                if (byteRangeStart > rangeElapsed) continue;
                startMarker = part.getSize() - (rangeElapsed - byteRangeStart + 1L);
                break;
            }
            Long bytesRead = 0L;
            Long tempLength = 0L;
            do {
                if (part == null && partIterator.hasNext()) {
                    part = partIterator.next();
                }
                RandomAccessFile raf = new RandomAccessFile(new File(this.getObjectPath(part.getBucketName(), part.getObjectName())), "r");
                tempLength = requestedSize > part.getSize() - startMarker + bytesRead ? Long.valueOf(part.getSize() - startMarker) : Long.valueOf(requestedSize - bytesRead);
                Object file = isCompressed != false ? new CompressedChunkedFile(raf, startMarker.longValue(), tempLength.longValue(), (int)Math.min(tempLength, 8192L)) : new ChunkedDataFile(raf, startMarker.longValue(), tempLength.longValue(), (int)Math.min(tempLength, 8192L));
                dataStreams.add((CompressedChunkedFile)file);
                bytesRead = bytesRead + tempLength;
                startMarker = 0L;
                tempLength = 0L;
                part = null;
            } while (bytesRead < requestedSize && partIterator.hasNext());
            reply.setDataInputStream(dataStreams);
        }
        catch (IOException ex) {
            throw new WalrusException(ex.getMessage());
        }
    }
}

