/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.storage;

import com.eucalyptus.component.Component;
import com.eucalyptus.component.Components;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.walrus.WalrusBackend;
import com.eucalyptus.walrus.entities.DRBDInfo;
import com.eucalyptus.walrus.entities.WalrusInfo;
import com.eucalyptus.walrus.storage.FileSystemStorageManager;
import com.eucalyptus.walrus.util.WalrusProperties;
import edu.ucsb.eucalyptus.util.SystemUtil;
import java.io.File;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class DRBDStorageManager
extends FileSystemStorageManager {
    private static Logger LOG = Logger.getLogger(DRBDStorageManager.class);
    private static final String PRIMARY_ROLE = "Primary";
    private static final String SECONDARY_ROLE = "Secondary";
    private static final String DSTATE_UPTODATE = "UpToDate";
    private static final String DSTATE_UNKNOWN = "Unknown";
    private static final String CSTATE_WFCONNECTION = "WFConnection";
    private static final String CSTATE_CONNECTED = "Connected";

    private String getConnectionStatus() throws ExecutionException, EucalyptusCloudException {
        String returnValue = SystemUtil.run((String[])new String[]{WalrusProperties.EUCA_ROOT_WRAPPER, "drbdadm", "cstate", DRBDInfo.getDRBDInfo().getResource()});
        if (returnValue.length() == 0) {
            throw new EucalyptusCloudException("Unable to get connection status for resource: " + DRBDInfo.getDRBDInfo().getResource());
        }
        return returnValue;
    }

    private String getDataStatus() throws ExecutionException, EucalyptusCloudException {
        String returnValue = SystemUtil.run((String[])new String[]{WalrusProperties.EUCA_ROOT_WRAPPER, "drbdadm", "dstate", DRBDInfo.getDRBDInfo().getResource()});
        if (returnValue.length() == 0) {
            throw new EucalyptusCloudException("Unable to get data status for resource: " + DRBDInfo.getDRBDInfo().getResource());
        }
        return returnValue;
    }

    private String getRole() throws ExecutionException, EucalyptusCloudException {
        String returnValue = SystemUtil.run((String[])new String[]{WalrusProperties.EUCA_ROOT_WRAPPER, "drbdadm", "role", DRBDInfo.getDRBDInfo().getResource()});
        if (returnValue.length() == 0) {
            throw new EucalyptusCloudException("Unable to get role for resource: " + DRBDInfo.getDRBDInfo().getResource());
        }
        return returnValue;
    }

    private void makePrimary() throws ExecutionException, EucalyptusCloudException {
        if (SystemUtil.runAndGetCode((String[])new String[]{WalrusProperties.EUCA_ROOT_WRAPPER, "drbdadm", "primary", DRBDInfo.getDRBDInfo().getResource()}) != 0) {
            throw new EucalyptusCloudException("Unable to make resource " + DRBDInfo.getDRBDInfo().getResource() + " primary");
        }
    }

    private void makeSecondary() throws ExecutionException, EucalyptusCloudException {
        if (SystemUtil.runAndGetCode((String[])new String[]{WalrusProperties.EUCA_ROOT_WRAPPER, "drbdadm", "secondary", DRBDInfo.getDRBDInfo().getResource()}) != 0) {
            throw new EucalyptusCloudException("Unable to make resource " + DRBDInfo.getDRBDInfo().getResource() + " secondary");
        }
    }

    private void connectResource() throws ExecutionException, EucalyptusCloudException {
        if (SystemUtil.runAndGetCode((String[])new String[]{WalrusProperties.EUCA_ROOT_WRAPPER, "drbdadm", "connect", DRBDInfo.getDRBDInfo().getResource()}) != 0) {
            throw new EucalyptusCloudException("Unable to connect resource: " + DRBDInfo.getDRBDInfo().getResource());
        }
    }

    private void disconnectResource() throws ExecutionException, EucalyptusCloudException {
        if (SystemUtil.runAndGetCode((String[])new String[]{WalrusProperties.EUCA_ROOT_WRAPPER, "drbdadm", "disconnect", DRBDInfo.getDRBDInfo().getResource()}) != 0) {
            throw new EucalyptusCloudException("Unable to disconnect resource: " + DRBDInfo.getDRBDInfo().getResource());
        }
    }

    private void generateConfig() {
    }

    private void mountPrimary() throws ExecutionException, EucalyptusCloudException {
        if (SystemUtil.runAndGetCode((String[])new String[]{"mount", DRBDInfo.getDRBDInfo().getBlockDevice()}) != 0) {
            throw new EucalyptusCloudException("Unable to mount " + DRBDInfo.getDRBDInfo().getBlockDevice() + " as " + WalrusInfo.getWalrusInfo().getStorageDir());
        }
        if (SystemUtil.runAndGetCode((String[])new String[]{WalrusProperties.EUCA_ROOT_WRAPPER, "chown", "eucalyptus:eucalyptus", WalrusInfo.getWalrusInfo().getStorageDir()}) != 0) {
            throw new EucalyptusCloudException("Unable to change perms on: " + WalrusInfo.getWalrusInfo().getStorageDir());
        }
        SystemUtil.setEucaReadWriteOnly((String)WalrusInfo.getWalrusInfo().getStorageDir());
    }

    private void unmountPrimary() throws ExecutionException, EucalyptusCloudException {
        if (SystemUtil.runAndGetCode((String[])new String[]{"umount", DRBDInfo.getDRBDInfo().getBlockDevice()}) != 0) {
            throw new EucalyptusCloudException("Unable to unmount " + DRBDInfo.getDRBDInfo().getBlockDevice());
        }
    }

    private boolean isMounted() throws EucalyptusCloudException {
        String returnValue = SystemUtil.run((String[])new String[]{WalrusProperties.EUCA_ROOT_WRAPPER, "cat", "/proc/mounts"});
        return returnValue.length() > 0 && returnValue.contains(DRBDInfo.getDRBDInfo().getBlockDevice());
    }

    private boolean isPrimary() throws EucalyptusCloudException, ExecutionException {
        String roleString = this.getRole();
        String[] roleParts = roleString.split("/");
        if (roleParts.length > 1) {
            return roleParts[0].startsWith(PRIMARY_ROLE);
        }
        throw new EucalyptusCloudException("Unable to parse role.");
    }

    private boolean isSecondary() throws EucalyptusCloudException, ExecutionException {
        String roleString = this.getRole();
        String[] roleParts = roleString.split("/");
        if (roleParts.length > 1) {
            return roleParts[0].startsWith(SECONDARY_ROLE);
        }
        throw new EucalyptusCloudException("Unable to parse role.");
    }

    private boolean isPeerPrimary() throws EucalyptusCloudException, ExecutionException {
        String roleString = this.getRole();
        String[] roleParts = roleString.split("/");
        if (roleParts.length > 1) {
            return roleParts[1].startsWith(PRIMARY_ROLE);
        }
        throw new EucalyptusCloudException("Unable to parse role.");
    }

    private boolean isPeerSecondary() throws EucalyptusCloudException, ExecutionException {
        String roleString = this.getRole();
        String[] roleParts = roleString.split("/");
        if (roleParts.length > 1) {
            return roleParts[1].startsWith(SECONDARY_ROLE);
        }
        throw new EucalyptusCloudException("Unable to parse role.");
    }

    private boolean isConnected() throws ExecutionException, EucalyptusCloudException {
        String cstateString = this.getConnectionStatus();
        return cstateString != null && cstateString.startsWith(CSTATE_CONNECTED);
    }

    private boolean isUpToDate() throws EucalyptusCloudException, ExecutionException {
        String dstateString = this.getDataStatus();
        String[] dstateParts = dstateString.split("/");
        if (dstateParts.length > 1) {
            return dstateParts[0].startsWith(DSTATE_UPTODATE) && dstateParts[1].startsWith(DSTATE_UPTODATE);
        }
        throw new EucalyptusCloudException("Unable to get resource dstate.");
    }

    private void checkLocalDisk() throws EucalyptusCloudException {
        String blockDevice = DRBDInfo.getDRBDInfo().getBlockDevice();
        File mount = new File(blockDevice);
        if (!mount.exists()) {
            throw new EucalyptusCloudException("Block device " + blockDevice + " not found.");
        }
        String storageDir = WalrusInfo.getWalrusInfo().getStorageDir();
        File root = new File(storageDir);
        if (!root.exists()) {
            throw new EucalyptusCloudException("Storage directory " + storageDir + " not found.");
        }
    }

    public void becomeMaster() throws EucalyptusCloudException, ExecutionException {
        this.checkLocalDisk();
        if (!this.isPrimary()) {
            if (this.isPeerPrimary()) {
                throw new EucalyptusCloudException("Peer is primary and I am supposed to be master! Unable to proceed!");
            }
            this.makePrimary();
        }
        if (!this.isConnected()) {
            try {
                this.connectResource();
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        if (!this.isMounted()) {
            try {
                this.mountPrimary();
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                if (this.isPrimary()) {
                    this.makeSecondary();
                }
                throw new EucalyptusCloudException("Unable to mount primary: " + e);
            }
        }
        if (!this.isPrimary()) {
            throw new EucalyptusCloudException("Unable to make resource primary.");
        }
    }

    public void becomeSlave() throws EucalyptusCloudException, ExecutionException {
        this.checkLocalDisk();
        if (this.isMounted()) {
            this.unmountPrimary();
        }
        if (!this.isSecondary()) {
            this.makeSecondary();
        }
        if (!this.isConnected()) {
            try {
                this.connectResource();
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        if (!this.isSecondary()) {
            throw new EucalyptusCloudException("Unable to make resource secondary.");
        }
        if (!this.isPeerPrimary()) {
            LOG.warn((Object)"Warning! Peer is not primary. No usable component?");
        }
    }

    public void secondaryDrasticRecovery() throws ExecutionException, EucalyptusCloudException {
        if (SystemUtil.runAndGetCode((String[])new String[]{WalrusProperties.EUCA_ROOT_WRAPPER, "drbdadm", "--", "--discard-my-data", "connect", DRBDInfo.getDRBDInfo().getResource()}) != 0) {
            throw new EucalyptusCloudException("Unable to recover from split brain for resource: " + DRBDInfo.getDRBDInfo().getResource());
        }
    }

    @Override
    public void enable() throws EucalyptusCloudException {
        try {
            this.becomeMaster();
        }
        catch (ExecutionException e) {
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    @Override
    public void disable() throws EucalyptusCloudException {
        try {
            this.becomeSlave();
        }
        catch (ExecutionException e) {
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    @Override
    public void check() throws EucalyptusCloudException {
        try {
            boolean notConnected = false;
            if (!this.isConnected()) {
                try {
                    this.connectResource();
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
            }
            if (Component.State.ENABLED.equals((Object)Components.lookup(WalrusBackend.class).getState())) {
                if (!this.isPrimary() || !this.isMounted()) {
                    throw new EucalyptusCloudException("I am the master, but not DRBD primary. Please make me primary. Aborting!");
                }
            } else {
                if (this.isConnected() && !this.isUpToDate()) {
                    throw new EucalyptusCloudException("Resource connected but not up to date!");
                }
                if (Component.State.DISABLED.equals((Object)Components.lookup(WalrusBackend.class).getState()) && !this.isSecondary()) {
                    LOG.warn((Object)"I am the slave, but not DRBD secondary. Trying to become secondary...");
                    if (this.isMounted()) {
                        this.unmountPrimary();
                    }
                    this.makeSecondary();
                    if (!this.isSecondary()) {
                        throw new EucalyptusCloudException("Attempt to set secondary failed. Unable to proceed!");
                    }
                }
            }
        }
        catch (ExecutionException ex) {
            throw new EucalyptusCloudException((Throwable)ex);
        }
    }

    @Override
    public void start() throws EucalyptusCloudException {
        try {
            this.becomeSlave();
        }
        catch (ExecutionException e) {
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    @Override
    public void stop() throws EucalyptusCloudException {
        try {
            if (this.isMounted()) {
                this.unmountPrimary();
            }
            if (!this.isSecondary()) {
                this.makeSecondary();
            }
        }
        catch (ExecutionException ex) {
            throw new EucalyptusCloudException((Throwable)ex);
        }
    }
}

