/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.pipeline;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.walrus.WalrusBackend;
import com.eucalyptus.walrus.pipeline.stages.WalrusOutboundStage;
import com.eucalyptus.walrus.pipeline.stages.WalrusPOSTUserAuthenticationStage;
import com.eucalyptus.walrus.pipeline.stages.WalrusRESTBindingStage;
import com.eucalyptus.walrus.pipeline.stages.WalrusRESTExceptionStage;
import com.eucalyptus.walrus.util.WalrusProperties;
import com.eucalyptus.ws.server.FilteredPipeline;
import com.eucalyptus.ws.stages.UnrollableStage;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;

@ComponentPart(value=WalrusBackend.class)
public class WalrusRESTPostPipeline
extends FilteredPipeline {
    private static Logger LOG = Logger.getLogger(WalrusRESTPostPipeline.class);
    private final UnrollableStage auth = new WalrusPOSTUserAuthenticationStage();
    private final UnrollableStage bind = new WalrusRESTBindingStage();
    private final UnrollableStage out = new WalrusOutboundStage();
    private final UnrollableStage exception = new WalrusRESTExceptionStage();

    public boolean checkAccepts(HttpRequest message) {
        return (message.getUri().startsWith(((WalrusBackend)ComponentIds.lookup(WalrusBackend.class)).getServicePath(new String[0])) || message.getHeader("Host") != null && message.getHeader("Host").contains(".walrus")) && !message.getHeaderNames().contains("SOAPAction") && message.getMethod().getName().equals(WalrusProperties.HTTPVerb.POST.toString()) && "multipart/form-data".equals(HttpHeaders.getHeader((HttpMessage)message, (String)"Content-Type"));
    }

    public String getName() {
        return "walrus-rest";
    }

    public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
        this.auth.unrollStage(pipeline);
        this.bind.unrollStage(pipeline);
        this.out.unrollStage(pipeline);
        this.exception.unrollStage(pipeline);
        return pipeline;
    }
}

