/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.pipeline;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.util.dns.DomainNames;
import com.eucalyptus.walrus.WalrusBackend;
import com.eucalyptus.walrus.pipeline.stages.WalrusOutboundStage;
import com.eucalyptus.walrus.pipeline.stages.WalrusRESTBindingStage;
import com.eucalyptus.walrus.pipeline.stages.WalrusRESTExceptionStage;
import com.eucalyptus.walrus.pipeline.stages.WalrusUserAuthenticationStage;
import com.eucalyptus.ws.server.FilteredPipeline;
import com.eucalyptus.ws.stages.UnrollableStage;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.xbill.DNS.Name;

@ComponentPart(value=WalrusBackend.class)
public class WalrusRESTPipeline
extends FilteredPipeline {
    private static Logger LOG = Logger.getLogger(WalrusRESTPipeline.class);
    private static final Splitter hostSplitter = Splitter.on((char)':').limit(2);
    private final UnrollableStage auth = new WalrusUserAuthenticationStage();
    private final UnrollableStage bind = new WalrusRESTBindingStage();
    private final UnrollableStage out = new WalrusOutboundStage();
    private final UnrollableStage exception = new WalrusRESTExceptionStage();
    private final String walrusServicePath = ((WalrusBackend)ComponentIds.lookup(WalrusBackend.class)).getServicePath(new String[0]);

    public boolean checkAccepts(HttpRequest message) {
        String uriPath = message.getUri();
        uriPath = uriPath == null ? "" : uriPath;
        String hostHeader = message.getHeader("Host");
        hostHeader = hostHeader == null ? "" : hostHeader;
        return !WalrusRESTPipeline.isSoapRequest(message) && !WalrusRESTPipeline.isPostRequest(message) && (this.isWalrusHostName(hostHeader) || this.isWalrusServicePathRequest(uriPath, hostHeader));
    }

    private static boolean isPostRequest(HttpRequest message) {
        return message.getMethod().getName().equals(HttpMethod.POST.toString()) && "multipart/form-data".equals(HttpHeaders.getHeader((HttpMessage)message, (String)"Content-Type"));
    }

    private static boolean isSoapRequest(HttpRequest message) {
        return message.getHeaderNames().contains("SOAPAction");
    }

    private boolean isWalrusServicePathRequest(String uriPath, String hostHeader) {
        return this.checkServicePathUri(uriPath) && !this.isWalrusHostName(hostHeader);
    }

    private boolean checkServicePathUri(String uriPath) {
        String tmpUri = uriPath;
        if (!tmpUri.endsWith("/")) {
            tmpUri = tmpUri + "/";
        }
        return tmpUri.startsWith(this.walrusServicePath + "/");
    }

    private boolean isWalrusHostName(String hostHeader) {
        return this.resolvesByHost(hostHeader) || this.maybeBucketHostedStyle(hostHeader);
    }

    private boolean maybeBucketHostedStyle(String fullHostHeader) {
        try {
            return DomainNames.absolute((Name)Name.fromString((String)((String)Iterables.getFirst((Iterable)hostSplitter.split((CharSequence)fullHostHeader), (Object)fullHostHeader)))).subdomain(DomainNames.externalSubdomain(WalrusBackend.class));
        }
        catch (Exception e) {
            LOG.error((Object)("Error parsing domain name from hostname: " + fullHostHeader), (Throwable)e);
            return false;
        }
    }

    public String getName() {
        return "walrus-rest";
    }

    public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
        this.auth.unrollStage(pipeline);
        this.bind.unrollStage(pipeline);
        this.out.unrollStage(pipeline);
        this.exception.unrollStage(pipeline);
        return pipeline;
    }
}

