/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.pipeline;

import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.storage.msgs.BucketLogData;
import com.eucalyptus.walrus.WalrusBucketLogger;
import com.eucalyptus.walrus.msgs.WalrusErrorMessageType;
import com.eucalyptus.walrus.msgs.WalrusResponseType;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class WalrusRESTLoggerOutbound
extends MessageStackHandler {
    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpResponse) {
            WalrusErrorMessageType errorMessage;
            BucketLogData logData;
            MappingHttpResponse httpResponse = (MappingHttpResponse)event.getMessage();
            if (httpResponse.getMessage() instanceof WalrusResponseType) {
                WalrusResponseType response = (WalrusResponseType)httpResponse.getMessage();
                BucketLogData logData2 = response.getLogData();
                if (logData2 != null) {
                    this.computeStats(logData2, httpResponse);
                    response.setLogData(null);
                }
            } else if (httpResponse.getMessage() instanceof WalrusErrorMessageType && (logData = (errorMessage = (WalrusErrorMessageType)httpResponse.getMessage()).getLogData()) != null) {
                this.computeStats(logData, httpResponse);
                logData.setError(errorMessage.getCode());
                errorMessage.setLogData(null);
            }
        }
    }

    private void computeStats(BucketLogData logData, MappingHttpResponse httpResponse) {
        logData.setBytesSent((long)httpResponse.getContent().readableBytes());
        long startTime = logData.getTotalTime();
        long currentTime = System.currentTimeMillis();
        logData.setTotalTime(currentTime - startTime);
        long startTurnAroundTime = logData.getTurnAroundTime();
        logData.setTurnAroundTime(Math.min(currentTime - startTurnAroundTime, logData.getTotalTime()));
        HttpResponseStatus status = httpResponse.getStatus();
        if (status != null) {
            logData.setStatus(Integer.toString(status.getCode()));
        }
        WalrusBucketLogger.getInstance().addLogEntry(logData);
    }
}

