/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.pipeline;

import com.eucalyptus.auth.principal.User;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.storage.msgs.BucketLogData;
import com.eucalyptus.walrus.msgs.WalrusRequestType;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import java.net.InetSocketAddress;
import java.util.Calendar;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;

public class WalrusRESTLoggerInbound
extends MessageStackHandler {
    public void incomingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        WalrusRequestType request;
        BucketLogData logData;
        MappingHttpRequest httpRequest;
        if (event.getMessage() instanceof MappingHttpRequest && (httpRequest = (MappingHttpRequest)event.getMessage()).getMessage() instanceof WalrusRequestType && (logData = (request = (WalrusRequestType)httpRequest.getMessage()).getLogData()) != null) {
            String userAgent;
            long currentTime = System.currentTimeMillis();
            logData.setTotalTime(currentTime);
            logData.setTurnAroundTime(currentTime);
            logData.setUri(httpRequest.getUri());
            String referrer = httpRequest.getHeader("Referer");
            if (referrer != null) {
                logData.setReferrer(referrer);
            }
            if ((userAgent = httpRequest.getHeader("User-Agent")) != null) {
                logData.setUserAgent(userAgent);
            }
            logData.setTimestamp(String.format("[%1$td/%1$tb/%1$tY:%1$tH:%1$tM:%1$tS %1$tz]", Calendar.getInstance()));
            User user = Contexts.lookup((String)httpRequest.getCorrelationId()).getUser();
            if (user != null) {
                logData.setAccessorId(user.getUserId());
            }
            if (request.getBucket() != null) {
                logData.setBucketName(request.getBucket());
            }
            if (request.getKey() != null) {
                logData.setKey(request.getKey());
            }
            if (ctx.getChannel().getRemoteAddress() instanceof InetSocketAddress) {
                InetSocketAddress sockAddress = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
                logData.setSourceAddress(sockAddress.getAddress().getHostAddress());
            }
        }
    }
}

