/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.pipeline;

import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.walrus.exceptions.WalrusException;
import com.eucalyptus.ws.WebServicesException;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class WalrusRESTExceptionHandler
extends SimpleChannelUpstreamHandler {
    private static Logger LOG = Logger.getLogger(WalrusRESTExceptionHandler.class);
    private static String CODE_UNKNOWN = "UNKNOWN";

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel ch = e.getChannel();
        Throwable cause = e.getCause();
        HttpResponseStatus status = null;
        String code = null;
        String resource = null;
        String message = null;
        String requestId = null;
        try {
            if (ch != null) {
                Context context = Contexts.lookup((Channel)ch);
                requestId = context.getCorrelationId();
                Contexts.clear((Context)context);
            }
        }
        catch (Exception ex) {
            LOG.trace((Object)"Error getting request ID or clearing context", (Throwable)ex);
        }
        if (cause instanceof WalrusException) {
            WalrusException walrusEx = (WalrusException)cause;
            status = walrusEx.getStatus();
            code = walrusEx.getCode();
            resource = walrusEx.getResource();
        } else if (cause instanceof WebServicesException) {
            WebServicesException webEx = (WebServicesException)cause;
            status = webEx.getStatus();
            code = CODE_UNKNOWN;
        } else {
            status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            code = CODE_UNKNOWN;
        }
        message = cause.getMessage();
        StringBuilder error = new StringBuilder().append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Error><Code>").append(code != null ? code : new String()).append("</Code><Message>").append(message != null ? message : new String()).append("</Message><Resource>").append(resource != null ? resource : new String()).append("</Resource><RequestId>").append(requestId != null ? requestId : new String()).append("</RequestId></Error>");
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)error, (Charset)Charset.forName("UTF-8"));
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.addHeader("Content-Type", (Object)"text/xml; charset=UTF-8");
        response.addHeader("Content-Length", (Object)String.valueOf(buffer.readableBytes()));
        response.setContent(buffer);
        ChannelFuture writeFuture = Channels.future((Channel)ctx.getChannel());
        writeFuture.addListener(ChannelFutureListener.CLOSE);
        response.addHeader("Connection", (Object)"close");
        if (ctx.getChannel().isConnected()) {
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)writeFuture, (Object)response);
        }
    }
}

