/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.pipeline;

import com.eucalyptus.auth.util.Hashes;
import com.eucalyptus.binding.Binding;
import com.eucalyptus.binding.BindingException;
import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.binding.HttpEmbedded;
import com.eucalyptus.binding.HttpParameterMapping;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.records.Logs;
import com.eucalyptus.storage.msgs.BucketLogData;
import com.eucalyptus.storage.msgs.s3.AccessControlList;
import com.eucalyptus.storage.msgs.s3.AccessControlPolicy;
import com.eucalyptus.storage.msgs.s3.CanonicalUser;
import com.eucalyptus.storage.msgs.s3.Grant;
import com.eucalyptus.storage.msgs.s3.Grantee;
import com.eucalyptus.storage.msgs.s3.Group;
import com.eucalyptus.storage.msgs.s3.LoggingEnabled;
import com.eucalyptus.storage.msgs.s3.MetaDataEntry;
import com.eucalyptus.storage.msgs.s3.Part;
import com.eucalyptus.storage.msgs.s3.TargetGrants;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.XMLParser;
import com.eucalyptus.walrus.WalrusBackend;
import com.eucalyptus.walrus.WalrusBucketLogger;
import com.eucalyptus.walrus.exceptions.NotImplementedException;
import com.eucalyptus.walrus.msgs.WalrusDataGetRequestType;
import com.eucalyptus.walrus.msgs.WalrusDataMessage;
import com.eucalyptus.walrus.msgs.WalrusDataMessenger;
import com.eucalyptus.walrus.msgs.WalrusDataQueue;
import com.eucalyptus.walrus.msgs.WalrusDataRequestType;
import com.eucalyptus.walrus.msgs.WalrusRequestType;
import com.eucalyptus.walrus.pipeline.WalrusAuthenticationHandler;
import com.eucalyptus.walrus.util.WalrusProperties;
import com.eucalyptus.walrus.util.WalrusUtil;
import com.eucalyptus.ws.MethodNotAllowedException;
import com.eucalyptus.ws.handlers.RestfulMarshallingHandler;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import groovy.lang.GroovyObject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.axiom.om.OMElement;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.log4j.Logger;
import org.apache.tools.ant.util.DateUtils;
import org.apache.xml.dtm.ref.DTMNodeList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class WalrusRESTBinding
extends RestfulMarshallingHandler {
    private static Logger LOG = Logger.getLogger(WalrusRESTBinding.class);
    private static final String SERVICE = "service";
    private static final String BUCKET = "bucket";
    private static final String OBJECT = "object";
    private static final Map<String, String> operationMap = WalrusRESTBinding.populateOperationMap();
    private static final Map<String, String> unsupportedOperationMap = WalrusRESTBinding.populateUnsupportedOperationMap();
    private static WalrusDataMessenger putMessenger;
    public static final int DATA_MESSAGE_SIZE = 102400;
    private String key;
    private String randomKey;
    private WalrusDataQueue<WalrusDataMessage> putQueue;
    private final String walrusServicePath = ((WalrusBackend)ComponentIds.lookup(WalrusBackend.class)).getServicePath(new String[0]);

    public WalrusRESTBinding() {
        super("http://walrus.s3.amazonaws.com/doc/2006-03-01");
    }

    public void handleUpstream(ChannelHandlerContext channelHandlerContext, ChannelEvent channelEvent) throws Exception {
        if (Logs.isExtrrreeeme()) {
            Logs.extreme().trace((Object)LogUtil.dumpObject((Object)channelEvent));
        }
        if (channelEvent instanceof MessageEvent) {
            MessageEvent msgEvent = (MessageEvent)channelEvent;
            try {
                this.incomingMessage(channelHandlerContext, msgEvent);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error processing incoming message in Walrus Binding", (Throwable)e);
                Channels.fireExceptionCaught((ChannelHandlerContext)channelHandlerContext, (Throwable)e);
                return;
            }
        } else if ((channelEvent.toString().contains("DISCONNECTED") || channelEvent.toString().contains("CLOSED")) && this.key != null && this.randomKey != null) {
            putMessenger.removeQueue(this.key, this.randomKey);
            this.putQueue = null;
        }
        channelHandlerContext.sendUpstream(channelEvent);
    }

    public void incomingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpRequest) {
            String expect;
            MappingHttpRequest httpRequest = (MappingHttpRequest)event.getMessage();
            BaseMessage msg = (BaseMessage)this.bind(httpRequest);
            httpRequest.setMessage((Object)msg);
            if (msg instanceof WalrusDataGetRequestType) {
                WalrusDataGetRequestType getObject = (WalrusDataGetRequestType)msg;
                getObject.setChannel(ctx.getChannel());
            }
            if (msg instanceof WalrusDataRequestType && (expect = httpRequest.getHeader("Expect")) != null && expect.toLowerCase().equals("100-continue")) {
                DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
                DownstreamMessageEvent newEvent = new DownstreamMessageEvent(ctx.getChannel(), event.getFuture(), (Object)response, null);
                Channel channel = ctx.getChannel();
                if (channel.isConnected()) {
                    ChannelFuture writeFuture = Channels.future((Channel)ctx.getChannel());
                    Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)writeFuture, (Object)response);
                }
                ctx.sendDownstream((ChannelEvent)newEvent);
            }
        } else if (event.getMessage() instanceof HttpChunk && this.putQueue != null) {
            HttpChunk httpChunk = (HttpChunk)event.getMessage();
            this.handleHttpChunk(httpChunk);
        }
    }

    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpResponse) {
            Binding binding;
            MappingHttpResponse httpResponse = (MappingHttpResponse)event.getMessage();
            BaseMessage msg = (BaseMessage)httpResponse.getMessage();
            if (!(msg instanceof EucalyptusErrorMessageType) && !(msg instanceof ExceptionResponseType)) {
                binding = BindingManager.getBinding((String)super.getNamespace());
                if (this.putQueue != null) {
                    this.putQueue = null;
                }
            } else {
                binding = BindingManager.getDefaultBinding();
                if (this.putQueue != null) {
                    this.putQueue = null;
                }
            }
            if (msg != null) {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                binding.toStream((OutputStream)byteOut, (Object)msg);
                byte[] req = byteOut.toByteArray();
                ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])req);
                httpResponse.addHeader("Content-Length", (Object)String.valueOf(buffer.readableBytes()));
                httpResponse.addHeader("Content-Type", (Object)"application/xml");
                httpResponse.setContent(buffer);
            }
        }
    }

    private static Map<String, String> populateOperationMap() {
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put(SERVICE + WalrusProperties.HTTPVerb.GET.toString(), "ListAllMyBuckets");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.HEAD.toString(), "HeadBucket");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.acl.toString(), "GetBucketAccessControlPolicy");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.BucketParameter.acl.toString(), "SetRESTBucketAccessControlPolicy");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString(), "ListBucket");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.prefix.toString(), "ListBucket");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.maxkeys.toString(), "ListBucket");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.marker.toString(), "ListBucket");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.delimiter.toString(), "ListBucket");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.PUT.toString(), "CreateBucket");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.DELETE.toString(), "DeleteBucket");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.location.toString(), "GetBucketLocation");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.logging.toString(), "GetBucketLoggingStatus");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.BucketParameter.logging.toString(), "SetBucketLoggingStatus");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.versions.toString(), "ListVersions");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.versioning.toString(), "GetBucketVersioningStatus");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.BucketParameter.versioning.toString(), "SetBucketVersioningStatus");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.ObjectParameter.acl.toString(), "GetObjectAccessControlPolicy");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.ObjectParameter.acl.toString(), "SetRESTObjectAccessControlPolicy");
        newMap.put(BUCKET + WalrusProperties.HTTPVerb.POST.toString(), "PostObject");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.PUT.toString(), "PutObject");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.PUT.toString() + "x-amz-copy-source".toString(), "CopyObject");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.GET.toString(), "GetObject");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.ObjectParameter.torrent.toString(), "GetObject");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.DELETE.toString(), "DeleteObject");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.HEAD.toString(), "GetObject");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.GET.toString() + "extended", "GetObjectExtended");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.DELETE.toString() + WalrusProperties.ObjectParameter.versionId.toString().toLowerCase(), "DeleteVersion");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.POST.toString() + WalrusProperties.ObjectParameter.uploads.toString(), "InitiateMultipartUpload");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.ObjectParameter.partNumber.toString().toLowerCase() + WalrusProperties.ObjectParameter.uploadId.toString().toLowerCase(), "UploadPart");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.ObjectParameter.uploadId.toString().toLowerCase() + WalrusProperties.ObjectParameter.partNumber.toString().toLowerCase(), "UploadPart");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.POST.toString() + WalrusProperties.ObjectParameter.uploadId.toString().toLowerCase(), "CompleteMultipartUpload");
        newMap.put(OBJECT + WalrusProperties.HTTPVerb.DELETE.toString() + WalrusProperties.ObjectParameter.uploadId.toString().toLowerCase(), "AbortMultipartUpload");
        return newMap;
    }

    private static Map<String, String> populateUnsupportedOperationMap() {
        HashMap<String, String> opsMap = new HashMap<String, String>();
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.cors.toString(), "GET Bucket cors");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.BucketParameter.cors.toString(), "PUT Bucket cors");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.DELETE.toString() + WalrusProperties.BucketParameter.cors.toString(), "DELETE Bucket cors");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.lifecycle.toString(), "GET Bucket lifecycle");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.BucketParameter.lifecycle.toString(), "PUT Bucket lifecycle");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.DELETE.toString() + WalrusProperties.BucketParameter.lifecycle.toString(), "DELETE Bucket lifecycle");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.policy.toString(), "GET Bucket policy");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.BucketParameter.policy.toString(), "PUT Bucket policy");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.DELETE.toString() + WalrusProperties.BucketParameter.policy.toString(), "DELETE Bucket policy");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.notification.toString(), "GET Bucket notification");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.BucketParameter.notification.toString(), "PUT Bucket notification");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.tagging.toString(), "GET Bucket tagging");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.BucketParameter.tagging.toString(), "PUT Bucket tagging");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.DELETE.toString() + WalrusProperties.BucketParameter.tagging.toString(), "DELETE Bucket tagging");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.requestPayment.toString().toLowerCase(), "GET Bucket requestPayment");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.website.toString(), "GET Bucket website");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.BucketParameter.website.toString(), "PUT Bucket website");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.DELETE.toString() + WalrusProperties.BucketParameter.website.toString(), "DELETE Bucket website");
        opsMap.put(BUCKET + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.BucketParameter.uploads.toString(), "List Multipart Uploads");
        opsMap.put(OBJECT + WalrusProperties.HTTPVerb.GET.toString() + WalrusProperties.ObjectParameter.uploadId.toString().toLowerCase(), "List Parts");
        opsMap.put(OBJECT + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.ObjectParameter.uploadId.toString().toLowerCase() + WalrusProperties.ObjectParameter.partNumber.toString().toLowerCase(), "Upload Part");
        opsMap.put(OBJECT + WalrusProperties.HTTPVerb.PUT.toString() + WalrusProperties.ObjectParameter.partNumber.toString().toLowerCase() + WalrusProperties.ObjectParameter.uploadId.toString().toLowerCase(), "Upload Part");
        opsMap.put(OBJECT + WalrusProperties.HTTPVerb.POST.toString() + WalrusProperties.ObjectParameter.uploads.toString(), "Initiate Multipart Upload");
        opsMap.put(OBJECT + WalrusProperties.HTTPVerb.POST.toString() + WalrusProperties.ObjectParameter.uploadId.toString().toLowerCase(), "Complete Multipart Upload");
        opsMap.put(OBJECT + WalrusProperties.HTTPVerb.DELETE.toString() + WalrusProperties.ObjectParameter.uploadId.toString().toLowerCase(), "Abort Multipart Upload");
        return opsMap;
    }

    public Object bind(MappingHttpRequest httpRequest) throws Exception {
        GroovyObject groovyMsg;
        Map<String, String> fieldMap;
        String servicePath = httpRequest.getServicePath();
        HashMap bindingArguments = new HashMap();
        String operationName = this.getOperation(httpRequest, bindingArguments);
        if (operationName == null) {
            throw new MethodNotAllowedException("Could not determine operation name for " + servicePath);
        }
        Map params = httpRequest.getParameters();
        try {
            Class<?> targetType = ClassLoader.getSystemClassLoader().loadClass("com.eucalyptus.walrus.msgs.".concat(operationName).concat("Type"));
            if (!GroovyObject.class.isAssignableFrom(targetType)) {
                throw new Exception();
            }
            fieldMap = this.buildFieldMap(targetType);
            groovyMsg = (GroovyObject)targetType.newInstance();
        }
        catch (Exception e) {
            throw new BindingException("Failed to construct message of type " + operationName);
        }
        this.addLogData((BaseMessage)groovyMsg, bindingArguments);
        List<String> failedMappings = this.populateObject(groovyMsg, fieldMap, params);
        this.populateObjectFromBindingMap(groovyMsg, fieldMap, httpRequest, bindingArguments);
        Context context = Contexts.lookup((String)httpRequest.getCorrelationId());
        this.setRequiredParams(groovyMsg, context);
        if (!params.isEmpty()) {
            params.clear();
        }
        if (!failedMappings.isEmpty()) {
            StringBuilder errMsg = new StringBuilder("Failed to bind the following fields:\n");
            for (String string : failedMappings) {
                errMsg.append(string).append('\n');
            }
            for (Map.Entry entry : params.entrySet()) {
                errMsg.append((String)entry.getKey()).append(" = ").append((String)entry.getValue()).append('\n');
            }
            throw new BindingException(errMsg.toString());
        }
        LOG.trace((Object)groovyMsg.toString());
        try {
            Binding binding = BindingManager.getDefaultBinding();
            OMElement msg = binding.toOM((Object)groovyMsg);
        }
        catch (RuntimeException e) {
            throw new BindingException("Failed to build a valid message: " + e.getMessage());
        }
        return groovyMsg;
    }

    private void addLogData(BaseMessage eucaMsg, Map bindingArguments) {
        String operation;
        if (eucaMsg instanceof WalrusRequestType && (operation = (String)bindingArguments.remove("Operation")) != null) {
            WalrusRequestType request = (WalrusRequestType)eucaMsg;
            BucketLogData logData = WalrusBucketLogger.getInstance().makeLogEntry(UUID.randomUUID().toString());
            logData.setOperation("REST." + operation);
            request.setLogData(logData);
        }
    }

    private void setRequiredParams(GroovyObject msg, Context context) throws Exception {
        msg.setProperty("timeStamp", (Object)new Date());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getOperation(MappingHttpRequest httpRequest, Map operationParams) throws Exception, NotImplementedException {
        String locationConstraint;
        String unsupportedOp;
        String[] target = null;
        String path = this.getOperationPath(httpRequest);
        String targetHost = httpRequest.getHeader("Host");
        if (targetHost.contains(".walrus")) {
            String bucket = targetHost.substring(0, targetHost.indexOf(".walrus"));
            path = "/" + bucket + path;
        }
        if (path.length() > 0) {
            target = WalrusUtil.getTarget(path);
        }
        String verb = httpRequest.getMethod().getName();
        String operationKey = "";
        Map params = httpRequest.getParameters();
        String operationName = null;
        long contentLength = 0L;
        String contentLengthString = httpRequest.getHeader("Content-Length");
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
        }
        if (target == null) {
            operationKey = SERVICE + verb;
        } else if (target.length == 1) {
            if (!target[0].equals("")) {
                operationKey = BUCKET + verb;
                operationParams.put("Bucket", target[0]);
                operationParams.put("Operation", verb.toUpperCase() + "." + "BUCKET");
                if (verb.equals(WalrusProperties.HTTPVerb.POST.toString())) {
                    String successActionRedirect;
                    Map formFields = httpRequest.getFormFields();
                    String objectKey = null;
                    String file = (String)formFields.get(WalrusProperties.FormField.file.toString());
                    String authenticationHeader = "";
                    if (formFields.containsKey(WalrusProperties.FormField.key.toString())) {
                        objectKey = (String)formFields.get(WalrusProperties.FormField.key.toString());
                        objectKey = objectKey.replaceAll("\\$\\{filename\\}", file);
                        operationParams.put("Key", objectKey);
                    }
                    if (formFields.containsKey(WalrusProperties.FormField.acl.toString())) {
                        String acl = (String)formFields.get(WalrusProperties.FormField.acl.toString());
                        httpRequest.addHeader("x-amz-acl", (Object)acl);
                    }
                    if (formFields.containsKey(WalrusProperties.FormField.redirect.toString())) {
                        successActionRedirect = (String)formFields.get(WalrusProperties.FormField.redirect.toString());
                        operationParams.put("SuccessActionRedirect", successActionRedirect);
                    }
                    if (formFields.containsKey(WalrusProperties.FormField.success_action_redirect.toString())) {
                        successActionRedirect = (String)formFields.get(WalrusProperties.FormField.success_action_redirect.toString());
                        operationParams.put("SuccessActionRedirect", successActionRedirect);
                    }
                    if (formFields.containsKey(WalrusProperties.FormField.success_action_status.toString())) {
                        Integer successActionStatus = Integer.parseInt((String)formFields.get(WalrusProperties.FormField.success_action_status.toString()));
                        if (successActionStatus == 200 || successActionStatus == 201) {
                            operationParams.put("SuccessActionStatus", successActionStatus);
                        } else {
                            operationParams.put("SuccessActionStatus", 204);
                        }
                    } else {
                        operationParams.put("SuccessActionStatus", 204);
                    }
                    if (formFields.containsKey("Content-Type")) {
                        operationParams.put("ContentType", formFields.get("Content-Type"));
                    }
                    this.key = target[0] + "." + objectKey;
                    this.randomKey = this.key + "." + Hashes.getRandom((int)10);
                    if (contentLengthString != null) {
                        operationParams.put("ContentLength", new Long(contentLength).toString());
                    }
                    operationParams.put(WalrusProperties.Headers.RandomKey.toString(), this.randomKey);
                    this.putQueue = WalrusRESTBinding.getWriteMessenger().interruptAllAndGetQueue(this.key, this.randomKey);
                    this.handleFirstChunk(httpRequest, (ChannelBuffer)formFields.get("x-ignore-FirstDataChunk"), contentLength);
                } else if (WalrusProperties.HTTPVerb.PUT.toString().equals(verb)) {
                    if (params.containsKey(WalrusProperties.BucketParameter.logging.toString())) {
                        this.getTargetBucketParams(operationParams, httpRequest);
                    } else if (params.containsKey(WalrusProperties.BucketParameter.versioning.toString())) {
                        this.getVersioningStatus(operationParams, httpRequest);
                    }
                }
            } else {
                operationKey = SERVICE + verb;
            }
        } else {
            operationKey = OBJECT + verb;
            String objectKey = target[1];
            try {
                objectKey = WalrusUtil.URLdecode(objectKey);
            }
            catch (UnsupportedEncodingException e) {
                throw new BindingException("Unable to get key: " + e.getMessage());
            }
            operationParams.put("Bucket", target[0]);
            operationParams.put("Key", objectKey);
            operationParams.put("Operation", verb.toUpperCase() + "." + "OBJECT");
            if (!params.containsKey(WalrusProperties.BucketParameter.acl.toString())) {
                if (verb.equals(WalrusProperties.HTTPVerb.PUT.toString())) {
                    if (httpRequest.containsHeader("x-amz-copy-source".toString())) {
                        AccessControlList accessControlList;
                        String copySource = httpRequest.getHeader("x-amz-copy-source".toString());
                        try {
                            copySource = WalrusUtil.URLdecode(copySource);
                        }
                        catch (UnsupportedEncodingException ex) {
                            throw new BindingException("Unable to decode copy source: " + copySource);
                        }
                        String[] sourceParts = copySource.split("\\?");
                        if (sourceParts.length > 1) {
                            operationParams.put("SourceVersionId", sourceParts[1].replaceFirst("versionId=", "").trim());
                        }
                        copySource = sourceParts[0];
                        String[] sourceTarget = WalrusUtil.getTarget(copySource);
                        String sourceObjectKey = "";
                        String sourceSplitOn = "";
                        if (sourceTarget.length <= 1) throw new BindingException("Malformed COPY request");
                        sourceObjectKey = sourceTarget[1];
                        operationParams.put("SourceBucket", sourceTarget[0]);
                        operationParams.put("SourceObject", sourceObjectKey);
                        operationParams.put("DestinationBucket", operationParams.remove("Bucket"));
                        operationParams.put("DestinationObject", operationParams.remove("Key"));
                        String metaDataDirective = httpRequest.getHeader("x-amz-metadata-directive".toString());
                        if (metaDataDirective != null) {
                            operationParams.put("MetadataDirective", metaDataDirective);
                        }
                        if (contentLength > 0L) {
                            accessControlList = null;
                            accessControlList = this.getAccessControlList(httpRequest);
                        } else {
                            accessControlList = new AccessControlList();
                        }
                        operationParams.put("AccessControlList", accessControlList);
                        operationKey = operationKey + "x-amz-copy-source".toString();
                        Set headerNames = httpRequest.getHeaderNames();
                        for (String string : headerNames) {
                            for (WalrusProperties.CopyHeaders header : WalrusProperties.CopyHeaders.values()) {
                                if (!string.replaceAll("-", "").equals(header.toString().toLowerCase())) continue;
                                String value = httpRequest.getHeader(string);
                                this.parseExtendedHeaders(operationParams, header.toString(), value);
                            }
                        }
                    } else {
                        String contentMD5;
                        String contentDisposition;
                        this.key = target[0] + "." + objectKey;
                        this.randomKey = this.key + "." + Hashes.getRandom((int)10);
                        String contentType = httpRequest.getHeader("Content-Type");
                        if (contentType != null) {
                            operationParams.put("ContentType", contentType);
                        }
                        if ((contentDisposition = httpRequest.getHeader("Content-Disposition")) != null) {
                            operationParams.put("ContentDisposition", contentDisposition);
                        }
                        if ((contentMD5 = httpRequest.getHeader("Content-MD5")) != null) {
                            operationParams.put("ContentMD5", contentMD5);
                        }
                        if (contentLengthString != null) {
                            operationParams.put("ContentLength", new Long(contentLength).toString());
                        }
                        operationParams.put(WalrusProperties.Headers.RandomKey.toString(), this.randomKey);
                        this.putQueue = WalrusRESTBinding.getWriteMessenger().interruptAllAndGetQueue(this.key, this.randomKey);
                        this.handleFirstChunk(httpRequest, contentLength);
                    }
                } else if (verb.equals(WalrusProperties.HTTPVerb.GET.toString())) {
                    if (params.containsKey("torrent")) {
                        operationParams.put("GetTorrent", Boolean.TRUE);
                    } else {
                        operationParams.put("GetData", Boolean.TRUE);
                        operationParams.put("InlineData", Boolean.FALSE);
                        operationParams.put("GetMetaData", Boolean.TRUE);
                    }
                    Set headerNames = httpRequest.getHeaderNames();
                    boolean isExtendedGet = false;
                    for (Object key : headerNames) {
                        for (WalrusProperties.ExtendedGetHeaders header : WalrusProperties.ExtendedGetHeaders.values()) {
                            if (!((String)key).replaceAll("-", "").equals(header.toString())) continue;
                            String value = httpRequest.getHeader((String)key);
                            isExtendedGet = true;
                            this.parseExtendedHeaders(operationParams, header.toString(), value);
                        }
                    }
                    if (isExtendedGet) {
                        operationKey = operationKey + "extended";
                        operationParams.put("ReturnCompleteObjectOnConditionFailure", Boolean.FALSE);
                    }
                    if (params.containsKey(WalrusProperties.GetOptionalParameters.IsCompressed.toString())) {
                        Boolean isCompressed = Boolean.parseBoolean((String)params.remove(WalrusProperties.GetOptionalParameters.IsCompressed.toString()));
                        operationParams.put("IsCompressed", isCompressed);
                    }
                } else if (verb.equals(WalrusProperties.HTTPVerb.HEAD.toString())) {
                    operationParams.put("GetData", Boolean.FALSE);
                    operationParams.put("InlineData", Boolean.FALSE);
                    operationParams.put("GetMetaData", Boolean.TRUE);
                } else if (verb.equals(WalrusProperties.HTTPVerb.POST.toString()) && params.containsKey("uploadId")) {
                    operationParams.put("Parts", this.getPartsList(httpRequest));
                }
            }
            if (params.containsKey(WalrusProperties.ObjectParameter.versionId.toString()) && !verb.equals(WalrusProperties.HTTPVerb.DELETE.toString())) {
                operationParams.put("VersionId", params.remove(WalrusProperties.ObjectParameter.versionId.toString()));
            }
        }
        if (verb.equals(WalrusProperties.HTTPVerb.PUT.toString()) && params.containsKey(WalrusProperties.BucketParameter.acl.toString())) {
            operationParams.put("AccessControlPolicy", this.getAccessControlPolicy(httpRequest));
        }
        ArrayList paramsToRemove = new ArrayList();
        boolean addMore = true;
        for (Object key : params.keySet()) {
            String value;
            String keyString = key.toString();
            boolean dontIncludeParam = false;
            for (WalrusAuthenticationHandler.SecurityParameter securityParam : WalrusAuthenticationHandler.SecurityParameter.values()) {
                if (!keyString.equals(securityParam.toString().toLowerCase())) continue;
                dontIncludeParam = true;
                break;
            }
            if (!dontIncludeParam) {
                value = (String)params.get(key);
                if (value != null) {
                    String[] keyStringParts = keyString.split("-");
                    if (keyStringParts.length > 1) {
                        keyString = "";
                        for (int i = 0; i < keyStringParts.length; ++i) {
                            keyString = keyString + this.toUpperFirst(keyStringParts[i]);
                        }
                    } else {
                        keyString = this.toUpperFirst(keyString);
                    }
                }
                dontIncludeParam = true;
                if (operationKey.startsWith(SERVICE)) {
                    for (WalrusProperties.ServiceParameter serviceParameter : WalrusProperties.ServiceParameter.values()) {
                        if (!keyString.toLowerCase().equals(serviceParameter.toString().toLowerCase())) continue;
                        dontIncludeParam = false;
                        break;
                    }
                } else if (operationKey.startsWith(BUCKET)) {
                    for (WalrusProperties.BucketParameter bucketParameter : WalrusProperties.BucketParameter.values()) {
                        if (!keyString.toLowerCase().equals(bucketParameter.toString().toLowerCase())) continue;
                        dontIncludeParam = false;
                        break;
                    }
                } else if (operationKey.startsWith(OBJECT)) {
                    for (WalrusProperties.ObjectParameter objectParameter : WalrusProperties.ObjectParameter.values()) {
                        if (!keyString.toLowerCase().equals(objectParameter.toString().toLowerCase())) continue;
                        dontIncludeParam = false;
                        break;
                    }
                }
                if (dontIncludeParam) {
                    paramsToRemove.add(key);
                }
            }
            if (dontIncludeParam) continue;
            value = (String)params.get(key);
            if (value != null) {
                operationParams.put(keyString, value);
            }
            for (WalrusProperties.SubResource subResource : WalrusProperties.SubResource.values()) {
                if (!keyString.toLowerCase().equals(subResource.toString().toLowerCase())) continue;
                operationKey = operationKey + keyString.toLowerCase();
            }
            paramsToRemove.add(key);
        }
        for (Object key : paramsToRemove) {
            params.remove(key);
        }
        operationName = operationMap.get(operationKey);
        if (operationName == null && (unsupportedOp = unsupportedOperationMap.get(operationKey)) != null) {
            String resourceType = null;
            String resource = null;
            if (target.length < 2) {
                resourceType = BUCKET;
                resource = target[0];
                throw new NotImplementedException(unsupportedOp + " is not implemented", resourceType, resource);
            } else {
                resourceType = OBJECT;
                String delimiter = new String();
                for (int i = 1; i < target.length; ++i) {
                    resource = resource + delimiter + target[i];
                    delimiter = "/";
                }
            }
            throw new NotImplementedException(unsupportedOp + " is not implemented", resourceType, resource);
        }
        if (!"CreateBucket".equals(operationName) || (locationConstraint = this.getLocationConstraint(httpRequest)) == null) return operationName;
        operationParams.put("LocationConstraint", locationConstraint);
        return operationName;
    }

    private void getTargetBucketParams(Map operationParams, MappingHttpRequest httpRequest) throws BindingException {
        String message = this.getMessageString(httpRequest);
        if (message.length() > 0) {
            try {
                XMLParser xmlParser = new XMLParser(message);
                String targetBucket = xmlParser.getValue("//TargetBucket");
                if (targetBucket == null || targetBucket.length() == 0) {
                    return;
                }
                String targetPrefix = xmlParser.getValue("//TargetPrefix");
                ArrayList<Grant> grants = new ArrayList<Grant>();
                List permissions = xmlParser.getValues("//TargetGrants/Grant/Permission");
                if (permissions == null) {
                    throw new BindingException("malformed access control list");
                }
                DTMNodeList grantees = xmlParser.getNodes("//TargetGrants/Grant/Grantee");
                if (grantees == null) {
                    throw new BindingException("malformed access control list");
                }
                for (int i = 0; i < grantees.getLength(); ++i) {
                    Grantee grantee;
                    Grant grant;
                    String id = xmlParser.getValue(grantees.item(i), "ID");
                    if (id.length() > 0) {
                        String canonicalUserName = xmlParser.getValue(grantees.item(i), "DisplayName");
                        grant = new Grant();
                        grantee = new Grantee();
                        grantee.setCanonicalUser(new CanonicalUser(id, canonicalUserName));
                        grant.setGrantee(grantee);
                        grant.setPermission((String)permissions.get(i));
                        grants.add(grant);
                        continue;
                    }
                    String groupUri = xmlParser.getValue(grantees.item(i), "URI");
                    if (groupUri.length() == 0) {
                        throw new BindingException("malformed access control list");
                    }
                    grant = new Grant();
                    grantee = new Grantee();
                    grantee.setGroup(new Group(groupUri));
                    grant.setGrantee(grantee);
                    grant.setPermission((String)permissions.get(i));
                    grants.add(grant);
                }
                TargetGrants targetGrants = new TargetGrants(grants);
                LoggingEnabled loggingEnabled = new LoggingEnabled(targetBucket, targetPrefix, new TargetGrants(grants));
                operationParams.put("LoggingEnabled", loggingEnabled);
            }
            catch (Exception ex) {
                throw new BindingException("Unable to parse logging configuration " + ex.getMessage());
            }
        }
    }

    private void getVersioningStatus(Map operationParams, MappingHttpRequest httpRequest) throws BindingException {
        String message = this.getMessageString(httpRequest);
        if (message.length() > 0) {
            try {
                XMLParser xmlParser = new XMLParser(message);
                String status = xmlParser.getValue("//Status");
                if (status == null || status.length() == 0) {
                    return;
                }
                operationParams.put("VersioningStatus", status);
            }
            catch (Exception ex) {
                throw new BindingException("Unable to parse versioning status " + ex.getMessage());
            }
        }
    }

    private void parseExtendedHeaders(Map operationParams, String headerString, String value) throws BindingException {
        if (headerString.equals(WalrusProperties.ExtendedGetHeaders.Range.toString())) {
            String prefix = "bytes=";
            assert (value.startsWith(prefix));
            String[] values = (value = value.substring(prefix.length())).split("-");
            if (values[0].equals("")) {
                operationParams.put(WalrusProperties.ExtendedHeaderRangeTypes.ByteRangeStart.toString(), new Long(0L));
            } else {
                operationParams.put(WalrusProperties.ExtendedHeaderRangeTypes.ByteRangeStart.toString(), Long.parseLong(values[0]));
            }
            if (values.length < 2 || values[1].equals("")) {
                operationParams.put(WalrusProperties.ExtendedHeaderRangeTypes.ByteRangeEnd.toString(), new Long(-1L));
            } else {
                operationParams.put(WalrusProperties.ExtendedHeaderRangeTypes.ByteRangeEnd.toString(), Long.parseLong(values[1]));
            }
        } else if (WalrusProperties.ExtendedHeaderDateTypes.contains((String)headerString)) {
            try {
                ArrayList<String> dateFormats = new ArrayList<String>();
                dateFormats.add("EEE, dd MMM yyyy HH:mm:ss zzz");
                operationParams.put(headerString, DateUtil.parseDate((String)value, dateFormats));
            }
            catch (Exception ex) {
                try {
                    operationParams.put(headerString, DateUtils.parseIso8601DateTime((String)value));
                }
                catch (ParseException e) {
                    throw new BindingException("Error parsing date value: " + value, (Throwable)e);
                }
            }
        } else {
            operationParams.put(headerString, value);
        }
    }

    private AccessControlPolicy getAccessControlPolicy(MappingHttpRequest httpRequest) throws BindingException {
        AccessControlPolicy accessControlPolicy = new AccessControlPolicy();
        AccessControlList accessControlList = new AccessControlList();
        ArrayList<Grant> grants = new ArrayList<Grant>();
        try {
            String aclString = this.getMessageString(httpRequest);
            if (aclString.length() > 0) {
                XMLParser xmlParser = new XMLParser(aclString);
                String ownerId = xmlParser.getValue("//Owner/ID");
                String displayName = xmlParser.getValue("//Owner/DisplayName");
                CanonicalUser canonicalUser = new CanonicalUser(ownerId, displayName);
                accessControlPolicy.setOwner(canonicalUser);
                List permissions = xmlParser.getValues("//AccessControlList/Grant/Permission");
                if (permissions == null) {
                    throw new BindingException("malformed access control list");
                }
                DTMNodeList grantees = xmlParser.getNodes("//AccessControlList/Grant/Grantee");
                if (grantees == null) {
                    throw new BindingException("malformed access control list");
                }
                for (int i = 0; i < grantees.getLength(); ++i) {
                    Grantee grantee;
                    Grant grant;
                    String canonicalUserName;
                    String id = xmlParser.getValue(grantees.item(i), "ID");
                    if (id.length() > 0) {
                        canonicalUserName = xmlParser.getValue(grantees.item(i), "DisplayName");
                        grant = new Grant();
                        grantee = new Grantee();
                        grantee.setCanonicalUser(new CanonicalUser(id, canonicalUserName));
                        grant.setGrantee(grantee);
                        grant.setPermission((String)permissions.get(i));
                        grants.add(grant);
                        continue;
                    }
                    if (!"".equals(xmlParser.getValue(grantees.item(i), "EmailAddress"))) {
                        canonicalUserName = xmlParser.getValue(grantees.item(i), "DisplayName");
                        grant = new Grant();
                        grantee = new Grantee();
                        String email = xmlParser.getValue(grantees.item(i), "EmailAddress");
                        grantee.setCanonicalUser(new CanonicalUser(email, canonicalUserName));
                        grant.setGrantee(grantee);
                        grant.setPermission((String)permissions.get(i));
                        grants.add(grant);
                        continue;
                    }
                    String groupUri = xmlParser.getValue(grantees.item(i), "URI");
                    if (groupUri.length() == 0) {
                        throw new BindingException("malformed access control list");
                    }
                    grant = new Grant();
                    grantee = new Grantee();
                    grantee.setGroup(new Group(groupUri));
                    grant.setGrantee(grantee);
                    grant.setPermission((String)permissions.get(i));
                    grants.add(grant);
                }
            }
        }
        catch (Exception ex) {
            throw new BindingException("Unable to parse access control policy", (Throwable)ex);
        }
        accessControlList.setGrants(grants);
        accessControlPolicy.setAccessControlList(accessControlList);
        return accessControlPolicy;
    }

    private AccessControlList getAccessControlList(MappingHttpRequest httpRequest) throws BindingException {
        AccessControlList accessControlList = new AccessControlList();
        ArrayList<Grant> grants = new ArrayList<Grant>();
        try {
            String aclString = this.getMessageString(httpRequest);
            if (aclString.length() > 0) {
                XMLParser xmlParser = new XMLParser(aclString);
                String ownerId = xmlParser.getValue("//Owner/ID");
                String displayName = xmlParser.getValue("//Owner/DisplayName");
                List permissions = xmlParser.getValues("/AccessControlList/Grant/Permission");
                if (permissions == null) {
                    throw new BindingException("malformed access control list");
                }
                DTMNodeList grantees = xmlParser.getNodes("/AccessControlList/Grant/Grantee");
                if (grantees == null) {
                    throw new BindingException("malformed access control list");
                }
                for (int i = 0; i < grantees.getLength(); ++i) {
                    Grantee grantee;
                    Grant grant;
                    String canonicalUserName = xmlParser.getValue(grantees.item(i), "DisplayName");
                    if (canonicalUserName.length() > 0) {
                        String id = xmlParser.getValue(grantees.item(i), "ID");
                        grant = new Grant();
                        grantee = new Grantee();
                        grantee.setCanonicalUser(new CanonicalUser(id, canonicalUserName));
                        grant.setGrantee(grantee);
                        grant.setPermission((String)permissions.get(i));
                        grants.add(grant);
                        continue;
                    }
                    String groupUri = xmlParser.getValue(grantees.item(i), "URI");
                    if (groupUri.length() == 0) {
                        throw new BindingException("malformed access control list");
                    }
                    grant = new Grant();
                    grantee = new Grantee();
                    grantee.setGroup(new Group(groupUri));
                    grant.setGrantee(grantee);
                    grant.setPermission((String)permissions.get(i));
                    grants.add(grant);
                }
            }
        }
        catch (Exception ex) {
            throw new BindingException("Unable to parse access control list", (Throwable)ex);
        }
        accessControlList.setGrants(grants);
        return accessControlList;
    }

    private ArrayList<Part> getPartsList(MappingHttpRequest httpRequest) throws BindingException {
        ArrayList<Part> partList = new ArrayList<Part>();
        try {
            String partsString = this.getMessageString(httpRequest);
            if (partsString.length() > 0) {
                XMLParser xmlParser = new XMLParser(partsString);
                DTMNodeList partNodes = xmlParser.getNodes("/CompleteMultipartUpload/Part");
                if (partNodes == null) {
                    throw new BindingException("Malformed part list");
                }
                for (int i = 0; i < partNodes.getLength(); ++i) {
                    Part part = new Part(Integer.valueOf(Integer.parseInt(xmlParser.getValue(partNodes.item(i), "PartNumber"))), xmlParser.getValue(partNodes.item(i), "ETag"));
                    partList.add(part);
                }
            }
        }
        catch (Exception ex) {
            throw new BindingException("Unable to parse part list", (Throwable)ex);
        }
        return partList;
    }

    protected String getOperationPath(MappingHttpRequest httpRequest) {
        String opPath;
        if (httpRequest.getServicePath().startsWith(this.walrusServicePath) && (Strings.isNullOrEmpty((String)(opPath = httpRequest.getServicePath().replaceFirst(this.walrusServicePath, ""))) || opPath.startsWith("/"))) {
            return opPath;
        }
        return httpRequest.getServicePath();
    }

    private String getLocationConstraint(MappingHttpRequest httpRequest) throws BindingException {
        String locationConstraint = null;
        try {
            String bucketConfiguration = this.getMessageString(httpRequest);
            if (bucketConfiguration.length() > 0) {
                XMLParser xmlParser = new XMLParser(bucketConfiguration);
                locationConstraint = xmlParser.getValue("/CreateBucketConfiguration/LocationConstraint");
            }
        }
        catch (Exception ex) {
            throw new BindingException("Error parsing location constraint", (Throwable)ex);
        }
        return locationConstraint;
    }

    private List<String> populateObject(GroovyObject obj, Map<String, String> paramFieldMap, Map<String, String> params) {
        ArrayList<String> failedMappings = new ArrayList<String>();
        for (Map.Entry<String, String> e : paramFieldMap.entrySet()) {
            try {
                if (!obj.getClass().getDeclaredField(e.getValue()).getType().equals(ArrayList.class)) continue;
                failedMappings.addAll(this.populateObjectList(obj, e, params, params.size()));
            }
            catch (NoSuchFieldException e1) {
                failedMappings.add(e.getKey());
            }
        }
        for (Map.Entry<String, String> e : paramFieldMap.entrySet()) {
            if (!params.containsKey(e.getKey()) || this.populateObjectField(obj, e, params)) continue;
            failedMappings.add(e.getKey());
        }
        return failedMappings;
    }

    private void populateObjectFromBindingMap(GroovyObject obj, Map<String, String> paramFieldMap, MappingHttpRequest httpRequest, Map bindingMap) throws BindingException {
        String metaDataString;
        String aclString = httpRequest.getAndRemoveHeader("x-amz-acl");
        if (aclString != null) {
            WalrusRESTBinding.addAccessControlList(obj, paramFieldMap, bindingMap, aclString);
        }
        if ((metaDataString = paramFieldMap.remove("MetaData")) != null) {
            Set headerNames = httpRequest.getHeaderNames();
            ArrayList<MetaDataEntry> metaData = new ArrayList<MetaDataEntry>();
            for (String key : headerNames) {
                if (!key.toLowerCase().startsWith("x-amz-meta-")) continue;
                MetaDataEntry metaDataEntry = new MetaDataEntry();
                metaDataEntry.setName(key.substring("x-amz-meta-".length()));
                metaDataEntry.setValue(httpRequest.getHeader(key));
                metaData.add(metaDataEntry);
            }
            obj.setProperty(metaDataString, metaData);
        }
        for (String key : bindingMap.keySet()) {
            obj.setProperty(key.substring(0, 1).toLowerCase().concat(key.substring(1)), bindingMap.get(key));
        }
    }

    private boolean populateObjectField(GroovyObject obj, Map.Entry<String, String> paramFieldPair, Map<String, String> params) {
        try {
            Class<?> declaredType = obj.getClass().getDeclaredField(paramFieldPair.getValue()).getType();
            if (declaredType.equals(String.class)) {
                obj.setProperty(paramFieldPair.getValue(), (Object)params.remove(paramFieldPair.getKey()));
            } else if (declaredType.getName().equals("int")) {
                obj.setProperty(paramFieldPair.getValue(), (Object)Integer.parseInt(params.remove(paramFieldPair.getKey())));
            } else if (declaredType.equals(Integer.class)) {
                obj.setProperty(paramFieldPair.getValue(), (Object)new Integer(params.remove(paramFieldPair.getKey())));
            } else if (declaredType.getName().equals("boolean")) {
                obj.setProperty(paramFieldPair.getValue(), (Object)Boolean.parseBoolean(params.remove(paramFieldPair.getKey())));
            } else if (declaredType.equals(Boolean.class)) {
                obj.setProperty(paramFieldPair.getValue(), (Object)new Boolean(params.remove(paramFieldPair.getKey())));
            } else if (declaredType.getName().equals("long")) {
                obj.setProperty(paramFieldPair.getValue(), (Object)Long.parseLong(params.remove(paramFieldPair.getKey())));
            } else if (declaredType.equals(Long.class)) {
                obj.setProperty(paramFieldPair.getValue(), (Object)new Long(params.remove(paramFieldPair.getKey())));
            } else {
                return false;
            }
            return true;
        }
        catch (Exception e1) {
            return false;
        }
    }

    private List<String> populateObjectList(GroovyObject obj, Map.Entry<String, String> paramFieldPair, Map<String, String> params, int paramSize) {
        ArrayList<String> failedMappings;
        block12: {
            failedMappings = new ArrayList<String>();
            try {
                Field declaredField = obj.getClass().getDeclaredField(paramFieldPair.getValue());
                ArrayList theList = (ArrayList)obj.getProperty(paramFieldPair.getValue());
                Class genericType = (Class)((ParameterizedType)declaredField.getGenericType()).getActualTypeArguments()[0];
                if (String.class.equals((Object)genericType)) {
                    if (params.containsKey(paramFieldPair.getKey())) {
                        theList.add(params.remove(paramFieldPair.getKey()));
                    } else {
                        ArrayList keys = Lists.newArrayList(params.keySet());
                        for (String k : keys) {
                            if (!k.matches(paramFieldPair.getKey() + "\\.\\d*")) continue;
                            theList.add(params.remove(k));
                        }
                    }
                    break block12;
                }
                if (!declaredField.isAnnotationPresent(HttpEmbedded.class)) break block12;
                HttpEmbedded annoteEmbedded = declaredField.getAnnotation(HttpEmbedded.class);
                if (annoteEmbedded.multiple()) {
                    String prefix = paramFieldPair.getKey();
                    ArrayList<String> embeddedListFieldNames = new ArrayList<String>();
                    for (String actualParameterName : params.keySet()) {
                        if (!actualParameterName.matches(prefix + ".1.*")) continue;
                        embeddedListFieldNames.add(actualParameterName.replaceAll(prefix + ".1.", ""));
                    }
                    for (int i = 0; i < paramSize + 1; ++i) {
                        boolean foundAll = true;
                        HashMap<String, String> embeddedParams = new HashMap<String, String>();
                        for (String fieldName : embeddedListFieldNames) {
                            String paramName = prefix + "." + i + "." + fieldName;
                            if (!params.containsKey(paramName)) {
                                failedMappings.add("Mismatched embedded field: " + paramName);
                                foundAll = false;
                                continue;
                            }
                            embeddedParams.put(fieldName, params.get(paramName));
                        }
                        if (foundAll) {
                            failedMappings.addAll(this.populateEmbedded(genericType, embeddedParams, theList));
                            continue;
                        }
                        break block12;
                    }
                    break block12;
                }
                failedMappings.addAll(this.populateEmbedded(genericType, params, theList));
            }
            catch (Exception e1) {
                failedMappings.add(paramFieldPair.getKey());
            }
        }
        return failedMappings;
    }

    private List<String> populateEmbedded(Class genericType, Map<String, String> params, ArrayList theList) throws InstantiationException, IllegalAccessException {
        GroovyObject embedded = (GroovyObject)genericType.newInstance();
        Map<String, String> embeddedFields = this.buildFieldMap(genericType);
        int startSize = params.size();
        List<String> embeddedFailures = this.populateObject(embedded, embeddedFields, params);
        if (embeddedFailures.isEmpty() && params.size() - startSize != 0) {
            theList.add(embedded);
        }
        return embeddedFailures;
    }

    private Map<String, String> buildFieldMap(Class targetType) {
        Field[] fields;
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (Field f : fields = targetType.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            if (f.isAnnotationPresent(HttpParameterMapping.class)) {
                for (String parameter : f.getAnnotation(HttpParameterMapping.class).parameter()) {
                    fieldMap.put(parameter, f.getName());
                }
                fieldMap.put(f.getName().substring(0, 1).toUpperCase().concat(f.getName().substring(1)), f.getName());
                continue;
            }
            fieldMap.put(f.getName().substring(0, 1).toUpperCase().concat(f.getName().substring(1)), f.getName());
        }
        return fieldMap;
    }

    private static void addAccessControlList(GroovyObject obj, Map<String, String> paramFieldMap, Map bindingMap, String cannedACLString) {
        ArrayList grants;
        AccessControlList accessControlList;
        if (bindingMap.containsKey("AccessControlPolicy")) {
            AccessControlPolicy accessControlPolicy = (AccessControlPolicy)bindingMap.get("AccessControlPolicy");
            accessControlList = accessControlPolicy.getAccessControlList();
            grants = accessControlList.getGrants();
        } else {
            accessControlList = new AccessControlList();
            grants = new ArrayList();
        }
        CanonicalUser aws = new CanonicalUser();
        aws.setDisplayName("");
        Grant grant = new Grant(new Grantee(aws), cannedACLString);
        grants.add(grant);
        accessControlList.setGrants(grants);
        String acl = paramFieldMap.remove("AccessControlList");
        if (acl != null) {
            obj.setProperty(acl, (Object)accessControlList);
        }
    }

    private String toUpperFirst(String string) {
        return string.substring(0, 1).toUpperCase().concat(string.substring(1));
    }

    private boolean exactMatch(JSONObject jsonObject, Map formFields, List<String> policyItemNames) {
        Iterator iterator = jsonObject.keys();
        boolean returnValue = false;
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            key = key.replaceAll("\\$", "");
            policyItemNames.add(key);
            try {
                if (jsonObject.get(key).equals(formFields.get(key))) {
                    returnValue = true;
                    continue;
                }
                returnValue = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return returnValue;
    }

    private boolean partialMatch(JSONArray jsonArray, Map<String, String> formFields, List<String> policyItemNames) {
        boolean returnValue = false;
        if (jsonArray.size() != 3) {
            return false;
        }
        try {
            String condition = (String)jsonArray.get(0);
            String key = (String)jsonArray.get(1);
            key = key.replaceAll("\\$", "");
            policyItemNames.add(key);
            String value = (String)jsonArray.get(2);
            if (condition.contains("eq")) {
                if (value.equals(formFields.get(key))) {
                    returnValue = true;
                }
            } else if (condition.contains("starts-with")) {
                if (!formFields.containsKey(key)) {
                    return false;
                }
                if (formFields.get(key).startsWith(value)) {
                    returnValue = true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return returnValue;
    }

    private String getMessageString(MappingHttpRequest httpRequest) {
        ChannelBuffer buffer = httpRequest.getContent();
        buffer.markReaderIndex();
        byte[] read = new byte[buffer.readableBytes()];
        buffer.readBytes(read);
        return new String(read);
    }

    private void handleHttpChunk(HttpChunk httpChunk) throws Exception {
        ChannelBuffer buffer = httpChunk.getContent();
        try {
            buffer.markReaderIndex();
            byte[] read = new byte[buffer.readableBytes()];
            buffer.readBytes(read);
            while (this.putQueue != null && !this.putQueue.offer((Object)WalrusDataMessage.DataMessage((byte[])read), 500L, TimeUnit.MILLISECONDS)) {
            }
            if (httpChunk.isLast()) {
                while (this.putQueue != null && !this.putQueue.offer((Object)WalrusDataMessage.EOF(), 1000L, TimeUnit.MILLISECONDS)) {
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Error handling HTTP chunk", ex);
        }
    }

    private void handleFirstChunk(MappingHttpRequest httpRequest, long dataLength) throws Exception {
        ChannelBuffer buffer = httpRequest.getContent();
        try {
            this.putQueue.put((Object)WalrusDataMessage.StartOfData((long)dataLength));
            buffer.markReaderIndex();
            byte[] read = new byte[buffer.readableBytes()];
            buffer.readBytes(read);
            this.putQueue.put((Object)WalrusDataMessage.DataMessage((byte[])read));
            if (!httpRequest.isChunked()) {
                this.putQueue.put((Object)WalrusDataMessage.EOF());
            }
        }
        catch (Exception ex) {
            throw new Exception("Error handling first chunk of PUT in walrus", ex);
        }
    }

    private void handleFirstChunk(MappingHttpRequest httpRequest, ChannelBuffer firstChunk, long dataLength) throws Exception {
        try {
            this.putQueue.put((Object)WalrusDataMessage.StartOfData((long)dataLength));
            byte[] read = new byte[firstChunk.readableBytes()];
            firstChunk.readBytes(read);
            this.putQueue.put((Object)WalrusDataMessage.DataMessage((byte[])read));
            if (!httpRequest.isChunked()) {
                this.putQueue.put((Object)WalrusDataMessage.EOF());
            }
        }
        catch (Exception ex) {
            throw new Exception("Error handling first data chunk", ex);
        }
    }

    public static synchronized WalrusDataMessenger getWriteMessenger() {
        if (putMessenger == null) {
            putMessenger = new WalrusDataMessenger();
        }
        return putMessenger;
    }

    class Writer
    extends Thread {
        private ChannelBuffer firstBuffer;
        private long dataLength;

        public Writer(ChannelBuffer firstBuffer, long dataLength) {
            this.firstBuffer = firstBuffer;
            this.dataLength = dataLength;
        }

        @Override
        public void run() {
            byte[] bytes = new byte[102400];
            try {
                Logs.extreme().trace((Object)"Starting upload");
                WalrusRESTBinding.this.putQueue.put((Object)WalrusDataMessage.StartOfData((long)this.dataLength));
                this.firstBuffer.markReaderIndex();
                byte[] read = new byte[this.firstBuffer.readableBytes()];
                this.firstBuffer.readBytes(read);
                WalrusRESTBinding.this.putQueue.put((Object)WalrusDataMessage.DataMessage((byte[])read));
            }
            catch (Exception ex) {
                LOG.error((Object)"Error putting data into internal transfer queue in Walrus", (Throwable)ex);
            }
        }
    }
}

