/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.pipeline;

import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.UpstreamMessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;

public class WalrusPOSTIncomingHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(WalrusPOSTIncomingHandler.class);
    private static final long EXPIRATION_LIMIT = 900000L;
    private boolean waitForNext;
    private boolean processedFirstChunk;
    private MappingHttpRequest httpRequest;

    public void handleUpstream(ChannelHandlerContext channelHandlerContext, ChannelEvent channelEvent) throws Exception {
        LOG.debug((Object)(((Object)((Object)this)).getClass().getSimpleName() + "[incoming]: " + channelEvent));
        if (channelEvent instanceof MessageEvent) {
            MessageEvent msgEvent = (MessageEvent)channelEvent;
            this.incomingMessage(channelHandlerContext, msgEvent);
        } else if (channelEvent instanceof ExceptionEvent) {
            this.exceptionCaught(channelHandlerContext, (ExceptionEvent)channelEvent);
        }
        if (!this.waitForNext) {
            channelHandlerContext.sendUpstream(channelEvent);
        }
        if (this.processedFirstChunk) {
            this.waitForNext = false;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent exceptionEvent) throws Exception {
        Throwable t = exceptionEvent.getCause();
        if (t != null && IOException.class.isAssignableFrom(t.getClass())) {
            LOG.debug((Object)t, t);
        } else {
            LOG.debug((Object)t, t);
        }
        ctx.sendUpstream((ChannelEvent)exceptionEvent);
    }

    public void incomingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpRequest) {
            MappingHttpRequest httpRequest = (MappingHttpRequest)event.getMessage();
            if (httpRequest.getContent().readableBytes() == 0) {
                this.waitForNext = true;
                this.processedFirstChunk = false;
                this.httpRequest = httpRequest;
            }
        } else if (event.getMessage() instanceof DefaultHttpChunk && !this.processedFirstChunk) {
            DefaultHttpChunk httpChunk = (DefaultHttpChunk)event.getMessage();
            this.httpRequest.setContent(httpChunk.getContent());
            this.processedFirstChunk = true;
            UpstreamMessageEvent newEvent = new UpstreamMessageEvent(ctx.getChannel(), (Object)this.httpRequest, null);
            ctx.sendUpstream((ChannelEvent)newEvent);
        }
    }
}

