/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.pipeline;

import com.eucalyptus.auth.AccessKeys;
import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.crypto.Hmac;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.walrus.WalrusBackend;
import com.eucalyptus.walrus.pipeline.UploadPolicyChecker;
import com.eucalyptus.walrus.util.WalrusProperties;
import com.eucalyptus.walrus.util.WalrusUtil;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.UpstreamMessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class WalrusPOSTAuthenticationHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(WalrusPOSTAuthenticationHandler.class);
    private String boundary;

    public void handleUpstream(ChannelHandlerContext channelHandlerContext, ChannelEvent channelEvent) throws Exception {
        LOG.debug((Object)(((Object)((Object)this)).getClass().getSimpleName() + "[incoming]: " + channelEvent));
        if (channelEvent instanceof MessageEvent) {
            MessageEvent msgEvent = (MessageEvent)channelEvent;
            this.incomingMessage(channelHandlerContext, msgEvent);
        } else if (channelEvent instanceof ExceptionEvent) {
            this.exceptionCaught(channelHandlerContext, (ExceptionEvent)channelEvent);
        }
        channelHandlerContext.sendUpstream(channelEvent);
    }

    public void incomingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        DefaultHttpChunk httpChunk;
        ChannelBuffer newBuffer;
        if (event.getMessage() instanceof MappingHttpRequest) {
            MappingHttpRequest httpRequest = (MappingHttpRequest)event.getMessage();
            Map formFields = httpRequest.getFormFields();
            String boundary = this.processPOSTHeaders(httpRequest, formFields);
            this.processPOSTParams(boundary, formFields, httpRequest.getContent());
            UploadPolicyChecker.checkPolicy(httpRequest, formFields);
            this.handle(httpRequest);
        } else if (event.getMessage() instanceof DefaultHttpChunk && (newBuffer = this.getDataChunk((httpChunk = (DefaultHttpChunk)event.getMessage()).getContent(), this.boundary)) != null) {
            DefaultHttpChunk newChunk = new DefaultHttpChunk(newBuffer);
            UpstreamMessageEvent newEvent = new UpstreamMessageEvent(ctx.getChannel(), (Object)newChunk, null);
            ctx.sendUpstream((ChannelEvent)newEvent);
        }
    }

    public void handle(MappingHttpRequest httpRequest) throws AuthenticationException {
        if (httpRequest.getFormFields().size() > 0) {
            String data = httpRequest.getAndRemoveHeader(WalrusProperties.FormField.FormUploadPolicyData.toString());
            String auth_part = httpRequest.getAndRemoveHeader(SecurityParameter.Authorization.toString());
            if (auth_part != null) {
                String[] sigString = this.getSigInfo(auth_part);
                String signature = sigString[1];
                this.authenticate(httpRequest, sigString[0], signature, data);
            } else {
                throw new AuthenticationException("User authentication failed.");
            }
        }
    }

    private void authenticate(MappingHttpRequest httpRequest, String accessKeyID, String signature, String data) throws AuthenticationException {
        signature = signature.replaceAll("=", "");
        try {
            AccessKey key = AccessKeys.lookupAccessKey((String)accessKeyID, (String)httpRequest.getHeader("x-amz-security-token"));
            User user = key.getUser();
            String queryKey = key.getSecretKey();
            String authSig = this.checkSignature(queryKey, data);
            if (!authSig.equals(signature)) {
                throw new AuthenticationException("User authentication failed. Could not verify signature");
            }
            Contexts.lookup((String)httpRequest.getCorrelationId()).setUser(user);
        }
        catch (Exception ex) {
            throw new AuthenticationException("User authentication failed. Unable to obtain query key");
        }
    }

    private String[] getSigInfo(String auth_part) {
        int index = auth_part.lastIndexOf(" ");
        String sigString = auth_part.substring(index + 1);
        return sigString.split(":");
    }

    protected String checkSignature(String queryKey, String subject) throws AuthenticationException {
        SecretKeySpec signingKey = new SecretKeySpec(queryKey.getBytes(), Hmac.HmacSHA1.toString());
        try {
            Mac mac = Hmac.HmacSHA1.getInstance();
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(subject.getBytes());
            return new String(Base64.encode((byte[])rawHmac)).replaceAll("=", "");
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new AuthenticationException("Failed to compute signature");
        }
    }

    private String processPOSTHeaders(MappingHttpRequest httpRequest, Map<String, String> formFields) throws AuthenticationException {
        String contentType = httpRequest.getHeader("Content-Type");
        String boundary = null;
        if (contentType != null) {
            if (contentType.startsWith("multipart/form-data")) {
                boundary = this.getFormFieldKeyName(contentType, "boundary");
                this.boundary = boundary = "--" + boundary + "\r\n";
            }
            String operationPath = httpRequest.getServicePath().replaceAll(((WalrusBackend)ComponentIds.lookup(WalrusBackend.class)).getServicePath(new String[0]), "");
            String[] target = WalrusUtil.getTarget(operationPath);
            formFields.put(WalrusProperties.FormField.bucket.toString(), target[0]);
            return boundary;
        }
        throw new AuthenticationException("No Content-Type specified");
    }

    private void processPOSTParams(String boundary, Map formFields, ChannelBuffer buffer) throws AuthenticationException {
        String[] parts;
        String message = this.getMessageString(buffer);
        for (String part : parts = message.split(boundary)) {
            Map<String, String> keyMap = this.getFormField(part, "name");
            Set<String> keys = keyMap.keySet();
            for (String key : keys) {
                if (WalrusProperties.FormField.file.toString().equals(key)) {
                    String contentType = this.getContentType(formFields, part, boundary);
                    if (contentType != null) {
                        this.getFirstChunk(formFields, buffer, contentType, boundary);
                    }
                    formFields.put(key, keyMap.get(key));
                    continue;
                }
                if ("Content-Type".toLowerCase().equals(key.toLowerCase())) {
                    formFields.put("Content-Type", keyMap.get(key));
                    continue;
                }
                formFields.put(key, keyMap.get(key));
            }
        }
    }

    private Map<String, String> getFormField(String message, String key) {
        HashMap<String, String> keymap = new HashMap<String, String>();
        String[] parts = message.split(";");
        if (parts.length >= 2 && parts[1].contains(key + "=")) {
            String keystring = parts[1].substring(parts[1].indexOf(61) + 1);
            if (parts.length == 2) {
                String[] keyparts = keystring.split("\r\n\r\n");
                String keyName = keyparts[0];
                keyName = keyName.replaceAll("\"", "");
                String value = keyparts[1].replaceAll("\r\n", "");
                keymap.put(keyName, value);
            } else {
                String keyName = keystring.trim();
                keyName = keyName.replaceAll("\"", "");
                String valuestring = parts[2].substring(parts[2].indexOf(61) + 1, parts[2].indexOf("\r\n")).trim();
                String value = valuestring.replaceAll("\"", "");
                keymap.put(keyName, value);
            }
        }
        return keymap;
    }

    private String getFormFieldKeyName(String message, String key) {
        String[] parts = message.split(";");
        if (parts.length > 1 && parts[1].contains(key + "=")) {
            String keystring = parts[1].substring(parts[1].indexOf(61) + 1);
            String[] keyparts = keystring.split("\r\n\r\n");
            String keyName = keyparts[0];
            keyName = keyName.replaceAll("\r\n", "");
            keyName = keyName.replaceAll("\"", "");
            return keyName;
        }
        return null;
    }

    private String getMessageString(ChannelBuffer buffer) {
        buffer.markReaderIndex();
        byte[] read = new byte[buffer.readableBytes()];
        buffer.readBytes(read);
        buffer.resetReaderIndex();
        return new String(read);
    }

    private String getContentType(Map<String, String> formFields, String part, String boundary) {
        int startValue;
        int endValue = part.indexOf("\r\n\r\n");
        if (endValue > (startValue = part.indexOf("Content-Type:") + "Content-Type".length() + 1)) {
            String contentType = part.substring(startValue, endValue);
            return contentType;
        }
        return null;
    }

    private void getFirstChunk(Map formFields, ChannelBuffer buffer, String contentType, String boundary) {
        buffer.markReaderIndex();
        String contentTypeString = "Content-Type".toString() + ":" + contentType + "\r\n\r\n";
        byte[] read = new byte[buffer.readableBytes()];
        buffer.readBytes(read);
        int index = this.getLastIndex(read, contentTypeString.getBytes());
        if (index > -1) {
            int firstIndex = index + 1;
            int lastIndex = read.length;
            boundary = "\r\n" + boundary;
            index = this.getFirstIndex(read, firstIndex, boundary.getBytes());
            if (index > -1) {
                lastIndex = index;
            }
            byte[] chunk = new byte[lastIndex - firstIndex];
            ChannelBuffer firstBuffer = ChannelBuffers.copiedBuffer((byte[])read, (int)firstIndex, (int)(lastIndex - firstIndex));
            formFields.put("x-ignore-FirstDataChunk", firstBuffer);
        }
        buffer.resetReaderIndex();
    }

    private ChannelBuffer getDataChunk(ChannelBuffer buffer, String boundary) {
        buffer.markReaderIndex();
        byte[] read = new byte[buffer.readableBytes()];
        buffer.readBytes(read);
        boundary = "\r\n" + boundary;
        int index = this.getFirstIndex(read, 0, boundary.getBytes());
        if (index > -1) {
            String readString = new String(read);
            ChannelBuffer newBuffer = ChannelBuffers.copiedBuffer((byte[])read, (int)0, (int)index);
            String newstring = new String(read, 0, index);
            return newBuffer;
        }
        buffer.resetReaderIndex();
        return null;
    }

    private int getFirstIndex(byte[] bytes, int sourceIndex, byte[] bytesToCompare) {
        int firstIndex = -1;
        if (bytes.length - sourceIndex < bytesToCompare.length) {
            return firstIndex;
        }
        for (int i = sourceIndex; i < bytes.length; ++i) {
            for (int j = 0; j < bytesToCompare.length && i + j < bytes.length; ++j) {
                if (bytes[i + j] != bytesToCompare[j]) {
                    firstIndex = -1;
                    break;
                }
                firstIndex = i;
            }
            if (firstIndex == -1) continue;
            return firstIndex;
        }
        return firstIndex;
    }

    private int getLastIndex(byte[] bytes, byte[] bytesToCompare) {
        int lastIndex = -1;
        if (bytes.length < bytesToCompare.length) {
            return lastIndex;
        }
        for (int i = 0; i < bytes.length; ++i) {
            for (int j = 0; j < bytesToCompare.length && i + j < bytes.length; ++j) {
                if (bytes[i + j] != bytesToCompare[j]) {
                    lastIndex = -1;
                    break;
                }
                lastIndex = i + j;
            }
            if (lastIndex == -1) continue;
            return lastIndex;
        }
        return lastIndex;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent exceptionEvent) throws Exception {
        LOG.info((Object)("[exception " + exceptionEvent + "]"));
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        DownstreamMessageEvent newEvent = new DownstreamMessageEvent(ctx.getChannel(), ctx.getChannel().getCloseFuture(), (Object)response, null);
        ctx.sendDownstream((ChannelEvent)newEvent);
        newEvent.getFuture().addListener(ChannelFutureListener.CLOSE);
    }

    public static enum SecurityParameter {
        AWSAccessKeyId,
        Timestamp,
        Expires,
        Signature,
        Authorization,
        Date,
        Content_MD5,
        Content_Type,
        SecurityToken;

    }
}

