/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.pipeline;

import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.storage.common.DateFormatter;
import com.eucalyptus.storage.msgs.s3.MetaDataEntry;
import com.eucalyptus.walrus.exceptions.HeadExceptionInterface;
import com.eucalyptus.walrus.msgs.CopyObjectResponseType;
import com.eucalyptus.walrus.msgs.CreateBucketResponseType;
import com.eucalyptus.walrus.msgs.PostObjectResponseType;
import com.eucalyptus.walrus.msgs.PutObjectResponseType;
import com.eucalyptus.walrus.msgs.WalrusDataGetResponseType;
import com.eucalyptus.walrus.msgs.WalrusDataResponseType;
import com.eucalyptus.walrus.msgs.WalrusDeleteResponseType;
import com.eucalyptus.walrus.msgs.WalrusErrorMessageType;
import com.eucalyptus.walrus.msgs.WalrusHeadResponseType;
import com.eucalyptus.walrus.util.WalrusUtil;
import com.eucalyptus.ws.WebServicesException;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.eucalyptus.ws.server.MessageStatistics;
import com.google.common.base.Strings;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.stream.ChunkedInput;

public class WalrusOutboundHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(WalrusOutboundHandler.class);

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent channelEvent) throws Exception {
        try {
            MessageEvent event;
            if (channelEvent instanceof MessageEvent && (event = (MessageEvent)channelEvent).getMessage() != null) {
                MappingHttpResponse httpResponse;
                BaseMessage msg;
                if (event.getMessage() instanceof MappingHttpResponse && (msg = (BaseMessage)(httpResponse = (MappingHttpResponse)event.getMessage()).getMessage()) instanceof WalrusDataGetResponseType) {
                    Callable stat = MessageStatistics.startDownstream((Channel)ctx.getChannel(), (ChannelHandler)this);
                    boolean isDone = this.handleMessage(ctx, event);
                    stat.call();
                    if (isDone) {
                        return;
                    }
                }
                Callable stat = MessageStatistics.startDownstream((Channel)ctx.getChannel(), (ChannelHandler)this);
                this.outgoingMessage(ctx, event);
                stat.call();
            }
            ctx.sendDownstream(channelEvent);
        }
        catch (Exception e) {
            throw new WebServicesException(e.getMessage(), HttpResponseStatus.BAD_REQUEST);
        }
    }

    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpResponse) {
            MappingHttpResponse httpResponse = (MappingHttpResponse)event.getMessage();
            BaseMessage msg = (BaseMessage)httpResponse.getMessage();
            if (msg instanceof PutObjectResponseType) {
                PutObjectResponseType putObjectResponse = (PutObjectResponseType)msg;
                httpResponse.addHeader("ETag", (Object)('\"' + putObjectResponse.getEtag() + '\"'));
                httpResponse.addHeader("Last-Modified", (Object)DateFormatter.dateToHeaderFormattedString((Date)putObjectResponse.getLastModified()));
                if (putObjectResponse.getVersionId() != null) {
                    httpResponse.addHeader("x-amz-version-id", (Object)putObjectResponse.getVersionId());
                }
            } else if (msg instanceof WalrusDataResponseType) {
                WalrusDataResponseType response = (WalrusDataResponseType)msg;
                httpResponse.addHeader("ETag", (Object)('\"' + response.getEtag() + '\"'));
                httpResponse.addHeader("Last-Modified", (Object)DateFormatter.dateToHeaderFormattedString((Date)response.getLastModified()));
                if (response.getVersionId() != null) {
                    httpResponse.addHeader("x-amz-version-id", (Object)response.getVersionId());
                }
            } else if (msg instanceof PostObjectResponseType) {
                PostObjectResponseType postObjectResponse = (PostObjectResponseType)msg;
                String redirectUrl = postObjectResponse.getRedirectUrl();
                if (redirectUrl != null) {
                    httpResponse.addHeader("Location", (Object)redirectUrl);
                    httpResponse.setStatus(HttpResponseStatus.SEE_OTHER);
                    httpResponse.setMessage(null);
                } else {
                    Integer successCode = postObjectResponse.getSuccessCode();
                    if (successCode != null) {
                        if (successCode != 201) {
                            httpResponse.setMessage(null);
                            httpResponse.setStatus(new HttpResponseStatus(successCode.intValue(), "OK"));
                        } else {
                            httpResponse.setStatus(new HttpResponseStatus(successCode.intValue(), "Created"));
                        }
                    }
                }
                event.getFuture().addListener(ChannelFutureListener.CLOSE);
            } else if (msg instanceof CopyObjectResponseType) {
                CopyObjectResponseType copyResponse = (CopyObjectResponseType)msg;
                if (copyResponse.getVersionId() != null) {
                    httpResponse.addHeader("x-amz-version-id", (Object)copyResponse.getVersionId());
                }
                if (copyResponse.getCopySourceVersionId() != null) {
                    httpResponse.addHeader("x-amz-copy-source-version-id", (Object)copyResponse.getCopySourceVersionId());
                }
            } else if (msg instanceof EucalyptusErrorMessageType) {
                EucalyptusErrorMessageType errorMessage = (EucalyptusErrorMessageType)msg;
                BaseMessage errMsg = WalrusUtil.convertErrorMessage(errorMessage);
                if (errMsg instanceof WalrusErrorMessageType) {
                    WalrusErrorMessageType walrusErrorMsg = (WalrusErrorMessageType)errMsg;
                    httpResponse.setStatus(walrusErrorMsg.getStatus());
                }
                httpResponse.setMessage((Object)errMsg);
            } else if (msg instanceof ExceptionResponseType) {
                ExceptionResponseType errorMessage = (ExceptionResponseType)msg;
                BaseMessage errMsg = WalrusUtil.convertErrorMessage(errorMessage);
                if (errMsg instanceof WalrusErrorMessageType) {
                    WalrusErrorMessageType walrusErrorMsg = (WalrusErrorMessageType)errMsg;
                    httpResponse.setStatus(walrusErrorMsg.getStatus());
                }
                if (errorMessage.getException() instanceof HeadExceptionInterface) {
                    httpResponse.setMessage(null);
                } else {
                    httpResponse.setMessage((Object)errMsg);
                }
            } else if (msg instanceof WalrusDeleteResponseType) {
                httpResponse.setStatus(HttpResponseStatus.NO_CONTENT);
                httpResponse.setMessage(null);
            } else if (msg instanceof WalrusHeadResponseType) {
                httpResponse.setStatus(HttpResponseStatus.OK);
                httpResponse.setMessage(null);
            } else if (msg instanceof CreateBucketResponseType) {
                httpResponse.setStatus(HttpResponseStatus.OK);
                httpResponse.setMessage(null);
                event.getFuture().addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    public boolean handleMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        return this.handleOutgoingMessage(ctx, event);
    }

    protected boolean handleOutgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        MappingHttpResponse httpResponse;
        BaseMessage msg;
        if (event.getMessage() instanceof MappingHttpResponse && (msg = (BaseMessage)(httpResponse = (MappingHttpResponse)event.getMessage()).getMessage()) instanceof WalrusDataGetResponseType) {
            WalrusDataGetResponseType dataResponse = (WalrusDataGetResponseType)msg;
            this.writeObjectStorageDataGetResponse(dataResponse, ctx);
            return true;
        }
        return false;
    }

    protected void writeObjectStorageDataGetResponse(WalrusDataGetResponseType response, ChannelHandlerContext ctx) {
        Channel channel;
        DefaultHttpResponse httpResponse = this.createHttpResponse(response);
        if (!Strings.isNullOrEmpty((String)response.getCorrelationId())) {
            httpResponse.setHeader("x-amz-request-id", (Object)response.getCorrelationId());
        }
        if ((channel = ctx.getChannel()).isWritable()) {
            ChannelFuture writeFuture = Channels.future((Channel)ctx.getChannel());
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)writeFuture, (Object)httpResponse);
            List dataStreams = response.getDataInputStream();
            if (dataStreams != null) {
                for (final ChunkedInput dataStream : dataStreams) {
                    channel.write((Object)dataStream).addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            dataStream.close();
                        }
                    });
                }
            } else {
                writeFuture.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    protected DefaultHttpResponse createHttpResponse(WalrusDataGetResponseType reply) {
        String versionId;
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        long contentLength = reply.getSize();
        String contentType = reply.getContentType();
        String etag = reply.getEtag();
        String contentDisposition = reply.getContentDisposition();
        httpResponse.addHeader("Content-Type", (Object)(contentType != null ? contentType : "binary/octet-stream"));
        if (etag != null) {
            httpResponse.addHeader("ETag", (Object)("\"" + etag + "\""));
        }
        httpResponse.addHeader("Last-Modified", (Object)DateFormatter.dateToHeaderFormattedString((Date)reply.getLastModified()));
        if (contentDisposition != null) {
            httpResponse.addHeader("Content-Disposition", (Object)contentDisposition);
        }
        if ((versionId = reply.getVersionId()) != null && !"null".equals(versionId)) {
            httpResponse.addHeader("x-amz-version-id", (Object)versionId);
        }
        httpResponse.setHeader("Date", (Object)DateFormatter.dateToHeaderFormattedString((Date)new Date()));
        for (MetaDataEntry m : reply.getMetaData()) {
            httpResponse.addHeader("x-amz-meta-" + m.getName(), (Object)m.getValue());
        }
        if (reply.getByteRangeEnd() != null && reply.getByteRangeStart() != null) {
            httpResponse.addHeader("Content-Range", (Object)(reply.getByteRangeStart() + "-" + reply.getByteRangeEnd() + "/" + reply.getSize()));
        }
        httpResponse.addHeader("Content-Length", (Object)String.valueOf(contentLength));
        return httpResponse;
    }
}

