/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.pipeline;

import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.auth.login.SecurityContext;
import com.eucalyptus.auth.login.WrappedCredentials;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.walrus.WalrusBackend;
import com.eucalyptus.walrus.auth.WalrusWrappedCredentials;
import com.eucalyptus.walrus.exceptions.AccessDeniedException;
import com.eucalyptus.walrus.pipeline.UploadPolicyChecker;
import com.eucalyptus.walrus.util.WalrusProperties;
import com.eucalyptus.walrus.util.WalrusUtil;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class WalrusAuthenticationHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(WalrusAuthenticationHandler.class);
    private static final String AWS_AUTH_TYPE = "AWS";
    private static final String EUCA_AUTH_TYPE = "EUCA2-RSA-SHA256";
    private static final String EUCA_OLD_AUTH_TYPE = "Euca";
    protected static final String ISO_8601_FORMAT = "yyyyMMdd'T'HHmmss'Z'";

    private static void canonicalizeHeaders(MappingHttpRequest httpRequest) {
        TreeMap<String, String> headerMap = new TreeMap<String, String>();
        Object value = null;
        for (String header : httpRequest.getHeaderNames()) {
            headerMap.put(header, Joiner.on((char)',').join((Iterable)httpRequest.getHeaders(header)));
        }
        httpRequest.clearHeaders();
        for (String foundHeader : headerMap.keySet()) {
            httpRequest.addHeader(foundHeader, (Object)((String)headerMap.get(foundHeader)).toString());
        }
    }

    private static void removeDuplicateHeaderValues(MappingHttpRequest httpRequest) {
        List hdrList = null;
        HashMap<String, List> fixedHeaders = new HashMap<String, List>();
        boolean foundDup = false;
        for (String string : httpRequest.getHeaderNames()) {
            hdrList = httpRequest.getHeaders(string);
            if (hdrList != null && hdrList.size() == 2 && ((String)hdrList.get(0)).equals(hdrList.get(1))) {
                foundDup = true;
                fixedHeaders.put(string, Lists.newArrayList((Object[])new String[]{(String)hdrList.get(0)}));
                continue;
            }
            fixedHeaders.put(string, hdrList);
        }
        if (foundDup) {
            LOG.debug((Object)("Found duplicate headers in: " + httpRequest.logMessage()));
            httpRequest.clearHeaders();
            for (Map.Entry entry : fixedHeaders.entrySet()) {
                for (String v : (List)entry.getValue()) {
                    httpRequest.addHeader((String)entry.getKey(), (Object)v);
                }
            }
        }
    }

    public void incomingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpRequest) {
            try {
                MappingHttpRequest httpRequest = (MappingHttpRequest)event.getMessage();
                WalrusAuthenticationHandler.removeDuplicateHeaderValues(httpRequest);
                WalrusAuthenticationHandler.canonicalizeHeaders(httpRequest);
                if (httpRequest.containsHeader(WalrusProperties.Headers.S3UploadPolicy.toString())) {
                    WalrusAuthenticationHandler.checkUploadPolicy(httpRequest);
                }
                this.handle(httpRequest);
            }
            catch (Exception ex) {
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)ex);
            }
        }
    }

    public static Map<AuthorizationField, String> processAuthorizationHeader(String authorization) throws AccessDeniedException {
        if (Strings.isNullOrEmpty((String)authorization)) {
            return null;
        }
        HashMap<AuthorizationField, String> authMap = new HashMap<AuthorizationField, String>();
        String[] components = authorization.split(" ");
        if (components.length < 2) {
            throw new AccessDeniedException("Invalid authoriztion header");
        }
        if (AWS_AUTH_TYPE.equals(components[0]) && (components.length == 2 || components.length == 3 && components[2].startsWith(":"))) {
            authMap.put(AuthorizationField.Type, AWS_AUTH_TYPE);
            if (components.length == 2) {
                String[] signatureElements = components[1].split(":");
                authMap.put(AuthorizationField.AccessKeyId, signatureElements[0]);
                authMap.put(AuthorizationField.Signature, signatureElements[1]);
            } else {
                authMap.put(AuthorizationField.AccessKeyId, components[1].trim());
                authMap.put(AuthorizationField.Signature, components[2].substring(1).trim());
            }
        } else if (EUCA_AUTH_TYPE.equals(components[0]) && components.length == 4) {
            authMap.put(AuthorizationField.Type, EUCA_AUTH_TYPE);
            authMap.put(AuthorizationField.CertFingerPrint, components[1].trim());
            authMap.put(AuthorizationField.SignedHeaders, components[2].trim());
            authMap.put(AuthorizationField.Signature, components[3].trim());
        } else if (EUCA_OLD_AUTH_TYPE.equals(components[0]) && components.length == 1) {
            authMap.put(AuthorizationField.Type, EUCA_OLD_AUTH_TYPE);
        } else {
            throw new AccessDeniedException("Invalid authorization header");
        }
        return authMap;
    }

    private static void checkUploadPolicy(MappingHttpRequest httpRequest) throws AccessDeniedException {
        String operationPath;
        String[] target;
        HashMap<String, String> fields = new HashMap<String, String>();
        String policy = httpRequest.getHeader(WalrusProperties.Headers.S3UploadPolicy.toString());
        fields.put(WalrusProperties.FormField.policy.toString(), policy);
        String policySignature = httpRequest.getHeader(WalrusProperties.Headers.S3UploadPolicySignature.toString());
        if (policySignature == null) {
            throw new AccessDeniedException("Policy signature must be specified with policy.");
        }
        String awsAccessKeyId = httpRequest.getHeader(SecurityParameter.AWSAccessKeyId.toString());
        if (awsAccessKeyId == null) {
            throw new AccessDeniedException("AWSAccessKeyID must be specified.");
        }
        fields.put(WalrusProperties.FormField.signature.toString(), policySignature);
        fields.put(SecurityParameter.AWSAccessKeyId.toString(), awsAccessKeyId);
        String acl = httpRequest.getHeader("x-amz-acl".toString());
        if (acl != null) {
            fields.put(WalrusProperties.FormField.acl.toString(), acl);
        }
        if ((target = WalrusUtil.getTarget(operationPath = httpRequest.getServicePath().replaceAll(((WalrusBackend)ComponentIds.lookup(WalrusBackend.class)).getServicePath(new String[0]), ""))) != null) {
            fields.put(WalrusProperties.FormField.bucket.toString(), target[0]);
            if (target.length > 1) {
                fields.put(WalrusProperties.FormField.key.toString(), target[1]);
            }
        }
        try {
            UploadPolicyChecker.checkPolicy(httpRequest, fields);
        }
        catch (AuthenticationException aex) {
            throw new AccessDeniedException(aex.getMessage());
        }
    }

    public void handle(MappingHttpRequest httpRequest) throws AccessDeniedException {
        String authHeader;
        Map<AuthorizationField, String> authMap;
        Map parameters = httpRequest.getParameters();
        if (httpRequest.containsHeader(SecurityParameter.Authorization.toString()) && AWS_AUTH_TYPE.equals((authMap = WalrusAuthenticationHandler.processAuthorizationHeader(authHeader = httpRequest.getAndRemoveHeader(SecurityParameter.Authorization.toString()))).get((Object)AuthorizationField.Type))) {
            S3Authentication.authenticate(httpRequest, authMap);
            return;
        }
        throw new AccessDeniedException("Invalid Authentication Scheme");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent exceptionEvent) throws Exception {
        LOG.info((Object)("[exception " + exceptionEvent + "]"));
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        DownstreamMessageEvent newEvent = new DownstreamMessageEvent(ctx.getChannel(), ctx.getChannel().getCloseFuture(), (Object)response, null);
        ctx.sendDownstream((ChannelEvent)newEvent);
        newEvent.getFuture().addListener(ChannelFutureListener.CLOSE);
    }

    private static class S3Authentication {
        private S3Authentication() {
        }

        private static void authenticate(MappingHttpRequest httpRequest, Map<AuthorizationField, String> authMap) throws AccessDeniedException {
            if (!authMap.get((Object)AuthorizationField.Type).equals(WalrusAuthenticationHandler.AWS_AUTH_TYPE)) {
                throw new AccessDeniedException("Mismatch between expected and found authentication types");
            }
            String verb = httpRequest.getMethod().getName();
            String date = S3Authentication.getDate(httpRequest);
            String addrString = S3Authentication.getS3AddressString(httpRequest);
            String content_md5 = httpRequest.getHeader("Content-MD5");
            content_md5 = content_md5 == null ? "" : content_md5;
            String content_type = httpRequest.getHeader("Content-Type");
            content_type = content_type == null ? "" : content_type;
            String securityToken = httpRequest.getHeader("x-amz-security-token");
            String canonicalizedAmzHeaders = S3Authentication.getCanonicalizedAmzHeaders(httpRequest);
            String data = verb + "\n" + content_md5 + "\n" + content_type + "\n" + date + "\n" + canonicalizedAmzHeaders + addrString;
            String accessKeyId = authMap.get((Object)AuthorizationField.AccessKeyId);
            String signature = authMap.get((Object)AuthorizationField.Signature);
            try {
                SecurityContext.getLoginContext((WrappedCredentials)new WalrusWrappedCredentials(httpRequest.getCorrelationId(), data, accessKeyId, signature, securityToken)).login();
            }
            catch (Exception ex) {
                String servicePath = ((WalrusBackend)ComponentIds.lookup(WalrusBackend.class)).getServicePath(new String[0]);
                if (addrString.startsWith(servicePath)) {
                    try {
                        String modifiedAddrString = addrString.replaceFirst(servicePath, "");
                        data = verb + "\n" + content_md5 + "\n" + content_type + "\n" + date + "\n" + canonicalizedAmzHeaders + modifiedAddrString;
                        SecurityContext.getLoginContext((WrappedCredentials)new WalrusWrappedCredentials(httpRequest.getCorrelationId(), data, accessKeyId, signature, securityToken)).login();
                    }
                    catch (Exception ex2) {
                        LOG.error((Object)ex2);
                        throw new AccessDeniedException(ex2.getMessage());
                    }
                }
                LOG.error((Object)ex);
                throw new AccessDeniedException(ex.getMessage());
            }
        }

        private static boolean checkExpires(String expires) {
            Long expireTime = Long.parseLong(expires);
            Long currentTime = new Date().getTime() / 1000L;
            return currentTime <= expireTime;
        }

        private static String getDate(MappingHttpRequest httpRequest) throws AccessDeniedException {
            String verifyDate;
            String date;
            if (httpRequest.containsHeader("x-amz-date")) {
                date = "";
                verifyDate = httpRequest.getHeader("x-amz-date");
            } else {
                verifyDate = date = httpRequest.getAndRemoveHeader(SecurityParameter.Date.toString());
                if (date == null || date.length() <= 0) {
                    throw new AccessDeniedException("User authentication failed. Date must be specified.");
                }
            }
            try {
                Date dateToVerify = DateUtil.parseDate((String)verifyDate);
                Date currentDate = new Date();
                if (Math.abs(currentDate.getTime() - dateToVerify.getTime()) > 900000L) {
                    LOG.error((Object)("Incoming WalrusBackend message is expired. Current date: " + currentDate.toString() + " Message's Verification Date: " + dateToVerify.toString()));
                    throw new AccessDeniedException("Message expired. Sorry.");
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("Cannot parse date: " + verifyDate));
                throw new AccessDeniedException("Unable to parse date.");
            }
            return date;
        }

        private static String getCanonicalizedAmzHeaders(MappingHttpRequest httpRequest) {
            String result = "";
            Set headerNames = httpRequest.getHeaderNames();
            TreeMap<String, String> amzHeaders = new TreeMap<String, String>();
            for (String headerName : headerNames) {
                String headerNameString = headerName.toLowerCase().trim();
                if (!headerNameString.startsWith("x-amz-")) continue;
                String value = httpRequest.getHeader(headerName).trim();
                String[] parts = value.split("\n");
                value = "";
                for (String part : parts) {
                    part = part.trim();
                    value = value + part + " ";
                }
                value = value.trim();
                if (amzHeaders.containsKey(headerNameString)) {
                    String oldValue = (String)amzHeaders.remove(headerNameString);
                    oldValue = oldValue + "," + value;
                    amzHeaders.put(headerNameString, oldValue);
                    continue;
                }
                amzHeaders.put(headerNameString, value);
            }
            for (String key : amzHeaders.keySet()) {
                String value = (String)amzHeaders.get(key);
                result = result + key + ":" + value + "\n";
            }
            return result;
        }

        private static String[] getSigInfo(String auth_part) {
            int index = auth_part.lastIndexOf(" ");
            String sigString = auth_part.substring(index + 1);
            return sigString.split(":");
        }

        private static String getS3AddressString(MappingHttpRequest httpRequest) throws AccessDeniedException {
            String addr = httpRequest.getUri();
            String targetHost = httpRequest.getHeader("Host");
            if (targetHost.contains(".walrus")) {
                String bucket = targetHost.substring(0, targetHost.indexOf(".walrus"));
                addr = "/" + bucket + addr;
            }
            String[] addrStrings = addr.split("\\?");
            StringBuilder addrString = new StringBuilder(addrStrings[0]);
            if (addrStrings.length > 1) {
                Object[] params = addrStrings[1].split("&");
                Arrays.sort(params);
                String[] pair = null;
                boolean first = true;
                try {
                    for (Object qparam : params) {
                        pair = ((String)qparam).split("=");
                        for (WalrusProperties.SubResource subResource : WalrusProperties.SubResource.values()) {
                            if (!pair[0].equals(subResource.toString())) continue;
                            if (first) {
                                addrString.append("?");
                                first = false;
                            } else {
                                addrString.append("&");
                            }
                            addrString.append(subResource.toString()).append(pair.length > 1 ? "=" + WalrusUtil.URLdecode(pair[1]) : "");
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new AccessDeniedException("Could not verify request. Failed url decoding query parameters: " + e.getMessage());
                }
            }
            return addrString.toString();
        }
    }

    private static enum AuthorizationField {
        Type,
        AccessKeyId,
        CertFingerPrint,
        SignedHeaders,
        Signature;

    }

    public static enum SecurityParameter {
        AWSAccessKeyId,
        Timestamp,
        Expires,
        Signature,
        Authorization,
        Date,
        Content_MD5,
        Content_Type,
        SecurityToken;

    }
}

