/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.pipeline;

import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.walrus.pipeline.WalrusPOSTAuthenticationHandler;
import com.eucalyptus.walrus.util.WalrusProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonSlurper;
import org.apache.log4j.Logger;
import org.apache.tools.ant.util.DateUtils;
import org.bouncycastle.util.encoders.Base64;

public class UploadPolicyChecker {
    private static Logger LOG = Logger.getLogger(UploadPolicyChecker.class);

    public static void checkPolicy(MappingHttpRequest httpRequest, Map<String, String> formFields) throws AuthenticationException {
        if (formFields.containsKey(WalrusProperties.FormField.policy.toString())) {
            String policyData;
            String authenticationHeader = "";
            String policy = new String(Base64.decode((String)formFields.remove(WalrusProperties.FormField.policy.toString())));
            try {
                policyData = new String(Base64.encode((byte[])policy.getBytes()));
            }
            catch (Exception ex) {
                LOG.warn((Object)ex, (Throwable)ex);
                throw new AuthenticationException("error reading policy data.");
            }
            try {
                JsonSlurper jsonSlurper = new JsonSlurper();
                JSONObject policyObject = (JSONObject)jsonSlurper.parseText(policy);
                String expiration = (String)policyObject.get(WalrusProperties.PolicyHeaders.expiration.toString());
                if (expiration != null) {
                    Date expirationDate = DateUtils.parseIso8601DateTimeOrDate((String)expiration);
                    if (new Date().getTime() > expirationDate.getTime()) {
                        LOG.warn((Object)"Policy has expired.");
                        throw new AuthenticationException("Policy has expired.");
                    }
                }
                ArrayList<String> policyItemNames = new ArrayList<String>();
                JSONArray conditions = (JSONArray)policyObject.get(WalrusProperties.PolicyHeaders.conditions.toString());
                for (int i = 0; i < conditions.size(); ++i) {
                    JSONArray jsonArray;
                    Object policyItem = conditions.get(i);
                    if (policyItem instanceof JSONObject) {
                        JSONObject jsonObject = (JSONObject)policyItem;
                        if (UploadPolicyChecker.exactMatch(jsonObject, formFields, policyItemNames)) continue;
                        LOG.warn((Object)"Policy verification failed. ");
                        throw new AuthenticationException("Policy verification failed.");
                    }
                    if (!(policyItem instanceof JSONArray) || UploadPolicyChecker.partialMatch(jsonArray = (JSONArray)policyItem, formFields, policyItemNames)) continue;
                    LOG.warn((Object)"Policy verification failed. ");
                    throw new AuthenticationException("Policy verification failed.");
                }
                Set<String> formFieldsKeys = formFields.keySet();
                for (String formKey : formFieldsKeys) {
                    if (formKey.startsWith("x-ignore-")) continue;
                    boolean fieldOkay = false;
                    for (WalrusProperties.IgnoredFields field : WalrusProperties.IgnoredFields.values()) {
                        if (!formKey.equals(field.toString())) continue;
                        fieldOkay = true;
                        break;
                    }
                    if (fieldOkay || policyItemNames.contains(formKey)) continue;
                    LOG.error((Object)("All fields except those marked with x-ignore- should be in policy. Form Key: " + formKey));
                    throw new AuthenticationException("All fields except those marked with x-ignore- should be in policy.");
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)ex);
                throw new AuthenticationException((Throwable)ex);
            }
            if (formFields.containsKey(WalrusProperties.FormField.AWSAccessKeyId.toString())) {
                String accessKeyId = formFields.remove(WalrusProperties.FormField.AWSAccessKeyId.toString());
                authenticationHeader = authenticationHeader + "AWS " + accessKeyId + ":";
            }
            if (formFields.containsKey(WalrusProperties.FormField.signature.toString())) {
                String signature = formFields.remove(WalrusProperties.FormField.signature.toString());
                authenticationHeader = authenticationHeader + signature;
                httpRequest.addHeader(WalrusPOSTAuthenticationHandler.SecurityParameter.Authorization.toString(), (Object)authenticationHeader);
            }
            httpRequest.addHeader(WalrusProperties.FormField.FormUploadPolicyData.toString(), (Object)policyData);
        }
    }

    private static boolean exactMatch(JSONObject jsonObject, Map<String, String> formFields, List<String> policyItemNames) {
        Iterator iterator = jsonObject.keys();
        String key = null;
        boolean returnValue = false;
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            key = key.replaceAll("\\$", "");
            policyItemNames.add(key);
            try {
                if (jsonObject.get(key).equals(formFields.get(key).trim())) {
                    returnValue = true;
                    continue;
                }
                returnValue = false;
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                return false;
            }
        }
        if (!returnValue) {
            LOG.error((Object)("exact match on " + key + " failed"));
        }
        return returnValue;
    }

    private static boolean partialMatch(JSONArray jsonArray, Map<String, String> formFields, List<String> policyItemNames) {
        String key;
        boolean returnValue = false;
        if (jsonArray.size() != 3) {
            return false;
        }
        try {
            String condition = (String)jsonArray.get(0);
            key = (String)jsonArray.get(1);
            key = key.replaceAll("\\$", "");
            policyItemNames.add(key);
            String value = (String)jsonArray.get(2);
            if (condition.contains("eq")) {
                if (value.equals(formFields.get(key).trim())) {
                    returnValue = true;
                }
            } else if (condition.contains("starts-with")) {
                if (!formFields.containsKey(key)) {
                    return false;
                }
                if (formFields.get(key).trim().startsWith(value)) {
                    returnValue = true;
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return false;
        }
        if (!returnValue) {
            LOG.error((Object)("partial match on " + key + " failed"));
        }
        return returnValue;
    }
}

