/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.bittorrent;

import com.eucalyptus.auth.util.Hashes;
import com.eucalyptus.records.Logs;
import com.eucalyptus.walrus.util.WalrusProperties;
import edu.ucsb.eucalyptus.util.StreamConsumer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TorrentCreator {
    private static Logger LOG = Logger.getLogger(TorrentCreator.class);
    private String torrentFilePath;
    private String filePath;
    private String trackerUrl;
    private String objectKey;
    private String objectName;
    private final String NAME_TAG = "name";

    public TorrentCreator(String filePath, String objectKey, String objectName, String torrentFilePath, String trackerUrl) {
        this.filePath = filePath;
        this.torrentFilePath = torrentFilePath;
        this.trackerUrl = trackerUrl;
        this.objectKey = objectKey;
        this.objectName = objectName;
    }

    private void makeTorrent() {
        new File(WalrusProperties.TRACKER_DIR).mkdirs();
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(new String[]{"btmakemetafile", this.filePath, this.trackerUrl, "--target", this.torrentFilePath});
            StreamConsumer error = new StreamConsumer(proc.getErrorStream());
            StreamConsumer output = new StreamConsumer(proc.getInputStream());
            error.start();
            output.start();
            int pid = proc.waitFor();
            output.join();
            String errValue = error.getReturnValue();
            String outValue = output.getReturnValue();
            if (errValue.length() > 0) {
                LOG.warn((Object)errValue);
            }
            if (outValue.length() > 0) {
                LOG.warn((Object)outValue);
            }
        }
        catch (Exception t) {
            LOG.error((Object)t);
        }
    }

    private void changeName() throws Exception {
        File inFile = new File(this.torrentFilePath);
        File outFile = new File(this.torrentFilePath + Hashes.getRandom((int)6));
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(inFile));
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(outFile));
        int totalBytesRead = 0;
        byte[] bytes = new byte[102400];
        String inString = "";
        try {
            int bytesRead;
            while ((bytesRead = inStream.read(bytes)) > 0) {
                inString = inString + new String(bytes, 0, bytesRead);
                totalBytesRead += bytesRead;
            }
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
            }
        }
        int len = inString.length();
        int idx = inString.indexOf("name");
        int lastidx = inString.indexOf(this.objectName) + this.objectName.length();
        try {
            outStream.write(bytes, 0, idx + "name".length());
            outStream.write(new String(this.objectKey.length() + ":" + this.objectKey).getBytes());
            outStream.write(bytes, lastidx, totalBytesRead - lastidx);
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                outStream.close();
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
            }
        }
        outFile.renameTo(inFile);
    }

    public void create() throws Exception {
        this.makeTorrent();
        this.changeName();
    }
}

