/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.auth;

import com.eucalyptus.auth.login.WrappedCredentials;
import javax.annotation.Nullable;

public class WalrusWrappedCredentials
extends WrappedCredentials<String> {
    private final String queryId;
    private final String signature;
    private final String securityToken;

    public WalrusWrappedCredentials(String correlationId, String data, String accessKeyId, String signature, String securityToken) {
        super(correlationId, (Object)data);
        this.queryId = accessKeyId;
        this.signature = signature;
        this.securityToken = securityToken;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public QueryIdCredential getQueryIdCredential() {
        return new QueryIdCredential(this.getQueryId());
    }

    public String getSignature() {
        return this.signature;
    }

    @Nullable
    public String getSecurityToken() {
        return this.securityToken;
    }

    public static final class QueryIdCredential {
        private final String queryId;

        private QueryIdCredential(String queryId) {
            this.queryId = queryId;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public String toString() {
            return this.getQueryId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryIdCredential that = (QueryIdCredential)o;
            return this.queryId.equals(that.queryId);
        }

        public int hashCode() {
            return this.queryId.hashCode();
        }
    }
}

