/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.auth;

import com.eucalyptus.auth.AccessKeys;
import com.eucalyptus.auth.api.BaseLoginModule;
import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.crypto.Hmac;
import com.eucalyptus.walrus.auth.WalrusWrappedCredentials;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.apache.xml.security.utils.Base64;

public class WalrusLoginModule
extends BaseLoginModule<WalrusWrappedCredentials> {
    private static Logger LOG = Logger.getLogger(WalrusLoginModule.class);

    public boolean accepts() {
        return super.getCallbackHandler() instanceof WalrusWrappedCredentials;
    }

    public boolean authenticate(WalrusWrappedCredentials credentials) throws Exception {
        String signature = credentials.getSignature().replaceAll("=", "");
        AccessKey key = AccessKeys.lookupAccessKey((String)credentials.getQueryId(), (String)credentials.getSecurityToken());
        if (!key.isActive().booleanValue()) {
            throw new AuthenticationException("The AWS Access Key Id you provided does not exist in our records.");
        }
        User user = key.getUser();
        String queryKey = key.getSecretKey();
        String authSig = this.checkSignature(queryKey, (String)credentials.getLoginData());
        if (authSig.equals(signature)) {
            super.setCredential((Object)credentials.getQueryIdCredential());
            super.setPrincipal(user);
            return true;
        }
        return false;
    }

    public void reset() {
    }

    protected String checkSignature(String queryKey, String subject) throws AuthenticationException {
        SecretKeySpec signingKey = new SecretKeySpec(queryKey.getBytes(), Hmac.HmacSHA1.toString());
        try {
            Mac mac = Mac.getInstance(Hmac.HmacSHA1.toString());
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(subject.getBytes());
            return new String(Base64.encode((byte[])rawHmac)).replaceAll("=", "");
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new AuthenticationException("Failed to compute signature");
        }
    }
}

