/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus;

import com.eucalyptus.entities.Transactions;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.walrus.entities.BucketInfo;
import com.eucalyptus.walrus.exceptions.InternalErrorException;
import com.eucalyptus.walrus.exceptions.NoSuchBucketException;
import com.eucalyptus.walrus.msgs.AbortMultipartUploadResponseType;
import com.eucalyptus.walrus.msgs.AbortMultipartUploadType;
import com.eucalyptus.walrus.msgs.AddObjectResponseType;
import com.eucalyptus.walrus.msgs.AddObjectType;
import com.eucalyptus.walrus.msgs.CompleteMultipartUploadResponseType;
import com.eucalyptus.walrus.msgs.CompleteMultipartUploadType;
import com.eucalyptus.walrus.msgs.CopyObjectResponseType;
import com.eucalyptus.walrus.msgs.CopyObjectType;
import com.eucalyptus.walrus.msgs.CreateBucketResponseType;
import com.eucalyptus.walrus.msgs.CreateBucketType;
import com.eucalyptus.walrus.msgs.DeleteBucketResponseType;
import com.eucalyptus.walrus.msgs.DeleteBucketType;
import com.eucalyptus.walrus.msgs.DeleteObjectResponseType;
import com.eucalyptus.walrus.msgs.DeleteObjectType;
import com.eucalyptus.walrus.msgs.DeleteVersionResponseType;
import com.eucalyptus.walrus.msgs.DeleteVersionType;
import com.eucalyptus.walrus.msgs.GetBucketAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.GetBucketAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.GetBucketLocationResponseType;
import com.eucalyptus.walrus.msgs.GetBucketLocationType;
import com.eucalyptus.walrus.msgs.GetBucketLoggingStatusResponseType;
import com.eucalyptus.walrus.msgs.GetBucketLoggingStatusType;
import com.eucalyptus.walrus.msgs.GetBucketVersioningStatusResponseType;
import com.eucalyptus.walrus.msgs.GetBucketVersioningStatusType;
import com.eucalyptus.walrus.msgs.GetObjectAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.GetObjectAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.GetObjectExtendedResponseType;
import com.eucalyptus.walrus.msgs.GetObjectExtendedType;
import com.eucalyptus.walrus.msgs.GetObjectResponseType;
import com.eucalyptus.walrus.msgs.GetObjectType;
import com.eucalyptus.walrus.msgs.HeadBucketResponseType;
import com.eucalyptus.walrus.msgs.HeadBucketType;
import com.eucalyptus.walrus.msgs.InitiateMultipartUploadResponseType;
import com.eucalyptus.walrus.msgs.InitiateMultipartUploadType;
import com.eucalyptus.walrus.msgs.ListAllMyBucketsResponseType;
import com.eucalyptus.walrus.msgs.ListAllMyBucketsType;
import com.eucalyptus.walrus.msgs.ListBucketResponseType;
import com.eucalyptus.walrus.msgs.ListBucketType;
import com.eucalyptus.walrus.msgs.ListVersionsResponseType;
import com.eucalyptus.walrus.msgs.ListVersionsType;
import com.eucalyptus.walrus.msgs.PostObjectResponseType;
import com.eucalyptus.walrus.msgs.PostObjectType;
import com.eucalyptus.walrus.msgs.PutObjectInlineResponseType;
import com.eucalyptus.walrus.msgs.PutObjectInlineType;
import com.eucalyptus.walrus.msgs.PutObjectResponseType;
import com.eucalyptus.walrus.msgs.PutObjectType;
import com.eucalyptus.walrus.msgs.SetBucketAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetBucketAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.SetBucketLoggingStatusResponseType;
import com.eucalyptus.walrus.msgs.SetBucketLoggingStatusType;
import com.eucalyptus.walrus.msgs.SetBucketVersioningStatusResponseType;
import com.eucalyptus.walrus.msgs.SetBucketVersioningStatusType;
import com.eucalyptus.walrus.msgs.SetObjectAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetObjectAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.SetRESTBucketAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetRESTBucketAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.SetRESTObjectAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetRESTObjectAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.UploadPartResponseType;
import com.eucalyptus.walrus.msgs.UploadPartType;
import com.eucalyptus.walrus.util.WalrusProperties;
import java.net.InetAddress;
import java.util.NoSuchElementException;

public abstract class WalrusManager {
    public static void configure() {
    }

    public abstract void initialize() throws EucalyptusCloudException;

    public abstract void check() throws EucalyptusCloudException;

    public abstract void start() throws EucalyptusCloudException;

    public abstract void stop() throws EucalyptusCloudException;

    public abstract ListAllMyBucketsResponseType listAllMyBuckets(ListAllMyBucketsType var1) throws EucalyptusCloudException;

    public abstract HeadBucketResponseType headBucket(HeadBucketType var1) throws EucalyptusCloudException;

    public abstract CreateBucketResponseType createBucket(CreateBucketType var1) throws EucalyptusCloudException;

    public abstract DeleteBucketResponseType deleteBucket(DeleteBucketType var1) throws EucalyptusCloudException;

    public abstract GetBucketAccessControlPolicyResponseType getBucketAccessControlPolicy(GetBucketAccessControlPolicyType var1) throws EucalyptusCloudException;

    public abstract PutObjectResponseType putObject(PutObjectType var1) throws EucalyptusCloudException;

    public abstract PostObjectResponseType postObject(PostObjectType var1) throws EucalyptusCloudException;

    public abstract PutObjectInlineResponseType putObjectInline(PutObjectInlineType var1) throws EucalyptusCloudException;

    public abstract AddObjectResponseType addObject(AddObjectType var1) throws EucalyptusCloudException;

    public abstract DeleteObjectResponseType deleteObject(DeleteObjectType var1) throws EucalyptusCloudException;

    public abstract ListBucketResponseType listBucket(ListBucketType var1) throws EucalyptusCloudException;

    public abstract GetObjectAccessControlPolicyResponseType getObjectAccessControlPolicy(GetObjectAccessControlPolicyType var1) throws EucalyptusCloudException;

    public abstract SetBucketAccessControlPolicyResponseType setBucketAccessControlPolicy(SetBucketAccessControlPolicyType var1) throws EucalyptusCloudException;

    public abstract SetRESTBucketAccessControlPolicyResponseType setRESTBucketAccessControlPolicy(SetRESTBucketAccessControlPolicyType var1) throws EucalyptusCloudException;

    public abstract SetObjectAccessControlPolicyResponseType setObjectAccessControlPolicy(SetObjectAccessControlPolicyType var1) throws EucalyptusCloudException;

    public abstract SetRESTObjectAccessControlPolicyResponseType setRESTObjectAccessControlPolicy(SetRESTObjectAccessControlPolicyType var1) throws EucalyptusCloudException;

    public abstract GetObjectResponseType getObject(GetObjectType var1) throws EucalyptusCloudException;

    public abstract GetObjectExtendedResponseType getObjectExtended(GetObjectExtendedType var1) throws EucalyptusCloudException;

    public abstract GetBucketLocationResponseType getBucketLocation(GetBucketLocationType var1) throws EucalyptusCloudException;

    public abstract CopyObjectResponseType copyObject(CopyObjectType var1) throws EucalyptusCloudException;

    public abstract SetBucketLoggingStatusResponseType setBucketLoggingStatus(SetBucketLoggingStatusType var1) throws EucalyptusCloudException;

    public abstract GetBucketLoggingStatusResponseType getBucketLoggingStatus(GetBucketLoggingStatusType var1) throws EucalyptusCloudException;

    public abstract GetBucketVersioningStatusResponseType getBucketVersioningStatus(GetBucketVersioningStatusType var1) throws EucalyptusCloudException;

    public abstract SetBucketVersioningStatusResponseType setBucketVersioningStatus(SetBucketVersioningStatusType var1) throws EucalyptusCloudException;

    public abstract ListVersionsResponseType listVersions(ListVersionsType var1) throws EucalyptusCloudException;

    public abstract DeleteVersionResponseType deleteVersion(DeleteVersionType var1) throws EucalyptusCloudException;

    public abstract void fastDeleteObject(DeleteObjectType var1) throws EucalyptusCloudException;

    public abstract void fastDeleteBucket(DeleteBucketType var1) throws EucalyptusCloudException;

    public abstract InitiateMultipartUploadResponseType initiateMultipartUpload(InitiateMultipartUploadType var1) throws EucalyptusCloudException;

    public abstract CompleteMultipartUploadResponseType completeMultipartUpload(CompleteMultipartUploadType var1) throws EucalyptusCloudException;

    public abstract AbortMultipartUploadResponseType abortMultipartUpload(AbortMultipartUploadType var1) throws EucalyptusCloudException;

    public abstract UploadPartResponseType uploadPart(UploadPartType var1) throws EucalyptusCloudException;

    public static InetAddress getBucketIp(String bucket) throws EucalyptusCloudException {
        try {
            Transactions.find((Object)new BucketInfo(bucket));
            return WalrusProperties.getWalrusAddress();
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucket);
        }
        catch (Exception e) {
            throw new InternalErrorException("Failed to lookup bucket " + bucket, (Throwable)e);
        }
    }
}

