/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus;

import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.util.Hashes;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Topology;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.storage.common.DateFormatter;
import com.eucalyptus.storage.common.fs.FileIO;
import com.eucalyptus.storage.msgs.s3.AccessControlList;
import com.eucalyptus.storage.msgs.s3.AccessControlPolicy;
import com.eucalyptus.storage.msgs.s3.BucketListEntry;
import com.eucalyptus.storage.msgs.s3.CanonicalUser;
import com.eucalyptus.storage.msgs.s3.CommonPrefixesEntry;
import com.eucalyptus.storage.msgs.s3.Grant;
import com.eucalyptus.storage.msgs.s3.Grantee;
import com.eucalyptus.storage.msgs.s3.ListAllMyBucketsList;
import com.eucalyptus.storage.msgs.s3.ListEntry;
import com.eucalyptus.storage.msgs.s3.MetaDataEntry;
import com.eucalyptus.storage.msgs.s3.Part;
import com.eucalyptus.storage.msgs.s3.Status;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.walrus.StorageManager;
import com.eucalyptus.walrus.WalrusBackend;
import com.eucalyptus.walrus.WalrusManager;
import com.eucalyptus.walrus.entities.BucketInfo;
import com.eucalyptus.walrus.entities.MetaDataInfo;
import com.eucalyptus.walrus.entities.ObjectInfo;
import com.eucalyptus.walrus.entities.PartInfo;
import com.eucalyptus.walrus.entities.WalrusInfo;
import com.eucalyptus.walrus.exceptions.AccessDeniedException;
import com.eucalyptus.walrus.exceptions.BucketAlreadyExistsException;
import com.eucalyptus.walrus.exceptions.BucketNotEmptyException;
import com.eucalyptus.walrus.exceptions.ContentMismatchException;
import com.eucalyptus.walrus.exceptions.HeadNoSuchBucketException;
import com.eucalyptus.walrus.exceptions.HeadNoSuchEntityException;
import com.eucalyptus.walrus.exceptions.InlineDataTooLargeException;
import com.eucalyptus.walrus.exceptions.InternalErrorException;
import com.eucalyptus.walrus.exceptions.InvalidArgumentException;
import com.eucalyptus.walrus.exceptions.InvalidPartException;
import com.eucalyptus.walrus.exceptions.InvalidRangeException;
import com.eucalyptus.walrus.exceptions.MethodNotAllowedException;
import com.eucalyptus.walrus.exceptions.NoSuchBucketException;
import com.eucalyptus.walrus.exceptions.NoSuchEntityException;
import com.eucalyptus.walrus.exceptions.NoSuchUploadException;
import com.eucalyptus.walrus.exceptions.NotModifiedException;
import com.eucalyptus.walrus.exceptions.PreconditionFailedException;
import com.eucalyptus.walrus.exceptions.WalrusException;
import com.eucalyptus.walrus.msgs.AbortMultipartUploadResponseType;
import com.eucalyptus.walrus.msgs.AbortMultipartUploadType;
import com.eucalyptus.walrus.msgs.AddObjectResponseType;
import com.eucalyptus.walrus.msgs.AddObjectType;
import com.eucalyptus.walrus.msgs.CompleteMultipartUploadResponseType;
import com.eucalyptus.walrus.msgs.CompleteMultipartUploadType;
import com.eucalyptus.walrus.msgs.CopyObjectResponseType;
import com.eucalyptus.walrus.msgs.CopyObjectType;
import com.eucalyptus.walrus.msgs.CreateBucketResponseType;
import com.eucalyptus.walrus.msgs.CreateBucketType;
import com.eucalyptus.walrus.msgs.DeleteBucketResponseType;
import com.eucalyptus.walrus.msgs.DeleteBucketType;
import com.eucalyptus.walrus.msgs.DeleteObjectResponseType;
import com.eucalyptus.walrus.msgs.DeleteObjectType;
import com.eucalyptus.walrus.msgs.DeleteVersionResponseType;
import com.eucalyptus.walrus.msgs.DeleteVersionType;
import com.eucalyptus.walrus.msgs.GetBucketAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.GetBucketAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.GetBucketLocationResponseType;
import com.eucalyptus.walrus.msgs.GetBucketLocationType;
import com.eucalyptus.walrus.msgs.GetBucketLoggingStatusResponseType;
import com.eucalyptus.walrus.msgs.GetBucketLoggingStatusType;
import com.eucalyptus.walrus.msgs.GetBucketVersioningStatusResponseType;
import com.eucalyptus.walrus.msgs.GetBucketVersioningStatusType;
import com.eucalyptus.walrus.msgs.GetObjectAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.GetObjectAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.GetObjectExtendedResponseType;
import com.eucalyptus.walrus.msgs.GetObjectExtendedType;
import com.eucalyptus.walrus.msgs.GetObjectResponseType;
import com.eucalyptus.walrus.msgs.GetObjectType;
import com.eucalyptus.walrus.msgs.HeadBucketResponseType;
import com.eucalyptus.walrus.msgs.HeadBucketType;
import com.eucalyptus.walrus.msgs.InitiateMultipartUploadResponseType;
import com.eucalyptus.walrus.msgs.InitiateMultipartUploadType;
import com.eucalyptus.walrus.msgs.ListAllMyBucketsResponseType;
import com.eucalyptus.walrus.msgs.ListAllMyBucketsType;
import com.eucalyptus.walrus.msgs.ListBucketResponseType;
import com.eucalyptus.walrus.msgs.ListBucketType;
import com.eucalyptus.walrus.msgs.ListVersionsResponseType;
import com.eucalyptus.walrus.msgs.ListVersionsType;
import com.eucalyptus.walrus.msgs.PostObjectResponseType;
import com.eucalyptus.walrus.msgs.PostObjectType;
import com.eucalyptus.walrus.msgs.PutObjectInlineResponseType;
import com.eucalyptus.walrus.msgs.PutObjectInlineType;
import com.eucalyptus.walrus.msgs.PutObjectResponseType;
import com.eucalyptus.walrus.msgs.PutObjectType;
import com.eucalyptus.walrus.msgs.SetBucketAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetBucketAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.SetBucketLoggingStatusResponseType;
import com.eucalyptus.walrus.msgs.SetBucketLoggingStatusType;
import com.eucalyptus.walrus.msgs.SetBucketVersioningStatusResponseType;
import com.eucalyptus.walrus.msgs.SetBucketVersioningStatusType;
import com.eucalyptus.walrus.msgs.SetObjectAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetObjectAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.SetRESTBucketAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetRESTBucketAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.SetRESTObjectAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetRESTObjectAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.UploadPartResponseType;
import com.eucalyptus.walrus.msgs.UploadPartType;
import com.eucalyptus.walrus.msgs.WalrusDataGetResponseType;
import com.eucalyptus.walrus.msgs.WalrusDataMessage;
import com.eucalyptus.walrus.msgs.WalrusDataMessenger;
import com.eucalyptus.walrus.msgs.WalrusDataQueue;
import com.eucalyptus.walrus.msgs.WalrusMonitor;
import com.eucalyptus.walrus.pipeline.WalrusRESTBinding;
import com.eucalyptus.walrus.util.WalrusProperties;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.util.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class WalrusFSManager
extends WalrusManager {
    private static Logger LOG = Logger.getLogger(WalrusFSManager.class);
    private StorageManager storageManager;

    public static void configure() {
    }

    public WalrusFSManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @Override
    public void initialize() throws EucalyptusCloudException {
        this.check();
    }

    @Override
    public void check() throws EucalyptusCloudException {
        WalrusInfo walrusInfo = WalrusInfo.getWalrusInfo();
        String bukkitDir = walrusInfo.getStorageDir();
        File bukkits = new File(bukkitDir);
        if (!bukkits.exists()) {
            if (!bukkits.mkdirs()) {
                LOG.fatal((Object)("Unable to make bucket root directory: " + bukkitDir));
                throw new InternalErrorException("Invalid bucket root directory");
            }
        } else if (!bukkits.canWrite()) {
            LOG.fatal((Object)("Cannot write to bucket root directory: " + bukkitDir));
            throw new InternalErrorException("Invalid bucket root directory");
        }
        try {
            SystemUtil.setEucaReadWriteOnly((String)bukkitDir);
        }
        catch (EucalyptusCloudException ex) {
            LOG.fatal((Object)ex);
        }
    }

    @Override
    public void start() throws EucalyptusCloudException {
    }

    @Override
    public void stop() throws EucalyptusCloudException {
    }

    @Override
    public ListAllMyBucketsResponseType listAllMyBuckets(ListAllMyBucketsType request) throws WalrusException {
        ListAllMyBucketsResponseType reply = (ListAllMyBucketsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        Account account = ctx.getAccount();
        if (account == null) {
            throw new AccessDeniedException("no such account");
        }
        try {
            BucketInfo searchBucket = new BucketInfo();
            searchBucket.setOwnerId(account.getAccountNumber());
            List bucketInfoList = Transactions.findAll((Object)searchBucket);
            ListAllMyBucketsList bucketList = new ListAllMyBucketsList();
            if (bucketInfoList != null && !bucketInfoList.isEmpty()) {
                bucketList.setBuckets((ArrayList)Lists.transform((List)bucketInfoList, (Function)new Function<BucketInfo, BucketListEntry>(){

                    public BucketListEntry apply(BucketInfo arg0) {
                        return new BucketListEntry(arg0.getBucketName(), DateFormatter.dateToListingFormattedString((Date)arg0.getCreationDate()));
                    }
                }));
            } else {
                bucketList.setBuckets(new ArrayList());
            }
            reply.setBucketList(bucketList);
            reply.setOwner(new CanonicalUser(account.getCanonicalId(), account.getName()));
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to list buckets for account " + account.getDisplayName()), (Throwable)e);
            throw new InternalErrorException("Failed to list buckets for account " + account.getDisplayName(), (Throwable)e);
        }
        return reply;
    }

    @Override
    public HeadBucketResponseType headBucket(HeadBucketType request) throws WalrusException {
        HeadBucketResponseType reply = (HeadBucketResponseType)request.getReply();
        String bucketName = request.getBucket();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
            return reply;
        }
        catch (NoSuchElementException e) {
            throw new HeadNoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Faild to look up bucket=" + bucketName), (Throwable)e);
            throw new HeadNoSuchBucketException("Faild to look up bucket=" + bucketName, (Throwable)e);
        }
    }

    @Override
    public CreateBucketResponseType createBucket(CreateBucketType request) throws WalrusException {
        CreateBucketResponseType reply = (CreateBucketResponseType)request.getReply();
        String bucketName = request.getBucket();
        String locationConstraint = request.getLocationConstraint();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
            throw new BucketAlreadyExistsException(bucketName);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (WalrusException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Faild to look up metadata for bucket " + bucketName, (Throwable)e);
        }
        try {
            BucketInfo bucket = new BucketInfo(bucketName, new Date());
            bucket.setBucketSize(Long.valueOf(0L));
            bucket.setLoggingEnabled(Boolean.valueOf(false));
            if (locationConstraint != null && locationConstraint.length() > 0) {
                bucket.setLocation(locationConstraint);
            } else {
                bucket.setLocation(null);
            }
            try {
                this.storageManager.createBucket(bucketName);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to create bucket " + bucketName + " on disk"), (Throwable)e);
                throw new InternalErrorException("Failed to create bucket " + bucketName + " on disk", (Throwable)e);
            }
            Transactions.saveDirect((Object)bucket);
        }
        catch (WalrusException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to save metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to save metadata for bucket=" + bucketName, (Throwable)e);
        }
        reply.setBucket(bucketName);
        return reply;
    }

    @Override
    public DeleteBucketResponseType deleteBucket(DeleteBucketType request) throws WalrusException {
        DeleteBucketResponseType reply = (DeleteBucketResponseType)request.getReply();
        String bucketName = request.getBucket();
        try (TransactionResource tr = Entities.transactionFor(BucketInfo.class);){
            BucketInfo bucketInfo = (BucketInfo)Entities.uniqueResult((Object)new BucketInfo(bucketName));
            ObjectInfo searchObject = new ObjectInfo();
            searchObject.setBucketName(bucketName);
            List objects = Transactions.findAll((Object)searchObject);
            if (objects != null && !objects.isEmpty()) {
                tr.commit();
                throw new BucketNotEmptyException(bucketName);
            }
            Entities.delete((Object)bucketInfo);
            Threads.lookup(WalrusBackend.class, ObjectDeleter.class).limitTo(Integer.valueOf(10)).submit((Runnable)new BucketDeleter(bucketName));
            tr.commit();
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to delete bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to delete bucket=" + bucketName, (Throwable)e);
        }
        reply.setStatus(HttpResponseStatus.NO_CONTENT);
        reply.setStatusMessage("NO CONTENT");
        return reply;
    }

    @Override
    public GetBucketAccessControlPolicyResponseType getBucketAccessControlPolicy(GetBucketAccessControlPolicyType request) throws WalrusException {
        Context ctx = Contexts.lookup();
        Account account = ctx.getAccount();
        GetBucketAccessControlPolicyResponseType reply = (GetBucketAccessControlPolicyResponseType)request.getReply();
        String bucketName = request.getBucket();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to lookup metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup metadata for bucket=" + bucketName, (Throwable)e);
        }
        reply.setAccessControlPolicy(WalrusFSManager.getPrivateACP(account.getCanonicalId(), account.getName()));
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutObjectResponseType putObject(PutObjectType request) throws WalrusException {
        PutObjectResponseType reply = (PutObjectResponseType)request.getReply();
        String bucketName = request.getBucket();
        String objectKey = request.getKey();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup metadata for bucket=" + bucketName, (Throwable)e);
        }
        long size = 0L;
        Date lastModified = null;
        String md5 = new String();
        String key = bucketName + "." + objectKey;
        String randomKey = request.getRandomKey();
        String prevObjectName = null;
        String tempObjectName = UUID.randomUUID().toString();
        String objectName = UUID.randomUUID().toString();
        WalrusDataMessenger messenger = WalrusRESTBinding.getWriteMessenger();
        WalrusDataQueue putQueue = messenger.getQueue(key, randomKey);
        try {
            WalrusDataMessage dataMessage;
            MessageDigest digest = null;
            FileIO fileIO = null;
            while ((dataMessage = (WalrusDataMessage)putQueue.poll(60L, TimeUnit.SECONDS)) != null) {
                WalrusMonitor monitor;
                if (putQueue.getInterrupted()) {
                    if (!WalrusDataMessage.isEOF((WalrusDataMessage)dataMessage)) continue;
                    monitor = messenger.getMonitor(key);
                    if (monitor.getLastModified() == null) {
                        LOG.trace((Object)("Monitor wait: " + key + " random: " + randomKey));
                        WalrusMonitor walrusMonitor = monitor;
                        synchronized (walrusMonitor) {
                            monitor.wait();
                        }
                    }
                    LOG.trace((Object)("Monitor resume: " + key + " random: " + randomKey));
                    lastModified = monitor.getLastModified();
                    md5 = monitor.getMd5();
                    if (fileIO != null) {
                        fileIO.finish();
                    }
                    ObjectDeleter objectDeleter = new ObjectDeleter(bucketName, tempObjectName, null, null);
                    Threads.lookup(WalrusBackend.class, ObjectDeleter.class).limitTo(Integer.valueOf(10)).submit((Runnable)objectDeleter);
                    LOG.warn((Object)("Transfer interrupted: " + key));
                    messenger.removeQueue(key, randomKey);
                    break;
                }
                if (WalrusDataMessage.isStart((WalrusDataMessage)dataMessage)) {
                    digest = Digest.MD5.get();
                    try {
                        fileIO = this.storageManager.prepareForWrite(bucketName, tempObjectName);
                        continue;
                    }
                    catch (Exception ex) {
                        messenger.removeQueue(key, randomKey);
                        throw new AccessDeniedException((Throwable)ex);
                    }
                }
                if (WalrusDataMessage.isEOF((WalrusDataMessage)dataMessage)) {
                    Throwable throwable;
                    String contentMD5AsHex;
                    if (digest == null) {
                        monitor = messenger.getMonitor(key);
                        md5 = monitor.getMd5();
                        lastModified = monitor.getLastModified();
                        if (md5 != null) break;
                        LOG.error((Object)("ETag did not match for: " + randomKey + " Computed MD5 is null"));
                        throw new ContentMismatchException(bucketName + "/" + objectKey);
                    }
                    md5 = Hashes.bytesToHex((byte[])digest.digest());
                    String contentMD5 = request.getContentMD5();
                    if (contentMD5 != null && !(contentMD5AsHex = Hashes.bytesToHex((byte[])Base64.decode((String)contentMD5))).equals(md5)) {
                        if (fileIO != null) {
                            fileIO.finish();
                        }
                        this.cleanupTempObject(bucketName, tempObjectName);
                        messenger.removeQueue(key, randomKey);
                        LOG.error((Object)("ETag did not match for: " + randomKey + " Expected: " + contentMD5AsHex + " Computed: " + md5));
                        throw new ContentMismatchException(bucketName + "/" + objectKey);
                    }
                    try {
                        if (fileIO != null) {
                            fileIO.finish();
                        }
                        this.storageManager.renameObject(bucketName, tempObjectName, objectName);
                    }
                    catch (IOException ex) {
                        LOG.error((Object)("Failed to rename file " + tempObjectName + " to " + objectName + ". object-key=" + objectKey + ", bucket=" + bucketName));
                        messenger.removeQueue(key, randomKey);
                        throw new AccessDeniedException(objectKey);
                    }
                    lastModified = new Date();
                    try {
                        throwable = null;
                        try (TransactionResource tr = Entities.transactionFor(ObjectInfo.class);){
                            ObjectInfo objectInfo = null;
                            try {
                                objectInfo = (ObjectInfo)Entities.uniqueResult((Object)new ObjectInfo(bucketName, objectKey));
                                prevObjectName = objectInfo.getObjectName();
                            }
                            catch (NoSuchElementException e) {
                                objectInfo = (ObjectInfo)Entities.persist((Object)new ObjectInfo(bucketName, objectKey));
                            }
                            objectInfo.replaceMetaData((List)request.getMetaData());
                            objectInfo.setEtag(md5);
                            objectInfo.setSize(Long.valueOf(size));
                            objectInfo.setLastModified(lastModified);
                            objectInfo.setObjectName(objectName);
                            objectInfo.setStorageClass("STANDARD");
                            objectInfo.setContentType(request.getContentType());
                            objectInfo.setContentDisposition(request.getContentDisposition());
                            tr.commit();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to update metadata for object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
                        throw new InternalErrorException("Failed to update metadata for object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
                    }
                    if (prevObjectName != null) {
                        ObjectDeleter objectDeleter = new ObjectDeleter(bucketName, prevObjectName, null, null);
                        Threads.lookup(WalrusBackend.class, ObjectDeleter.class).limitTo(Integer.valueOf(10)).submit((Runnable)objectDeleter);
                    }
                    WalrusMonitor monitor2 = messenger.getMonitor(key);
                    throwable = monitor2;
                    synchronized (throwable) {
                        monitor2.setLastModified(lastModified);
                        monitor2.setMd5(md5);
                        monitor2.notifyAll();
                    }
                    messenger.clearQueues(key);
                    messenger.removeQueue(key, randomKey);
                    LOG.trace((Object)("Transfer complete: " + key));
                    break;
                }
                assert (WalrusDataMessage.isData((WalrusDataMessage)dataMessage));
                byte[] data = dataMessage.getPayload();
                try {
                    if (fileIO != null) {
                        fileIO.write(data);
                    }
                }
                catch (IOException ex) {
                    LOG.error((Object)ex);
                }
                size += (long)data.length;
                if (digest == null) continue;
                digest.update(data);
            }
            if (dataMessage == null) {
                messenger.removeQueue(key, randomKey);
                throw new InternalErrorException("Put timed out: " + key + "." + randomKey);
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Transfer interrupted: " + key + "." + randomKey), (Throwable)e);
            throw new InternalErrorException("Transfer interrupted: " + key + "." + randomKey);
        }
        catch (WalrusException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to perform put object for object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to perform put object for object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
        finally {
            this.cleanupTempObject(bucketName, tempObjectName);
            messenger.removeQueue(key, randomKey);
        }
        reply.setSize(Long.valueOf(size));
        reply.setEtag(md5);
        reply.setLastModified(lastModified);
        reply.setVersionId("null");
        return reply;
    }

    private void cleanupTempObject(String bucketName, String tempObjectName) {
        ObjectDeleter objectDeleter = new ObjectDeleter(bucketName, tempObjectName, null, null);
        Threads.lookup(WalrusBackend.class, ObjectDeleter.class).limitTo(Integer.valueOf(10)).submit((Runnable)objectDeleter);
    }

    @Override
    public PostObjectResponseType postObject(PostObjectType request) throws WalrusException {
        PostObjectResponseType reply = (PostObjectResponseType)request.getReply();
        String bucketName = request.getBucket();
        String key = request.getKey();
        PutObjectType putObject = new PutObjectType();
        putObject.setUserId(Contexts.lookup().getUserFullName().getUserId());
        putObject.setBucket(bucketName);
        putObject.setKey(key);
        putObject.setRandomKey(request.getRandomKey());
        putObject.setAccessControlList(request.getAccessControlList());
        putObject.setContentType(request.getContentType());
        putObject.setContentLength(request.getContentLength());
        putObject.setAccessKeyID(request.getAccessKeyID());
        putObject.setEffectiveUserId(request.getEffectiveUserId());
        putObject.setCredential(request.getCredential());
        putObject.setIsCompressed(request.getIsCompressed());
        putObject.setMetaData(request.getMetaData());
        putObject.setStorageClass(request.getStorageClass());
        PutObjectResponseType putObjectResponse = this.putObject(putObject);
        String etag = putObjectResponse.getEtag();
        reply.setEtag(etag);
        reply.setLastModified(putObjectResponse.getLastModified());
        reply.set_return(putObjectResponse.get_return());
        reply.setMetaData(putObjectResponse.getMetaData());
        reply.setErrorCode(putObjectResponse.getErrorCode());
        reply.setStatusMessage(putObjectResponse.getStatusMessage());
        reply.setLogData(putObjectResponse.getLogData());
        reply.setVersionId("null");
        String successActionRedirect = request.getSuccessActionRedirect();
        if (successActionRedirect != null) {
            try {
                URI addrUri = new URL(successActionRedirect).toURI();
                InetAddress.getByName(addrUri.getHost());
            }
            catch (Exception ex) {
                LOG.warn((Object)ex);
            }
            String paramString = "bucket=" + bucketName + "&key=" + key + "&etag=quot;" + etag + "quot;";
            reply.setRedirectUrl(successActionRedirect + "?" + paramString);
        } else {
            Integer successActionStatus = request.getSuccessActionStatus();
            if (successActionStatus != null) {
                if (successActionStatus == 200 || successActionStatus == 201) {
                    reply.setSuccessCode(successActionStatus);
                    if (successActionStatus == 200) {
                        return reply;
                    }
                    reply.setBucket(bucketName);
                    reply.setKey(key);
                    reply.setLocation(Topology.lookup(WalrusBackend.class, (Partition[])new Partition[0]).getUri().getHost() + "/" + bucketName + "/" + key);
                } else {
                    reply.setSuccessCode(Integer.valueOf(204));
                    return reply;
                }
            }
        }
        return reply;
    }

    @Override
    public PutObjectInlineResponseType putObjectInline(PutObjectInlineType request) throws WalrusException {
        PutObjectInlineResponseType reply = (PutObjectInlineResponseType)request.getReply();
        String bucketName = request.getBucket();
        String objectKey = request.getKey();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        long size = 0L;
        Date lastModified = null;
        String md5 = new String();
        String prevObjectName = null;
        String objectName = UUID.randomUUID().toString();
        try {
            if ((long)request.getBase64Data().getBytes().length > WalrusProperties.MAX_INLINE_DATA_SIZE) {
                throw new InlineDataTooLargeException(bucketName + "/" + objectKey);
            }
            byte[] base64Data = Hashes.base64decode((String)request.getBase64Data()).getBytes();
            size = base64Data.length;
            try {
                FileIO fileIO = this.storageManager.prepareForWrite(bucketName, objectName);
                if (fileIO != null) {
                    fileIO.write(base64Data);
                    fileIO.finish();
                }
            }
            catch (Exception ex) {
                throw new AccessDeniedException((Throwable)ex);
            }
            md5 = Hashes.getHexString((byte[])Digest.MD5.get().digest(base64Data));
            lastModified = new Date();
            try (TransactionResource tr = Entities.transactionFor(ObjectInfo.class);){
                ObjectInfo objectInfo = null;
                try {
                    objectInfo = (ObjectInfo)Entities.uniqueResult((Object)new ObjectInfo(bucketName, objectKey));
                    prevObjectName = objectInfo.getObjectName();
                }
                catch (NoSuchElementException e) {
                    objectInfo = (ObjectInfo)Entities.persist((Object)new ObjectInfo(bucketName, objectKey));
                }
                objectInfo.setEtag(md5);
                objectInfo.setSize(Long.valueOf(size));
                objectInfo.setLastModified(lastModified);
                objectInfo.setObjectName(objectName);
                objectInfo.setStorageClass("STANDARD");
                if (request.getMetaData() != null) {
                    objectInfo.replaceMetaData((List)request.getMetaData());
                }
                tr.commit();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to update metadata for object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
                throw new InternalErrorException("Failed to update metadata for object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
            }
            if (prevObjectName != null) {
                ObjectDeleter objectDeleter = new ObjectDeleter(bucketName, prevObjectName, null, null);
                Threads.lookup(WalrusBackend.class, ObjectDeleter.class).limitTo(Integer.valueOf(10)).submit((Runnable)objectDeleter);
            }
        }
        catch (WalrusException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to perform put object for object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to perform put object for object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
        reply.setSize(Long.valueOf(size));
        reply.setEtag(md5);
        reply.setLastModified(lastModified);
        reply.setVersionId("null");
        return reply;
    }

    @Override
    public AddObjectResponseType addObject(AddObjectType request) throws WalrusException {
        AddObjectResponseType reply = (AddObjectResponseType)request.getReply();
        String bucketName = request.getBucket();
        String objectKey = request.getKey();
        String objectName = request.getObjectName();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        ObjectInfo objectInfo = null;
        try {
            TransactionResource tr = Entities.transactionFor(ObjectInfo.class);
            Throwable throwable = null;
            try {
                try {
                    objectInfo = (ObjectInfo)Entities.uniqueResult((Object)new ObjectInfo(bucketName, objectKey));
                    throw new InternalErrorException("Object already exists " + objectKey);
                }
                catch (NoSuchElementException e) {
                    objectInfo = new ObjectInfo(bucketName, objectKey);
                    objectInfo.setObjectName(objectName);
                    objectInfo.setSize(Long.valueOf(this.storageManager.getSize(bucketName, objectName)));
                    objectInfo.setEtag(request.getEtag());
                    objectInfo.setLastModified(new Date());
                    objectInfo.setStorageClass("STANDARD");
                    objectInfo = (ObjectInfo)Entities.persist((Object)objectInfo);
                    tr.commit();
                    if (tr != null) {
                        if (throwable != null) {
                            try {
                                tr.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            tr.close();
                        }
                    }
                }
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (tr != null) {
                        if (throwable != null) {
                            try {
                                tr.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            tr.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to process metadata for object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to process metadata for object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
        return reply;
    }

    @Override
    public DeleteObjectResponseType deleteObject(DeleteObjectType request) throws WalrusException {
        DeleteObjectResponseType reply = (DeleteObjectResponseType)request.getReply();
        final String bucketName = request.getBucket();
        final String objectKey = request.getKey();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        Boolean taskAdded = Boolean.FALSE;
        try {
            Entities.asTransaction(ObjectInfo.class, (Function)new Function<Boolean, String>(){

                public String apply(Boolean arg0) {
                    try {
                        ObjectInfo objectInfo = (ObjectInfo)Entities.uniqueResult((Object)new ObjectInfo(bucketName, objectKey));
                        if (!arg0.booleanValue()) {
                            ObjectDeleter objectDeleter = new ObjectDeleter(bucketName, objectInfo.getObjectName(), objectKey, objectInfo.getUploadId());
                            Threads.lookup(WalrusBackend.class, ObjectDeleter.class).limitTo(Integer.valueOf(10)).submit((Runnable)objectDeleter);
                            arg0 = Boolean.TRUE;
                        }
                        Entities.delete((Object)objectInfo);
                    }
                    catch (NoSuchElementException e) {
                        LOG.debug((Object)("Metadata for object-key=" + objectKey + ", bucket=" + bucketName + " not found. Nothing to delete"));
                    }
                    catch (Exception e) {
                        Exceptions.toUndeclared((Throwable)e);
                    }
                    return null;
                }
            }).apply((Object)taskAdded);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to delete object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to delete object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
        reply.setStatus(HttpResponseStatus.NO_CONTENT);
        reply.setStatusMessage("NO CONTENT");
        return reply;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ListBucketResponseType listBucket(ListBucketType request) throws WalrusException {
        ListBucketResponseType reply = (ListBucketResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        Account account = ctx.getAccount();
        String bucketName = request.getBucket();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        String prefix = request.getPrefix();
        String delimiter = request.getDelimiter();
        String marker = request.getMarker();
        int maxKeys = -1;
        reply.setName(bucketName);
        reply.setIsTruncated(false);
        reply.setPrefix(prefix);
        reply.setMarker(marker);
        reply.setDelimiter(delimiter);
        if (request.getMaxKeys() != null) {
            maxKeys = Integer.parseInt(request.getMaxKeys());
            if (maxKeys < 0) {
                throw new InvalidArgumentException("max-keys", "Argument max-keys must be an integer between 0 and 2147483647");
            }
            if (maxKeys == 0) {
                reply.setMaxKeys(maxKeys);
                reply.setContents(new ArrayList());
                reply.setCommonPrefixesList(new ArrayList());
                return reply;
            }
        } else {
            maxKeys = WalrusProperties.MAX_KEYS;
            reply.setMaxKeys(maxKeys);
        }
        try (TransactionResource tr = Entities.transactionFor(ObjectInfo.class);){
            int queryStrideSize = maxKeys + 1;
            ObjectInfo searchObj = new ObjectInfo();
            searchObj.setBucketName(bucketName);
            Criteria objCriteria = Entities.createCriteria(ObjectInfo.class);
            objCriteria.add((Criterion)Example.create((Object)searchObj));
            objCriteria.addOrder(Order.asc((String)"objectKey"));
            objCriteria.setMaxResults(queryStrideSize);
            objCriteria.setReadOnly(true);
            if (!Strings.isNullOrEmpty((String)marker)) {
                objCriteria.add((Criterion)Restrictions.gt((String)"objectKey", (Object)marker));
            } else {
                marker = "";
            }
            if (!Strings.isNullOrEmpty((String)prefix)) {
                objCriteria.add((Criterion)Restrictions.like((String)"objectKey", (String)prefix, (MatchMode)MatchMode.START));
            } else {
                prefix = "";
            }
            if (Strings.isNullOrEmpty((String)delimiter)) {
                delimiter = "";
            }
            List objectInfos = null;
            int resultKeyCount = 0;
            ArrayList<ListEntry> contents = new ArrayList<ListEntry>();
            String nextMarker = null;
            TreeSet<String> commonPrefixes = new TreeSet<String>();
            int firstResult = -1;
            CanonicalUser owner = new CanonicalUser(account.getCanonicalId(), account.getName());
            block14: do {
                objCriteria.setFirstResult(queryStrideSize * ++firstResult);
                objectInfos = objCriteria.list();
                if (objectInfos.size() <= 0) continue;
                for (ObjectInfo objectInfo : objectInfos) {
                    String[] parts;
                    String objectKey = objectInfo.getObjectKey();
                    if (!Strings.isNullOrEmpty((String)delimiter) && (parts = objectKey.substring(prefix.length()).split(delimiter, 2)).length > 1) {
                        String prefixString = prefix + parts[0] + delimiter;
                        if (StringUtils.equals((String)prefixString, (String)marker) || commonPrefixes.contains(prefixString)) continue;
                        if (resultKeyCount == maxKeys) {
                            reply.setNextMarker(nextMarker);
                            reply.setIsTruncated(true);
                            ++resultKeyCount;
                            continue block14;
                        }
                        commonPrefixes.add(prefixString);
                        if (++resultKeyCount != maxKeys) continue;
                        nextMarker = prefixString;
                        continue;
                    }
                    if (resultKeyCount == maxKeys) {
                        reply.setNextMarker(nextMarker);
                        reply.setIsTruncated(true);
                        ++resultKeyCount;
                        continue block14;
                    }
                    ListEntry listEntry = new ListEntry();
                    listEntry.setKey(objectKey);
                    listEntry.setEtag(objectInfo.getEtag());
                    listEntry.setLastModified(DateFormatter.dateToListingFormattedString((Date)objectInfo.getLastModified()));
                    listEntry.setStorageClass(objectInfo.getStorageClass());
                    listEntry.setSize(objectInfo.getSize().longValue());
                    listEntry.setStorageClass(objectInfo.getStorageClass());
                    listEntry.setOwner(owner);
                    contents.add(listEntry);
                    if (++resultKeyCount != maxKeys) continue;
                    nextMarker = objectKey;
                }
            } while ((resultKeyCount > maxKeys || objectInfos.size() > maxKeys) && resultKeyCount <= maxKeys);
            tr.commit();
            reply.setContents(contents);
            if (!commonPrefixes.isEmpty()) {
                ArrayList<CommonPrefixesEntry> commonPrefixesList = new ArrayList<CommonPrefixesEntry>();
                for (String prefixEntry : commonPrefixes) {
                    commonPrefixesList.add(new CommonPrefixesEntry(prefixEntry));
                }
                reply.setCommonPrefixesList(commonPrefixesList);
            }
            ListBucketResponseType listBucketResponseType = reply;
            return listBucketResponseType;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to lookup metadata for objects in bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup metadata for objects in bucket=" + bucketName, (Throwable)e);
        }
    }

    @Override
    public GetObjectAccessControlPolicyResponseType getObjectAccessControlPolicy(GetObjectAccessControlPolicyType request) throws WalrusException {
        GetObjectAccessControlPolicyResponseType reply = (GetObjectAccessControlPolicyResponseType)request.getReply();
        String bucketName = request.getBucket();
        String objectKey = request.getKey();
        Context ctx = Contexts.lookup();
        Account account = ctx.getAccount();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        try {
            Transactions.find((Object)new ObjectInfo(bucketName, objectKey));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchEntityException(objectKey);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to look up metadata for object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
        reply.setAccessControlPolicy(WalrusFSManager.getPrivateACP(account.getCanonicalId(), account.getName()));
        return reply;
    }

    @Override
    public SetBucketAccessControlPolicyResponseType setBucketAccessControlPolicy(SetBucketAccessControlPolicyType request) throws WalrusException {
        throw new MethodNotAllowedException("PUT bucket access control policy is not supported by Walrus backend. Try issuing the request to objectstorage", "bucket", request.getBucket() + "?acl");
    }

    @Override
    public SetRESTBucketAccessControlPolicyResponseType setRESTBucketAccessControlPolicy(SetRESTBucketAccessControlPolicyType request) throws WalrusException {
        throw new MethodNotAllowedException("PUT bucket access control policy is not supported by Walrus backend. Try issuing the request to objectstorage", "bucket", request.getBucket() + "?acl");
    }

    @Override
    public SetObjectAccessControlPolicyResponseType setObjectAccessControlPolicy(SetObjectAccessControlPolicyType request) throws WalrusException {
        throw new MethodNotAllowedException("PUT object access control policy is not supported by Walrus backend. Try issuing the request to objectstorage", "object", request.getBucket() + "/" + request.getKey() + "?acl");
    }

    @Override
    public SetRESTObjectAccessControlPolicyResponseType setRESTObjectAccessControlPolicy(SetRESTObjectAccessControlPolicyType request) throws WalrusException {
        throw new MethodNotAllowedException("PUT object access control policy is not supported by Walrus backend. Try issuing the request to objectstorage", "object", request.getBucket() + "/" + request.getKey() + "?acl");
    }

    @Override
    public GetObjectResponseType getObject(GetObjectType request) throws WalrusException {
        Boolean getData;
        Boolean getMetaData;
        GetObjectResponseType reply = (GetObjectResponseType)request.getReply();
        reply.setHasStreamingData(false);
        String bucketName = request.getBucket();
        String objectKey = request.getKey();
        Boolean deleteAfterGet = request.getDeleteAfterGet();
        if (deleteAfterGet == null) {
            deleteAfterGet = false;
        }
        if ((getMetaData = request.getGetMetaData()) == null) {
            getMetaData = false;
        }
        if ((getData = request.getGetData()) == null) {
            getData = false;
        }
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            if (getData.booleanValue()) {
                throw new NoSuchBucketException(bucketName);
            }
            throw new HeadNoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        ObjectInfo objectInfo = null;
        try (TransactionResource tr = Entities.transactionFor(ObjectInfo.class);){
            objectInfo = (ObjectInfo)Entities.uniqueResult((Object)new ObjectInfo(bucketName, objectKey));
            if (objectInfo.getMetaData() != null) {
                objectInfo.getMetaData().size();
            }
            tr.commit();
        }
        catch (NoSuchElementException e) {
            if (getData.booleanValue()) {
                throw new NoSuchEntityException(objectKey);
            }
            throw new HeadNoSuchEntityException(objectKey);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to look up metadata for object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
        try {
            String objectName = objectInfo.getObjectName();
            Date lastModified = objectInfo.getLastModified();
            Long size = objectInfo.getSize();
            String etag = objectInfo.getEtag();
            String contentType = objectInfo.getContentType();
            String contentDisposition = objectInfo.getContentDisposition();
            if (getMetaData.booleanValue() && objectInfo.getMetaData() != null) {
                ArrayList<MetaDataEntry> metaData = new ArrayList<MetaDataEntry>();
                for (MetaDataInfo metaDataInfo : objectInfo.getMetaData()) {
                    metaData.add(new MetaDataEntry(metaDataInfo.getName(), metaDataInfo.getValue()));
                }
                reply.setMetaData(metaData);
            }
            if (request.getGetData().booleanValue()) {
                if (objectInfo.isMultipart()) {
                    String inlineData = this.getMultipartData(objectInfo, request, reply);
                    if (inlineData != null) {
                        reply.setBase64Data(inlineData);
                    }
                } else if (request.getInlineData().booleanValue()) {
                    if (size * 4L > WalrusProperties.MAX_INLINE_DATA_SIZE) {
                        throw new InlineDataTooLargeException(bucketName + "/" + objectKey);
                    }
                    byte[] bytes = new byte[102400];
                    int bytesRead = 0;
                    int offset = 0;
                    String base64Data = "";
                    try {
                        FileIO fileIO = this.storageManager.prepareForRead(bucketName, objectName);
                        while ((bytesRead = fileIO.read((long)offset)) > 0) {
                            ByteBuffer buffer = fileIO.getBuffer();
                            if (buffer == null) continue;
                            buffer.get(bytes, 0, bytesRead);
                            base64Data = base64Data + new String(bytes, 0, bytesRead);
                            offset += bytesRead;
                        }
                        fileIO.finish();
                    }
                    catch (Exception e) {
                        LOG.error((Object)e, (Throwable)e);
                        throw new InternalErrorException((Throwable)e);
                    }
                    reply.setBase64Data(Hashes.base64encode((String)base64Data));
                } else {
                    reply.setHasStreamingData(true);
                    this.storageManager.getObject(bucketName, objectName, (WalrusDataGetResponseType)reply, size, request.getIsCompressed());
                }
            }
            reply.setEtag(etag);
            reply.setLastModified(lastModified);
            reply.setVersionId("null");
            reply.setSize(size);
            reply.setContentType(contentType);
            reply.setContentDisposition(contentDisposition);
            Status status = new Status();
            status.setCode(200);
            status.setDescription("OK");
            reply.setStatus(status);
            return reply;
        }
        catch (WalrusException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to perform get operation for object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to perform get operation for object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
    }

    @Override
    public GetObjectExtendedResponseType getObjectExtended(GetObjectExtendedType request) throws WalrusException {
        GetObjectExtendedResponseType reply = (GetObjectExtendedResponseType)request.getReply();
        Date ifModifiedSince = request.getIfModifiedSince();
        Date ifUnmodifiedSince = request.getIfUnmodifiedSince();
        String ifMatch = request.getIfMatch();
        String ifNoneMatch = request.getIfNoneMatch();
        boolean returnCompleteObjectOnFailure = request.getReturnCompleteObjectOnConditionFailure();
        String bucketName = request.getBucket();
        String objectKey = request.getKey();
        Boolean getData = request.getGetData();
        if (getData == null) {
            getData = false;
        }
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            if (getData.booleanValue()) {
                throw new NoSuchBucketException(bucketName);
            }
            throw new HeadNoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        ObjectInfo objectInfo = null;
        try (TransactionResource tr = Entities.transactionFor(ObjectInfo.class);){
            objectInfo = (ObjectInfo)Entities.uniqueResult((Object)new ObjectInfo(bucketName, objectKey));
            objectInfo.getMetaData();
            if (objectInfo.getMetaData() != null) {
                objectInfo.getMetaData().size();
            }
            tr.commit();
        }
        catch (NoSuchElementException e) {
            if (getData.booleanValue()) {
                throw new NoSuchEntityException(objectKey);
            }
            throw new HeadNoSuchEntityException(objectKey);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to look up metadata for object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
        try {
            String etag = objectInfo.getEtag();
            String objectName = objectInfo.getObjectName();
            Long byteRangeStart = request.getByteRangeStart();
            Long byteRangeEnd = request.getByteRangeEnd();
            if (byteRangeStart == null) {
                byteRangeStart = 0L;
            }
            if (byteRangeEnd == null) {
                byteRangeEnd = -1L;
            }
            if (byteRangeEnd == -1L || byteRangeEnd + 1L > objectInfo.getSize()) {
                byteRangeEnd = objectInfo.getSize() - 1L;
            }
            if (byteRangeStart > objectInfo.getSize() || byteRangeStart > byteRangeEnd || byteRangeStart < 0L || byteRangeEnd < 0L) {
                throw new InvalidRangeException("Range: " + byteRangeStart + "-" + byteRangeEnd + "object: " + bucketName + "/" + objectKey);
            }
            if (ifMatch != null && !ifMatch.equals(etag) && !returnCompleteObjectOnFailure) {
                throw new PreconditionFailedException(objectKey + " etag: " + etag);
            }
            if (ifNoneMatch != null && ifNoneMatch.equals(etag) && !returnCompleteObjectOnFailure) {
                throw new NotModifiedException(objectKey + " ETag: " + etag);
            }
            Date lastModified = objectInfo.getLastModified();
            if (ifModifiedSince != null && ifModifiedSince.getTime() >= lastModified.getTime() && !returnCompleteObjectOnFailure) {
                throw new NotModifiedException(objectKey + " LastModified: " + lastModified.toString());
            }
            if (ifUnmodifiedSince != null && ifUnmodifiedSince.getTime() < lastModified.getTime() && !returnCompleteObjectOnFailure) {
                throw new PreconditionFailedException(objectKey + " lastModified: " + lastModified.toString());
            }
            if (request.getGetMetaData().booleanValue() && objectInfo.getMetaData() != null) {
                ArrayList<MetaDataEntry> metaData = new ArrayList<MetaDataEntry>();
                for (MetaDataInfo metaDataInfo : objectInfo.getMetaData()) {
                    metaData.add(new MetaDataEntry(metaDataInfo.getName(), metaDataInfo.getValue()));
                }
                reply.setMetaData(metaData);
            }
            Long size = byteRangeEnd - byteRangeStart + 1L;
            String contentType = objectInfo.getContentType();
            String contentDisposition = objectInfo.getContentDisposition();
            if (request.getGetData().booleanValue()) {
                if (objectInfo.isMultipart()) {
                    List<PartInfo> parts = this.getOrderedListOfParts(objectInfo);
                    this.storageManager.getMultipartObject((WalrusDataGetResponseType)reply, parts, request.getIsCompressed(), byteRangeStart, byteRangeEnd);
                } else {
                    this.storageManager.getObject(bucketName, objectName, (WalrusDataGetResponseType)reply, byteRangeStart, byteRangeEnd + 1L, request.getIsCompressed());
                }
            }
            reply.setEtag(etag);
            reply.setLastModified(lastModified);
            reply.setSize(size);
            reply.setContentType(contentType);
            reply.setContentDisposition(contentDisposition);
            reply.setByteRangeStart(byteRangeStart);
            reply.setByteRangeEnd(byteRangeEnd);
            reply.setVersionId("null");
            Status status = new Status();
            status.setCode(200);
            status.setDescription("OK");
            reply.setStatus(status);
            return reply;
        }
        catch (WalrusException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to perform get extended operation for object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to perform get extended operation for object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
    }

    private String getMultipartData(ObjectInfo objectInfo, GetObjectType request, GetObjectResponseType response) throws WalrusException {
        List<PartInfo> parts = this.getOrderedListOfParts(objectInfo);
        if (request.getInlineData().booleanValue()) {
            if (objectInfo.getSize() * 4L > WalrusProperties.MAX_INLINE_DATA_SIZE) {
                throw new InlineDataTooLargeException(request.getBucket() + "/" + request.getKey());
            }
            String base64Data = "";
            for (PartInfo part : parts) {
                byte[] bytes = new byte[102400];
                int bytesRead = 0;
                int offset = 0;
                try {
                    FileIO fileIO = this.storageManager.prepareForRead(part.getBucketName(), part.getObjectName());
                    while ((bytesRead = fileIO.read((long)offset)) > 0) {
                        ByteBuffer buffer = fileIO.getBuffer();
                        if (buffer == null) continue;
                        buffer.get(bytes, 0, bytesRead);
                        base64Data = base64Data + new String(bytes, 0, bytesRead);
                        offset += bytesRead;
                    }
                    fileIO.finish();
                }
                catch (Exception e) {
                    LOG.error((Object)e, (Throwable)e);
                    throw new InternalErrorException((Throwable)e);
                }
            }
            return Hashes.base64encode((String)base64Data);
        }
        response.setHasStreamingData(true);
        this.storageManager.getMultipartObject((WalrusDataGetResponseType)response, parts, request.getIsCompressed());
        return null;
    }

    @Override
    public GetBucketLocationResponseType getBucketLocation(GetBucketLocationType request) throws WalrusException {
        GetBucketLocationResponseType reply = (GetBucketLocationResponseType)request.getReply();
        String bucketName = request.getBucket();
        try {
            BucketInfo bucket = (BucketInfo)Transactions.find((Object)new BucketInfo(bucketName));
            String location = bucket.getLocation();
            if (location == null || location.equalsIgnoreCase("US")) {
                reply.setLocationConstraint(null);
            } else {
                reply.setLocationConstraint(location);
            }
            return reply;
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
    }

    @Override
    public CopyObjectResponseType copyObject(CopyObjectType request) throws WalrusException {
        CopyObjectResponseType reply = (CopyObjectResponseType)request.getReply();
        String srcBucketName = request.getSourceBucket();
        String srcObjectKey = request.getSourceObject();
        String destBucketName = request.getDestinationBucket();
        String destObjectKey = request.getDestinationObject();
        String metadataDirective = request.getMetadataDirective();
        if (metadataDirective == null) {
            metadataDirective = "COPY";
        }
        try {
            Transactions.find((Object)new BucketInfo(srcBucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(srcBucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + srcBucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + srcBucketName, (Throwable)e);
        }
        ObjectInfo srcObjectInfo = null;
        try (TransactionResource tr = Entities.transactionFor(ObjectInfo.class);){
            srcObjectInfo = (ObjectInfo)Entities.uniqueResult((Object)new ObjectInfo(srcBucketName, srcObjectKey));
            if (srcObjectInfo.getMetaData() != null) {
                srcObjectInfo.getMetaData().size();
            }
            tr.commit();
        }
        catch (NoSuchElementException e) {
            throw new NoSuchEntityException(srcObjectKey);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for object-key=" + srcObjectKey + ", bucket=" + srcBucketName), (Throwable)e);
            throw new InternalErrorException("Failed to look up metadata for object-key=" + srcObjectKey + ", bucket=" + srcBucketName, (Throwable)e);
        }
        if (!StringUtils.equalsIgnoreCase((String)srcBucketName, (String)destBucketName)) {
            try {
                Transactions.find((Object)new BucketInfo(destBucketName));
            }
            catch (NoSuchElementException e) {
                throw new NoSuchBucketException(destBucketName);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to look up metadata for bucket=" + destBucketName), (Throwable)e);
                throw new InternalErrorException("Failed to lookup bucket " + destBucketName, (Throwable)e);
            }
        }
        String prevDestObjectName = null;
        String destinationObjectName = UUID.randomUUID().toString();
        String etag = srcObjectInfo.getEtag();
        Date lastModified = null;
        try {
            if (srcObjectInfo.isMultipart()) {
                List<PartInfo> parts = this.getOrderedListOfParts(srcObjectInfo);
                this.storageManager.copyMultipartObject(parts, destBucketName, destinationObjectName);
            } else {
                this.storageManager.copyObject(srcBucketName, srcObjectInfo.getObjectName(), destBucketName, destinationObjectName);
            }
            lastModified = new Date();
            try (TransactionResource tr = Entities.transactionFor(ObjectInfo.class);){
                ObjectInfo destObjectInfo = null;
                try {
                    destObjectInfo = (ObjectInfo)Entities.uniqueResult((Object)new ObjectInfo(destBucketName, destObjectKey));
                    prevDestObjectName = destObjectInfo.getObjectName();
                }
                catch (NoSuchElementException e) {
                    destObjectInfo = (ObjectInfo)Entities.persist((Object)new ObjectInfo(destBucketName, destObjectKey));
                }
                destObjectInfo.setObjectName(destinationObjectName);
                destObjectInfo.setSize(srcObjectInfo.getSize());
                destObjectInfo.setStorageClass(srcObjectInfo.getStorageClass());
                destObjectInfo.setContentType(srcObjectInfo.getContentType());
                destObjectInfo.setContentDisposition(srcObjectInfo.getContentDisposition());
                destObjectInfo.setEtag(etag);
                destObjectInfo.setLastModified(lastModified);
                if (!metadataDirective.equals("REPLACE")) {
                    destObjectInfo.setMetaData(srcObjectInfo.cloneMetaData());
                } else {
                    destObjectInfo.replaceMetaData((List)request.getMetaData());
                }
                tr.commit();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to update metadata for object-key=" + destObjectKey + ", bucket=" + destBucketName), (Throwable)e);
                throw new InternalErrorException("Failed to update metadata for object-key=" + destObjectKey + ", bucket=" + destBucketName, (Throwable)e);
            }
            if (prevDestObjectName != null) {
                ObjectDeleter objectDeleter = new ObjectDeleter(destBucketName, prevDestObjectName, null, null);
                Threads.lookup(WalrusBackend.class, ObjectDeleter.class).limitTo(Integer.valueOf(10)).submit((Runnable)objectDeleter);
            }
        }
        catch (WalrusException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to copy source-object-key=" + srcObjectKey + ", source-bucket=" + srcBucketName + " to destination-object-key=" + destObjectKey + ", destination-bucket=" + destBucketName));
            throw new InternalErrorException("Failed to copy source-object-key=" + srcObjectKey + ", source-bucket=" + srcBucketName + " to destination-object-key=" + destObjectKey + ", destination-bucket=" + destBucketName, (Throwable)e);
        }
        reply.setEtag(etag);
        reply.setLastModified(DateFormatter.dateToListingFormattedString((Date)lastModified));
        reply.setCopySourceVersionId("null");
        reply.setVersionId("null");
        return reply;
    }

    @Override
    public SetBucketLoggingStatusResponseType setBucketLoggingStatus(SetBucketLoggingStatusType request) throws WalrusException {
        throw new MethodNotAllowedException("PUT bucket logging not supported by Walrus backend. Try issuing the request to objectstorage", "object", request.getBucket() + "?logging");
    }

    @Override
    public GetBucketLoggingStatusResponseType getBucketLoggingStatus(GetBucketLoggingStatusType request) throws WalrusException {
        GetBucketLoggingStatusResponseType reply = (GetBucketLoggingStatusResponseType)request.getReply();
        String bucketName = request.getBucket();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        return reply;
    }

    @Override
    public GetBucketVersioningStatusResponseType getBucketVersioningStatus(GetBucketVersioningStatusType request) throws WalrusException {
        GetBucketVersioningStatusResponseType reply = (GetBucketVersioningStatusResponseType)request.getReply();
        String bucketName = request.getBucket();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        return reply;
    }

    @Override
    public SetBucketVersioningStatusResponseType setBucketVersioningStatus(SetBucketVersioningStatusType request) throws WalrusException {
        throw new MethodNotAllowedException("PUT bucket versioning is not supported by Walrus backend. Try issuing the request to objectstorage", "object", request.getBucket() + "?versioning");
    }

    @Override
    public ListVersionsResponseType listVersions(ListVersionsType request) throws WalrusException {
        throw new MethodNotAllowedException("GET bucket object versions is not supported by Walrus backend. Try issuing the request to objectstorage", "object", request.getBucket() + "?versions");
    }

    @Override
    public DeleteVersionResponseType deleteVersion(DeleteVersionType request) throws WalrusException {
        throw new MethodNotAllowedException("Delete object version is not supported by Walrus backend. Try issuing the request to objectstorage", "object", request.getKey());
    }

    public static InetAddress getBucketIp(String bucket) throws WalrusException {
        try {
            Transactions.find((Object)new BucketInfo(bucket));
            return WalrusProperties.getWalrusAddress();
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucket);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucket), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucket, (Throwable)e);
        }
    }

    @Override
    public void fastDeleteObject(DeleteObjectType request) throws WalrusException {
        final String bucketName = request.getBucket();
        final String objectKey = request.getKey();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        Boolean deleted = Boolean.FALSE;
        try {
            Entities.asTransaction(ObjectInfo.class, (Function)new Function<Boolean, String>(){

                public String apply(Boolean arg0) {
                    try {
                        ObjectInfo objectInfo = (ObjectInfo)Entities.uniqueResult((Object)new ObjectInfo(bucketName, objectKey));
                        if (!arg0.booleanValue()) {
                            try {
                                if (objectInfo.isMultipart()) {
                                    WalrusFSManager.this.deleteParts(bucketName, objectKey, objectInfo.getUploadId(), false);
                                } else {
                                    WalrusFSManager.this.storageManager.deleteObject(bucketName, objectInfo.getObjectName());
                                }
                            }
                            catch (IOException e) {
                                LOG.warn((Object)("Failed to delete object-file=" + objectInfo.getObjectName() + ", bucket=" + bucketName + " on disk. Cause: " + e.getMessage()));
                            }
                            arg0 = Boolean.TRUE;
                        }
                        Entities.delete((Object)objectInfo);
                    }
                    catch (NoSuchElementException e) {
                        LOG.debug((Object)("Metadata for object-key=" + objectKey + ", bucket=" + bucketName + " not found. Nothing to delete"));
                    }
                    catch (Exception e) {
                        Exceptions.toUndeclared((Throwable)e);
                    }
                    return null;
                }
            }).apply((Object)deleted);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to delete object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to delete object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
    }

    @Override
    public void fastDeleteBucket(DeleteBucketType request) throws WalrusException {
        String bucketName = request.getBucket();
        try (TransactionResource tr = Entities.transactionFor(BucketInfo.class);){
            BucketInfo bucketInfo = (BucketInfo)Entities.uniqueResult((Object)new BucketInfo(bucketName));
            ObjectInfo searchObject = new ObjectInfo();
            searchObject.setBucketName(bucketName);
            List objects = Transactions.findAll((Object)searchObject);
            if (objects != null && !objects.isEmpty()) {
                tr.commit();
                throw new BucketNotEmptyException(bucketName);
            }
            Entities.delete((Object)bucketInfo);
            tr.commit();
            Threads.lookup(WalrusBackend.class, ObjectDeleter.class).limitTo(Integer.valueOf(10)).submit((Runnable)new BucketDeleter(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to delete bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to delete bucket=" + bucketName, (Throwable)e);
        }
    }

    @Override
    public InitiateMultipartUploadResponseType initiateMultipartUpload(InitiateMultipartUploadType request) throws WalrusException {
        InitiateMultipartUploadResponseType reply = (InitiateMultipartUploadResponseType)request.getReply();
        String bucketName = request.getBucket();
        String objectKey = request.getKey();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        PartInfo manifest = PartInfo.generateManifest((String)bucketName, (String)objectKey);
        manifest.setStorageClass("STANDARD");
        manifest.setContentEncoding(request.getContentEncoding());
        manifest.setContentType(request.getContentType());
        manifest.replaceMetaData((List)request.getMetaData());
        manifest.setObjectName(null);
        try {
            manifest = (PartInfo)Transactions.saveDirect((Object)manifest);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to save part manifest metatdata for object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to save part manifest metatdata for object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
        reply.setUploadId(manifest.getUploadId());
        reply.setBucket(bucketName);
        reply.setKey(objectKey);
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResponseType uploadPart(UploadPartType request) throws WalrusException {
        UploadPartResponseType reply = (UploadPartResponseType)request.getReply();
        String bucketName = request.getBucket();
        String objectKey = request.getKey();
        String uploadId = request.getUploadId();
        Integer partNumber = Integer.parseInt(request.getPartNumber());
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        PartInfo manifest = null;
        try (TransactionResource tr = Entities.transactionFor(PartInfo.class);){
            PartInfo search = new PartInfo(bucketName, objectKey, uploadId);
            Criteria manifestCriteria = Entities.createCriteria(PartInfo.class);
            manifestCriteria.add((Criterion)Example.create((Object)search));
            manifestCriteria.add(Restrictions.isNull((String)"partNumber"));
            manifestCriteria.add(Restrictions.isNull((String)"cleanup"));
            manifestCriteria.setReadOnly(true);
            List foundManifests = manifestCriteria.list();
            if (foundManifests == null || foundManifests.size() != 1) {
                if (foundManifests == null) {
                    throw new InternalErrorException("Got invalid metadata");
                }
                if (foundManifests.size() < 1) {
                    throw new NoSuchUploadException("Multipart upload ID is invalid. Intitiate a multipart upload request before uploading the parts");
                }
                throw new InternalErrorException("Multiple manifests found for same uploadId");
            }
            manifest = (PartInfo)foundManifests.get(0);
            if (manifest.getMetaData() != null) {
                manifest.getMetaData().size();
            }
            tr.commit();
        }
        catch (WalrusException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to process metadata for part-number=" + partNumber + ", upload-id=" + uploadId + ", object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to process metadata for part-number=" + partNumber + ", upload-id=" + uploadId + ", object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
        long size = 0L;
        Date lastModified = null;
        String md5 = new String();
        String key = bucketName + "." + objectKey;
        String randomKey = request.getRandomKey();
        String prevObjectName = null;
        String tempObjectName = UUID.randomUUID().toString();
        String objectName = UUID.randomUUID().toString();
        WalrusDataMessenger messenger = WalrusRESTBinding.getWriteMessenger();
        WalrusDataQueue putQueue = messenger.getQueue(key, randomKey);
        try {
            WalrusDataMessage dataMessage;
            MessageDigest digest = null;
            FileIO fileIO = null;
            while ((dataMessage = (WalrusDataMessage)putQueue.take()) != null) {
                WalrusMonitor monitor;
                if (putQueue.getInterrupted()) {
                    if (!WalrusDataMessage.isEOF((WalrusDataMessage)dataMessage)) continue;
                    monitor = messenger.getMonitor(key);
                    if (monitor.getLastModified() == null) {
                        LOG.trace((Object)("Monitor wait: " + key + " random: " + randomKey));
                        WalrusMonitor walrusMonitor = monitor;
                        synchronized (walrusMonitor) {
                            monitor.wait();
                        }
                    }
                    LOG.trace((Object)("Monitor resume: " + key + " random: " + randomKey));
                    lastModified = monitor.getLastModified();
                    md5 = monitor.getMd5();
                    if (fileIO != null) {
                        fileIO.finish();
                    }
                    ObjectDeleter objectDeleter = new ObjectDeleter(bucketName, tempObjectName, null, null);
                    Threads.lookup(WalrusBackend.class, ObjectDeleter.class).limitTo(Integer.valueOf(10)).submit((Runnable)objectDeleter);
                    LOG.warn((Object)("Transfer interrupted: " + key));
                    messenger.removeQueue(key, randomKey);
                    break;
                }
                if (WalrusDataMessage.isStart((WalrusDataMessage)dataMessage)) {
                    tempObjectName = UUID.randomUUID().toString();
                    digest = Digest.MD5.get();
                    try {
                        fileIO = this.storageManager.prepareForWrite(bucketName, tempObjectName);
                        continue;
                    }
                    catch (Exception ex) {
                        messenger.removeQueue(key, randomKey);
                        throw new InternalErrorException((Throwable)ex);
                    }
                }
                if (WalrusDataMessage.isEOF((WalrusDataMessage)dataMessage)) {
                    Throwable throwable;
                    String contentMD5AsHex;
                    if (digest == null) {
                        monitor = messenger.getMonitor(key);
                        md5 = monitor.getMd5();
                        lastModified = monitor.getLastModified();
                        if (md5 == null) {
                            LOG.error((Object)("ETag did not match for: " + randomKey + " Computed MD5 is null"));
                            throw new ContentMismatchException(bucketName + "/" + objectKey);
                        }
                        break;
                    }
                    md5 = Hashes.bytesToHex((byte[])digest.digest());
                    String contentMD5 = request.getContentMD5();
                    if (contentMD5 != null && !(contentMD5AsHex = Hashes.bytesToHex((byte[])Base64.decode((String)contentMD5))).equals(md5)) {
                        if (fileIO != null) {
                            fileIO.finish();
                        }
                        this.cleanupTempObject(bucketName, tempObjectName);
                        messenger.removeQueue(key, randomKey);
                        LOG.error((Object)("ETag did not match for: " + randomKey + " Expected: " + contentMD5AsHex + " Computed: " + md5));
                        throw new ContentMismatchException(bucketName + "/" + objectKey);
                    }
                    try {
                        if (fileIO != null) {
                            fileIO.finish();
                        }
                        this.storageManager.renameObject(bucketName, tempObjectName, objectName);
                    }
                    catch (IOException ex) {
                        LOG.error((Object)("Failed to rename file " + tempObjectName + " to " + objectName + ". part-number=" + partNumber + ", upload-id=" + uploadId + ", object-key=" + objectKey + ", bucket=" + bucketName));
                        messenger.removeQueue(key, randomKey);
                        throw new InternalErrorException(objectKey);
                    }
                    lastModified = new Date();
                    try {
                        throwable = null;
                        try (TransactionResource tr = Entities.transactionFor(PartInfo.class);){
                            PartInfo partInfo = null;
                            try {
                                partInfo = (PartInfo)Entities.uniqueResult((Object)new PartInfo(bucketName, objectKey, uploadId, partNumber));
                                prevObjectName = partInfo.getObjectName();
                            }
                            catch (NoSuchElementException e) {
                                partInfo = (PartInfo)Entities.persist((Object)PartInfo.generatePart((String)bucketName, (String)objectKey, (String)uploadId, (Integer)partNumber, (String)objectName));
                            }
                            partInfo.setEtag(md5);
                            partInfo.setSize(Long.valueOf(size));
                            partInfo.setLastModified(lastModified);
                            partInfo.setStorageClass("STANDARD");
                            partInfo.setObjectName(objectName);
                            tr.commit();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to update metadata for part-number=" + partNumber + ", upload-id=" + uploadId + ", object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
                        throw new InternalErrorException("Failed to update metadata for part-number=" + partNumber + ", upload-id=" + uploadId + ", object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
                    }
                    if (prevObjectName != null) {
                        ObjectDeleter objectDeleter = new ObjectDeleter(bucketName, prevObjectName, null, null);
                        Threads.lookup(WalrusBackend.class, ObjectDeleter.class).limitTo(Integer.valueOf(10)).submit((Runnable)objectDeleter);
                    }
                    WalrusMonitor monitor2 = messenger.getMonitor(key);
                    throwable = monitor2;
                    synchronized (throwable) {
                        monitor2.setLastModified(lastModified);
                        monitor2.setMd5(md5);
                        monitor2.notifyAll();
                    }
                    messenger.clearQueues(key);
                    messenger.removeQueue(key, randomKey);
                    LOG.trace((Object)("Transfer complete: " + key + " uploadId: " + uploadId + " partNumber: " + partNumber));
                    break;
                }
                assert (WalrusDataMessage.isData((WalrusDataMessage)dataMessage));
                byte[] data = dataMessage.getPayload();
                try {
                    if (fileIO != null) {
                        fileIO.write(data);
                    }
                }
                catch (IOException ex) {
                    LOG.error((Object)ex);
                }
                size += (long)data.length;
                if (digest == null) continue;
                digest.update(data);
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Transfer interrupted: " + key + "." + randomKey), (Throwable)e);
            throw new InternalErrorException("Transfer interrupted: " + key + "." + randomKey);
        }
        catch (WalrusException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to perform put object for object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to perform put object for object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
        finally {
            this.cleanupTempObject(bucketName, tempObjectName);
            messenger.removeQueue(key, randomKey);
        }
        reply.setSize(Long.valueOf(size));
        reply.setEtag(md5);
        reply.setLastModified(lastModified);
        return reply;
    }

    @Override
    public CompleteMultipartUploadResponseType completeMultipartUpload(CompleteMultipartUploadType request) throws WalrusException {
        CompleteMultipartUploadResponseType reply = (CompleteMultipartUploadResponseType)request.getReply();
        String bucketName = request.getBucket();
        String objectKey = request.getKey();
        String uploadId = request.getUploadId();
        ArrayList requestParts = request.getParts();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        if (requestParts == null || requestParts.isEmpty()) {
            throw new InvalidArgumentException("List of parts cannot be emtpy");
        }
        PartInfo manifest = null;
        List foundParts = null;
        long size = 0L;
        Date lastModified = null;
        String eTag = new String();
        String eTagString = new String();
        String prevObjectName = null;
        try (TransactionResource tr = Entities.transactionFor(PartInfo.class);){
            PartInfo search = new PartInfo(bucketName, objectKey, uploadId);
            Criteria manifestCriteria = Entities.createCriteria(PartInfo.class);
            manifestCriteria.add((Criterion)Example.create((Object)search));
            manifestCriteria.add(Restrictions.isNull((String)"partNumber"));
            manifestCriteria.add(Restrictions.isNull((String)"cleanup"));
            List foundManifests = manifestCriteria.list();
            if (foundManifests == null || foundManifests.size() != 1) {
                if (foundManifests == null) {
                    throw new InternalErrorException("Got invalid metadata");
                }
                if (foundManifests.size() < 1) {
                    throw new NoSuchUploadException("Multipart upload ID is invalid");
                }
                throw new InternalErrorException("Multiple manifests found for same uploadId");
            }
            manifest = (PartInfo)foundManifests.get(0);
            if (manifest.getMetaData() != null) {
                manifest.getMetaData().size();
            }
            Criteria partCriteria = Entities.createCriteria(PartInfo.class);
            partCriteria.add((Criterion)Example.create((Object)search));
            partCriteria.add(Restrictions.isNotNull((String)"partNumber"));
            foundParts = partCriteria.list();
            if (foundParts == null || foundParts.isEmpty()) {
                throw new InvalidPartException("No parts uploaded for upload-Id=" + request.getUploadId());
            }
            if (requestParts.size() > foundParts.size()) {
                throw new InvalidArgumentException("Number of parts in the manifest is greater than the number of parts uploaded. Upload Id: " + request.getUploadId());
            }
            HashMap<Integer, PartInfo> partsMap = new HashMap<Integer, PartInfo>(foundParts.size());
            for (PartInfo foundPart : foundParts) {
                partsMap.put(foundPart.getPartNumber(), foundPart);
            }
            PartInfo include = null;
            for (Part requestPart : requestParts) {
                include = (PartInfo)partsMap.remove(requestPart.getPartNumber());
                if (include != null) {
                    eTagString = eTagString + include.getEtag();
                    size += include.getSize().longValue();
                    include.setCleanup(Boolean.FALSE);
                    continue;
                }
                throw new InvalidPartException("Part Number: " + requestPart.getPartNumber() + " upload id: " + request.getUploadId());
            }
            manifest.setCleanup(Boolean.FALSE);
            for (PartInfo excluded : partsMap.values()) {
                excluded.setCleanup(Boolean.TRUE);
            }
            tr.commit();
        }
        catch (WalrusException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to process part metadata for upload-id=" + uploadId + ", object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to process part metadata for upload-id=" + uploadId + ", object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
        MessageDigest digest = Digest.MD5.get();
        digest.update(eTagString.getBytes());
        eTag = "uuid-" + Hashes.bytesToHex((byte[])digest.digest());
        lastModified = new Date();
        try (TransactionResource tr = Entities.transactionFor(ObjectInfo.class);){
            ObjectInfo objectInfo = null;
            try {
                objectInfo = (ObjectInfo)Entities.uniqueResult((Object)new ObjectInfo(bucketName, objectKey));
                prevObjectName = objectInfo.getObjectName();
            }
            catch (NoSuchElementException e) {
                objectInfo = (ObjectInfo)Entities.persist((Object)new ObjectInfo(bucketName, objectKey));
            }
            objectInfo.setUploadId(uploadId);
            objectInfo.setEtag(eTag);
            objectInfo.setSize(Long.valueOf(size));
            objectInfo.setLastModified(lastModified);
            objectInfo.setStorageClass(manifest.getStorageClass());
            objectInfo.setContentDisposition(manifest.getContentDisposition());
            objectInfo.setContentType(manifest.getContentType());
            objectInfo.setMetaData(manifest.cloneMetaData());
            objectInfo.setObjectName(null);
            tr.commit();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to process metadata for upload-id=" + uploadId + ", object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to process metadata for upload-id=" + uploadId + ", object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
        this.firePartsCleanupTask(bucketName, objectKey, uploadId);
        if (prevObjectName != null) {
            ObjectDeleter objectDeleter = new ObjectDeleter(bucketName, prevObjectName, null, null);
            Threads.lookup(WalrusBackend.class, ObjectDeleter.class).limitTo(Integer.valueOf(10)).submit((Runnable)objectDeleter);
        }
        reply.setEtag(eTag);
        reply.setLastModified(lastModified);
        reply.setLocation("WalrusBackend" + bucketName + "/" + objectKey);
        reply.setBucket(bucketName);
        reply.setKey(objectKey);
        reply.setVersionId("null");
        return reply;
    }

    @Override
    public AbortMultipartUploadResponseType abortMultipartUpload(AbortMultipartUploadType request) throws WalrusException {
        AbortMultipartUploadResponseType reply = (AbortMultipartUploadResponseType)request.getReply();
        String bucketName = request.getBucket();
        String objectKey = request.getKey();
        String uploadId = request.getUploadId();
        try {
            Transactions.find((Object)new BucketInfo(bucketName));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchBucketException(bucketName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to look up metadata for bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to lookup bucket " + bucketName, (Throwable)e);
        }
        PartInfo manifest = null;
        List foundParts = null;
        try (TransactionResource tr = Entities.transactionFor(PartInfo.class);){
            PartInfo search = new PartInfo(bucketName, objectKey, uploadId);
            Criteria manifestCriteria = Entities.createCriteria(PartInfo.class);
            manifestCriteria.add((Criterion)Example.create((Object)search));
            manifestCriteria.add(Restrictions.isNull((String)"partNumber"));
            manifestCriteria.add(Restrictions.isNull((String)"cleanup"));
            List foundManifests = manifestCriteria.list();
            if (foundManifests == null || foundManifests.size() != 1) {
                if (foundManifests == null) {
                    throw new InternalErrorException("Got invalid metadata");
                }
                if (foundManifests.size() < 1) {
                    throw new NoSuchUploadException("Multipart upload ID is invalid");
                }
                throw new InternalErrorException("Multiple manifests found for same uploadId");
            }
            manifest = (PartInfo)foundManifests.get(0);
            if (manifest.getMetaData() != null) {
                manifest.getMetaData().size();
            }
            Criteria partCriteria = Entities.createCriteria(PartInfo.class);
            partCriteria.add((Criterion)Example.create((Object)search));
            partCriteria.add(Restrictions.isNotNull((String)"partNumber"));
            foundParts = partCriteria.list();
            if (foundParts != null && !foundParts.isEmpty()) {
                for (PartInfo foundPart : foundParts) {
                    foundPart.setCleanup(Boolean.TRUE);
                }
            }
            manifest.setCleanup(Boolean.TRUE);
            tr.commit();
        }
        catch (WalrusException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to process part metadata for upload-id=" + uploadId + ", object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
            throw new InternalErrorException("Failed to process part metadata for upload-id=" + uploadId + ", object-key=" + objectKey + ", bucket=" + bucketName, (Throwable)e);
        }
        this.firePartsCleanupTask(bucketName, objectKey, uploadId);
        return reply;
    }

    private void firePartsCleanupTask(final String bucketName, final String objectKey, final String uploadId) {
        try {
            Threads.lookup(WalrusBackend.class, ObjectDeleter.class).limitTo(Integer.valueOf(10)).submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        WalrusFSManager.this.deleteParts(bucketName, objectKey, uploadId, true);
                    }
                    catch (Throwable f) {
                        LOG.error((Object)("Error during part cleanup for " + bucketName + "/" + objectKey + " uploadId: " + uploadId), f);
                    }
                }
            });
        }
        catch (Throwable f) {
            LOG.warn((Object)("Error cleaning parts for " + bucketName + "/" + objectKey + " uploadId: " + uploadId + " ."), f);
        }
    }

    private void deleteParts(String bucketName, String objectKey, String uploadId, boolean cleanupFlag) {
        PartInfo searchPart = new PartInfo(bucketName, objectKey, uploadId);
        searchPart.setCleanup(Boolean.valueOf(cleanupFlag));
        try {
            Entities.asTransaction(PartInfo.class, (Function)new Function<PartInfo, String>(){

                public String apply(PartInfo arg0) {
                    block7: {
                        try {
                            List allParts = Entities.query((Object)arg0);
                            if (allParts != null && !allParts.isEmpty()) {
                                for (PartInfo part : allParts) {
                                    if (part.getObjectName() != null) {
                                        try {
                                            WalrusFSManager.this.storageManager.deleteObject(part.getBucketName(), part.getObjectName());
                                        }
                                        catch (IOException e) {
                                            LOG.warn((Object)("Unable to delete file on disk for part-file=" + part.getObjectName() + ", part-number=" + part.getPartNumber() + ", upload-id=" + part.getUploadId() + ", object-key=" + part.getObjectKey() + ", bucket=" + part.getBucketName() + ": " + e.getMessage()));
                                        }
                                    }
                                    Entities.delete((Object)part);
                                }
                                break block7;
                            }
                            LOG.debug((Object)("No parts to delete for upload=" + arg0.getUploadId() + ", object-key=" + arg0.getObjectKey() + ", bucket=" + arg0.getBucketName()));
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Failed to cleanup parts for upload-id=" + arg0.getUploadId() + ", object-key=" + arg0.getObjectKey() + ", bucket=" + arg0.getBucketName()), (Throwable)e);
                        }
                    }
                    return null;
                }
            }).apply((Object)searchPart);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to cleanup parts for upload-id=" + uploadId + ", object-key=" + objectKey + ", bucket=" + bucketName), (Throwable)e);
        }
    }

    private void deleteParts(String bucketName) {
        PartInfo searchPart = new PartInfo();
        searchPart.setBucketName(bucketName);
        try {
            Entities.asTransaction(PartInfo.class, (Function)new Function<PartInfo, String>(){

                public String apply(PartInfo arg0) {
                    block7: {
                        try {
                            List allParts = Entities.query((Object)arg0);
                            if (allParts != null && !allParts.isEmpty()) {
                                for (PartInfo part : allParts) {
                                    if (part.getObjectName() != null) {
                                        try {
                                            WalrusFSManager.this.storageManager.deleteObject(part.getBucketName(), part.getObjectName());
                                        }
                                        catch (IOException e) {
                                            LOG.warn((Object)("Unable to delete file on disk for part-file=" + part.getObjectName() + ", part-number=" + part.getPartNumber() + ", upload-id=" + part.getUploadId() + ", object-key=" + part.getObjectKey() + ", bucket=" + part.getBucketName() + ". cause: " + e.getMessage()));
                                        }
                                    }
                                    Entities.delete((Object)part);
                                }
                                break block7;
                            }
                            LOG.debug((Object)("No parts to delete for bucket=" + arg0.getBucketName()));
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Failed to cleanup parts for bucket=" + arg0.getBucketName()), (Throwable)e);
                        }
                    }
                    return null;
                }
            }).apply((Object)searchPart);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to cleanup parts for bucket=" + searchPart.getBucketName()), (Throwable)e);
        }
    }

    private List<PartInfo> getOrderedListOfParts(ObjectInfo objectInfo) throws InternalErrorException {
        if (objectInfo != null && !Strings.isNullOrEmpty((String)objectInfo.getUploadId())) {
            PartInfo searchPart = new PartInfo(objectInfo.getBucketName(), objectInfo.getObjectKey(), objectInfo.getUploadId());
            searchPart.setCleanup(Boolean.FALSE);
            List parts = null;
            try (TransactionResource tr = Entities.transactionFor(PartInfo.class);){
                Criteria partCriteria = Entities.createCriteria(PartInfo.class);
                partCriteria.setReadOnly(true);
                partCriteria.add((Criterion)Example.create((Object)searchPart));
                partCriteria.add(Restrictions.isNotNull((String)"partNumber"));
                partCriteria.addOrder(Order.asc((String)"partNumber"));
                parts = partCriteria.list();
                tr.commit();
                if (parts == null || parts.isEmpty()) {
                    throw new InternalErrorException("No parts found for object " + objectInfo.getObjectKey());
                }
                List list = parts;
                return list;
            }
        }
        throw new InternalErrorException("Object may not be uploaded using multipart upload");
    }

    private static AccessControlPolicy getPrivateACP(String canonicalId, String displayName) {
        AccessControlList accessControlList = new AccessControlList();
        ArrayList<Grant> grants = WalrusFSManager.getPrivateGrants(canonicalId, displayName);
        accessControlList.setGrants(grants);
        return new AccessControlPolicy(new CanonicalUser(canonicalId, displayName), accessControlList);
    }

    private static ArrayList<Grant> getPrivateGrants(String canonicalId, String displayName) {
        ArrayList<Grant> grants = new ArrayList<Grant>();
        grants.add(new Grant(new Grantee(new CanonicalUser(canonicalId, displayName)), WalrusProperties.Permission.FULL_CONTROL.toString()));
        return grants;
    }

    private class BucketDeleter
    implements Runnable {
        final String bucketName;

        public BucketDeleter(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public void run() {
            try {
                WalrusFSManager.this.deleteParts(this.bucketName);
                WalrusFSManager.this.storageManager.deleteBucket(this.bucketName);
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        }
    }

    private class ObjectDeleter
    implements Runnable {
        final String bucketName;
        final String objectName;
        final String objectKey;
        final String uploadId;

        public ObjectDeleter(String bucketName, String objectName, String objectKey, String uploadId) {
            this.bucketName = bucketName;
            this.objectName = objectName;
            this.objectKey = objectKey;
            this.uploadId = uploadId;
        }

        @Override
        public void run() {
            if (StringUtils.isNotBlank((String)this.uploadId)) {
                WalrusFSManager.this.deleteParts(this.bucketName, this.objectKey, this.uploadId, false);
            } else {
                try {
                    WalrusFSManager.this.storageManager.deleteObject(this.bucketName, this.objectName);
                }
                catch (Exception ex) {
                    LOG.error((Object)("Failed to delete file=" + this.objectName + ", bucket=" + this.bucketName), (Throwable)ex);
                    return;
                }
            }
        }
    }
}

