/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.troubleshooting.checker.DiskResourceCheck;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.walrus.BackendStorageManagerFactory;
import com.eucalyptus.walrus.StorageManager;
import com.eucalyptus.walrus.WalrusBackend;
import com.eucalyptus.walrus.WalrusFSManager;
import com.eucalyptus.walrus.WalrusManager;
import com.eucalyptus.walrus.bittorrent.Tracker;
import com.eucalyptus.walrus.entities.WalrusInfo;
import com.eucalyptus.walrus.exceptions.AccessDeniedException;
import com.eucalyptus.walrus.msgs.AbortMultipartUploadResponseType;
import com.eucalyptus.walrus.msgs.AbortMultipartUploadType;
import com.eucalyptus.walrus.msgs.AddObjectResponseType;
import com.eucalyptus.walrus.msgs.AddObjectType;
import com.eucalyptus.walrus.msgs.CompleteMultipartUploadResponseType;
import com.eucalyptus.walrus.msgs.CompleteMultipartUploadType;
import com.eucalyptus.walrus.msgs.CopyObjectResponseType;
import com.eucalyptus.walrus.msgs.CopyObjectType;
import com.eucalyptus.walrus.msgs.CreateBucketResponseType;
import com.eucalyptus.walrus.msgs.CreateBucketType;
import com.eucalyptus.walrus.msgs.DeleteBucketResponseType;
import com.eucalyptus.walrus.msgs.DeleteBucketType;
import com.eucalyptus.walrus.msgs.DeleteObjectResponseType;
import com.eucalyptus.walrus.msgs.DeleteObjectType;
import com.eucalyptus.walrus.msgs.DeleteVersionResponseType;
import com.eucalyptus.walrus.msgs.DeleteVersionType;
import com.eucalyptus.walrus.msgs.GetBucketAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.GetBucketAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.GetBucketLocationResponseType;
import com.eucalyptus.walrus.msgs.GetBucketLocationType;
import com.eucalyptus.walrus.msgs.GetBucketLoggingStatusResponseType;
import com.eucalyptus.walrus.msgs.GetBucketLoggingStatusType;
import com.eucalyptus.walrus.msgs.GetBucketVersioningStatusResponseType;
import com.eucalyptus.walrus.msgs.GetBucketVersioningStatusType;
import com.eucalyptus.walrus.msgs.GetObjectAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.GetObjectAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.GetObjectExtendedResponseType;
import com.eucalyptus.walrus.msgs.GetObjectExtendedType;
import com.eucalyptus.walrus.msgs.GetObjectResponseType;
import com.eucalyptus.walrus.msgs.GetObjectType;
import com.eucalyptus.walrus.msgs.GetWalrusConfigurationResponseType;
import com.eucalyptus.walrus.msgs.GetWalrusConfigurationType;
import com.eucalyptus.walrus.msgs.HeadBucketResponseType;
import com.eucalyptus.walrus.msgs.HeadBucketType;
import com.eucalyptus.walrus.msgs.InitiateMultipartUploadResponseType;
import com.eucalyptus.walrus.msgs.InitiateMultipartUploadType;
import com.eucalyptus.walrus.msgs.ListAllMyBucketsResponseType;
import com.eucalyptus.walrus.msgs.ListAllMyBucketsType;
import com.eucalyptus.walrus.msgs.ListBucketResponseType;
import com.eucalyptus.walrus.msgs.ListBucketType;
import com.eucalyptus.walrus.msgs.ListVersionsResponseType;
import com.eucalyptus.walrus.msgs.ListVersionsType;
import com.eucalyptus.walrus.msgs.PostObjectResponseType;
import com.eucalyptus.walrus.msgs.PostObjectType;
import com.eucalyptus.walrus.msgs.PutObjectInlineResponseType;
import com.eucalyptus.walrus.msgs.PutObjectInlineType;
import com.eucalyptus.walrus.msgs.PutObjectResponseType;
import com.eucalyptus.walrus.msgs.PutObjectType;
import com.eucalyptus.walrus.msgs.SetBucketAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetBucketAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.SetBucketLoggingStatusResponseType;
import com.eucalyptus.walrus.msgs.SetBucketLoggingStatusType;
import com.eucalyptus.walrus.msgs.SetBucketVersioningStatusResponseType;
import com.eucalyptus.walrus.msgs.SetBucketVersioningStatusType;
import com.eucalyptus.walrus.msgs.SetObjectAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetObjectAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.SetRESTBucketAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetRESTBucketAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.SetRESTObjectAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetRESTObjectAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.UpdateWalrusConfigurationResponseType;
import com.eucalyptus.walrus.msgs.UpdateWalrusConfigurationType;
import com.eucalyptus.walrus.msgs.UploadPartResponseType;
import com.eucalyptus.walrus.msgs.UploadPartType;
import com.eucalyptus.walrus.msgs.WalrusDataMessenger;
import com.eucalyptus.walrus.util.WalrusProperties;
import edu.ucsb.eucalyptus.msgs.ComponentProperty;
import edu.ucsb.eucalyptus.util.SystemUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import org.apache.log4j.Logger;

public class WalrusControl {
    private static Logger LOG = Logger.getLogger(WalrusControl.class);
    private static WalrusDataMessenger imageMessenger = new WalrusDataMessenger();
    private static StorageManager storageManager;
    private static WalrusManager walrusManager;

    public static void checkPreconditions() throws EucalyptusCloudException, ExecutionException {
        try {
            SystemUtil.CommandOutput out = SystemUtil.runWithRawOutput((String[])new String[]{WalrusProperties.EUCA_ROOT_WRAPPER, "drbdadm", "status"});
            if (out.failed() || out.output.length() == 0) {
                Faults.advisory((ServiceConfiguration)Components.lookup(WalrusBackend.class).getLocalServiceConfiguration(), (Throwable[])new Throwable[]{new EucalyptusCloudException("drbdadm not found: Is drbd installed?")});
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed determining if drbd is installed using 'drbdadm status'.", (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    public static void configure() {
        WalrusInfo walrusInfo = WalrusInfo.getWalrusInfo();
        try {
            storageManager = BackendStorageManagerFactory.getStorageManager();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
        walrusManager = new WalrusFSManager(storageManager);
        WalrusManager.configure();
        String limits = System.getProperty("euca.walrus.usageLimits");
        if (limits != null) {
            WalrusProperties.shouldEnforceUsageLimits = Boolean.parseBoolean(limits);
        }
        try {
            walrusManager.check();
        }
        catch (EucalyptusCloudException ex) {
            LOG.error((Object)"Error initializing walrus", (Throwable)ex);
            SystemUtil.shutdownWithError((String)ex.getMessage());
        }
        if (System.getProperty("euca.virtualhosting.disable") != null) {
            WalrusProperties.enableVirtualHosting = false;
        }
        try {
            if (storageManager != null) {
                storageManager.start();
            }
        }
        catch (EucalyptusCloudException ex) {
            LOG.error((Object)("Error starting storage backend: " + (Object)((Object)ex)));
        }
        try {
            ScheduledFuture ex = DiskResourceCheck.start((DiskResourceCheck.Checker)new DiskResourceCheck.Checker(new DiskResourceCheck.LocationInfo(new File(WalrusInfo.getWalrusInfo().getStorageDir()), Double.valueOf(10.0)), WalrusBackend.class, 300000L));
        }
        catch (Exception ex) {
            LOG.error((Object)"Error starting disk space check for WalrusBackend storage directory.", (Throwable)ex);
        }
    }

    public static void enable() throws EucalyptusCloudException {
        storageManager.enable();
    }

    public static void disable() throws EucalyptusCloudException {
        storageManager.disable();
    }

    public static void check() throws EucalyptusCloudException {
        storageManager.check();
    }

    public static void stop() throws EucalyptusCloudException {
        storageManager.stop();
        Tracker.die();
        storageManager = null;
        walrusManager = null;
        WalrusProperties.shouldEnforceUsageLimits = true;
        WalrusProperties.enableVirtualHosting = true;
    }

    public UpdateWalrusConfigurationResponseType UpdateWalrusConfiguration(UpdateWalrusConfigurationType request) throws EucalyptusCloudException {
        UpdateWalrusConfigurationResponseType reply = (UpdateWalrusConfigurationResponseType)request.getReply();
        if (((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name().equals(request.getEffectiveUserId())) {
            throw new AccessDeniedException("Only admin can change walrus properties.");
        }
        if (request.getProperties() != null) {
            for (ComponentProperty prop : request.getProperties()) {
                LOG.info((Object)("WalrusBackend property: " + prop.getDisplayName() + " Qname: " + prop.getQualifiedName() + " Value: " + prop.getValue()));
                try {
                    ConfigurableProperty entry = PropertyDirectory.getPropertyEntry((String)prop.getQualifiedName());
                    entry.setValue(prop.getValue());
                }
                catch (IllegalAccessException e) {
                    LOG.error((Object)e, (Throwable)e);
                }
            }
        }
        String name = request.getName();
        walrusManager.check();
        return reply;
    }

    public GetWalrusConfigurationResponseType GetWalrusConfiguration(GetWalrusConfigurationType request) throws EucalyptusCloudException {
        GetWalrusConfigurationResponseType reply = (GetWalrusConfigurationResponseType)request.getReply();
        ConfigurableClass configurableClass = WalrusInfo.class.getAnnotation(ConfigurableClass.class);
        if (configurableClass != null) {
            String prefix = configurableClass.root();
            reply.setProperties((ArrayList)PropertyDirectory.getComponentPropertySet((String)prefix));
        }
        return reply;
    }

    protected void checkPermissions() throws AccessDeniedException {
        if (!Contexts.lookup().hasAdministrativePrivileges()) {
            throw new AccessDeniedException("Service", "WalrusBackend");
        }
    }

    public HeadBucketResponseType HeadBucket(HeadBucketType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.headBucket(request);
    }

    public CreateBucketResponseType CreateBucket(CreateBucketType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.createBucket(request);
    }

    public DeleteBucketResponseType DeleteBucket(DeleteBucketType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.deleteBucket(request);
    }

    public ListAllMyBucketsResponseType ListAllMyBuckets(ListAllMyBucketsType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.listAllMyBuckets(request);
    }

    public GetBucketAccessControlPolicyResponseType GetBucketAccessControlPolicy(GetBucketAccessControlPolicyType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.getBucketAccessControlPolicy(request);
    }

    public PutObjectResponseType PutObject(PutObjectType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.putObject(request);
    }

    public PostObjectResponseType PostObject(PostObjectType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.postObject(request);
    }

    public PutObjectInlineResponseType PutObjectInline(PutObjectInlineType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.putObjectInline(request);
    }

    public AddObjectResponseType AddObject(AddObjectType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.addObject(request);
    }

    public DeleteObjectResponseType DeleteObject(DeleteObjectType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.deleteObject(request);
    }

    public ListBucketResponseType ListBucket(ListBucketType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.listBucket(request);
    }

    public GetObjectAccessControlPolicyResponseType GetObjectAccessControlPolicy(GetObjectAccessControlPolicyType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.getObjectAccessControlPolicy(request);
    }

    public SetBucketAccessControlPolicyResponseType SetBucketAccessControlPolicy(SetBucketAccessControlPolicyType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.setBucketAccessControlPolicy(request);
    }

    public SetObjectAccessControlPolicyResponseType SetObjectAccessControlPolicy(SetObjectAccessControlPolicyType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.setObjectAccessControlPolicy(request);
    }

    public SetRESTBucketAccessControlPolicyResponseType SetRESTBucketAccessControlPolicy(SetRESTBucketAccessControlPolicyType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.setRESTBucketAccessControlPolicy(request);
    }

    public SetRESTObjectAccessControlPolicyResponseType SetRESTObjectAccessControlPolicy(SetRESTObjectAccessControlPolicyType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.setRESTObjectAccessControlPolicy(request);
    }

    public GetObjectResponseType GetObject(GetObjectType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.getObject(request);
    }

    public GetObjectExtendedResponseType GetObjectExtended(GetObjectExtendedType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.getObjectExtended(request);
    }

    public GetBucketLocationResponseType GetBucketLocation(GetBucketLocationType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.getBucketLocation(request);
    }

    public CopyObjectResponseType CopyObject(CopyObjectType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.copyObject(request);
    }

    public GetBucketLoggingStatusResponseType GetBucketLoggingStatus(GetBucketLoggingStatusType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.getBucketLoggingStatus(request);
    }

    public SetBucketLoggingStatusResponseType SetBucketLoggingStatus(SetBucketLoggingStatusType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.setBucketLoggingStatus(request);
    }

    public GetBucketVersioningStatusResponseType GetBucketVersioningStatus(GetBucketVersioningStatusType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.getBucketVersioningStatus(request);
    }

    public SetBucketVersioningStatusResponseType SetBucketVersioningStatus(SetBucketVersioningStatusType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.setBucketVersioningStatus(request);
    }

    public ListVersionsResponseType ListVersions(ListVersionsType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.listVersions(request);
    }

    public DeleteVersionResponseType DeleteVersion(DeleteVersionType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.deleteVersion(request);
    }

    public InitiateMultipartUploadResponseType InitiateMultipartUpload(InitiateMultipartUploadType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.initiateMultipartUpload(request);
    }

    public UploadPartResponseType UploadPart(UploadPartType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.uploadPart(request);
    }

    public CompleteMultipartUploadResponseType CompleteMultipartUpload(CompleteMultipartUploadType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.completeMultipartUpload(request);
    }

    public AbortMultipartUploadResponseType AbortMultipartUpload(AbortMultipartUploadType request) throws EucalyptusCloudException {
        this.checkPermissions();
        return walrusManager.abortMultipartUpload(request);
    }
}

