/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.util.Hashes;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Dispatcher;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.storage.msgs.BucketLogData;
import com.eucalyptus.storage.msgs.s3.CanonicalUser;
import com.eucalyptus.storage.msgs.s3.Grant;
import com.eucalyptus.storage.msgs.s3.Grantee;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.walrus.entities.WalrusInfo;
import com.eucalyptus.walrus.msgs.AddObjectType;
import com.eucalyptus.ws.client.ServiceDispatcher;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class WalrusBucketLogger {
    private Logger LOG = Logger.getLogger(WalrusBucketLogger.class);
    private static WalrusBucketLogger singleton;
    private static int LOG_THRESHOLD;
    private static int LOG_PERIODICITY;
    private LinkedBlockingQueue<BucketLogData> logData = new LinkedBlockingQueue();
    private ConcurrentHashMap<String, LogFileEntry> logFileMap = new ConcurrentHashMap();
    ScheduledExecutorService logger = Executors.newSingleThreadScheduledExecutor();

    public WalrusBucketLogger() {
        this.logger.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (WalrusBucketLogger.this.logData.size() > LOG_THRESHOLD) {
                    Dispatcher dispatcher = ServiceDispatcher.lookupSingle((Component)Components.lookup((String)"walrus"));
                    ArrayList data = new ArrayList();
                    WalrusBucketLogger.this.logData.drainTo(data);
                    for (BucketLogData entry : data) {
                        String bucket = entry.getTargetBucket();
                        String uuid = UUID.randomUUID().toString();
                        String key = entry.getTargetPrefix() + String.format("%1$tY-%1$tm-%1$td-%1$tH-%1$tM-%1$tS-", Calendar.getInstance()) + uuid;
                        if (!WalrusBucketLogger.this.logFileMap.containsKey(bucket)) {
                            try {
                                String logFileName = "logentry-" + uuid;
                                FileChannel channel = new FileOutputStream(new File(WalrusInfo.getWalrusInfo().getStorageDir() + "/" + bucket + "/" + logFileName)).getChannel();
                                WalrusBucketLogger.this.logFileMap.put(bucket, new LogFileEntry(logFileName, channel));
                            }
                            catch (FileNotFoundException e) {
                                WalrusBucketLogger.this.LOG.error((Object)e);
                            }
                        }
                        try {
                            LogFileEntry logFileEntry = (LogFileEntry)WalrusBucketLogger.this.logFileMap.get(bucket);
                            FileChannel logChannel = logFileEntry.getChannel();
                            String logString = entry.toFormattedString();
                            logChannel.write(ByteBuffer.wrap(logString.getBytes()), logChannel.size());
                            MessageDigest digest = Digest.MD5.get();
                            digest.update(logString.getBytes());
                            String etag = Hashes.bytesToHex((byte[])digest.digest());
                            AddObjectType request = new AddObjectType();
                            request.regarding();
                            request.setBucket(bucket);
                            request.setKey(key);
                            request.setObjectName(logFileEntry.getLogFileName());
                            request.setEtag(etag);
                            String ownerId = entry.getOwnerId();
                            try {
                                ArrayList<Grant> grants = new ArrayList<Grant>();
                                grants.add(new Grant(new Grantee(new CanonicalUser(ownerId, Accounts.lookupAccountById((String)ownerId).getName())), "FULL_CONTROL"));
                                request.getAccessControlList().setGrants(grants);
                            }
                            catch (AuthException e1) {
                                WalrusBucketLogger.this.LOG.error((Object)e1);
                            }
                            try {
                                dispatcher.send((BaseMessage)request);
                            }
                            catch (EucalyptusCloudException e) {
                                WalrusBucketLogger.this.LOG.error((Object)e);
                            }
                        }
                        catch (IOException e) {
                            WalrusBucketLogger.this.LOG.error((Object)e);
                        }
                    }
                    for (String bucket : WalrusBucketLogger.this.logFileMap.keySet()) {
                        try {
                            ((LogFileEntry)WalrusBucketLogger.this.logFileMap.get(bucket)).getChannel().close();
                        }
                        catch (IOException e) {
                            WalrusBucketLogger.this.LOG.error((Object)e);
                        }
                    }
                    WalrusBucketLogger.this.logFileMap.clear();
                }
            }
        }, 1L, LOG_PERIODICITY, TimeUnit.SECONDS);
    }

    public static WalrusBucketLogger getInstance() {
        if (singleton == null) {
            singleton = new WalrusBucketLogger();
        }
        return singleton;
    }

    public void addLogEntry(BucketLogData logEntry) {
        try {
            this.logData.offer(logEntry, 500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public BucketLogData makeLogEntry(String requestId) {
        return new BucketLogData(requestId);
    }

    static {
        LOG_THRESHOLD = 10;
        LOG_PERIODICITY = 120;
    }

    private class LogFileEntry {
        private String logFileName;
        private FileChannel channel;

        public LogFileEntry(String logFileName, FileChannel channel) {
            this.logFileName = logFileName;
            this.channel = channel;
        }

        public FileChannel getChannel() {
            return this.channel;
        }

        public String getLogFileName() {
            return this.logFileName;
        }
    }
}

