/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus;

import com.eucalyptus.storage.common.fs.FileIO;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.walrus.entities.PartInfo;
import com.eucalyptus.walrus.exceptions.WalrusException;
import com.eucalyptus.walrus.msgs.WalrusDataGetResponseType;
import java.io.IOException;
import java.util.List;

public interface StorageManager {
    public void checkPreconditions() throws EucalyptusCloudException;

    public boolean bucketExists(String var1);

    public boolean objectExists(String var1, String var2);

    public void createBucket(String var1) throws IOException;

    public long getSize(String var1, String var2);

    public void deleteBucket(String var1) throws IOException;

    public void createObject(String var1, String var2) throws IOException;

    public void putObject(String var1, String var2, byte[] var3, boolean var4) throws IOException;

    public FileIO prepareForRead(String var1, String var2) throws Exception;

    public FileIO prepareForWrite(String var1, String var2) throws Exception;

    public int readObject(String var1, String var2, byte[] var3, long var4) throws IOException;

    public int readObject(String var1, byte[] var2, long var3) throws IOException;

    public void deleteObject(String var1, String var2) throws IOException;

    public void deleteAbsoluteObject(String var1) throws IOException;

    public void copyObject(String var1, String var2, String var3, String var4) throws IOException;

    public void copyMultipartObject(List<PartInfo> var1, String var2, String var3) throws Exception;

    public void renameObject(String var1, String var2, String var3) throws IOException;

    public String getObjectPath(String var1, String var2);

    public void getObject(String var1, String var2, WalrusDataGetResponseType var3, Long var4, Boolean var5) throws WalrusException;

    public void getObject(String var1, String var2, WalrusDataGetResponseType var3, Long var4, Long var5, Boolean var6) throws WalrusException;

    public void getMultipartObject(WalrusDataGetResponseType var1, List<PartInfo> var2, Boolean var3) throws WalrusException;

    public void getMultipartObject(WalrusDataGetResponseType var1, List<PartInfo> var2, Boolean var3, Long var4, Long var5) throws WalrusException;

    public void disable() throws EucalyptusCloudException;

    public void enable() throws EucalyptusCloudException;

    public void stop() throws EucalyptusCloudException;

    public void check() throws EucalyptusCloudException;

    public void start() throws EucalyptusCloudException;
}

