/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.ws;

import com.eucalyptus.util.Strings;
import com.eucalyptus.ws.protocol.OperationParameter;
import com.eucalyptus.ws.protocol.RequestLoggingFilter;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class EuareRequestLoggingFilter
implements RequestLoggingFilter {
    private static final Iterable<String> CREATE_UPDATE_PROFILE_ACTION_NVPS = Iterables.concat(EuareRequestLoggingFilter.buildActionNVPs("CreateLoginProfile"), EuareRequestLoggingFilter.buildActionNVPs("UpdateLoginProfile"));
    private static final Iterable<String> UPLOAD_CERT_ACTION_NVPS = EuareRequestLoggingFilter.buildActionNVPs("UploadServerCertificate");
    private static final String PASSWORD_PARAMETER = "Password=";
    private static final String PASSWORD_PARAMETER_REDACTED = "Password=********";
    private static final String PRIVATE_KEY_PARAMETER = "PrivateKey=";
    private static final String PRIVATE_KEY_PARAMETER_REDACTED = "PrivateKey=********";

    private static Iterable<String> buildActionNVPs(String action) {
        return Iterables.unmodifiableIterable((Iterable)Iterables.transform(Arrays.asList(OperationParameter.values()), (Function)Functions.compose((Function)Strings.append((String)("=" + action)), (Function)Functions.toStringFunction())));
    }

    public Collection<String> apply(Collection<String> parametersOrBody) {
        if (this.isAction(parametersOrBody, CREATE_UPDATE_PROFILE_ACTION_NVPS)) {
            return this.filterParameter(parametersOrBody, PASSWORD_PARAMETER, PASSWORD_PARAMETER_REDACTED);
        }
        if (this.isAction(parametersOrBody, UPLOAD_CERT_ACTION_NVPS)) {
            return this.filterParameter(parametersOrBody, PRIVATE_KEY_PARAMETER, PRIVATE_KEY_PARAMETER_REDACTED);
        }
        return parametersOrBody;
    }

    private boolean isAction(Collection<String> parametersOrBody, Iterable<String> actionNvps) {
        return Iterables.tryFind(actionNvps, (Predicate)Predicates.in(parametersOrBody)).isPresent();
    }

    private Collection<String> filterParameter(Collection<String> parametersOrBody, String parameter, String redacted) {
        Optional parameterAndValue = Iterables.tryFind(parametersOrBody, (Predicate)Strings.startsWith((String)parameter));
        if (parameterAndValue.isPresent()) {
            ArrayList parametersCopy = Lists.newArrayList(parametersOrBody);
            parametersCopy.set(parametersCopy.indexOf(parameterAndValue.get()), redacted);
            return parametersCopy;
        }
        return parametersOrBody;
    }
}

