/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.ws;

import com.eucalyptus.auth.euare.ErrorResponseType;
import com.eucalyptus.auth.euare.ErrorType;
import com.eucalyptus.auth.euare.EuareException;
import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.NoSuchContextException;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.LogUtil;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.message.ExceptionMessage;

public class EuareReplyQueue {
    private static Logger LOG = Logger.getLogger(EuareReplyQueue.class);

    public static void handle(String service, MuleMessage responseMessage, BaseMessage request) {
        BaseMessage reply = null;
        if (responseMessage.getExceptionPayload() == null) {
            reply = (BaseMessage)responseMessage.getPayload();
        } else {
            Throwable t = responseMessage.getExceptionPayload().getException();
            t = t.getCause() == null ? t : t.getCause();
            reply = new EucalyptusErrorMessageType(service, request, t.getMessage());
        }
        String corrId = reply.getCorrelationId();
        EventRecord.here(EuareReplyQueue.class, (EventType)EventType.MSG_REPLY, (String[])new String[]{reply.getCorrelationId(), reply.getClass().getSimpleName()}).debug();
        try {
            Context context = Contexts.lookup((String)corrId);
            Channel channel = context.getChannel();
            Channels.write((Channel)channel, (Object)reply);
            Contexts.clear((Context)context);
        }
        catch (NoSuchContextException e) {
            LOG.trace((Object)e, (Throwable)e);
        }
    }

    public void handle(BaseMessage responseMessage) {
        EventRecord.here(EuareReplyQueue.class, (EventType)EventType.MSG_REPLY, (String[])new String[]{responseMessage.getCorrelationId(), responseMessage.getClass().getSimpleName()}).debug();
        LOG.debug((Object)("HERE: " + responseMessage));
        String corrId = responseMessage.getCorrelationId();
        try {
            Context context = Contexts.lookup((String)corrId);
            Channel channel = context.getChannel();
            Channels.write((Channel)channel, (Object)responseMessage);
            Contexts.clear((Context)context);
        }
        catch (NoSuchContextException e) {
            LOG.warn((Object)"Received a reply for absent client:  No channel to write response message.", (Throwable)e);
            LOG.debug((Object)responseMessage);
        }
    }

    public void handle(ExceptionMessage exMsg) {
        EventRecord.here(EuareReplyQueue.class, (EventType)EventType.MSG_REPLY, (String[])new String[]{exMsg.getPayload().getClass().getSimpleName()}).debug();
        Throwable exception = exMsg.getException();
        if (exception instanceof MessagingException && exception.getCause() instanceof EucalyptusCloudException) {
            HttpResponseStatus status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            String errorName = "InternalFailure";
            if (exception.getCause() instanceof EuareException) {
                EuareException euareException = (EuareException)((Object)exception.getCause());
                status = euareException.getStatus();
                errorName = euareException.getError();
            }
            ErrorResponseType errorResp = new ErrorResponseType();
            BaseMessage payload = null;
            try {
                payload = this.parsePayload(exMsg.getPayload());
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to parse payload ", (Throwable)e);
            }
            if (payload != null) {
                errorResp.setHttpStatus(status);
                errorResp.setCorrelationId(payload.getCorrelationId());
                errorResp.setRequestId(payload.getCorrelationId());
                ErrorType error = new ErrorType();
                error.setType("Sender");
                error.setCode(errorName);
                error.setMessage(exception.getCause().getMessage());
                errorResp.getErrorList().add(error);
                this.handle((BaseMessage)errorResp);
            }
        }
    }

    private BaseMessage parsePayload(Object payload) throws Exception {
        if (payload instanceof BaseMessage) {
            return (BaseMessage)payload;
        }
        if (payload instanceof String) {
            return (BaseMessage)BindingManager.getBinding((String)"https://iam.amazonaws.com/doc/2010-05-08/").fromOM((String)payload);
        }
        return new EucalyptusErrorMessageType("ReplyQueue", LogUtil.dumpObject((Object)payload));
    }
}

