/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.euare.policy;

import com.eucalyptus.auth.PolicyResourceContext;
import com.eucalyptus.auth.euare.policy.EuarePolicyContext;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.RestrictedType;
import com.eucalyptus.util.TypeMappers;
import com.google.common.collect.Sets;
import java.util.Set;

public class EuarePolicyResourceInterceptor
implements PolicyResourceContext.PolicyResourceInterceptor {
    private static final Set<Class<? extends RestrictedType>> accepted = Sets.newCopyOnWriteArraySet();
    private static final Set<Class<? extends RestrictedType>> rejected = Sets.newCopyOnWriteArraySet();

    public void onResource(PolicyResourceContext.PolicyResourceInfo resource, String action) {
        EuarePolicyContext.clearContext();
        if (resource != null && RestrictedType.class.isAssignableFrom(resource.getResourceClass()) && (accepted.contains(resource.getResourceClass()) || !rejected.contains(resource.getResourceClass()) && Account.class.isAssignableFrom(resource.getResourceClass()))) {
            try {
                EuarePolicyContext.setEuarePolicyContextResource((EuarePolicyContext.EuarePolicyContextResource)TypeMappers.transform((Object)resource.getResourceObject(), EuarePolicyContext.EuarePolicyContextResource.class));
                accepted.add(resource.getResourceClass());
            }
            catch (IllegalArgumentException e) {
                rejected.add(resource.getResourceClass());
                Logs.exhaust().info((Object)("Policy context not set for resource type: " + resource.getResourceClass().getSimpleName()));
            }
        }
    }
}

