/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.euare.policy;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import javax.annotation.Nullable;

public class EuarePolicyContext {
    private static final ThreadLocal<EuarePolicyContextResource> resourceLocal = new ThreadLocal();

    static void clearContext() {
        resourceLocal.set(null);
    }

    static void setEuarePolicyContextResource(@Nullable EuarePolicyContextResource resource) {
        resourceLocal.set(resource);
    }

    @Nullable
    public static Boolean isSystemAccount() {
        EuarePolicyContextResource resource = resourceLocal.get();
        return resource == null ? null : resource.isSystemAccount();
    }

    @TypeMapper
    public static enum AccountEuarePolicyContextTransform implements Function<Account, EuarePolicyContextResource>
    {
        INSTANCE;


        public EuarePolicyContextResource apply(final Account account) {
            return new EuarePolicyContextResource(){

                @Override
                @Nullable
                public Boolean isSystemAccount() {
                    return Accounts.isSystemAccount((Account)account);
                }
            };
        }
    }

    public static interface EuarePolicyContextResource {
        @Nullable
        public Boolean isSystemAccount();
    }
}

