/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.euare;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.euare.EuareQuotaUtil;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.key.KeyUtils;
import com.eucalyptus.auth.policy.key.PolicyKey;
import com.eucalyptus.auth.policy.key.QuotaKey;
import com.eucalyptus.auth.principal.Authorization;
import net.sf.json.JSONException;

@PolicyKey(value="iam:quota-usernumber")
public class UserNumberQuotaKey
extends QuotaKey {
    private static final String KEY = "iam:quota-usernumber";

    public void validateValueType(String value) throws JSONException {
        KeyUtils.validateIntegerValue((String)value, (String)KEY);
    }

    public boolean canApply(String action, String resourceType) {
        return PolicySpec.qualifiedName((String)"iam", (String)"createuser").equals(action);
    }

    public String value(Authorization.Scope scope, String id, String resource, Long quantity) throws AuthException {
        switch (scope) {
            case ACCOUNT: {
                return Long.toString(EuareQuotaUtil.countUserByAccount(id) + quantity);
            }
            case GROUP: {
                return "Not supported";
            }
            case USER: {
                return "Not supported";
            }
        }
        throw new AuthException("Invalid scope");
    }
}

