/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.euare;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthContext;
import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.PolicyParseException;
import com.eucalyptus.auth.Privileged;
import com.eucalyptus.auth.ServerCertificate;
import com.eucalyptus.auth.ServerCertificates;
import com.eucalyptus.auth.entities.ServerCertificateEntity;
import com.eucalyptus.auth.euare.AccessKeyMetadataType;
import com.eucalyptus.auth.euare.AccessKeyType;
import com.eucalyptus.auth.euare.AccountType;
import com.eucalyptus.auth.euare.AddRoleToInstanceProfileResponseType;
import com.eucalyptus.auth.euare.AddRoleToInstanceProfileType;
import com.eucalyptus.auth.euare.AddUserToGroupResponseType;
import com.eucalyptus.auth.euare.AddUserToGroupType;
import com.eucalyptus.auth.euare.CreateAccessKeyResponseType;
import com.eucalyptus.auth.euare.CreateAccessKeyType;
import com.eucalyptus.auth.euare.CreateAccountAliasResponseType;
import com.eucalyptus.auth.euare.CreateAccountAliasType;
import com.eucalyptus.auth.euare.CreateAccountResponseType;
import com.eucalyptus.auth.euare.CreateAccountType;
import com.eucalyptus.auth.euare.CreateGroupResponseType;
import com.eucalyptus.auth.euare.CreateGroupType;
import com.eucalyptus.auth.euare.CreateInstanceProfileResponseType;
import com.eucalyptus.auth.euare.CreateInstanceProfileType;
import com.eucalyptus.auth.euare.CreateLoginProfileResponseType;
import com.eucalyptus.auth.euare.CreateLoginProfileType;
import com.eucalyptus.auth.euare.CreateRoleResponseType;
import com.eucalyptus.auth.euare.CreateRoleType;
import com.eucalyptus.auth.euare.CreateSigningCertificateResponseType;
import com.eucalyptus.auth.euare.CreateSigningCertificateType;
import com.eucalyptus.auth.euare.CreateUserResponseType;
import com.eucalyptus.auth.euare.CreateUserType;
import com.eucalyptus.auth.euare.DeactivateMFADeviceResponseType;
import com.eucalyptus.auth.euare.DeactivateMFADeviceType;
import com.eucalyptus.auth.euare.DeleteAccessKeyResponseType;
import com.eucalyptus.auth.euare.DeleteAccessKeyType;
import com.eucalyptus.auth.euare.DeleteAccountAliasResponseType;
import com.eucalyptus.auth.euare.DeleteAccountAliasType;
import com.eucalyptus.auth.euare.DeleteAccountPolicyResponseType;
import com.eucalyptus.auth.euare.DeleteAccountPolicyType;
import com.eucalyptus.auth.euare.DeleteAccountResponseType;
import com.eucalyptus.auth.euare.DeleteAccountType;
import com.eucalyptus.auth.euare.DeleteGroupPolicyResponseType;
import com.eucalyptus.auth.euare.DeleteGroupPolicyType;
import com.eucalyptus.auth.euare.DeleteGroupResponseType;
import com.eucalyptus.auth.euare.DeleteGroupType;
import com.eucalyptus.auth.euare.DeleteInstanceProfileResponseType;
import com.eucalyptus.auth.euare.DeleteInstanceProfileType;
import com.eucalyptus.auth.euare.DeleteLoginProfileResponseType;
import com.eucalyptus.auth.euare.DeleteLoginProfileType;
import com.eucalyptus.auth.euare.DeleteRolePolicyResponseType;
import com.eucalyptus.auth.euare.DeleteRolePolicyType;
import com.eucalyptus.auth.euare.DeleteRoleResponseType;
import com.eucalyptus.auth.euare.DeleteRoleType;
import com.eucalyptus.auth.euare.DeleteServerCertificateResponseType;
import com.eucalyptus.auth.euare.DeleteServerCertificateType;
import com.eucalyptus.auth.euare.DeleteSigningCertificateResponseType;
import com.eucalyptus.auth.euare.DeleteSigningCertificateType;
import com.eucalyptus.auth.euare.DeleteUserPolicyResponseType;
import com.eucalyptus.auth.euare.DeleteUserPolicyType;
import com.eucalyptus.auth.euare.DeleteUserResponseType;
import com.eucalyptus.auth.euare.DeleteUserType;
import com.eucalyptus.auth.euare.DownloadServerCertificateResponseType;
import com.eucalyptus.auth.euare.DownloadServerCertificateResultType;
import com.eucalyptus.auth.euare.DownloadServerCertificateType;
import com.eucalyptus.auth.euare.EnableMFADeviceResponseType;
import com.eucalyptus.auth.euare.EnableMFADeviceType;
import com.eucalyptus.auth.euare.EuareException;
import com.eucalyptus.auth.euare.EuareServerCertificateUtil;
import com.eucalyptus.auth.euare.GetAccountPolicyResponseType;
import com.eucalyptus.auth.euare.GetAccountPolicyResultType;
import com.eucalyptus.auth.euare.GetAccountPolicyType;
import com.eucalyptus.auth.euare.GetAccountSummaryResponseType;
import com.eucalyptus.auth.euare.GetAccountSummaryType;
import com.eucalyptus.auth.euare.GetGroupPolicyResponseType;
import com.eucalyptus.auth.euare.GetGroupPolicyResultType;
import com.eucalyptus.auth.euare.GetGroupPolicyType;
import com.eucalyptus.auth.euare.GetGroupResponseType;
import com.eucalyptus.auth.euare.GetGroupType;
import com.eucalyptus.auth.euare.GetInstanceProfileResponseType;
import com.eucalyptus.auth.euare.GetInstanceProfileType;
import com.eucalyptus.auth.euare.GetLdapSyncStatusResponseType;
import com.eucalyptus.auth.euare.GetLdapSyncStatusType;
import com.eucalyptus.auth.euare.GetLoginProfileResponseType;
import com.eucalyptus.auth.euare.GetLoginProfileType;
import com.eucalyptus.auth.euare.GetRolePolicyResponseType;
import com.eucalyptus.auth.euare.GetRolePolicyResult;
import com.eucalyptus.auth.euare.GetRolePolicyType;
import com.eucalyptus.auth.euare.GetRoleResponseType;
import com.eucalyptus.auth.euare.GetRoleType;
import com.eucalyptus.auth.euare.GetServerCertificateResponseType;
import com.eucalyptus.auth.euare.GetServerCertificateResultType;
import com.eucalyptus.auth.euare.GetServerCertificateType;
import com.eucalyptus.auth.euare.GetUserInfoResponseType;
import com.eucalyptus.auth.euare.GetUserInfoType;
import com.eucalyptus.auth.euare.GetUserPolicyResponseType;
import com.eucalyptus.auth.euare.GetUserPolicyResultType;
import com.eucalyptus.auth.euare.GetUserPolicyType;
import com.eucalyptus.auth.euare.GetUserResponseType;
import com.eucalyptus.auth.euare.GetUserType;
import com.eucalyptus.auth.euare.GroupType;
import com.eucalyptus.auth.euare.InstanceProfileType;
import com.eucalyptus.auth.euare.ListAccessKeysResponseType;
import com.eucalyptus.auth.euare.ListAccessKeysResultType;
import com.eucalyptus.auth.euare.ListAccessKeysType;
import com.eucalyptus.auth.euare.ListAccountAliasesResponseType;
import com.eucalyptus.auth.euare.ListAccountAliasesType;
import com.eucalyptus.auth.euare.ListAccountPoliciesResponseType;
import com.eucalyptus.auth.euare.ListAccountPoliciesResultType;
import com.eucalyptus.auth.euare.ListAccountPoliciesType;
import com.eucalyptus.auth.euare.ListAccountsResponseType;
import com.eucalyptus.auth.euare.ListAccountsType;
import com.eucalyptus.auth.euare.ListGroupPoliciesResponseType;
import com.eucalyptus.auth.euare.ListGroupPoliciesResultType;
import com.eucalyptus.auth.euare.ListGroupPoliciesType;
import com.eucalyptus.auth.euare.ListGroupsForUserResponseType;
import com.eucalyptus.auth.euare.ListGroupsForUserType;
import com.eucalyptus.auth.euare.ListGroupsResponseType;
import com.eucalyptus.auth.euare.ListGroupsType;
import com.eucalyptus.auth.euare.ListInstanceProfilesForRoleResponseType;
import com.eucalyptus.auth.euare.ListInstanceProfilesForRoleType;
import com.eucalyptus.auth.euare.ListInstanceProfilesResponseType;
import com.eucalyptus.auth.euare.ListInstanceProfilesType;
import com.eucalyptus.auth.euare.ListMFADevicesResponseType;
import com.eucalyptus.auth.euare.ListMFADevicesType;
import com.eucalyptus.auth.euare.ListRolePoliciesResponseType;
import com.eucalyptus.auth.euare.ListRolePoliciesResult;
import com.eucalyptus.auth.euare.ListRolePoliciesType;
import com.eucalyptus.auth.euare.ListRolesResponseType;
import com.eucalyptus.auth.euare.ListRolesType;
import com.eucalyptus.auth.euare.ListServerCertificatesResponseType;
import com.eucalyptus.auth.euare.ListServerCertificatesResultType;
import com.eucalyptus.auth.euare.ListServerCertificatesType;
import com.eucalyptus.auth.euare.ListSigningCertificatesResponseType;
import com.eucalyptus.auth.euare.ListSigningCertificatesResultType;
import com.eucalyptus.auth.euare.ListSigningCertificatesType;
import com.eucalyptus.auth.euare.ListUserPoliciesResponseType;
import com.eucalyptus.auth.euare.ListUserPoliciesResultType;
import com.eucalyptus.auth.euare.ListUserPoliciesType;
import com.eucalyptus.auth.euare.ListUsersResponseType;
import com.eucalyptus.auth.euare.ListUsersResultType;
import com.eucalyptus.auth.euare.ListUsersType;
import com.eucalyptus.auth.euare.PutAccountPolicyResponseType;
import com.eucalyptus.auth.euare.PutAccountPolicyType;
import com.eucalyptus.auth.euare.PutGroupPolicyResponseType;
import com.eucalyptus.auth.euare.PutGroupPolicyType;
import com.eucalyptus.auth.euare.PutRolePolicyResponseType;
import com.eucalyptus.auth.euare.PutRolePolicyType;
import com.eucalyptus.auth.euare.PutUserPolicyResponseType;
import com.eucalyptus.auth.euare.PutUserPolicyType;
import com.eucalyptus.auth.euare.RemoveRoleFromInstanceProfileResponseType;
import com.eucalyptus.auth.euare.RemoveRoleFromInstanceProfileType;
import com.eucalyptus.auth.euare.RemoveUserFromGroupResponseType;
import com.eucalyptus.auth.euare.RemoveUserFromGroupType;
import com.eucalyptus.auth.euare.ResyncMFADeviceResponseType;
import com.eucalyptus.auth.euare.ResyncMFADeviceType;
import com.eucalyptus.auth.euare.RoleListType;
import com.eucalyptus.auth.euare.RoleType;
import com.eucalyptus.auth.euare.ServerCertificateMetadataListTypeType;
import com.eucalyptus.auth.euare.ServerCertificateMetadataType;
import com.eucalyptus.auth.euare.ServerCertificateType;
import com.eucalyptus.auth.euare.SignCertificateResponseType;
import com.eucalyptus.auth.euare.SignCertificateResultType;
import com.eucalyptus.auth.euare.SignCertificateType;
import com.eucalyptus.auth.euare.SigningCertificateType;
import com.eucalyptus.auth.euare.SummaryMapTypeEntryType;
import com.eucalyptus.auth.euare.UpdateAccessKeyResponseType;
import com.eucalyptus.auth.euare.UpdateAccessKeyType;
import com.eucalyptus.auth.euare.UpdateAssumeRolePolicyResponseType;
import com.eucalyptus.auth.euare.UpdateAssumeRolePolicyType;
import com.eucalyptus.auth.euare.UpdateGroupResponseType;
import com.eucalyptus.auth.euare.UpdateGroupType;
import com.eucalyptus.auth.euare.UpdateLoginProfileResponseType;
import com.eucalyptus.auth.euare.UpdateLoginProfileType;
import com.eucalyptus.auth.euare.UpdateServerCertificateResponseType;
import com.eucalyptus.auth.euare.UpdateServerCertificateType;
import com.eucalyptus.auth.euare.UpdateSigningCertificateResponseType;
import com.eucalyptus.auth.euare.UpdateSigningCertificateType;
import com.eucalyptus.auth.euare.UpdateUserInfoResponseType;
import com.eucalyptus.auth.euare.UpdateUserInfoType;
import com.eucalyptus.auth.euare.UpdateUserResponseType;
import com.eucalyptus.auth.euare.UpdateUserType;
import com.eucalyptus.auth.euare.UploadServerCertificateResponseType;
import com.eucalyptus.auth.euare.UploadServerCertificateResultType;
import com.eucalyptus.auth.euare.UploadServerCertificateType;
import com.eucalyptus.auth.euare.UploadSigningCertificateResponseType;
import com.eucalyptus.auth.euare.UploadSigningCertificateType;
import com.eucalyptus.auth.euare.UserInfoType;
import com.eucalyptus.auth.euare.UserType;
import com.eucalyptus.auth.euare.events.AccountEventUtils;
import com.eucalyptus.auth.ldap.LdapSync;
import com.eucalyptus.auth.policy.ern.EuareResourceName;
import com.eucalyptus.auth.policy.key.Iso8601DateParser;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Certificate;
import com.eucalyptus.auth.principal.Group;
import com.eucalyptus.auth.principal.InstanceProfile;
import com.eucalyptus.auth.principal.Policy;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.util.X509CertHelper;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.crypto.Certs;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.springframework.web.util.UriUtils;

public class EuareService {
    private static final Logger LOG = Logger.getLogger(EuareService.class);
    private static final boolean ENCODE_POLICIES = Boolean.valueOf(System.getProperty("com.eucalyptus.auth.euare.encodePolicies", "true"));

    public CreateAccountResponseType createAccount(CreateAccountType request) throws EucalyptusCloudException {
        CreateAccountResponseType reply = (CreateAccountResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        try {
            Account newAccount = Privileged.createAccount((AuthContext)requestUser, (String)request.getAccountName(), null, null);
            AccountType account = reply.getCreateAccountResult().getAccount();
            account.setAccountName(newAccount.getName());
            account.setAccountId(newAccount.getAccountNumber());
            AccountEventUtils.fireCreated((String)newAccount.getAccountNumber());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to create account by " + ctx.getUser().getName());
                }
                if ("Account already exists".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "Account " + request.getAccountName() + " already exists.");
                }
                if ("Invalid name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Invalid account name " + request.getAccountName());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeleteAccountResponseType deleteAccount(DeleteAccountType request) throws EucalyptusCloudException {
        DeleteAccountResponseType reply = (DeleteAccountResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account accountFound = EuareService.lookupAccountByName(request.getAccountName());
        try {
            boolean recursive = request.getRecursive() != null && request.getRecursive() != false;
            Privileged.deleteAccount((AuthContext)requestUser, (Account)accountFound, (boolean)recursive);
            AccountEventUtils.fireDeleted((String)accountFound.getAccountNumber());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete account by " + ctx.getUser().getName());
                }
                if ("Account still has groups and can not be deleted".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "DeleteConflict", "Account " + request.getAccountName() + " can not be deleted.");
                }
                if ("Can not delete system account".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "DeleteConflict", "System account can not be deleted.");
                }
                if ("Empty account name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty account name");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public ListAccountsResponseType listAccounts(ListAccountsType request) throws EucalyptusCloudException {
        ListAccountsResponseType reply = (ListAccountsResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        if (!Permissions.perhapsAuthorized((String)"iam", (String)"listaccounts", (AuthContextSupplier)ctx.getAuthContext())) {
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to list accounts");
        }
        ArrayList accounts = reply.getListAccountsResult().getAccounts().getMemberList();
        try {
            for (Account account : Iterables.filter((Iterable)Accounts.listAllAccounts(), (Predicate)RestrictedTypes.filterPrivileged())) {
                AccountType at = new AccountType();
                at.setAccountName(account.getName());
                at.setAccountId(account.getAccountNumber());
                accounts.add(at);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public ListGroupsResponseType listGroups(ListGroupsType request) throws EucalyptusCloudException {
        ListGroupsResponseType reply = (ListGroupsResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        String path = "/";
        if (!Strings.isNullOrEmpty((String)request.getPathPrefix())) {
            path = request.getPathPrefix();
        }
        if (!Permissions.perhapsAuthorized((String)"iam", (String)"listgroups", (AuthContextSupplier)ctx.getAuthContext())) {
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to list groups");
        }
        reply.getListGroupsResult().setIsTruncated(Boolean.valueOf(false));
        ArrayList groups = reply.getListGroupsResult().getGroups().getMemberList();
        try {
            for (Group group : account.getGroups()) {
                if (!group.getPath().startsWith(path) || !Privileged.allowListGroup((AuthContext)requestUser, (Account)account, (Group)group)) continue;
                GroupType g = new GroupType();
                this.fillGroupResult(g, group, account);
                groups.add(g);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeleteAccessKeyResponseType deleteAccessKey(DeleteAccessKeyType request) throws EucalyptusCloudException {
        DeleteAccessKeyResponseType reply = (DeleteAccessKeyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = ctx.getUser();
        if (!Strings.isNullOrEmpty((String)request.getUserName())) {
            userFound = EuareService.lookupUserByName(account, request.getUserName());
        }
        try {
            Privileged.deleteAccessKey((AuthContext)requestUser, (Account)account, (User)userFound, (String)request.getAccessKeyId());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete access key of " + request.getUserName() + "by " + ctx.getUser().getName());
                }
                if ("Empty access key id".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidId", "Empty key id");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public ListSigningCertificatesResponseType listSigningCertificates(ListSigningCertificatesType request) throws EucalyptusCloudException {
        ListSigningCertificatesResponseType reply = (ListSigningCertificatesResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = ctx.getUser();
        if (!Strings.isNullOrEmpty((String)request.getUserName())) {
            userFound = EuareService.lookupUserByName(account, request.getUserName());
        }
        ListSigningCertificatesResultType result = reply.getListSigningCertificatesResult();
        result.setIsTruncated(Boolean.valueOf(false));
        ArrayList certs = result.getCertificates().getMemberList();
        try {
            for (Certificate cert : Privileged.listSigningCertificates((AuthContext)requestUser, (Account)account, (User)userFound)) {
                SigningCertificateType c = new SigningCertificateType();
                c.setUserName(userFound.getName());
                c.setCertificateId(cert.getCertificateId());
                c.setCertificateBody(B64.url.decString((String)cert.getPem()));
                c.setStatus(cert.isActive() != false ? "Active" : "Inactive");
                c.setUploadDate(cert.getCreateDate());
                certs.add(c);
            }
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to list signing certificates for " + request.getUserName() + " by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public UploadSigningCertificateResponseType uploadSigningCertificate(UploadSigningCertificateType request) throws EucalyptusCloudException {
        UploadSigningCertificateResponseType reply = (UploadSigningCertificateResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = ctx.getUser();
        if (!Strings.isNullOrEmpty((String)request.getUserName())) {
            userFound = EuareService.lookupUserByName(account, request.getUserName());
        }
        try {
            Certificate cert = Privileged.uploadSigningCertificate((AuthContext)requestUser, (Account)account, (User)userFound, (String)request.getCertificateBody());
            SigningCertificateType result = reply.getUploadSigningCertificateResult().getCertificate();
            result.setUserName(userFound.getName());
            result.setCertificateId(cert.getCertificateId());
            result.setCertificateBody(request.getCertificateBody());
            result.setStatus("Active");
            result.setUploadDate(cert.getCreateDate());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to upload signing certificate of " + request.getUserName() + "by " + ctx.getUser().getName());
                }
                if ("Resource quota is exceeded".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "LimitExceeded", "Signing certificate limit exceeded");
                }
                if ("Conflict".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "DuplicateCertificate", "Trying to upload duplicate certificate");
                }
                if ("Invalid cert".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidCertificate", "Invalid certificate " + request.getCertificateBody());
                }
                if ("Empty certificate".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "MalformedCertificate", "Empty certificate body");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeleteUserPolicyResponseType deleteUserPolicy(DeleteUserPolicyType request) throws EucalyptusCloudException {
        DeleteUserPolicyResponseType reply = (DeleteUserPolicyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = EuareService.lookupUserByName(account, request.getUserName());
        try {
            Privileged.deleteUserPolicy((AuthContext)requestUser, (Account)account, (User)userFound, (String)request.getPolicyName());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete policy for user " + request.getUserName() + " by " + ctx.getUser().getName());
                }
                if ("Empty policy name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty policy name");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public PutUserPolicyResponseType putUserPolicy(PutUserPolicyType request) throws EucalyptusCloudException {
        PutUserPolicyResponseType reply = (PutUserPolicyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = EuareService.lookupUserByName(account, request.getUserName());
        try {
            Privileged.putUserPolicy((AuthContext)requestUser, (Account)account, (User)userFound, (String)request.getPolicyName(), (String)request.getPolicyDocument());
        }
        catch (PolicyParseException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "MalformedPolicyDocument", "Error in uploaded policy: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to put user policy for " + request.getUserName() + " by " + ctx.getUser().getName());
                }
                if ("Invalid name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Invalid policy name " + request.getPolicyName());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public ListServerCertificatesResponseType listServerCertificates(ListServerCertificatesType request) throws EucalyptusCloudException {
        ListServerCertificatesResponseType reply = (ListServerCertificatesResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        String pathPrefix = request.getPathPrefix();
        if (pathPrefix == null || pathPrefix.isEmpty()) {
            pathPrefix = "/";
        }
        try {
            List certs = Privileged.listServerCertificate((AuthContext)requestUser, (Account)account, (String)pathPrefix);
            ListServerCertificatesResultType result = new ListServerCertificatesResultType();
            ServerCertificateMetadataListTypeType lists = new ServerCertificateMetadataListTypeType();
            lists.setMemberList(new ArrayList(Collections2.transform((Collection)certs, (Function)new Function<ServerCertificate, ServerCertificateMetadataType>(){

                public ServerCertificateMetadataType apply(ServerCertificate cert) {
                    return EuareService.getServerCertificateMetadata(cert);
                }
            })));
            result.setServerCertificateMetadataList(lists);
            reply.setListServerCertificatesResult(result);
        }
        catch (AuthException ex) {
            if ("Access to the resource is denied".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to list server certificates by " + ctx.getUser().getName());
            }
            LOG.error((Object)"failed to list server certificates", (Throwable)ex);
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        catch (Exception ex) {
            LOG.error((Object)"failed to list server certificates", (Throwable)ex);
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public GetUserPolicyResponseType getUserPolicy(GetUserPolicyType request) throws EucalyptusCloudException {
        GetUserPolicyResponseType reply = (GetUserPolicyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = EuareService.lookupUserByName(account, request.getUserName());
        try {
            Policy policy = Privileged.getUserPolicy((AuthContext)requestUser, (Account)account, (User)userFound, (String)request.getPolicyName());
            if (policy == null) {
                throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Can not find policy " + request.getPolicyName());
            }
            GetUserPolicyResultType result = reply.getGetUserPolicyResult();
            result.setUserName(request.getUserName());
            result.setPolicyName(request.getPolicyName());
            result.setPolicyDocument(this.encodePolicy(policy.getText()));
        }
        catch (EuareException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get user policies for " + request.getUserName() + " by " + ctx.getUser().getName());
                }
                if ("Empty policy name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty policy name");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public UpdateLoginProfileResponseType updateLoginProfile(UpdateLoginProfileType request) throws EucalyptusCloudException {
        UpdateLoginProfileResponseType reply = (UpdateLoginProfileResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = EuareService.lookupUserByName(account, request.getUserName());
        try {
            Privileged.updateLoginProfile((AuthContext)requestUser, (Account)account, (User)userFound, (String)request.getPassword());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to update login profile of " + request.getUserName() + "by " + ctx.getUser().getName());
                }
                if ("Invalid password".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "Invalid password", "Invalid password");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public UpdateServerCertificateResponseType updateServerCertificate(UpdateServerCertificateType request) throws EucalyptusCloudException {
        UpdateServerCertificateResponseType reply = (UpdateServerCertificateResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        String certName = request.getServerCertificateName();
        if (certName == null || certName.length() <= 0) {
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Certificate name is empty");
        }
        try {
            String newCertName = request.getNewServerCertificateName();
            String newPath = request.getNewPath();
            if (newCertName != null && newCertName.length() > 0 || newPath != null && newPath.length() > 0) {
                Privileged.updateServerCertificate((AuthContext)requestUser, (Account)account, (String)certName, (String)newCertName, (String)newPath);
            }
        }
        catch (AuthException ex) {
            if ("Access to the resource is denied".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to update server certificates by " + ctx.getUser().getName());
            }
            if ("No server certificate with the requested name exist".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Server certificate " + certName + " does not exist");
            }
            if ("Server certificate with the same name already exists".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "Server certificate " + request.getNewServerCertificateName() + " already exists.");
            }
            LOG.error((Object)"failed to update server certificate", (Throwable)ex);
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        catch (Exception ex) {
            LOG.error((Object)"failed to update server certificate", (Throwable)ex);
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public UpdateUserResponseType updateUser(UpdateUserType request) throws EucalyptusCloudException {
        UpdateUserResponseType reply = (UpdateUserResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = EuareService.lookupUserByName(account, request.getUserName());
        try {
            Boolean enabled = request.getEnabled() != null ? Boolean.valueOf("true".equalsIgnoreCase(request.getEnabled())) : null;
            Long passwordExpiration = request.getPasswordExpiration() != null ? Long.valueOf(Iso8601DateParser.parse((String)request.getPasswordExpiration()).getTime()) : null;
            Privileged.modifyUser((AuthContext)requestUser, (Account)account, (User)userFound, (String)request.getNewUserName(), (String)request.getNewPath(), (Boolean)enabled, (Long)passwordExpiration, null);
            if (request.getRegStatus() != null) {
                userFound.setRegistrationStatus(EuareService.parseRegStatIgnoreCase(request.getRegStatus()));
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidValue", "Invalid registration status " + request.getRegStatus());
        }
        catch (ParseException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidValue", "Invalid password expiration " + request.getPasswordExpiration());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to update user by " + ctx.getUser().getName());
                }
                if ("User already exists".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "User name " + request.getNewUserName() + " already exists.");
                }
                if ("Invalid name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Invalid new name " + request.getNewUserName());
                }
                if ("Invalid path".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidPath", "Invalid new path " + request.getNewPath());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeleteLoginProfileResponseType deleteLoginProfile(DeleteLoginProfileType request) throws EucalyptusCloudException {
        DeleteLoginProfileResponseType reply = (DeleteLoginProfileResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = EuareService.lookupUserByName(account, request.getUserName());
        try {
            Privileged.deleteLoginProfile((AuthContext)requestUser, (Account)account, (User)userFound);
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete login profile for " + request.getUserName() + " by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public UpdateSigningCertificateResponseType updateSigningCertificate(UpdateSigningCertificateType request) throws EucalyptusCloudException {
        UpdateSigningCertificateResponseType reply = (UpdateSigningCertificateResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = ctx.getUser();
        if (!Strings.isNullOrEmpty((String)request.getUserName())) {
            userFound = EuareService.lookupUserByName(account, request.getUserName());
        }
        try {
            Privileged.modifySigningCertificate((AuthContext)requestUser, (Account)account, (User)userFound, (String)request.getCertificateId(), (String)request.getStatus());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to update signing certificate of " + request.getUserName() + "by " + ctx.getUser().getName());
                }
                if ("No such certificate".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Can not find the certificate " + request.getCertificateId());
                }
                if ("Empty status".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidValue", "Empty status");
                }
                if ("Empty certificate id".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidId", "Empty certificate id");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeleteGroupPolicyResponseType deleteGroupPolicy(DeleteGroupPolicyType request) throws EucalyptusCloudException {
        DeleteGroupPolicyResponseType reply = (DeleteGroupPolicyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Group groupFound = EuareService.lookupGroupByName(account, request.getGroupName());
        try {
            Privileged.deleteGroupPolicy((AuthContext)requestUser, (Account)account, (Group)groupFound, (String)request.getPolicyName());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete group policy of " + request.getGroupName() + " by " + ctx.getUser().getName());
                }
                if ("Empty policy name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty policy name");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public ListUsersResponseType listUsers(ListUsersType request) throws EucalyptusCloudException {
        ListUsersResponseType reply = (ListUsersResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        String path = "/";
        if (!Strings.isNullOrEmpty((String)request.getPathPrefix())) {
            path = request.getPathPrefix();
        }
        if (!Permissions.perhapsAuthorized((String)"iam", (String)"listusers", (AuthContextSupplier)ctx.getAuthContext())) {
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to list users");
        }
        ListUsersResultType result = reply.getListUsersResult();
        result.setIsTruncated(Boolean.valueOf(false));
        ArrayList users = reply.getListUsersResult().getUsers().getMemberList();
        try {
            for (User user : account.getUsers()) {
                if (!user.getPath().startsWith(path) || !Privileged.allowListUser((AuthContext)requestUser, (Account)account, (User)user)) continue;
                UserType u = new UserType();
                this.fillUserResult(u, user, account);
                users.add(u);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public UpdateGroupResponseType updateGroup(UpdateGroupType request) throws EucalyptusCloudException {
        UpdateGroupResponseType reply = (UpdateGroupResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Group groupFound = EuareService.lookupGroupByName(account, request.getGroupName());
        try {
            Privileged.modifyGroup((AuthContext)requestUser, (Account)account, (Group)groupFound, (String)request.getNewGroupName(), (String)request.getNewPath());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to update group " + groupFound.getName() + " by " + ctx.getUser().getName());
                }
                if ("Group already exists".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "Group name " + request.getNewGroupName() + " already exists.");
                }
                if ("Invalid name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Invalid new name " + request.getNewGroupName());
                }
                if ("Invalid path".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidPath", "Invalid new path " + request.getNewPath());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public GetServerCertificateResponseType getServerCertificate(GetServerCertificateType request) throws EucalyptusCloudException {
        GetServerCertificateResponseType reply = (GetServerCertificateResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        String certName = request.getServerCertificateName();
        if (certName == null || certName.length() <= 0) {
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Certificate name is empty");
        }
        try {
            ServerCertificate cert = Privileged.getServerCertificate((AuthContext)requestUser, (Account)account, (String)certName);
            GetServerCertificateResultType result = new GetServerCertificateResultType();
            ServerCertificateType certType = new ServerCertificateType();
            certType.setCertificateBody(cert.getCertificateBody());
            certType.setCertificateChain(cert.getCertificateChain());
            certType.setServerCertificateMetadata(EuareService.getServerCertificateMetadata(cert));
            result.setServerCertificate(certType);
            reply.setGetServerCertificateResult(result);
        }
        catch (AuthException ex) {
            if ("Access to the resource is denied".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get server certificate by " + ctx.getUser().getName());
            }
            if ("No server certificate with the requested name exist".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Server certificate " + certName + " does not exist");
            }
            LOG.error((Object)"failed to get server certificate", (Throwable)ex);
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        catch (Exception ex) {
            LOG.error((Object)"failed to get server certificate", (Throwable)ex);
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public PutGroupPolicyResponseType putGroupPolicy(PutGroupPolicyType request) throws EucalyptusCloudException {
        PutGroupPolicyResponseType reply = (PutGroupPolicyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Group groupFound = EuareService.lookupGroupByName(account, request.getGroupName());
        try {
            Privileged.putGroupPolicy((AuthContext)requestUser, (Account)account, (Group)groupFound, (String)request.getPolicyName(), (String)request.getPolicyDocument());
        }
        catch (PolicyParseException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "MalformedPolicyDocument", "Error in uploaded policy: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to put group policy for " + groupFound.getName() + " by " + ctx.getUser().getName());
                }
                if ("Invalid name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Invalid policy name " + request.getPolicyName());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public CreateUserResponseType createUser(CreateUserType request) throws EucalyptusCloudException {
        CreateUserResponseType reply = (CreateUserResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        try {
            User newUser = Privileged.createUser((AuthContext)requestUser, (Account)account, (String)request.getUserName(), (String)EuareService.sanitizePath(request.getPath()));
            UserType u = reply.getCreateUserResult().getUser();
            this.fillUserResult(u, newUser, account);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to create user by " + ctx.getUser().getName());
                }
                if ("Resource quota is exceeded".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "LimitExceeded", "User quota exceeded");
                }
                if ("User already exists".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "User " + request.getUserName() + " already exists.");
                }
                if ("Invalid name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Invalid user name " + request.getUserName());
                }
                if ("Invalid path".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidPath", "Invalid user path " + request.getPath());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeleteSigningCertificateResponseType deleteSigningCertificate(DeleteSigningCertificateType request) throws EucalyptusCloudException {
        DeleteSigningCertificateResponseType reply = (DeleteSigningCertificateResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = ctx.getUser();
        if (!Strings.isNullOrEmpty((String)request.getUserName())) {
            userFound = EuareService.lookupUserByName(account, request.getUserName());
        }
        try {
            Privileged.deleteSigningCertificate((AuthContext)requestUser, (Account)account, (User)userFound, (String)request.getCertificateId());
            return reply;
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete cert for user " + request.getUserName() + " by " + ctx.getUser().getName());
                }
                if ("Empty certificate id".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidId", "Empty certificate id");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    public EnableMFADeviceResponseType enableMFADevice(EnableMFADeviceType request) throws EucalyptusCloudException {
        throw new EuareException(HttpResponseStatus.BAD_REQUEST, "NotImplemented", "Operation not implemented");
    }

    public ListUserPoliciesResponseType listUserPolicies(ListUserPoliciesType request) throws EucalyptusCloudException {
        ListUserPoliciesResponseType reply = (ListUserPoliciesResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = EuareService.lookupUserByName(account, request.getUserName());
        ListUserPoliciesResultType result = reply.getListUserPoliciesResult();
        result.setIsTruncated(Boolean.valueOf(false));
        ArrayList policies = result.getPolicyNames().getMemberList();
        try {
            for (Policy p : Privileged.listUserPolicies((AuthContext)requestUser, (Account)account, (User)userFound)) {
                policies.add(p.getName());
            }
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to list user policies for " + request.getUserName() + " by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public ListAccessKeysResponseType listAccessKeys(ListAccessKeysType request) throws EucalyptusCloudException {
        ListAccessKeysResponseType reply = (ListAccessKeysResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = ctx.getUser();
        if (!Strings.isNullOrEmpty((String)request.getUserName())) {
            userFound = EuareService.lookupUserByName(account, request.getUserName());
        }
        ListAccessKeysResultType result = reply.getListAccessKeysResult();
        try {
            result.setIsTruncated(Boolean.valueOf(false));
            ArrayList keys = result.getAccessKeyMetadata().getMemberList();
            for (AccessKey k : Privileged.listAccessKeys((AuthContext)requestUser, (Account)account, (User)userFound)) {
                AccessKeyMetadataType key = new AccessKeyMetadataType();
                key.setUserName(userFound.getName());
                key.setAccessKeyId(k.getAccessKey());
                key.setStatus(k.isActive() != false ? "Active" : "Inactive");
                keys.add(key);
            }
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to list access keys for " + request.getUserName() + " by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public GetLoginProfileResponseType getLoginProfile(GetLoginProfileType request) throws EucalyptusCloudException {
        GetLoginProfileResponseType reply = (GetLoginProfileResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = EuareService.lookupUserByName(account, request.getUserName());
        if (userFound.getPassword() == null) {
            throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Can not find login profile for " + request.getUserName());
        }
        try {
            if (!Privileged.allowReadLoginProfile((AuthContext)requestUser, (Account)account, (User)userFound)) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get login profile for " + request.getUserName() + " by " + ctx.getUser().getName());
            }
            reply.getGetLoginProfileResult().getLoginProfile().setUserName(request.getUserName());
            return reply;
        }
        catch (EuareException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    public ListGroupsForUserResponseType listGroupsForUser(ListGroupsForUserType request) throws EucalyptusCloudException {
        ListGroupsForUserResponseType reply = (ListGroupsForUserResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = EuareService.lookupUserByName(account, request.getUserName());
        reply.getListGroupsForUserResult().setIsTruncated(Boolean.valueOf(false));
        ArrayList groups = reply.getListGroupsForUserResult().getGroups().getMemberList();
        try {
            for (Group group : Privileged.listGroupsForUser((AuthContext)requestUser, (Account)account, (User)userFound)) {
                GroupType g = new GroupType();
                this.fillGroupResult(g, group, account);
                groups.add(g);
            }
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get user groups for " + request.getUserName() + " by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public CreateGroupResponseType createGroup(CreateGroupType request) throws EucalyptusCloudException {
        CreateGroupResponseType reply = (CreateGroupResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        try {
            Group newGroup = Privileged.createGroup((AuthContext)requestUser, (Account)account, (String)request.getGroupName(), (String)EuareService.sanitizePath(request.getPath()));
            GroupType g = reply.getCreateGroupResult().getGroup();
            this.fillGroupResult(g, newGroup, account);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to create group by " + ctx.getUser().getName());
                }
                if ("Resource quota is exceeded".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "LimitExceeded", "Group quota exceeded");
                }
                if ("Group already exists".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "Group " + request.getGroupName() + " already exists.");
                }
                if ("Invalid name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Invalid group name " + request.getGroupName());
                }
                if ("Invalid path".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidPath", "Invalid group path " + request.getPath());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public UploadServerCertificateResponseType uploadServerCertificate(UploadServerCertificateType request) throws EucalyptusCloudException {
        UploadServerCertificateResponseType reply = (UploadServerCertificateResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        String pemCertBody = request.getCertificateBody();
        String pemCertChain = request.getCertificateChain();
        String path = (String)Objects.firstNonNull((Object)request.getPath(), (Object)"/");
        String certName = request.getServerCertificateName();
        String pemPk = request.getPrivateKey();
        try {
            Privileged.createServerCertificate((AuthContext)requestUser, (Account)account, (String)pemCertBody, (String)pemCertChain, (String)path, (String)certName, (String)pemPk);
        }
        catch (AuthException ex) {
            if ("Access to the resource is denied".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to upload server certificate by " + ctx.getUser().getName());
            }
            if ("Server certificate with the same name already exists".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "Server certificate " + certName + " already exists.");
            }
            if ("Server certificate name is invalid".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Server certificate name " + certName + " is invalid format.");
            }
            if ("Server certificate path is invalid".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidPath", "Path " + path + " is invalid.");
            }
            if ("Resource quota is exceeded".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.CONFLICT, "LimitExceeded", "Server certificate quota exceeded");
            }
            if ("Server certificate/private-key is malformed".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.BAD_REQUEST, "MalformedCertificate", "Server certificate is malformed");
            }
            LOG.error((Object)"Failed to create server certificate", (Throwable)ex);
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to create server certificate", (Throwable)ex);
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        try {
            UploadServerCertificateResultType result = new UploadServerCertificateResultType();
            ServerCertificateMetadataType metadata = EuareService.getServerCertificateMetadata(ctx.getAccount().lookupServerCertificate(certName));
            result.setServerCertificateMetadata(metadata);
            reply.setUploadServerCertificateResult(result);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to set certificate metadata", (Throwable)ex);
        }
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public GetGroupPolicyResponseType getGroupPolicy(GetGroupPolicyType request) throws EucalyptusCloudException {
        GetGroupPolicyResponseType reply = (GetGroupPolicyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Group groupFound = EuareService.lookupGroupByName(account, request.getGroupName());
        try {
            Policy policy = Privileged.getGroupPolicy((AuthContext)requestUser, (Account)account, (Group)groupFound, (String)request.getPolicyName());
            if (policy == null) {
                throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Can not find policy " + request.getPolicyName());
            }
            GetGroupPolicyResultType result = reply.getGetGroupPolicyResult();
            result.setGroupName(request.getGroupName());
            result.setPolicyName(request.getPolicyName());
            result.setPolicyDocument(this.encodePolicy(policy.getText()));
        }
        catch (EuareException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get group policy for " + request.getGroupName() + " by " + ctx.getUser().getName());
                }
                if ("Empty policy name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty policy name");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeleteUserResponseType deleteUser(DeleteUserType request) throws EucalyptusCloudException {
        DeleteUserResponseType reply = (DeleteUserResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userToDelete = EuareService.lookupUserByName(account, request.getUserName());
        try {
            boolean recursive = request.getIsRecursive() != null && request.getIsRecursive() != false;
            Privileged.deleteUser((AuthContext)requestUser, (Account)account, (User)userToDelete, (boolean)recursive);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete user by " + ctx.getUser().getName());
                }
                if ("User has resources attached and can not be deleted".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "DeleteConflict", "Attempted to delete a user with resource attached by " + ctx.getUser().getName());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeactivateMFADeviceResponseType deactivateMFADevice(DeactivateMFADeviceType request) throws EucalyptusCloudException {
        throw new EuareException(HttpResponseStatus.BAD_REQUEST, "NotImplemented", "Operation not implemented");
    }

    public RemoveUserFromGroupResponseType removeUserFromGroup(RemoveUserFromGroupType request) throws EucalyptusCloudException {
        RemoveUserFromGroupResponseType reply = (RemoveUserFromGroupResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = EuareService.lookupUserByName(account, request.getUserName());
        Group groupFound = EuareService.lookupGroupByName(account, request.getGroupName());
        try {
            Privileged.removeUserFromGroup((AuthContext)requestUser, (Account)account, (User)userFound, (Group)groupFound);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to remove user from group by " + ctx.getUser().getName());
                }
                if ("No such user".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "NoSuchEntity", "User " + request.getUserName() + " is not in the group " + request.getGroupName());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeleteServerCertificateResponseType deleteServerCertificate(DeleteServerCertificateType request) throws EucalyptusCloudException {
        DeleteServerCertificateResponseType reply = (DeleteServerCertificateResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        String certName = request.getServerCertificateName();
        if (certName == null || certName.length() <= 0) {
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Certificate name is empty");
        }
        try {
            Privileged.deleteServerCertificate((AuthContext)requestUser, (Account)account, (String)certName);
        }
        catch (AuthException ex) {
            if ("Access to the resource is denied".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete server certificates by " + ctx.getUser().getName());
            }
            if ("No server certificate with the requested name exist".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Server ceritifcate " + certName + " does not exist");
            }
            if ("Server certificate is attached to subordinate entities".equals(ex.getMessage())) {
                throw new EuareException(HttpResponseStatus.CONFLICT, "DeleteConflict", "Server certificate " + certName + " is in use");
            }
            LOG.error((Object)"failed to delete server certificate", (Throwable)ex);
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        catch (Exception ex) {
            LOG.error((Object)"failed to delete server certificate", (Throwable)ex);
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public ListGroupPoliciesResponseType listGroupPolicies(ListGroupPoliciesType request) throws EucalyptusCloudException {
        ListGroupPoliciesResponseType reply = (ListGroupPoliciesResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Group groupFound = EuareService.lookupGroupByName(account, request.getGroupName());
        ListGroupPoliciesResultType result = reply.getListGroupPoliciesResult();
        result.setIsTruncated(Boolean.valueOf(false));
        ArrayList policies = result.getPolicyNames().getMemberList();
        try {
            for (Policy p : Privileged.listGroupPolicies((AuthContext)requestUser, (Account)account, (Group)groupFound)) {
                policies.add(p.getName());
            }
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to list group polices for " + request.getGroupName() + " by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public CreateLoginProfileResponseType createLoginProfile(CreateLoginProfileType request) throws EucalyptusCloudException {
        CreateLoginProfileResponseType reply = (CreateLoginProfileResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = EuareService.lookupUserByName(account, request.getUserName());
        if (userFound.getPassword() != null) {
            throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "User " + userFound.getName() + " already has a login profile");
        }
        try {
            Privileged.createLoginProfile((AuthContext)requestUser, (Account)account, (User)userFound, (String)request.getPassword());
            reply.getCreateLoginProfileResult().getLoginProfile().setUserName(ctx.getUser().getName());
            return reply;
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to create login profile for " + request.getUserName() + " by " + ctx.getUser().getName());
                }
                if ("Invalid password".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "Invalid password", "Invalid password");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    public CreateAccessKeyResponseType createAccessKey(CreateAccessKeyType request) throws EucalyptusCloudException {
        CreateAccessKeyResponseType reply = (CreateAccessKeyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = ctx.getUser();
        if (!Strings.isNullOrEmpty((String)request.getUserName())) {
            userFound = EuareService.lookupUserByName(account, request.getUserName());
        }
        try {
            AccessKey key = Privileged.createAccessKey((AuthContext)requestUser, (Account)account, (User)userFound);
            AccessKeyType keyResult = reply.getCreateAccessKeyResult().getAccessKey();
            keyResult.setAccessKeyId(key.getAccessKey());
            keyResult.setCreateDate(key.getCreateDate());
            keyResult.setSecretAccessKey(key.getSecretKey());
            keyResult.setStatus(key.isActive() != false ? "Active" : "Inactive");
            keyResult.setUserName(userFound.getName());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to create access key for user " + request.getUserName() + " by " + ctx.getUser().getName());
                }
                if ("Resource quota is exceeded".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "LimitExceeded", "Access key limit exceeded");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public GetUserResponseType getUser(GetUserType request) throws EucalyptusCloudException {
        GetUserResponseType reply = (GetUserResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = ctx.getUser();
        if (!Strings.isNullOrEmpty((String)request.getUserName())) {
            userFound = EuareService.lookupUserByName(account, request.getUserName());
        }
        try {
            if (!Privileged.allowReadUser((AuthContext)requestUser, (Account)account, (User)userFound)) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get user by " + ctx.getUser().getName());
            }
            UserType u = reply.getGetUserResult().getUser();
            this.fillUserResult(u, userFound, account);
            if (request.getShowExtra() != null && request.getShowExtra().booleanValue()) {
                this.fillUserResultExtra(u, userFound);
            }
            return reply;
        }
        catch (EuareException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    public ResyncMFADeviceResponseType resyncMFADevice(ResyncMFADeviceType request) throws EucalyptusCloudException {
        throw new EuareException(HttpResponseStatus.BAD_REQUEST, "NotImplemented", "Operation not implemented");
    }

    public ListMFADevicesResponseType listMFADevices(ListMFADevicesType request) throws EucalyptusCloudException {
        throw new EuareException(HttpResponseStatus.BAD_REQUEST, "NotImplemented", "Operation not implemented");
    }

    public UpdateAccessKeyResponseType updateAccessKey(UpdateAccessKeyType request) throws EucalyptusCloudException {
        UpdateAccessKeyResponseType reply = (UpdateAccessKeyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = ctx.getUser();
        if (!Strings.isNullOrEmpty((String)request.getUserName())) {
            userFound = EuareService.lookupUserByName(account, request.getUserName());
        }
        try {
            Privileged.modifyAccessKey((AuthContext)requestUser, (Account)account, (User)userFound, (String)request.getAccessKeyId(), (String)request.getStatus());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to update access key of " + request.getUserName() + "by " + ctx.getUser().getName());
                }
                if ("Empty access key id".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidId", "Empty access key id");
                }
                if ("Empty status".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidValue", "Empty status");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public AddUserToGroupResponseType addUserToGroup(AddUserToGroupType request) throws EucalyptusCloudException {
        AddUserToGroupResponseType reply = (AddUserToGroupResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = EuareService.lookupUserByName(account, request.getUserName());
        Group groupFound = EuareService.lookupGroupByName(account, request.getGroupName());
        try {
            Privileged.addUserToGroup((AuthContext)requestUser, (Account)account, (User)userFound, (Group)groupFound);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to add user to group by " + ctx.getUser().getName());
                }
                if ("Conflict".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "User " + request.getUserName() + " is already in the group " + request.getGroupName());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public GetGroupResponseType getGroup(GetGroupType request) throws EucalyptusCloudException {
        GetGroupResponseType reply = (GetGroupResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Group groupFound = EuareService.lookupGroupByName(account, request.getGroupName());
        try {
            if (!Privileged.allowReadGroup((AuthContext)requestUser, (Account)account, (Group)groupFound)) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get group " + request.getGroupName() + " by " + ctx.getUser().getName());
            }
            reply.getGetGroupResult().setIsTruncated(Boolean.valueOf(false));
            GroupType g = reply.getGetGroupResult().getGroup();
            this.fillGroupResult(g, groupFound, account);
            ArrayList users = reply.getGetGroupResult().getUsers().getMemberList();
            for (User user : groupFound.getUsers()) {
                UserType u = new UserType();
                this.fillUserResult(u, user, account);
                users.add(u);
            }
        }
        catch (EuareException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeleteGroupResponseType deleteGroup(DeleteGroupType request) throws EucalyptusCloudException {
        DeleteGroupResponseType reply = (DeleteGroupResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Group groupFound = EuareService.lookupGroupByName(account, request.getGroupName());
        try {
            boolean recursive = request.getIsRecursive() != null && request.getIsRecursive() != false;
            Privileged.deleteGroup((AuthContext)requestUser, (Account)account, (Group)groupFound, (boolean)recursive);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete group by " + ctx.getUser().getName());
                }
                if ("Group has resources attached and can not be deleted".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "DeleteConflict", "Attempted to delete group with resources attached by " + ctx.getUser().getName());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public CreateAccountAliasResponseType createAccountAlias(CreateAccountAliasType request) throws EucalyptusCloudException {
        CreateAccountAliasResponseType reply = (CreateAccountAliasResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        try {
            Privileged.modifyAccount((AuthContext)requestUser, (Account)account, (String)request.getAccountAlias());
            return reply;
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to create account alias by " + ctx.getUser().getName());
                }
                if ("Conflict".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "Can not change to a name already in use: " + request.getAccountAlias());
                }
                if ("Account already exists".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "Account alias " + request.getAccountAlias() + " already exists.");
                }
                if ("Invalid name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Invalid account alias " + request.getAccountAlias());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    public DeleteAccountAliasResponseType deleteAccountAlias(DeleteAccountAliasType request) throws EucalyptusCloudException {
        DeleteAccountAliasResponseType reply = (DeleteAccountAliasResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        try {
            Privileged.deleteAccountAlias((AuthContext)requestUser, (Account)account, (String)request.getAccountAlias());
            return reply;
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete account alias by " + ctx.getUser().getName());
                }
                if ("Empty account name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidValue", "Empty account alias");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    public ListAccountAliasesResponseType listAccountAliases(ListAccountAliasesType request) throws EucalyptusCloudException {
        ListAccountAliasesResponseType reply = (ListAccountAliasesResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        try {
            reply.getListAccountAliasesResult().getAccountAliases().getMemberList().addAll(Privileged.listAccountAliases((AuthContext)requestUser, (Account)account));
            return reply;
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to list account aliases by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    public GetAccountSummaryResponseType getAccountSummary(GetAccountSummaryType request) throws EucalyptusCloudException {
        GetAccountSummaryResponseType reply = (GetAccountSummaryResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        try {
            account = Privileged.getAccountSummary((AuthContext)requestUser, (Account)account);
            ArrayList map = reply.getGetAccountSummaryResult().getSummaryMap().getEntryList();
            map.add(new SummaryMapTypeEntryType("Groups", Integer.valueOf(account.getGroups().size())));
            map.add(new SummaryMapTypeEntryType("Users", Integer.valueOf(account.getUsers().size())));
            map.add(new SummaryMapTypeEntryType("Roles", Integer.valueOf(account.getRoles().size())));
            map.add(new SummaryMapTypeEntryType("InstanceProfiles", Integer.valueOf(account.getInstanceProfiles().size())));
            map.add(new SummaryMapTypeEntryType("ServerCertificates", Integer.valueOf(account.listServerCertificates("/").size())));
            return reply;
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get account summary by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    public CreateSigningCertificateResponseType createSigningCertificate(CreateSigningCertificateType request) throws EucalyptusCloudException {
        CreateSigningCertificateResponseType reply = (CreateSigningCertificateResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = ctx.getUser();
        if (!Strings.isNullOrEmpty((String)request.getUserName())) {
            userFound = EuareService.lookupUserByName(account, request.getUserName());
        }
        try {
            KeyPair keyPair = Certs.generateKeyPair();
            Certificate cert = Privileged.createSigningCertificate((AuthContext)requestUser, (Account)account, (User)userFound, (KeyPair)keyPair);
            SigningCertificateType result = reply.getCreateSigningCertificateResult().getCertificate();
            result.setUserName(userFound.getName());
            result.setCertificateId(cert.getCertificateId());
            result.setCertificateBody(B64.url.decString((String)cert.getPem()));
            result.setPrivateKey(X509CertHelper.privateKeyToPem((PrivateKey)keyPair.getPrivate()));
            result.setStatus("Active");
            result.setUploadDate(cert.getCreateDate());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to create signing certificate of " + request.getUserName() + "by " + ctx.getUser().getName());
                }
                if ("Resource quota is exceeded".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "LimitExceeded", "Signing certificate limit exceeded");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public GetUserInfoResponseType getUserInfo(GetUserInfoType request) throws EucalyptusCloudException {
        GetUserInfoResponseType reply = (GetUserInfoResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = ctx.getUser();
        if (!Strings.isNullOrEmpty((String)request.getUserName())) {
            userFound = EuareService.lookupUserByName(account, request.getUserName());
        }
        try {
            if (!Privileged.allowReadUser((AuthContext)requestUser, (Account)account, (User)userFound)) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get user info by " + ctx.getUser().getName());
            }
            ArrayList infos = reply.getGetUserInfoResult().getInfos().getMemberList();
            if (!Strings.isNullOrEmpty((String)request.getInfoKey())) {
                String value = userFound.getInfo(request.getInfoKey());
                if (value != null) {
                    UserInfoType ui = new UserInfoType();
                    ui.setKey(request.getInfoKey().toLowerCase());
                    ui.setValue(value);
                    infos.add(ui);
                }
            } else {
                for (Map.Entry entry : userFound.getInfo().entrySet()) {
                    UserInfoType ui = new UserInfoType();
                    ui.setKey((String)entry.getKey());
                    ui.setValue((String)entry.getValue());
                    infos.add(ui);
                }
            }
        }
        catch (EuareException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public UpdateUserInfoResponseType updateUserInfo(UpdateUserInfoType request) throws EucalyptusCloudException {
        UpdateUserInfoResponseType reply = (UpdateUserInfoResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        User userFound = EuareService.lookupUserByName(account, request.getUserName());
        if (Strings.isNullOrEmpty((String)request.getInfoKey())) {
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty key name");
        }
        try {
            Privileged.updateUserInfoItem((AuthContext)requestUser, (Account)account, (User)userFound, (String)request.getInfoKey(), (String)request.getInfoValue());
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get user by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public PutAccountPolicyResponseType putAccountPolicy(PutAccountPolicyType request) throws EucalyptusCloudException {
        PutAccountPolicyResponseType reply = (PutAccountPolicyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account accountFound = EuareService.lookupAccountByName(request.getAccountName());
        try {
            Privileged.putAccountPolicy((AuthContext)requestUser, (Account)accountFound, (String)request.getPolicyName(), (String)request.getPolicyDocument());
        }
        catch (PolicyParseException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "MalformedPolicyDocument", "Error in uploaded policy: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to put account policy for " + accountFound.getName() + " by " + ctx.getUser().getName());
                }
                if ("Invalid name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Invalid policy name " + request.getPolicyName());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public ListAccountPoliciesResponseType listAccountPolicies(ListAccountPoliciesType request) throws EucalyptusCloudException {
        ListAccountPoliciesResponseType reply = (ListAccountPoliciesResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account accountFound = EuareService.lookupAccountByName(request.getAccountName());
        ListAccountPoliciesResultType result = reply.getListAccountPoliciesResult();
        result.setIsTruncated(Boolean.valueOf(false));
        ArrayList policies = result.getPolicyNames().getMemberList();
        try {
            for (Policy p : Privileged.listAccountPolicies((AuthContext)requestUser, (Account)accountFound)) {
                policies.add(p.getName());
            }
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to list account policies for " + accountFound.getName() + " by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public GetAccountPolicyResponseType getAccountPolicy(GetAccountPolicyType request) throws EucalyptusCloudException {
        GetAccountPolicyResponseType reply = (GetAccountPolicyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account accountFound = EuareService.lookupAccountByName(request.getAccountName());
        try {
            Policy policy = Privileged.getAccountPolicy((AuthContext)requestUser, (Account)accountFound, (String)request.getPolicyName());
            if (policy == null) {
                throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Can not find policy " + request.getPolicyName());
            }
            GetAccountPolicyResultType result = reply.getGetAccountPolicyResult();
            result.setAccountName(request.getAccountName());
            result.setPolicyName(request.getPolicyName());
            result.setPolicyDocument(this.encodePolicy(policy.getText()));
        }
        catch (EuareException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to put account policy for " + accountFound.getName() + " by " + ctx.getUser().getName());
                }
                if ("Empty policy name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty policy name");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeleteAccountPolicyResponseType deleteAccountPolicy(DeleteAccountPolicyType request) throws EucalyptusCloudException {
        DeleteAccountPolicyResponseType reply = (DeleteAccountPolicyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account accountFound = EuareService.lookupAccountByName(request.getAccountName());
        try {
            Privileged.deleteAccountPolicy((AuthContext)requestUser, (Account)accountFound, (String)request.getPolicyName());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete account policy for " + accountFound.getName() + " by " + ctx.getUser().getName());
                }
                if ("Empty policy name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty policy name");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public CreateRoleResponseType createRole(CreateRoleType request) throws EucalyptusCloudException {
        CreateRoleResponseType reply = (CreateRoleResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        try {
            Role newRole = Privileged.createRole((AuthContext)requestUser, (Account)account, (String)request.getRoleName(), (String)EuareService.sanitizePath(request.getPath()), (String)request.getAssumeRolePolicyDocument());
            reply.getCreateRoleResult().setRole(this.fillRoleResult(new RoleType(), newRole));
        }
        catch (PolicyParseException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "MalformedPolicyDocument", "Error in uploaded policy: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to create role by " + ctx.getUser().getName());
                }
                if ("Resource quota is exceeded".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "LimitExceeded", "Role quota exceeded");
                }
                if ("Role already exists".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "Role " + request.getRoleName() + " already exists.");
                }
                if ("Invalid name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Invalid role name " + request.getRoleName());
                }
                if ("Invalid path".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidPath", "Invalid role path " + request.getPath());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public UpdateAssumeRolePolicyResponseType updateAssumeRolePolicy(UpdateAssumeRolePolicyType request) throws EucalyptusCloudException {
        UpdateAssumeRolePolicyResponseType reply = (UpdateAssumeRolePolicyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Role roleFound = EuareService.lookupRoleByName(account, request.getRoleName());
        try {
            Privileged.updateAssumeRolePolicy((AuthContext)requestUser, (Account)account, (Role)roleFound, (String)request.getPolicyDocument());
        }
        catch (PolicyParseException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "MalformedPolicyDocument", "Error in uploaded policy: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to update role " + roleFound.getName() + " by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public GetRoleResponseType getRole(GetRoleType request) throws EucalyptusCloudException {
        GetRoleResponseType reply = (GetRoleResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Role roleFound = EuareService.lookupRoleByName(account, request.getRoleName());
        try {
            if (!Privileged.allowReadRole((AuthContext)requestUser, (Account)account, (Role)roleFound)) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get role " + request.getRoleName() + " by " + ctx.getUser().getName());
            }
            reply.getGetRoleResult().setRole(this.fillRoleResult(new RoleType(), roleFound));
        }
        catch (EuareException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeleteRoleResponseType deleteRole(DeleteRoleType request) throws EucalyptusCloudException {
        DeleteRoleResponseType reply = (DeleteRoleResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Role roleFound = EuareService.lookupRoleByName(account, request.getRoleName());
        try {
            Privileged.deleteRole((AuthContext)requestUser, (Account)account, (Role)roleFound);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete role by " + ctx.getUser().getName());
                }
                if ("Role has resources attached and can not be deleted".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "DeleteConflict", "Attempted to delete role with resources attached by " + ctx.getUser().getName());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public ListRolesResponseType listRoles(ListRolesType request) throws EucalyptusCloudException {
        ListRolesResponseType reply = (ListRolesResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        String path = "/";
        if (!Strings.isNullOrEmpty((String)request.getPathPrefix())) {
            path = request.getPathPrefix();
        }
        if (!Permissions.perhapsAuthorized((String)"iam", (String)"listroles", (AuthContextSupplier)ctx.getAuthContext())) {
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to list roles");
        }
        reply.getListRolesResult().setIsTruncated(Boolean.valueOf(false));
        ArrayList roles = reply.getListRolesResult().getRoles().getMember();
        try {
            for (Role role : account.getRoles()) {
                if (!role.getPath().startsWith(path) || !Privileged.allowListRole((AuthContext)requestUser, (Account)account, (Role)role)) continue;
                roles.add(this.fillRoleResult(new RoleType(), role));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public PutRolePolicyResponseType putRolePolicy(PutRolePolicyType request) throws EucalyptusCloudException {
        PutRolePolicyResponseType reply = (PutRolePolicyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Role roleFound = EuareService.lookupRoleByName(account, request.getRoleName());
        try {
            Privileged.putRolePolicy((AuthContext)requestUser, (Account)account, (Role)roleFound, (String)request.getPolicyName(), (String)request.getPolicyDocument());
        }
        catch (PolicyParseException e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "MalformedPolicyDocument", "Error in uploaded policy: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to put role policy for " + roleFound.getName() + " by " + ctx.getUser().getName());
                }
                if ("Invalid name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Invalid policy name " + request.getPolicyName());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public GetRolePolicyResponseType getRolePolicy(GetRolePolicyType request) throws EucalyptusCloudException {
        GetRolePolicyResponseType reply = (GetRolePolicyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Role roleFound = EuareService.lookupRoleByName(account, request.getRoleName());
        try {
            Policy policy = Privileged.getRolePolicy((AuthContext)requestUser, (Account)account, (Role)roleFound, (String)request.getPolicyName());
            if (policy == null) {
                throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Can not find policy " + request.getPolicyName());
            }
            GetRolePolicyResult result = reply.getGetRolePolicyResult();
            result.setRoleName(request.getRoleName());
            result.setPolicyName(request.getPolicyName());
            result.setPolicyDocument(this.encodePolicy(policy.getText()));
        }
        catch (EuareException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get role policy for " + request.getRoleName() + " by " + ctx.getUser().getName());
                }
                if ("Empty policy name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty policy name");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeleteRolePolicyResponseType deleteRolePolicy(DeleteRolePolicyType request) throws EucalyptusCloudException {
        DeleteRolePolicyResponseType reply = (DeleteRolePolicyResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Role roleFound = EuareService.lookupRoleByName(account, request.getRoleName());
        try {
            Privileged.deleteRolePolicy((AuthContext)requestUser, (Account)account, (Role)roleFound, (String)request.getPolicyName());
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete role policy of " + request.getRoleName() + " by " + ctx.getUser().getName());
                }
                if ("Empty policy name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty policy name");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public ListRolePoliciesResponseType listRolePolicies(ListRolePoliciesType request) throws EucalyptusCloudException {
        ListRolePoliciesResponseType reply = (ListRolePoliciesResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Role roleFound = EuareService.lookupRoleByName(account, request.getRoleName());
        ListRolePoliciesResult result = reply.getListRolePoliciesResult();
        result.setIsTruncated(Boolean.valueOf(false));
        ArrayList policies = result.getPolicyNames().getMemberList();
        try {
            for (Policy p : Privileged.listRolePolicies((AuthContext)requestUser, (Account)account, (Role)roleFound)) {
                policies.add(p.getName());
            }
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to list role polices for " + request.getRoleName() + " by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public CreateInstanceProfileResponseType createInstanceProfile(CreateInstanceProfileType request) throws EucalyptusCloudException {
        CreateInstanceProfileResponseType reply = (CreateInstanceProfileResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        try {
            InstanceProfile newInstanceProfile = Privileged.createInstanceProfile((AuthContext)requestUser, (Account)account, (String)request.getInstanceProfileName(), (String)EuareService.sanitizePath(request.getPath()));
            reply.getCreateInstanceProfileResult().setInstanceProfile(this.fillInstanceProfileResult(new InstanceProfileType(), newInstanceProfile));
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to create instance profile by " + ctx.getUser().getName());
                }
                if ("Resource quota is exceeded".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "LimitExceeded", "Instance profile quota exceeded");
                }
                if ("Instance profile already exists".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "Instance profile " + request.getInstanceProfileName() + " already exists.");
                }
                if ("Invalid name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Invalid instance profile name " + request.getInstanceProfileName());
                }
                if ("Invalid path".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidPath", "Invalid instance profile path " + request.getPath());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public GetInstanceProfileResponseType getInstanceProfile(GetInstanceProfileType request) throws EucalyptusCloudException {
        GetInstanceProfileResponseType reply = (GetInstanceProfileResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        InstanceProfile instanceProfileFound = EuareService.lookupInstanceProfileByName(account, request.getInstanceProfileName());
        try {
            if (!Privileged.allowReadInstanceProfile((AuthContext)requestUser, (Account)account, (InstanceProfile)instanceProfileFound)) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get instance profile " + request.getInstanceProfileName() + " by " + ctx.getUser().getName());
            }
            reply.getGetInstanceProfileResult().setInstanceProfile(this.fillInstanceProfileResult(new InstanceProfileType(), instanceProfileFound));
        }
        catch (EuareException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public AddRoleToInstanceProfileResponseType addRoleToInstanceProfile(AddRoleToInstanceProfileType request) throws EucalyptusCloudException {
        AddRoleToInstanceProfileResponseType reply = (AddRoleToInstanceProfileResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Role roleFound = EuareService.lookupRoleByName(account, request.getRoleName());
        InstanceProfile instanceProfileFound = EuareService.lookupInstanceProfileByName(account, request.getInstanceProfileName());
        try {
            Privileged.addRoleToInstanceProfile((AuthContext)requestUser, (Account)account, (InstanceProfile)instanceProfileFound, (Role)roleFound);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("Access to the resource is denied".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to add role to instance profile by " + ctx.getUser().getName());
                }
                if ("Conflict".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.CONFLICT, "EntityAlreadyExists", "Role " + request.getRoleName() + " is already in the instance profile " + request.getInstanceProfileName());
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public RemoveRoleFromInstanceProfileResponseType removeRoleFromInstanceProfile(RemoveRoleFromInstanceProfileType request) throws EucalyptusCloudException {
        RemoveRoleFromInstanceProfileResponseType reply = (RemoveRoleFromInstanceProfileResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Role roleFound = EuareService.lookupRoleByName(account, request.getRoleName());
        InstanceProfile instanceProfileFound = EuareService.lookupInstanceProfileByName(account, request.getInstanceProfileName());
        try {
            Privileged.removeRoleFromInstanceProfile((AuthContext)requestUser, (Account)account, (InstanceProfile)instanceProfileFound, (Role)roleFound);
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to remove role from instance profile by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public ListInstanceProfilesForRoleResponseType listInstanceProfilesForRole(ListInstanceProfilesForRoleType request) throws EucalyptusCloudException {
        ListInstanceProfilesForRoleResponseType reply = (ListInstanceProfilesForRoleResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        Role roleFound = EuareService.lookupRoleByName(account, request.getRoleName());
        reply.getListInstanceProfilesForRoleResult().setIsTruncated(Boolean.valueOf(false));
        ArrayList instanceProfiles = reply.getListInstanceProfilesForRoleResult().getInstanceProfiles().getMember();
        try {
            for (InstanceProfile instanceProfile : Privileged.listInstanceProfilesForRole((AuthContext)requestUser, (Account)account, (Role)roleFound)) {
                if (!Privileged.allowListInstanceProfileForRole((AuthContext)requestUser, (Account)account, (InstanceProfile)instanceProfile)) continue;
                instanceProfiles.add(this.fillInstanceProfileResult(new InstanceProfileType(), instanceProfile));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public DeleteInstanceProfileResponseType deleteInstanceProfile(DeleteInstanceProfileType request) throws EucalyptusCloudException {
        DeleteInstanceProfileResponseType reply = (DeleteInstanceProfileResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        InstanceProfile instanceProfileFound = EuareService.lookupInstanceProfileByName(account, request.getInstanceProfileName());
        try {
            Privileged.deleteInstanceProfile((AuthContext)requestUser, (Account)account, (InstanceProfile)instanceProfileFound);
        }
        catch (Exception e) {
            if (e instanceof AuthException && "Access to the resource is denied".equals(e.getMessage())) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to delete instance profile by " + ctx.getUser().getName());
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public ListInstanceProfilesResponseType listInstanceProfiles(ListInstanceProfilesType request) throws EucalyptusCloudException {
        ListInstanceProfilesResponseType reply = (ListInstanceProfilesResponseType)request.getReply();
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        Account account = this.getRealAccount(ctx, request.getDelegateAccount());
        String path = "/";
        if (!Strings.isNullOrEmpty((String)request.getPathPrefix())) {
            path = request.getPathPrefix();
        }
        if (!Permissions.perhapsAuthorized((String)"iam", (String)"listinstanceprofiles", (AuthContextSupplier)ctx.getAuthContext())) {
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to list instance profiles");
        }
        reply.getListInstanceProfilesResult().setIsTruncated(Boolean.valueOf(false));
        ArrayList instanceProfiles = reply.getListInstanceProfilesResult().getInstanceProfiles().getMember();
        try {
            for (InstanceProfile instanceProfile : account.getInstanceProfiles()) {
                if (!instanceProfile.getPath().startsWith(path) || !Privileged.allowListInstanceProfile((AuthContext)requestUser, (Account)account, (InstanceProfile)instanceProfile)) continue;
                instanceProfiles.add(this.fillInstanceProfileResult(new InstanceProfileType(), instanceProfile));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
        return reply;
    }

    public GetLdapSyncStatusResponseType getLdapSyncStatus(GetLdapSyncStatusType request) throws EucalyptusCloudException {
        GetLdapSyncStatusResponseType reply = (GetLdapSyncStatusResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        if (!requestUser.isSystemAdmin()) {
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Not authorized to get LDAP sync status by " + ctx.getUser().getName());
        }
        reply.getResponseMetadata().setRequestId(reply.getCorrelationId());
        reply.getGetLdapSyncStatusResult().setSyncEnabled(Boolean.valueOf(LdapSync.getLic().isSyncEnabled()));
        reply.getGetLdapSyncStatusResult().setInSync(Boolean.valueOf(LdapSync.inSync()));
        return reply;
    }

    public SignCertificateResponseType signCertificate(SignCertificateType request) throws EucalyptusCloudException {
        X509Certificate vmCert;
        SignCertificateResponseType reply = (SignCertificateResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        String pubkey = request.getKey();
        String instanceId = request.getInstance();
        Integer expirationDays = request.getExpirationDays();
        if (pubkey == null || pubkey.length() <= 0) {
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidValue", "No public key is provided");
        }
        if (instanceId == null || instanceId.length() <= 0) {
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidValue", "No instance ID is provided");
        }
        if (expirationDays == null) {
            expirationDays = 180;
        }
        if (!requestUser.isSystemAdmin()) {
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "SignCertificate can be called by only system admin");
        }
        try {
            vmCert = EuareServerCertificateUtil.generateVMCertificate(pubkey, instanceId, expirationDays);
        }
        catch (EuareException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        String certPem = B64.standard.encString((byte[])PEMFiles.getBytes((Object)vmCert));
        SignCertificateResultType result = new SignCertificateResultType();
        result.setCertificate(certPem);
        reply.setSignCertificateResult(result);
        reply.set_return(Boolean.valueOf(true));
        return reply;
    }

    public DownloadServerCertificateResponseType downloadCertificate(DownloadServerCertificateType request) throws EucalyptusCloudException {
        DownloadServerCertificateResponseType reply = (DownloadServerCertificateResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AuthContext requestUser = EuareService.getAuthContext(ctx);
        if (!requestUser.isSystemUser()) {
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "The user not authorized to perform action");
        }
        String sigB64 = request.getSignature();
        Date ts = request.getTimestamp();
        String certPem = request.getDelegationCertificate();
        String authSigB64 = request.getAuthSignature();
        String certArn = request.getCertificateArn();
        boolean oldCertType = false;
        try {
            if (!EuareServerCertificateUtil.verifyCertificate(certPem, true)) {
                oldCertType = true;
                if (!EuareServerCertificateUtil.verifyCertificate(certPem, false)) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Invalid VM certificate (certificate may have been expired)");
                }
            }
        }
        catch (EuareException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Invalid VM certificate (certificate may have been expired)");
        }
        if (sigB64 == null || ts == null) {
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Signature and timestamp are required");
        }
        Date now = new Date();
        long tsDiff = now.getTime() - ts.getTime();
        long TIMEOUT_MS = 600000L;
        if (tsDiff < 0L || Math.abs(tsDiff) > 600000L) {
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Invalid timestamp");
        }
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(tz);
        String tsAsIso = df.format(ts);
        String payload = String.format("%s&%s", certArn, tsAsIso);
        try {
            if (!EuareServerCertificateUtil.verifySignature(certPem, payload, sigB64)) {
                throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Invalid signature");
            }
        }
        catch (EuareException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"failed to verify signature", (Throwable)ex);
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        if (oldCertType) {
            try {
                String certStr = B64.standard.decString((String)certPem);
                if (!EuareServerCertificateUtil.verifySignatureWithEuare(certStr, authSigB64)) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Invalid signature");
                }
            }
            catch (EuareException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOG.error((Object)"failed to verify auth signature", (Throwable)ex);
                throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
            }
        }
        try {
            ServerCertificateEntity ex = (ServerCertificateEntity)RestrictedTypes.doPrivileged((String)certArn, (Function)ServerCertificates.Lookup.INSTANCE);
        }
        catch (AuthException ex) {
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "The user not authorized to download certificate");
        }
        catch (NoSuchElementException ex) {
            throw new EuareException(HttpResponseStatus.BAD_REQUEST, "NoSuchEntity", "Server certificate is not found");
        }
        catch (Exception ex) {
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        DownloadServerCertificateResultType result = new DownloadServerCertificateResultType();
        try {
            result.setCertificateArn(certArn);
            String serverCertPem = B64.standard.encString((String)EuareServerCertificateUtil.getServerCertificate(certArn));
            result.setServerCertificate(serverCertPem);
            String pk = EuareServerCertificateUtil.getEncryptedKey(certArn, certPem);
            result.setServerPk(pk);
            String msg = String.format("%s&%s", serverCertPem, pk);
            String sig = EuareServerCertificateUtil.generateSignatureWithEuare(msg);
            result.setSignature(sig);
            reply.setDownloadServerCertificateResult(result);
        }
        catch (Exception ex) {
            LOG.error((Object)"failed to prepare server certificate", (Throwable)ex);
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
        return reply;
    }

    private void fillUserResult(UserType u, User userFound, Account account) {
        u.setUserName(userFound.getName());
        u.setUserId(userFound.getUserId());
        u.setPath(userFound.getPath());
        u.setArn(new EuareResourceName(account.getAccountNumber(), "user", userFound.getPath(), userFound.getName()).toString());
        u.setCreateDate(userFound.getCreateDate());
    }

    private void fillUserResultExtra(UserType u, User userFound) {
        u.setEnabled(userFound.isEnabled().toString());
        u.setRegStatus(userFound.getRegistrationStatus().toString());
        u.setPasswordExpiration(new Date(userFound.getPasswordExpires()).toString());
    }

    private void fillGroupResult(GroupType g, Group groupFound, Account account) {
        g.setPath(groupFound.getPath());
        g.setGroupName(groupFound.getName());
        g.setGroupId(groupFound.getGroupId());
        g.setArn(new EuareResourceName(account.getAccountNumber(), "group", groupFound.getPath(), groupFound.getName()).toString());
        g.setCreateDate(groupFound.getCreateDate());
    }

    private InstanceProfileType fillInstanceProfileResult(InstanceProfileType instanceProfileType, InstanceProfile instanceProfileFound) throws AuthException {
        instanceProfileType.setInstanceProfileName(instanceProfileFound.getName());
        instanceProfileType.setInstanceProfileId(instanceProfileFound.getInstanceProfileId());
        instanceProfileType.setPath(instanceProfileFound.getPath());
        instanceProfileType.setArn(Accounts.getInstanceProfileArn((InstanceProfile)instanceProfileFound));
        instanceProfileType.setCreateDate(instanceProfileFound.getCreationTimestamp());
        Role role = instanceProfileFound.getRole();
        instanceProfileType.setRoles(role == null ? new RoleListType() : new RoleListType(this.fillRoleResult(new RoleType(), role)));
        return instanceProfileType;
    }

    private RoleType fillRoleResult(RoleType roleType, Role roleFound) throws AuthException {
        roleType.setRoleName(roleFound.getName());
        roleType.setRoleId(roleFound.getRoleId());
        roleType.setPath(roleFound.getPath());
        roleType.setAssumeRolePolicyDocument(this.encodePolicy(roleFound.getAssumeRolePolicy().getText()));
        roleType.setArn(Accounts.getRoleArn((Role)roleFound));
        roleType.setCreateDate(roleFound.getCreationTimestamp());
        return roleType;
    }

    private static AuthContext getAuthContext(Context ctx) throws EucalyptusCloudException {
        try {
            return ctx.getAuthContext().get();
        }
        catch (AuthException e) {
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    private Account getRealAccount(Context ctx, String delegateAccount) throws EuareException {
        Account requestAccount = ctx.getAccount();
        if (delegateAccount != null) {
            if ("eucalyptus".equals(requestAccount.getName())) {
                try {
                    Account account = Accounts.lookupAccountByName((String)delegateAccount);
                    if (!RestrictedTypes.filterPrivileged().apply((Object)account)) {
                        throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Delegation access not authorized for " + delegateAccount);
                    }
                    return account;
                }
                catch (AuthException e) {
                    throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Can not find delegation account " + delegateAccount);
                }
            }
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Non-sysadmin can not have delegation access to " + delegateAccount);
        }
        if (ctx.isAdministrator() && !RestrictedTypes.filterPrivileged().apply((Object)requestAccount)) {
            throw new EuareException(HttpResponseStatus.FORBIDDEN, "NotAuthorized", "Access not authorized for " + requestAccount);
        }
        return requestAccount;
    }

    private static String sanitizePath(String path) {
        if (path == null || "".equals(path)) {
            return "/";
        }
        if (path.length() > 1 && !path.endsWith("/")) {
            return path.concat("/");
        }
        return path;
    }

    private static User lookupUserByName(Account account, String userName) throws EucalyptusCloudException {
        try {
            return account.lookupUserByName(userName);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("No such user".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Can not find user " + userName);
                }
                if ("Empty user name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty user name");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    private static Group lookupGroupByName(Account account, String groupName) throws EucalyptusCloudException {
        try {
            return account.lookupGroupByName(groupName);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("No such group".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Can not find group " + groupName);
                }
                if ("Empty group name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty group name");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    private static InstanceProfile lookupInstanceProfileByName(Account account, String instanceProfileName) throws EucalyptusCloudException {
        try {
            return account.lookupInstanceProfileByName(instanceProfileName);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("No such instance profile".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Can not find instance profile " + instanceProfileName);
                }
                if ("Empty instance profile name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty instance profile name");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    private static Role lookupRoleByName(Account account, String roleName) throws EucalyptusCloudException {
        try {
            return account.lookupRoleByName(roleName);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if ("No such role".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Can not find role " + roleName);
                }
                if ("Empty role name".equals(e.getMessage())) {
                    throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty role name");
                }
            }
            LOG.error((Object)e, (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    private static Account lookupAccountByName(String accountName) throws EucalyptusCloudException {
        try {
            return Accounts.lookupAccountByName((String)accountName);
        }
        catch (Exception e1) {
            try {
                return Accounts.lookupAccountById((String)accountName);
            }
            catch (Exception e) {
                if (e instanceof AuthException) {
                    if ("No such account".equals(e.getMessage())) {
                        throw new EuareException(HttpResponseStatus.NOT_FOUND, "NoSuchEntity", "Can not find account " + accountName);
                    }
                    if ("Empty account name".equals(e.getMessage())) {
                        throw new EuareException(HttpResponseStatus.BAD_REQUEST, "InvalidName", "Empty account name");
                    }
                }
                LOG.error((Object)e, (Throwable)e);
                throw new EucalyptusCloudException((Throwable)e);
            }
        }
    }

    private static User.RegistrationStatus parseRegStatIgnoreCase(String value) throws IllegalArgumentException {
        for (User.RegistrationStatus stat : User.RegistrationStatus.values()) {
            if (!stat.toString().equalsIgnoreCase(value)) continue;
            return stat;
        }
        throw new IllegalArgumentException("Invalid registration status value");
    }

    private static ServerCertificateMetadataType getServerCertificateMetadata(ServerCertificate cert) {
        ServerCertificateMetadataType metadata = new ServerCertificateMetadataType();
        metadata.setArn(cert.getArn());
        metadata.setServerCertificateId(cert.getCertificateId());
        metadata.setServerCertificateName(cert.getCertificateName());
        metadata.setPath(cert.getCertificatePath());
        metadata.setUploadDate(cert.getCreatedTime());
        return metadata;
    }

    private String encodePolicy(String policy) {
        try {
            return ENCODE_POLICIES && policy != null ? UriUtils.encodeScheme((String)policy, (String)StandardCharsets.UTF_8.name()) : policy;
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.toUndeclared((Throwable)e);
        }
    }
}

