/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.euare;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.ServerCertificate;
import com.eucalyptus.auth.euare.EuareException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.crypto.Certs;
import com.eucalyptus.crypto.Ciphers;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.util.Exceptions;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class EuareServerCertificateUtil {
    private static Logger LOG = Logger.getLogger(EuareServerCertificateUtil.class);

    public static String getServerCertificate(String certArn) throws AuthException {
        ServerCertificate targetCert = EuareServerCertificateUtil.lookupServerCertificate(certArn);
        String serverCert = targetCert.getCertificateBody();
        String chain = targetCert.getCertificateChain();
        if (chain != null && chain.length() > 0) {
            serverCert = String.format("%s\n%s", serverCert, chain);
        }
        return serverCert;
    }

    public static String getEncryptedKey(String certArn, String certPem) throws AuthException {
        ServerCertificate targetCert = EuareServerCertificateUtil.lookupServerCertificate(certArn);
        MessageDigest digest = Digest.SHA256.get();
        byte[] salt = new byte[32];
        ((SecureRandom)Crypto.getSecureRandomSupplier().get()).nextBytes(salt);
        digest.update(salt);
        SecretKeySpec symmKey = new SecretKeySpec(digest.digest(), "AES");
        try {
            Cipher cipher = Ciphers.AES_CBC.get();
            byte[] iv = new byte[16];
            ((SecureRandom)Crypto.getSecureRandomSupplier().get()).nextBytes(iv);
            cipher.init(1, (Key)symmKey, new IvParameterSpec(iv), (SecureRandom)Crypto.getSecureRandomSupplier().get());
            byte[] cipherText = cipher.doFinal(Base64.encode((byte[])targetCert.getPrivateKey().getBytes()));
            String encPrivKey = new String(Base64.encode((byte[])Arrays.concatenate((byte[])iv, (byte[])cipherText)));
            X509Certificate x509Cert = PEMFiles.getCert((byte[])B64.standard.dec((String)certPem));
            cipher = Ciphers.RSA_PKCS1.get();
            cipher.init(1, (Key)x509Cert.getPublicKey(), (SecureRandom)Crypto.getSecureRandomSupplier().get());
            byte[] symmkey = cipher.doFinal(symmKey.getEncoded());
            String b64SymKey = new String(Base64.encode((byte[])symmkey));
            return String.format("%s\n%s", b64SymKey, encPrivKey);
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public static X509Certificate generateVMCertificate(String b64PubKey, String instanceId, int expirationDays) throws EuareException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(B64.standard.dec((String)b64PubKey));
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            X500Principal subjectDn = new X500Principal(String.format("CN=%s, OU=Eucalyptus, O=Cloud, C=US", instanceId));
            SystemCredentials.Credentials euareCred = SystemCredentials.lookup(Euare.class);
            Principal signer = euareCred.getCertificate().getSubjectDN();
            PrivateKey signingKey = euareCred.getPrivateKey();
            Date notAfter = DateUtils.addDays((Date)Calendar.getInstance().getTime(), (int)expirationDays);
            X509Certificate cert = Certs.generateCertificate((PublicKey)publicKey, (X500Principal)subjectDn, (X500Principal)new X500Principal(signer.getName()), (PrivateKey)signingKey, (Date)notAfter);
            if (cert == null) {
                throw new Exception("Null returned");
            }
            return cert;
        }
        catch (Exception ex) {
            LOG.error((Object)"failed to generate VM certificate", (Throwable)ex);
            throw new EuareException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "InternalFailure");
        }
    }

    public static String generateSignatureWithEuare(String msg) {
        return EuareServerCertificateUtil.generateSignature(SystemCredentials.lookup(Euare.class).getPrivateKey(), msg);
    }

    public static String generateSignature(PrivateKey key, String msg) {
        try {
            Signature sig = Signature.getInstance("SHA256withRSA");
            sig.initSign(key);
            sig.update(msg.getBytes("UTF-8"));
            byte[] bsig = sig.sign();
            return B64.standard.encString((byte[])bsig);
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public static boolean verifyCertificate(String certPem, boolean checkSigner) {
        try {
            X509Certificate cert = PEMFiles.getCert((byte[])B64.standard.dec((String)certPem));
            cert.checkValidity();
            if (checkSigner) {
                SystemCredentials.Credentials euareCred = SystemCredentials.lookup(Euare.class);
                X509Certificate signer = euareCred.getCertificate();
                cert.verify(signer.getPublicKey());
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean verifySignature(String certPem, String msg, String sigB64) {
        try {
            Signature sig = Signature.getInstance("SHA256withRSA");
            X509Certificate cert = PEMFiles.getCert((byte[])B64.standard.dec((String)certPem));
            sig.initVerify(cert);
            sig.update(msg.getBytes("UTF-8"));
            return sig.verify(B64.standard.dec((byte[])sigB64.getBytes()));
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public static boolean verifySignatureWithEuare(String msg, String sigB64) {
        String euareCert = B64.standard.encString((byte[])PEMFiles.getBytes((Object)SystemCredentials.lookup(Euare.class).getCertificate()));
        return EuareServerCertificateUtil.verifySignature(euareCert, msg, sigB64);
    }

    private static ServerCertificate lookupServerCertificate(String certArn) throws AuthException {
        if (!certArn.startsWith("arn:aws:iam::")) {
            Exceptions.toUndeclared((Throwable)new Exception("ARN is not in valid format"));
        }
        String arn = certArn;
        int idx = (arn = arn.replace("arn:aws:iam::", "")).indexOf(":server-certificate");
        if (idx <= 0) {
            Exceptions.toUndeclared((Throwable)new Exception("ARN is not in valid format"));
        }
        String acctId = arn.substring(0, idx);
        Account owner = Accounts.lookupAccountById((String)acctId);
        String prefix = String.format("arn:aws:iam::%s:server-certificate", acctId);
        if (!certArn.startsWith(prefix)) {
            throw new AuthException("No server certificate with the requested name exist");
        }
        String pathAndName = certArn.replace(prefix, "");
        String certName = pathAndName.substring(pathAndName.lastIndexOf("/") + 1);
        ServerCertificate targetCert = owner.lookupServerCertificate(certName);
        if (targetCert == null) {
            throw new AuthException("No server certificate with the requested name exist");
        }
        return targetCert;
    }
}

