/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.common.policy;

import com.eucalyptus.auth.policy.ern.Ern;
import com.eucalyptus.auth.policy.ern.ServiceErnBuilder;
import com.eucalyptus.loadbalancing.common.policy.LoadBalancingResourceName;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONException;

public class LoadBalancingErnBuilder
extends ServiceErnBuilder {
    public static final Pattern RESOURCE_PATTERN = Pattern.compile("([a-z0-9_-]+)/(\\S+)");
    public static final int ARN_PATTERNGROUP_ELB_TYPE = 1;
    public static final int ARN_PATTERNGROUP_ELB_ID = 2;

    public LoadBalancingErnBuilder() {
        super(Collections.singleton("elasticloadbalancing"));
    }

    public Ern build(String ern, String service, String region, String account, String resource) throws JSONException {
        Matcher matcher = RESOURCE_PATTERN.matcher(resource);
        if (matcher.matches()) {
            String type = matcher.group(1).toLowerCase();
            String id = matcher.group(2);
            return new LoadBalancingResourceName(type, id);
        }
        throw new JSONException("'" + ern + "' is not a valid ARN");
    }
}

