/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.common.msgs;

import com.eucalyptus.system.Ats;
import com.eucalyptus.util.MessageValidation;
import com.eucalyptus.util.Pair;
import edu.ucsb.eucalyptus.msgs.EucalyptusData;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;

public class LoadBalancingMessageValidation {

    public static enum FieldRegexValue {
        STRING_128("(?s).{1,128}"),
        STRING_255("(?s).{1,255}"),
        LOAD_BALANCER_NAME("[a-zA-Z0-9-]{1,32}"),
        LOAD_BALANCER_SCHEME("internal|internet-facing"),
        LOAD_BALANCER_TAG_KEY("[\\p{L}\\p{Z}\\p{N}_.:/=+@-]{1,128}"),
        LOAD_BALANCER_TAG_VALUE("[\\p{L}\\p{Z}\\p{N}_.:/=+@-]{0,256}"),
        LOAD_BALANCER_INSTANCE_ID_OPTIONAL_STATUS("i-[a-fA-F0-9]{8}(?::(?:InService|OutOfService|Error))?"),
        EC2_INSTANCE_ID("i-[a-fA-F0-9]{8}"),
        EC2_SECURITY_GROUP_ID("sg-[a-fA-F0-9]{8}"),
        EC2_SUBNET_ID("subnet-[a-fA-F0-9]{8}");

        private final Pattern pattern;

        private FieldRegexValue(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public Pattern pattern() {
            return this.pattern;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FieldRange {
        public long min() default 0L;

        public long max() default 0x7FFFFFFFFFFFFFFFL;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FieldRegex {
        public FieldRegexValue value();
    }

    public static class LoadBalancingMessageValidationAssistant
    implements MessageValidation.ValidationAssistant {
        public boolean validate(Object object) {
            return object instanceof EucalyptusData;
        }

        public Pair<Long, Long> range(Ats ats) {
            FieldRange range = (FieldRange)ats.get(FieldRange.class);
            return range == null ? null : Pair.pair((Object)range.min(), (Object)range.max());
        }

        public Pattern regex(Ats ats) {
            FieldRegex regex = (FieldRegex)ats.get(FieldRegex.class);
            return regex == null ? null : regex.value().pattern();
        }
    }
}

