/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.resources.client;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.resources.client.ClientContext;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.Futures;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import org.apache.log4j.Logger;

public abstract class EucalyptusClientTask<TM extends BaseMessage, TC extends ComponentId> {
    private static final Logger LOG = Logger.getLogger(EucalyptusClientTask.class);
    private volatile boolean dispatched = false;

    protected EucalyptusClientTask() {
    }

    final CheckedListenableFuture<Boolean> dispatch(final ClientContext<TM, TC> context) {
        try {
            final CheckedListenableFuture future = Futures.newGenericeFuture();
            this.dispatchInternal(context, new Callback.Checked<TM>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fireException(Throwable throwable) {
                    try {
                        EucalyptusClientTask.this.dispatchFailure(context, throwable);
                    }
                    finally {
                        future.set((Object)false);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fire(TM response) {
                    try {
                        EucalyptusClientTask.this.dispatchSuccess(context, response);
                    }
                    finally {
                        future.set((Object)true);
                    }
                }
            });
            this.dispatched = true;
            return future;
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return Futures.predestinedFuture((Object)false);
        }
    }

    abstract void dispatchInternal(ClientContext<TM, TC> var1, Callback.Checked<TM> var2);

    void dispatchFailure(ClientContext<TM, TC> context, Throwable throwable) {
        LOG.error((Object)"Eucalyptus client error", throwable);
    }

    abstract void dispatchSuccess(ClientContext<TM, TC> var1, TM var2);
}

