/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.resources.client;

import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.VmTypeDetails;
import com.eucalyptus.compute.common.backend.DescribeInstanceTypesResponseType;
import com.eucalyptus.compute.common.backend.DescribeInstanceTypesType;
import com.eucalyptus.resources.EucalyptusActivityException;
import com.eucalyptus.resources.client.AbstractClientContext;
import com.eucalyptus.resources.client.ClientContext;
import com.eucalyptus.resources.client.EucalyptusClientTask;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.DispatchingClient;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.CheckedListenableFuture;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.List;

public class EucalyptusClient {
    private static EucalyptusClient _instance = null;

    private EucalyptusClient() {
    }

    public static EucalyptusClient getInstance() {
        if (_instance == null) {
            _instance = new EucalyptusClient();
        }
        return _instance;
    }

    public List<VmTypeDetails> describeVMTypes() {
        EucalyptusDescribeVMTypesTask task = new EucalyptusDescribeVMTypesTask();
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusBaseSystemContext());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                List<VmTypeDetails> describe = task.getVMTypes();
                return describe;
            }
            throw new EucalyptusActivityException("failed to describe the vm types");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private class EucalyptusDescribeVMTypesTask
    extends EucalyptusClientTask<BaseMessage, Eucalyptus> {
        private List<VmTypeDetails> types = null;

        private EucalyptusDescribeVMTypesTask() {
        }

        private DescribeInstanceTypesType describeVMTypes() {
            DescribeInstanceTypesType req = new DescribeInstanceTypesType();
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<BaseMessage, Eucalyptus> context, Callback.Checked<BaseMessage> callback) {
            DispatchingClient<BaseMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.describeVMTypes(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<BaseMessage, Eucalyptus> context, BaseMessage response) {
            DescribeInstanceTypesResponseType resp = (DescribeInstanceTypesResponseType)response;
            this.types = resp.getInstanceTypeDetails();
        }

        public List<VmTypeDetails> getVMTypes() {
            return this.types;
        }
    }

    private class EucalyptusBaseSystemContext
    extends AbstractClientContext<BaseMessage, Eucalyptus> {
        private EucalyptusBaseSystemContext() {
            super(null, Eucalyptus.class);
        }
    }
}

