/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.resources.client;

import com.eucalyptus.auth.euare.AddRoleToInstanceProfileResponseType;
import com.eucalyptus.auth.euare.AddRoleToInstanceProfileType;
import com.eucalyptus.auth.euare.CreateInstanceProfileResponseType;
import com.eucalyptus.auth.euare.CreateInstanceProfileType;
import com.eucalyptus.auth.euare.CreateRoleResponseType;
import com.eucalyptus.auth.euare.CreateRoleType;
import com.eucalyptus.auth.euare.DeleteInstanceProfileResponseType;
import com.eucalyptus.auth.euare.DeleteInstanceProfileType;
import com.eucalyptus.auth.euare.DeleteRolePolicyResponseType;
import com.eucalyptus.auth.euare.DeleteRolePolicyType;
import com.eucalyptus.auth.euare.DeleteRoleResponseType;
import com.eucalyptus.auth.euare.DeleteRoleType;
import com.eucalyptus.auth.euare.DeleteServerCertificateResponseType;
import com.eucalyptus.auth.euare.DeleteServerCertificateType;
import com.eucalyptus.auth.euare.EuareMessage;
import com.eucalyptus.auth.euare.GetRolePolicyResponseType;
import com.eucalyptus.auth.euare.GetRolePolicyResult;
import com.eucalyptus.auth.euare.GetRolePolicyType;
import com.eucalyptus.auth.euare.GetServerCertificateResponseType;
import com.eucalyptus.auth.euare.GetServerCertificateType;
import com.eucalyptus.auth.euare.InstanceProfileType;
import com.eucalyptus.auth.euare.ListInstanceProfilesResponseType;
import com.eucalyptus.auth.euare.ListInstanceProfilesType;
import com.eucalyptus.auth.euare.ListRolePoliciesResponseType;
import com.eucalyptus.auth.euare.ListRolePoliciesType;
import com.eucalyptus.auth.euare.ListRolesResponseType;
import com.eucalyptus.auth.euare.ListRolesType;
import com.eucalyptus.auth.euare.PutRolePolicyResponseType;
import com.eucalyptus.auth.euare.PutRolePolicyType;
import com.eucalyptus.auth.euare.RemoveRoleFromInstanceProfileResponseType;
import com.eucalyptus.auth.euare.RemoveRoleFromInstanceProfileType;
import com.eucalyptus.auth.euare.RoleType;
import com.eucalyptus.auth.euare.ServerCertificateType;
import com.eucalyptus.auth.euare.UploadServerCertificateResponseType;
import com.eucalyptus.auth.euare.UploadServerCertificateType;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.resources.EucalyptusActivityException;
import com.eucalyptus.resources.client.AbstractClientContext;
import com.eucalyptus.resources.client.ClientContext;
import com.eucalyptus.resources.client.EucalyptusClientTask;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.DispatchingClient;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.List;

public class EuareClient {
    private static EuareClient _instance = null;

    private EuareClient() {
    }

    public static EuareClient getInstance() {
        if (_instance == null) {
            _instance = new EuareClient();
        }
        return _instance;
    }

    public List<RoleType> listRoles(String userId, String pathPrefix) {
        EuareListRolesTask task = new EuareListRolesTask(pathPrefix);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getRoles();
            }
            throw new EucalyptusActivityException("failed to list IAM roles");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public RoleType createRole(String userId, String roleName, String path, String assumeRolePolicy) {
        EuareCreateRoleTask task = new EuareCreateRoleTask(roleName, path, assumeRolePolicy);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getRole();
            }
            throw new EucalyptusActivityException("failed to create IAM role");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public ServerCertificateType getServerCertificate(String userId, String certName) {
        EuareGetServerCertificateTask task = new EuareGetServerCertificateTask(certName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getServerCertificate();
            }
            throw new EucalyptusActivityException("failed to get server certificate");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteRole(String userId, String roleName) {
        EuareDeleteRoleTask task = new EuareDeleteRoleTask(roleName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete IAM role");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<InstanceProfileType> listInstanceProfiles(String userId, String pathPrefix) {
        EuareListInstanceProfilesTask task = new EuareListInstanceProfilesTask(pathPrefix);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getInstanceProfiles();
            }
            throw new EucalyptusActivityException("failed to delete IAM role");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public InstanceProfileType createInstanceProfile(String userId, String profileName, String path) {
        EuareCreateInstanceProfileTask task = new EuareCreateInstanceProfileTask(profileName, path);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getInstanceProfile();
            }
            throw new EucalyptusActivityException("failed to create IAM instance profile");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteInstanceProfile(String userId, String profileName) {
        EuareDeleteInstanceProfileTask task = new EuareDeleteInstanceProfileTask(profileName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete IAM instance profile");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void addRoleToInstanceProfile(String userId, String instanceProfileName, String roleName) {
        EuareAddRoleToInstanceProfileTask task = new EuareAddRoleToInstanceProfileTask(instanceProfileName, roleName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to add role to the instance profile");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void removeRoleFromInstanceProfile(String userId, String instanceProfileName, String roleName) {
        EuareRemoveRoleFromInstanceProfileTask task = new EuareRemoveRoleFromInstanceProfileTask(instanceProfileName, roleName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to remove role from the instance profile");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<String> listRolePolicies(String userId, String roleName) {
        EuareListRolePoliciesTask task = new EuareListRolePoliciesTask(roleName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResult();
            }
            throw new EucalyptusActivityException("failed to list role's policies");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public GetRolePolicyResult getRolePolicy(String userId, String roleName, String policyName) {
        EuareGetRolePolicyTask task = new EuareGetRolePolicyTask(roleName, policyName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResult();
            }
            throw new EucalyptusActivityException("failed to get role's policy");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void putRolePolicy(String userId, String roleName, String policyName, String policyDocument) {
        EuarePutRolePolicyTask task = new EuarePutRolePolicyTask(roleName, policyName, policyDocument);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to put role's policy");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteRolePolicy(String userId, String roleName, String policyName) {
        EuareDeleteRolePolicyTask task = new EuareDeleteRolePolicyTask(roleName, policyName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete role's policy");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void uploadServerCertificate(String userId, String certName, String certPath, String certBodyPem, String pkPem, String certChainPem) {
        UploadServerCertificateTask task = new UploadServerCertificateTask(certName, certPath, certBodyPem, pkPem, certChainPem);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to upload server certificate");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteServerCertificate(String userId, String certName) {
        DeleteServerCertificateTask task = new DeleteServerCertificateTask(certName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete server certificate");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private class DeleteServerCertificateTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String certName = null;

        private DeleteServerCertificateTask(String certName) {
            this.certName = certName;
        }

        private DeleteServerCertificateType deleteServerCertificate() {
            DeleteServerCertificateType req = new DeleteServerCertificateType();
            req.setServerCertificateName(this.certName);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteServerCertificate(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            DeleteServerCertificateResponseType resp = new DeleteServerCertificateResponseType();
        }
    }

    private class UploadServerCertificateTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String certName = null;
        private String certPath = "/";
        private String certPem = null;
        private String pkPem = null;
        private String certChain = null;

        private UploadServerCertificateTask(String certName, String certPath, String certPem, String pkPem, String certChain) {
            this.certName = certName;
            if (certPath != null) {
                this.certPath = certPath;
            }
            this.certPem = certPem;
            this.pkPem = pkPem;
            this.certChain = certChain;
        }

        private UploadServerCertificateType uploadServerCertificate() {
            UploadServerCertificateType req = new UploadServerCertificateType();
            req.setServerCertificateName(this.certName);
            req.setPath(this.certPath);
            req.setCertificateBody(this.certPem);
            req.setPrivateKey(this.pkPem);
            if (this.certChain != null) {
                req.setCertificateChain(this.certChain);
            }
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.uploadServerCertificate(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            UploadServerCertificateResponseType resp = (UploadServerCertificateResponseType)response;
        }
    }

    private class EuareDeleteRolePolicyTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String roleName = null;
        private String policyName = null;

        private EuareDeleteRolePolicyTask(String roleName, String policyName) {
            this.roleName = roleName;
            this.policyName = policyName;
        }

        private DeleteRolePolicyType deleteRolePolicy() {
            DeleteRolePolicyType req = new DeleteRolePolicyType();
            req.setRoleName(this.roleName);
            req.setPolicyName(this.policyName);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteRolePolicy(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            DeleteRolePolicyResponseType resp = (DeleteRolePolicyResponseType)response;
        }
    }

    private class EuareGetRolePolicyTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String roleName = null;
        private String policyName = null;
        private GetRolePolicyResult result = null;

        private EuareGetRolePolicyTask(String roleName, String policyName) {
            this.roleName = roleName;
            this.policyName = policyName;
        }

        private GetRolePolicyType getRolePolicy() {
            GetRolePolicyType req = new GetRolePolicyType();
            req.setRoleName(this.roleName);
            req.setPolicyName(this.policyName);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.getRolePolicy(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            try {
                GetRolePolicyResponseType resp = (GetRolePolicyResponseType)response;
                this.result = resp.getGetRolePolicyResult();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        GetRolePolicyResult getResult() {
            return this.result;
        }
    }

    private class EuareListRolePoliciesTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String roleName = null;
        private List<String> policies = null;

        private EuareListRolePoliciesTask(String roleName) {
            this.roleName = roleName;
        }

        private ListRolePoliciesType listRolePolicies() {
            ListRolePoliciesType req = new ListRolePoliciesType();
            req.setRoleName(this.roleName);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.listRolePolicies(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            try {
                ListRolePoliciesResponseType resp = (ListRolePoliciesResponseType)response;
                this.policies = resp.getListRolePoliciesResult().getPolicyNames().getMemberList();
            }
            catch (Exception ex) {
                this.policies = Lists.newArrayList();
            }
        }

        public List<String> getResult() {
            return this.policies;
        }
    }

    private class EuarePutRolePolicyTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String roleName = null;
        private String policyName = null;
        private String policyDocument = null;

        private EuarePutRolePolicyTask(String roleName, String policyName, String policyDocument) {
            this.roleName = roleName;
            this.policyName = policyName;
            this.policyDocument = policyDocument;
        }

        private PutRolePolicyType putRolePolicy() {
            PutRolePolicyType req = new PutRolePolicyType();
            req.setRoleName(this.roleName);
            req.setPolicyName(this.policyName);
            req.setPolicyDocument(this.policyDocument);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.putRolePolicy(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            PutRolePolicyResponseType resp = (PutRolePolicyResponseType)response;
        }
    }

    private class EuareListRolesTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String pathPrefix = null;
        private List<RoleType> roles = Lists.newArrayList();

        private EuareListRolesTask(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        private ListRolesType listRoles() {
            ListRolesType req = new ListRolesType();
            req.setPathPrefix(this.pathPrefix);
            return req;
        }

        public List<RoleType> getRoles() {
            return this.roles;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.listRoles(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            ListRolesResponseType resp = (ListRolesResponseType)response;
            try {
                this.roles = resp.getListRolesResult().getRoles().getMember();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class EuareCreateRoleTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        String roleName = null;
        String path = null;
        String assumeRolePolicy = null;
        private RoleType role = null;

        private EuareCreateRoleTask(String roleName, String path, String assumeRolePolicy) {
            this.roleName = roleName;
            this.path = path;
            this.assumeRolePolicy = assumeRolePolicy;
        }

        private CreateRoleType createRole() {
            CreateRoleType req = new CreateRoleType();
            req.setRoleName(this.roleName);
            req.setPath(this.path);
            req.setAssumeRolePolicyDocument(this.assumeRolePolicy);
            return req;
        }

        public RoleType getRole() {
            return this.role;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.createRole(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            CreateRoleResponseType resp = (CreateRoleResponseType)response;
            try {
                this.role = resp.getCreateRoleResult().getRole();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class EuareDeleteRoleTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String roleName = null;

        private EuareDeleteRoleTask(String roleName) {
            this.roleName = roleName;
        }

        private DeleteRoleType deleteRole() {
            DeleteRoleType req = new DeleteRoleType();
            req.setRoleName(this.roleName);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteRole(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            DeleteRoleResponseType resp = (DeleteRoleResponseType)response;
        }
    }

    private class EuareCreateInstanceProfileTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String profileName = null;
        private String path = null;
        private InstanceProfileType instanceProfile = null;

        private EuareCreateInstanceProfileTask(String profileName, String path) {
            this.profileName = profileName;
            this.path = path;
        }

        private CreateInstanceProfileType createInstanceProfile() {
            CreateInstanceProfileType req = new CreateInstanceProfileType();
            req.setInstanceProfileName(this.profileName);
            req.setPath(this.path);
            return req;
        }

        public InstanceProfileType getInstanceProfile() {
            return this.instanceProfile;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.createInstanceProfile(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            CreateInstanceProfileResponseType resp = (CreateInstanceProfileResponseType)response;
            try {
                this.instanceProfile = resp.getCreateInstanceProfileResult().getInstanceProfile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class EuareListInstanceProfilesTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String pathPrefix = null;
        private List<InstanceProfileType> instanceProfiles = null;

        private EuareListInstanceProfilesTask(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        private ListInstanceProfilesType listInstanceProfiles() {
            ListInstanceProfilesType req = new ListInstanceProfilesType();
            req.setPathPrefix(this.pathPrefix);
            return req;
        }

        public List<InstanceProfileType> getInstanceProfiles() {
            return this.instanceProfiles;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.listInstanceProfiles(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            ListInstanceProfilesResponseType resp = (ListInstanceProfilesResponseType)response;
            try {
                this.instanceProfiles = resp.getListInstanceProfilesResult().getInstanceProfiles().getMember();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class EuareRemoveRoleFromInstanceProfileTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String instanceProfileName = null;
        private String roleName = null;

        private EuareRemoveRoleFromInstanceProfileTask(String instanceProfileName, String roleName) {
            this.instanceProfileName = instanceProfileName;
            this.roleName = roleName;
        }

        private RemoveRoleFromInstanceProfileType removeRoleFromInstanceProfile() {
            RemoveRoleFromInstanceProfileType req = new RemoveRoleFromInstanceProfileType();
            req.setRoleName(this.roleName);
            req.setInstanceProfileName(this.instanceProfileName);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.removeRoleFromInstanceProfile(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            RemoveRoleFromInstanceProfileResponseType resp = (RemoveRoleFromInstanceProfileResponseType)response;
        }
    }

    private class EuareAddRoleToInstanceProfileTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String instanceProfileName = null;
        private String roleName = null;

        private EuareAddRoleToInstanceProfileTask(String instanceProfileName, String roleName) {
            this.instanceProfileName = instanceProfileName;
            this.roleName = roleName;
        }

        private AddRoleToInstanceProfileType addRoleToInstanceProfile() {
            AddRoleToInstanceProfileType req = new AddRoleToInstanceProfileType();
            req.setRoleName(this.roleName);
            req.setInstanceProfileName(this.instanceProfileName);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.addRoleToInstanceProfile(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            AddRoleToInstanceProfileResponseType resp = (AddRoleToInstanceProfileResponseType)response;
        }
    }

    private class EuareDeleteInstanceProfileTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String profileName = null;

        private EuareDeleteInstanceProfileTask(String profileName) {
            this.profileName = profileName;
        }

        private DeleteInstanceProfileType deleteInstanceProfile() {
            DeleteInstanceProfileType req = new DeleteInstanceProfileType();
            req.setInstanceProfileName(this.profileName);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteInstanceProfile(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            DeleteInstanceProfileResponseType resp = (DeleteInstanceProfileResponseType)response;
        }
    }

    private class EuareGetServerCertificateTask
    extends EucalyptusClientTask<EuareMessage, Euare> {
        private String certName = null;
        private ServerCertificateType certificate = null;

        private EuareGetServerCertificateTask(String certName) {
            this.certName = certName;
        }

        private GetServerCertificateType getRequest() {
            GetServerCertificateType req = new GetServerCertificateType();
            req.setServerCertificateName(this.certName);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.getRequest(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EuareMessage, Euare> context, EuareMessage response) {
            GetServerCertificateResponseType resp = (GetServerCertificateResponseType)response;
            if (resp.getGetServerCertificateResult() != null) {
                this.certificate = resp.getGetServerCertificateResult().getServerCertificate();
            }
        }

        public ServerCertificateType getServerCertificate() {
            return this.certificate;
        }
    }

    private class EuareContext
    extends AbstractClientContext<EuareMessage, Euare> {
        private EuareContext(String userId) {
            super(userId, Euare.class);
        }
    }
}

