/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.resources.client;

import com.eucalyptus.empyrean.DescribeServicesResponseType;
import com.eucalyptus.empyrean.DescribeServicesType;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.empyrean.EmpyreanMessage;
import com.eucalyptus.empyrean.ServiceStatusType;
import com.eucalyptus.resources.EucalyptusActivityException;
import com.eucalyptus.resources.client.AbstractClientContext;
import com.eucalyptus.resources.client.ClientContext;
import com.eucalyptus.resources.client.EucalyptusClientTask;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.DispatchingClient;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.CheckedListenableFuture;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.List;

public class EmpyreanClient {
    private static EmpyreanClient _instance = null;

    private EmpyreanClient() {
    }

    public static EmpyreanClient getInstance() {
        if (_instance == null) {
            _instance = new EmpyreanClient();
        }
        return _instance;
    }

    public List<ServiceStatusType> describeServices(String componentType) {
        EucalyptusDescribeServicesTask serviceTask = new EucalyptusDescribeServicesTask(componentType);
        CheckedListenableFuture<Boolean> result = serviceTask.dispatch(new EmpyreanSystemContext());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return serviceTask.getServiceDetais();
            }
            throw new EucalyptusActivityException("failed to describe services");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private class EucalyptusDescribeServicesTask
    extends EucalyptusClientTask<EmpyreanMessage, Empyrean> {
        private String componentType = null;
        private List<ServiceStatusType> services = null;

        private EucalyptusDescribeServicesTask(String componentType) {
            this.componentType = componentType;
        }

        private DescribeServicesType describeServices() {
            DescribeServicesType req = new DescribeServicesType();
            req.setByServiceType(this.componentType);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<EmpyreanMessage, Empyrean> context, Callback.Checked<EmpyreanMessage> callback) {
            DispatchingClient<EmpyreanMessage, Empyrean> client = context.getClient();
            client.dispatch((BaseMessage)this.describeServices(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<EmpyreanMessage, Empyrean> context, EmpyreanMessage response) {
            DescribeServicesResponseType resp = (DescribeServicesResponseType)response;
            this.services = resp.getServiceStatuses();
        }

        public List<ServiceStatusType> getServiceDetais() {
            return this.services;
        }
    }

    private class EmpyreanSystemContext
    extends AbstractClientContext<EmpyreanMessage, Empyrean> {
        private EmpyreanSystemContext() {
            super(null, Empyrean.class);
        }
    }
}

