/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.resources.client;

import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.compute.common.AuthorizeSecurityGroupIngressResponseType;
import com.eucalyptus.compute.common.AuthorizeSecurityGroupIngressType;
import com.eucalyptus.compute.common.ClusterInfoType;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.ComputeMessage;
import com.eucalyptus.compute.common.CreateSecurityGroupResponseType;
import com.eucalyptus.compute.common.CreateSecurityGroupType;
import com.eucalyptus.compute.common.CreateTagsResponseType;
import com.eucalyptus.compute.common.CreateTagsType;
import com.eucalyptus.compute.common.DeleteResourceTag;
import com.eucalyptus.compute.common.DeleteSecurityGroupResponseType;
import com.eucalyptus.compute.common.DeleteSecurityGroupType;
import com.eucalyptus.compute.common.DeleteTagsResponseType;
import com.eucalyptus.compute.common.DeleteTagsType;
import com.eucalyptus.compute.common.DescribeAvailabilityZonesResponseType;
import com.eucalyptus.compute.common.DescribeAvailabilityZonesType;
import com.eucalyptus.compute.common.DescribeImagesResponseType;
import com.eucalyptus.compute.common.DescribeImagesType;
import com.eucalyptus.compute.common.DescribeInstancesResponseType;
import com.eucalyptus.compute.common.DescribeInstancesType;
import com.eucalyptus.compute.common.DescribeKeyPairsResponseItemType;
import com.eucalyptus.compute.common.DescribeKeyPairsResponseType;
import com.eucalyptus.compute.common.DescribeKeyPairsType;
import com.eucalyptus.compute.common.DescribeSecurityGroupsResponseType;
import com.eucalyptus.compute.common.DescribeSecurityGroupsType;
import com.eucalyptus.compute.common.DescribeTagsResponseType;
import com.eucalyptus.compute.common.DescribeTagsType;
import com.eucalyptus.compute.common.DescribeVolumesResponseType;
import com.eucalyptus.compute.common.DescribeVolumesType;
import com.eucalyptus.compute.common.Filter;
import com.eucalyptus.compute.common.GroupItemType;
import com.eucalyptus.compute.common.ImageDetails;
import com.eucalyptus.compute.common.IpPermissionType;
import com.eucalyptus.compute.common.ReservationInfoType;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.RevokeSecurityGroupIngressResponseType;
import com.eucalyptus.compute.common.RevokeSecurityGroupIngressType;
import com.eucalyptus.compute.common.RunInstancesResponseType;
import com.eucalyptus.compute.common.RunInstancesType;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.compute.common.TagInfo;
import com.eucalyptus.compute.common.TerminateInstancesItemType;
import com.eucalyptus.compute.common.TerminateInstancesResponseType;
import com.eucalyptus.compute.common.TerminateInstancesType;
import com.eucalyptus.compute.common.Volume;
import com.eucalyptus.resources.EucalyptusActivityException;
import com.eucalyptus.resources.client.AbstractClientContext;
import com.eucalyptus.resources.client.ClientContext;
import com.eucalyptus.resources.client.EucalyptusClientTask;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.DispatchingClient;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class Ec2Client {
    private static final Logger LOG = Logger.getLogger(Ec2Client.class);
    private static Ec2Client _instance = null;

    private Ec2Client() {
    }

    public static Ec2Client getInstance() {
        if (_instance == null) {
            _instance = new Ec2Client();
        }
        return _instance;
    }

    public List<String> launchInstances(String userId, String availabilityZone, String imageId, String instanceType, int numInstances) {
        return this.launchInstances(userId, availabilityZone, imageId, instanceType, null, null, numInstances);
    }

    public List<String> launchInstances(String userId, String availabilityZone, String imageId, String instanceType, String groupName, String userData, int numInstances) {
        LOG.info((Object)("launching instances at zone=" + availabilityZone + ", imageId=" + imageId + ", group=" + groupName));
        ComputeLaunchInstanceTask launchTask = new ComputeLaunchInstanceTask(availabilityZone, imageId, instanceType, numInstances);
        if (userData != null) {
            launchTask.setUserData(userData);
        }
        if (groupName != null) {
            launchTask.setSecurityGroup(groupName);
        }
        CheckedListenableFuture<Boolean> result = launchTask.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                List<String> instances = launchTask.getInstanceIds();
                return instances;
            }
            throw new EucalyptusActivityException("failed to launch the instance");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<String> terminateInstances(String userId, List<String> instances) {
        LOG.info((Object)String.format("terminating %d instances", instances.size()));
        if (instances.size() <= 0) {
            return instances;
        }
        ComputeTerminateInstanceTask terminateTask = new ComputeTerminateInstanceTask(instances);
        CheckedListenableFuture<Boolean> result = terminateTask.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                List<String> terminated = terminateTask.getTerminatedInstances();
                return terminated;
            }
            throw new EucalyptusActivityException("failed to terminate the instances");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<RunningInstancesItemType> describeInstances(String userId, List<String> instances) {
        ComputeDescribeInstanceTask describeTask = new ComputeDescribeInstanceTask(instances);
        CheckedListenableFuture<Boolean> result = describeTask.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                List<RunningInstancesItemType> describe = describeTask.getResult();
                return describe;
            }
            throw new EucalyptusActivityException("failed to describe the instances");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<ClusterInfoType> describeAvailabilityZones(String userId, boolean verbose) {
        ComputeDescribeAvailabilityZonesTask task = new ComputeDescribeAvailabilityZonesTask(verbose);
        CheckedListenableFuture<Boolean> result = task.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                List<ClusterInfoType> describe = task.getAvailabilityZones();
                return describe;
            }
            throw new EucalyptusActivityException("failed to describe the availability zones");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void createSecurityGroup(String userId, String groupName, String groupDesc) {
        ComputeCreateGroupTask task = new ComputeCreateGroupTask(groupName, groupDesc);
        CheckedListenableFuture<Boolean> result = task.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue() && task.getGroupId() != null) {
                return;
            }
            throw new EucalyptusActivityException("failed to create the group " + groupName);
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteSecurityGroup(String userId, String groupName) {
        ComputeDeleteGroupTask task = new ComputeDeleteGroupTask(groupName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete the group " + groupName);
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<SecurityGroupItemType> describeSecurityGroups(String userId, List<String> groupNames) {
        ComputeDescribeSecurityGroupTask task = new ComputeDescribeSecurityGroupTask(groupNames);
        CheckedListenableFuture<Boolean> result = task.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResult();
            }
            throw new EucalyptusActivityException("failed to describe security groups");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void authorizeSecurityGroup(String userId, String groupName, String protocol, int portNum) {
        ComputeAuthorizeIngressRuleTask task = new ComputeAuthorizeIngressRuleTask(groupName, protocol, portNum);
        CheckedListenableFuture<Boolean> result = task.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException(String.format("failed to authorize:%s, %s, %d ", groupName, protocol, portNum));
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void revokeSecurityGroup(String userId, String groupName, String protocol, int portNum) {
        ComputeRevokeIngressRuleTask task = new ComputeRevokeIngressRuleTask(groupName, protocol, portNum);
        CheckedListenableFuture<Boolean> result = task.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException(String.format("failed to revoke:%s, %s, %d ", groupName, protocol, portNum));
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<DescribeKeyPairsResponseItemType> describeKeyPairs(String userId, List<String> keyNames) {
        ComputeDescribeKeyPairsTask task = new ComputeDescribeKeyPairsTask(keyNames);
        CheckedListenableFuture<Boolean> result = task.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResult();
            }
            throw new EucalyptusActivityException("failed to describe keypairs");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<ImageDetails> describeImages(String userId, List<String> imageIds) {
        ComputeDescribeImagesTask task = new ComputeDescribeImagesTask(imageIds);
        CheckedListenableFuture<Boolean> result = task.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResult();
            }
            throw new EucalyptusActivityException("failed to describe keypairs");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void createTags(String userId, String tagKey, String tagValue, List<String> resources) {
        ComputeCreateTagsTask task = new ComputeCreateTagsTask(tagKey, tagValue, resources);
        CheckedListenableFuture<Boolean> result = task.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to create tags");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<TagInfo> describeTags(String userId, List<String> names, List<String> values) {
        DescribeTagsTask task = new DescribeTagsTask(names, values);
        CheckedListenableFuture<Boolean> result = task.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getTags();
            }
            throw new EucalyptusActivityException("failed to describe tags");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteTags(String userId, String tagKey, String tagValue, List<String> resources) {
        ComputeDeleteTagsTask task = new ComputeDeleteTagsTask(tagKey, tagValue, resources);
        CheckedListenableFuture<Boolean> result = task.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete tags");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<Volume> describeVolumes(String userId, List<String> volumeIds) {
        DescribeVolumesTask task = new DescribeVolumesTask(volumeIds);
        CheckedListenableFuture<Boolean> result = task.dispatch(new Ec2Context(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getVolumes();
            }
            throw new EucalyptusActivityException("failed to describe volumes");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private class DescribeVolumesTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        private List<String> volumeIds = null;
        private List<Volume> result = null;

        private DescribeVolumesTask() {
            this.volumeIds = null;
        }

        private DescribeVolumesTask(List<String> volumeIds) {
            this.volumeIds = volumeIds;
        }

        private DescribeVolumesType describeVolumes() {
            DescribeVolumesType req = new DescribeVolumesType();
            if (this.volumeIds != null && this.volumeIds.size() > 0) {
                req.setVolumeSet(Lists.newArrayList(this.volumeIds));
            }
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.describeVolumes(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            DescribeVolumesResponseType resp = (DescribeVolumesResponseType)response;
            this.result = resp.getVolumeSet();
        }

        public List<Volume> getVolumes() {
            return this.result;
        }
    }

    private class DescribeTagsTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        private List<String> names = null;
        private List<String> values = null;
        private List<TagInfo> tags = null;

        private DescribeTagsTask(List<String> names, List<String> values) {
            this.names = names;
            this.values = values;
        }

        private DescribeTagsType describeTags() {
            if (this.names.size() != this.values.size()) {
                throw Exceptions.toUndeclared((Throwable)new Exception("Names and values don't match"));
            }
            DescribeTagsType req = new DescribeTagsType();
            ArrayList filterSet = Lists.newArrayList();
            for (int i = 0; i < this.names.size(); ++i) {
                String name = this.names.get(i);
                String value = this.values.get(i);
                Filter f = new Filter();
                f.setName(name);
                f.setValueSet(Lists.newArrayList((Object[])new String[]{value}));
                filterSet.add(f);
            }
            req.setFilterSet(filterSet);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.describeTags(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            DescribeTagsResponseType resp = (DescribeTagsResponseType)response;
            this.tags = resp.getTagSet();
        }

        public List<TagInfo> getTags() {
            return this.tags;
        }
    }

    private class ComputeDescribeKeyPairsTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        private List<String> keyNames = null;
        private List<DescribeKeyPairsResponseItemType> result = null;

        private ComputeDescribeKeyPairsTask() {
        }

        private ComputeDescribeKeyPairsTask(String keyName) {
            this.keyNames = Lists.newArrayList((Object[])new String[]{keyName});
        }

        private ComputeDescribeKeyPairsTask(List<String> keyNames) {
            this.keyNames = keyNames;
        }

        private DescribeKeyPairsType describeKeyPairs() {
            DescribeKeyPairsType req = new DescribeKeyPairsType();
            if (this.keyNames != null) {
                req.setKeySet(new ArrayList<String>(this.keyNames));
            }
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.describeKeyPairs(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            DescribeKeyPairsResponseType resp = (DescribeKeyPairsResponseType)response;
            this.result = resp.getKeySet();
        }

        List<DescribeKeyPairsResponseItemType> getResult() {
            return this.result;
        }
    }

    private class ComputeCreateTagsTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        private String tagKey = null;
        private String tagValue = null;
        private List<String> resources = null;

        private ComputeCreateTagsTask(String tagKey, String tagValue, List<String> resources) {
            this.tagKey = tagKey;
            this.tagValue = tagValue;
            this.resources = resources;
        }

        private CreateTagsType createTags() {
            CreateTagsType req = new CreateTagsType();
            req.setResourcesSet(Lists.newArrayList(this.resources));
            ResourceTag tag = new ResourceTag();
            tag.setKey(this.tagKey);
            tag.setValue(this.tagValue);
            req.setTagSet(Lists.newArrayList((Object[])new ResourceTag[]{tag}));
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.createTags(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            CreateTagsResponseType resp = (CreateTagsResponseType)response;
        }
    }

    private class ComputeDeleteTagsTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        private String tagKey = null;
        private String tagValue = null;
        private List<String> resources = null;

        private ComputeDeleteTagsTask(String tagKey, String tagValue, List<String> resources) {
            this.tagKey = tagKey;
            this.tagValue = tagValue;
            this.resources = resources;
        }

        private DeleteTagsType deleteTags() {
            DeleteTagsType req = new DeleteTagsType();
            req.setResourcesSet(Lists.newArrayList(this.resources));
            DeleteResourceTag tag = new DeleteResourceTag();
            tag.setKey(this.tagKey);
            tag.setValue(this.tagValue);
            req.setTagSet(Lists.newArrayList((Object[])new DeleteResourceTag[]{tag}));
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteTags(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            DeleteTagsResponseType resp = (DeleteTagsResponseType)response;
        }
    }

    private class ComputeDescribeImagesTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        private List<String> imageIds = null;
        private List<ImageDetails> result = null;

        private ComputeDescribeImagesTask(List<String> imageIds) {
            this.imageIds = imageIds;
        }

        private DescribeImagesType describeImages() {
            DescribeImagesType req = new DescribeImagesType();
            if (this.imageIds != null && this.imageIds.size() > 0) {
                req.setImagesSet(new ArrayList<String>(this.imageIds));
            }
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.describeImages(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            DescribeImagesResponseType resp = (DescribeImagesResponseType)response;
            this.result = resp.getImagesSet();
        }

        List<ImageDetails> getResult() {
            return this.result;
        }
    }

    private class ComputeDescribeAvailabilityZonesTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        private List<ClusterInfoType> zones = null;
        private boolean verbose = false;

        private ComputeDescribeAvailabilityZonesTask(boolean verbose) {
            this.verbose = verbose;
        }

        private DescribeAvailabilityZonesType describeAvailabilityZones() {
            DescribeAvailabilityZonesType req = new DescribeAvailabilityZonesType();
            if (this.verbose) {
                req.setAvailabilityZoneSet(Lists.newArrayList((Object[])new String[]{"verbose"}));
            }
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.describeAvailabilityZones(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            DescribeAvailabilityZonesResponseType resp = (DescribeAvailabilityZonesResponseType)response;
            this.zones = resp.getAvailabilityZoneInfo();
        }

        public List<ClusterInfoType> getAvailabilityZones() {
            return this.zones;
        }
    }

    private class ComputeLaunchInstanceTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        private final String availabilityZone;
        private final String imageId;
        private final String instanceType;
        private String userData;
        private String groupName;
        private int numInstances = 1;
        private final AtomicReference<List<String>> instanceIds = new AtomicReference(Collections.emptyList());

        private ComputeLaunchInstanceTask(String availabilityZone, String imageId, String instanceType, int numInstances) {
            this.availabilityZone = availabilityZone;
            this.imageId = imageId;
            this.instanceType = instanceType;
            this.numInstances = numInstances;
        }

        private RunInstancesType runInstances() {
            AccountFullName systemAcct = AccountFullName.getInstance((Account)Principals.systemAccount(), (String[])new String[0]);
            LOG.info((Object)("runInstances with zone=" + this.availabilityZone + ", account=" + systemAcct));
            RunInstancesType runInstances = new RunInstancesType();
            runInstances.setImageId(this.imageId);
            runInstances.setInstanceType(this.instanceType);
            if (this.groupName != null) {
                runInstances.setSecurityGroups(Lists.newArrayList((Object[])new GroupItemType[]{new GroupItemType(this.groupName, null)}));
            }
            if (this.availabilityZone != null) {
                runInstances.setAvailabilityZone(this.availabilityZone);
            }
            runInstances.setMinCount(Math.max(1, this.numInstances));
            runInstances.setMaxCount(Math.max(1, this.numInstances));
            runInstances.setUserData(this.userData);
            return runInstances;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.runInstances(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            ArrayList instanceIds = Lists.newArrayList();
            RunInstancesResponseType resp = (RunInstancesResponseType)response;
            for (RunningInstancesItemType item : resp.getRsvInfo().getInstancesSet()) {
                instanceIds.add(item.getInstanceId());
            }
            this.instanceIds.set((List<String>)ImmutableList.copyOf((Collection)instanceIds));
        }

        void setUserData(String userData) {
            this.userData = userData;
        }

        void setSecurityGroup(String groupName) {
            this.groupName = groupName;
        }

        List<String> getInstanceIds() {
            return this.instanceIds.get();
        }
    }

    private class ComputeDescribeSecurityGroupTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        private List<String> groups = null;
        private List<SecurityGroupItemType> result = null;

        ComputeDescribeSecurityGroupTask(List<String> groups) {
            this.groups = groups;
        }

        private DescribeSecurityGroupsType describeSecurityGroups() {
            DescribeSecurityGroupsType req = new DescribeSecurityGroupsType();
            req.setSecurityGroupSet(Lists.newArrayList(this.groups));
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.describeSecurityGroups(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            DescribeSecurityGroupsResponseType resp = (DescribeSecurityGroupsResponseType)response;
            this.result = resp.getSecurityGroupInfo();
        }

        public List<SecurityGroupItemType> getResult() {
            return this.result;
        }
    }

    private class ComputeDeleteGroupTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        private String groupName = null;

        ComputeDeleteGroupTask(String groupName) {
            this.groupName = groupName;
        }

        private DeleteSecurityGroupType deleteSecurityGroup() {
            DeleteSecurityGroupType req = new DeleteSecurityGroupType();
            req.setGroupName(this.groupName);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteSecurityGroup(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            DeleteSecurityGroupResponseType resp = (DeleteSecurityGroupResponseType)response;
        }
    }

    private class ComputeRevokeIngressRuleTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        String groupName = null;
        String protocol = null;
        int portNum = 1;

        ComputeRevokeIngressRuleTask(String groupName, String protocol, int portNum) {
            this.groupName = groupName;
            this.protocol = protocol;
            this.portNum = portNum;
        }

        private RevokeSecurityGroupIngressType revoke() {
            RevokeSecurityGroupIngressType req = new RevokeSecurityGroupIngressType();
            req.setGroupName(this.groupName);
            IpPermissionType perm = new IpPermissionType();
            perm.setFromPort(Integer.valueOf(this.portNum));
            perm.setToPort(Integer.valueOf(this.portNum));
            perm.setCidrIpRanges((Collection)Lists.newArrayList(Arrays.asList("0.0.0.0/0")));
            perm.setIpProtocol(this.protocol);
            req.setIpPermissions(Lists.newArrayList(Arrays.asList(perm)));
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.revoke(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            RevokeSecurityGroupIngressResponseType resp = (RevokeSecurityGroupIngressResponseType)response;
        }
    }

    private class ComputeAuthorizeIngressRuleTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        String groupName = null;
        String protocol = null;
        int portNum = 1;

        ComputeAuthorizeIngressRuleTask(String groupName, String protocol, int portNum) {
            this.protocol = protocol;
            this.groupName = groupName;
            this.portNum = portNum;
        }

        private AuthorizeSecurityGroupIngressType authorize() {
            AuthorizeSecurityGroupIngressType req = new AuthorizeSecurityGroupIngressType();
            req.setGroupName(this.groupName);
            IpPermissionType perm = new IpPermissionType();
            perm.setFromPort(Integer.valueOf(this.portNum));
            perm.setToPort(Integer.valueOf(this.portNum));
            perm.setCidrIpRanges((Collection)Lists.newArrayList(Arrays.asList("0.0.0.0/0")));
            perm.setIpProtocol(this.protocol);
            req.setIpPermissions(Lists.newArrayList(Arrays.asList(perm)));
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.authorize(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            AuthorizeSecurityGroupIngressResponseType resp = (AuthorizeSecurityGroupIngressResponseType)response;
        }
    }

    private class ComputeCreateGroupTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        private String groupName = null;
        private String groupDesc = null;
        private String groupId = null;

        ComputeCreateGroupTask(String groupName, String groupDesc) {
            this.groupName = groupName;
            this.groupDesc = groupDesc;
        }

        private CreateSecurityGroupType createSecurityGroup() {
            CreateSecurityGroupType req = new CreateSecurityGroupType();
            req.setGroupName(this.groupName);
            req.setGroupDescription(this.groupDesc);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.createSecurityGroup(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            CreateSecurityGroupResponseType resp = (CreateSecurityGroupResponseType)response;
            this.groupId = resp.getGroupId();
        }

        public String getGroupId() {
            return this.groupId;
        }
    }

    private class ComputeTerminateInstanceTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        private final List<String> instanceIds;
        private final AtomicReference<List<String>> terminatedIds = new AtomicReference();

        private ComputeTerminateInstanceTask(List<String> instanceId) {
            this.instanceIds = instanceId;
        }

        private TerminateInstancesType terminateInstances() {
            TerminateInstancesType req = new TerminateInstancesType();
            req.setInstancesSet(Lists.newArrayList(this.instanceIds));
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.terminateInstances(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            TerminateInstancesResponseType resp = (TerminateInstancesResponseType)response;
            this.terminatedIds.set(Lists.transform((List)resp.getInstancesSet(), (Function)new Function<TerminateInstancesItemType, String>(){

                public String apply(TerminateInstancesItemType item) {
                    return item.getInstanceId();
                }
            }));
        }

        List<String> getTerminatedInstances() {
            return this.terminatedIds.get();
        }
    }

    private class ComputeDescribeInstanceTask
    extends EucalyptusClientTask<ComputeMessage, Compute> {
        private final List<String> instanceIds;
        private final AtomicReference<List<RunningInstancesItemType>> result = new AtomicReference();

        private ComputeDescribeInstanceTask(List<String> instanceId) {
            this.instanceIds = instanceId;
        }

        private DescribeInstancesType describeInstances() {
            DescribeInstancesType req = new DescribeInstancesType();
            req.setInstancesSet(Lists.newArrayList(this.instanceIds));
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<ComputeMessage, Compute> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Compute> client = context.getClient();
            client.dispatch((BaseMessage)this.describeInstances(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<ComputeMessage, Compute> context, ComputeMessage response) {
            DescribeInstancesResponseType resp = (DescribeInstancesResponseType)response;
            ArrayList resultInstances = Lists.newArrayList();
            for (ReservationInfoType res : resp.getReservationSet()) {
                resultInstances.addAll(res.getInstancesSet());
            }
            this.result.set(resultInstances);
        }

        public List<RunningInstancesItemType> getResult() {
            return this.result.get();
        }
    }

    private class Ec2Context
    extends AbstractClientContext<ComputeMessage, Compute> {
        private Ec2Context(String userId) {
            super(userId, Compute.class);
        }
    }
}

