/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.resources.client;

import com.eucalyptus.component.id.Dns;
import com.eucalyptus.resources.EucalyptusActivityException;
import com.eucalyptus.resources.client.AbstractClientContext;
import com.eucalyptus.resources.client.ClientContext;
import com.eucalyptus.resources.client.EucalyptusClientTask;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.DispatchingClient;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.CheckedListenableFuture;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.DnsMessage;
import edu.ucsb.eucalyptus.msgs.RemoveMultiANameResponseType;
import edu.ucsb.eucalyptus.msgs.RemoveMultiANameType;
import edu.ucsb.eucalyptus.msgs.RemoveMultiARecordResponseType;
import edu.ucsb.eucalyptus.msgs.RemoveMultiARecordType;

public class DnsClient {
    private static DnsClient _instance = null;

    private DnsClient() {
    }

    public static DnsClient getInstance() {
        if (_instance == null) {
            _instance = new DnsClient();
        }
        return _instance;
    }

    public void removeARecord(String zone, String name, String address) {
        DnsRemoveARecordTask task = new DnsRemoveARecordTask(zone, name, address);
        CheckedListenableFuture<Boolean> result = task.dispatch(new DnsContext(null));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to remove A record ");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void removeMultiARecord(String zone, String name) {
        DnsRemoveMultiARecordTask task = new DnsRemoveMultiARecordTask(zone, name);
        CheckedListenableFuture<Boolean> result = task.dispatch(new DnsContext(null));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to remove multi A records ");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private class DnsRemoveMultiARecordTask
    extends EucalyptusClientTask<DnsMessage, Dns> {
        private String zone = null;
        private String name = null;

        private DnsRemoveMultiARecordTask(String zone, String name) {
            this.zone = zone;
            this.name = name;
        }

        private RemoveMultiANameType removeARecord() {
            RemoveMultiANameType req = new RemoveMultiANameType();
            req.setZone(this.zone);
            req.setName(this.name);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<DnsMessage, Dns> context, Callback.Checked<DnsMessage> callback) {
            DispatchingClient<DnsMessage, Dns> client = context.getClient();
            client.dispatch((BaseMessage)this.removeARecord(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<DnsMessage, Dns> context, DnsMessage response) {
            RemoveMultiANameResponseType resp = (RemoveMultiANameResponseType)response;
        }
    }

    private class DnsRemoveARecordTask
    extends EucalyptusClientTask<DnsMessage, Dns> {
        private String zone = null;
        private String name = null;
        private String address = null;

        private DnsRemoveARecordTask(String zone, String name, String address) {
            this.zone = zone;
            this.name = name;
            this.address = address;
        }

        private RemoveMultiARecordType removeARecord() {
            RemoveMultiARecordType req = new RemoveMultiARecordType();
            req.setZone(this.zone);
            req.setName(this.name);
            req.setAddress(this.address);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<DnsMessage, Dns> context, Callback.Checked<DnsMessage> callback) {
            DispatchingClient<DnsMessage, Dns> client = context.getClient();
            client.dispatch((BaseMessage)this.removeARecord(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<DnsMessage, Dns> context, DnsMessage response) {
            RemoveMultiARecordResponseType resp = (RemoveMultiARecordResponseType)response;
        }
    }

    private class DnsContext
    extends AbstractClientContext<DnsMessage, Dns> {
        private DnsContext(String userId) {
            super(userId, Dns.class);
        }
    }
}

