/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.resources.client;

import com.eucalyptus.cloudwatch.common.CloudWatch;
import com.eucalyptus.cloudwatch.common.msgs.CloudWatchMessage;
import com.eucalyptus.cloudwatch.common.msgs.MetricData;
import com.eucalyptus.cloudwatch.common.msgs.PutMetricDataResponseType;
import com.eucalyptus.cloudwatch.common.msgs.PutMetricDataType;
import com.eucalyptus.resources.EucalyptusActivityException;
import com.eucalyptus.resources.client.AbstractClientContext;
import com.eucalyptus.resources.client.ClientContext;
import com.eucalyptus.resources.client.EucalyptusClientTask;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.DispatchingClient;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.CheckedListenableFuture;
import edu.ucsb.eucalyptus.msgs.BaseMessage;

public class CloudWatchClient {
    private static CloudWatchClient _instance = null;

    private CloudWatchClient() {
    }

    public static CloudWatchClient getInstance() {
        if (_instance == null) {
            _instance = new CloudWatchClient();
        }
        return _instance;
    }

    public void putCloudWatchMetricData(String userId, String namespace, MetricData data) {
        CloudWatchPutMetricDataTask task = new CloudWatchPutMetricDataTask(namespace, data);
        CheckedListenableFuture<Boolean> result = task.dispatch(new CloudWatchContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to remove multi A records");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private class CloudWatchPutMetricDataTask
    extends EucalyptusClientTask<CloudWatchMessage, CloudWatch> {
        private MetricData metricData = null;
        private String namespace = null;

        private CloudWatchPutMetricDataTask(String namespace, MetricData data) {
            this.namespace = namespace;
            this.metricData = data;
        }

        private PutMetricDataType putMetricData() {
            PutMetricDataType request = new PutMetricDataType();
            request.setNamespace(this.namespace);
            request.setMetricData(this.metricData);
            return request;
        }

        @Override
        void dispatchInternal(ClientContext<CloudWatchMessage, CloudWatch> context, Callback.Checked<CloudWatchMessage> callback) {
            DispatchingClient<CloudWatchMessage, CloudWatch> client = context.getClient();
            client.dispatch((BaseMessage)this.putMetricData(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<CloudWatchMessage, CloudWatch> context, CloudWatchMessage response) {
            PutMetricDataResponseType resp = (PutMetricDataResponseType)response;
        }
    }

    private class CloudWatchContext
    extends AbstractClientContext<CloudWatchMessage, CloudWatch> {
        private CloudWatchContext(String userId) {
            super(userId, CloudWatch.class);
        }
    }
}

