/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.resources.client;

import com.eucalyptus.autoscaling.common.AutoScaling;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupNames;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingMessage;
import com.eucalyptus.autoscaling.common.msgs.AvailabilityZones;
import com.eucalyptus.autoscaling.common.msgs.CreateAutoScalingGroupResponseType;
import com.eucalyptus.autoscaling.common.msgs.CreateAutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.CreateLaunchConfigurationResponseType;
import com.eucalyptus.autoscaling.common.msgs.CreateLaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.CreateOrUpdateTagsResponseType;
import com.eucalyptus.autoscaling.common.msgs.CreateOrUpdateTagsType;
import com.eucalyptus.autoscaling.common.msgs.DeleteAutoScalingGroupResponseType;
import com.eucalyptus.autoscaling.common.msgs.DeleteAutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.DeleteLaunchConfigurationResponseType;
import com.eucalyptus.autoscaling.common.msgs.DeleteLaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.DeleteTagsResponseType;
import com.eucalyptus.autoscaling.common.msgs.DeleteTagsType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsType;
import com.eucalyptus.autoscaling.common.msgs.DescribeLaunchConfigurationsResponseType;
import com.eucalyptus.autoscaling.common.msgs.DescribeLaunchConfigurationsType;
import com.eucalyptus.autoscaling.common.msgs.DescribeTagsResponseType;
import com.eucalyptus.autoscaling.common.msgs.DescribeTagsType;
import com.eucalyptus.autoscaling.common.msgs.LaunchConfigurationNames;
import com.eucalyptus.autoscaling.common.msgs.LaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.SecurityGroups;
import com.eucalyptus.autoscaling.common.msgs.SetDesiredCapacityResponseType;
import com.eucalyptus.autoscaling.common.msgs.SetDesiredCapacityType;
import com.eucalyptus.autoscaling.common.msgs.TagDescription;
import com.eucalyptus.autoscaling.common.msgs.TagType;
import com.eucalyptus.autoscaling.common.msgs.Tags;
import com.eucalyptus.autoscaling.common.msgs.UpdateAutoScalingGroupResponseType;
import com.eucalyptus.autoscaling.common.msgs.UpdateAutoScalingGroupType;
import com.eucalyptus.resources.EucalyptusActivityException;
import com.eucalyptus.resources.client.AbstractClientContext;
import com.eucalyptus.resources.client.ClientContext;
import com.eucalyptus.resources.client.EucalyptusClientTask;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.DispatchingClient;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.List;
import org.apache.log4j.Logger;

public class AutoScalingClient {
    private static final Logger LOG = Logger.getLogger(AutoScalingClient.class);
    private static AutoScalingClient _instance = null;

    private AutoScalingClient() {
    }

    public static AutoScalingClient getInstance() {
        if (_instance == null) {
            _instance = new AutoScalingClient();
        }
        return _instance;
    }

    public void createLaunchConfiguration(String userId, String imageId, String instanceType, String instanceProfileName, String launchConfigName, String securityGroup, String keyName, String userData) {
        AutoScalingCreateLaunchConfigTask task = new AutoScalingCreateLaunchConfigTask(imageId, instanceType, instanceProfileName, launchConfigName, securityGroup, keyName, userData);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to create launch configuration");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void createAutoScalingGroup(String userId, String groupName, List<String> availabilityZones, int capacity, String launchConfigName, String tagKey, String tagValue) {
        AutoScalingCreateGroupTask task = new AutoScalingCreateGroupTask(groupName, availabilityZones, capacity, launchConfigName, tagKey, tagValue);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to create autoscaling group");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public LaunchConfigurationType describeLaunchConfiguration(String userId, String launchConfigName) {
        AutoScalingDescribeLaunchConfigsTask task = new AutoScalingDescribeLaunchConfigsTask(launchConfigName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue() && task.getResult() != null) {
                return task.getResult();
            }
            throw new EucalyptusActivityException("failed to describe launch configuration");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteLaunchConfiguration(String userId, String launchConfigName) {
        AutoScalingDeleteLaunchConfigTask task = new AutoScalingDeleteLaunchConfigTask(launchConfigName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete launch configuration");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteAutoScalingGroup(String userId, String groupName, boolean terminateInstances) {
        AutoScalingDeleteGroupTask task = new AutoScalingDeleteGroupTask(groupName, terminateInstances);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete autoscaling group");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public DescribeAutoScalingGroupsResponseType describeAutoScalingGroups(String userId, List<String> groupNames) {
        AutoScalingDescribeGroupsTask task = new AutoScalingDescribeGroupsTask(groupNames);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResponse();
            }
            throw new EucalyptusActivityException("failed to describe autoscaling groups");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void updateAutoScalingGroup(String userId, String groupName, List<String> zones, int capacity) {
        this.updateAutoScalingGroup(userId, groupName, zones, capacity, null);
    }

    public void updateAutoScalingGroup(String userId, String groupName, List<String> zones, int capacity, String launchConfigName) {
        AutoScalingUpdateGroupTask task = new AutoScalingUpdateGroupTask(groupName, zones, capacity, launchConfigName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to update autoscaling group");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void setAutoScalingDesiredCapacity(String userId, String groupName, int capacity) {
        AutoScalingSetDesiredCapacityTask task = new AutoScalingSetDesiredCapacityTask(groupName, capacity);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to set autoscaling group capacity");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void createOrUpdateAutoscalingTags(String userId, String tagKey, String tagValue, String asgName) {
        AutoscalingCreateOrUpdateTagsTask task = new AutoscalingCreateOrUpdateTagsTask(tagKey, tagValue, asgName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to create/update autoscaling tags");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<TagDescription> describeAutoScalingTags(String userId) {
        AutoScalingDescribeTagsTask task = new AutoScalingDescribeTagsTask();
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getTags();
            }
            throw new EucalyptusActivityException("failed to describe tags");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteAutoscalingTags(String userId, String tagKey, String tagValue, String asgName) {
        AutoscalingDeleteTagsTask task = new AutoscalingDeleteTagsTask(tagKey, tagValue, asgName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingContext(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete autoscaling tags");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private class AutoScalingDescribeTagsTask
    extends EucalyptusClientTask<AutoScalingMessage, AutoScaling> {
        private List<TagDescription> result = null;

        private AutoScalingDescribeTagsTask() {
        }

        private DescribeTagsType describeTags() {
            DescribeTagsType req = new DescribeTagsType();
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.describeTags(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            DescribeTagsResponseType resp = (DescribeTagsResponseType)response;
            if (resp.getDescribeTagsResult() != null && resp.getDescribeTagsResult().getTags() != null) {
                this.result = resp.getDescribeTagsResult().getTags().getMember();
            }
        }

        public List<TagDescription> getTags() {
            return this.result;
        }
    }

    private class AutoscalingCreateOrUpdateTagsTask
    extends EucalyptusClientTask<AutoScalingMessage, AutoScaling> {
        private String tagKey = null;
        private String tagValue = null;
        private String asgName = null;

        private AutoscalingCreateOrUpdateTagsTask(String tagKey, String tagValue, String asgName) {
            this.tagKey = tagKey;
            this.tagValue = tagValue;
            this.asgName = asgName;
        }

        private CreateOrUpdateTagsType createOrUpdateTags() {
            CreateOrUpdateTagsType req = new CreateOrUpdateTagsType();
            Tags tags = new Tags();
            TagType tag = new TagType();
            tag.setKey(this.tagKey);
            tag.setValue(this.tagValue);
            tag.setPropagateAtLaunch(Boolean.valueOf(true));
            tag.setResourceType("auto-scaling-group");
            tag.setResourceId(this.asgName);
            tags.setMember(Lists.newArrayList((Object[])new TagType[]{tag}));
            req.setTags(tags);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.createOrUpdateTags(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            CreateOrUpdateTagsResponseType resp = (CreateOrUpdateTagsResponseType)response;
        }
    }

    private class AutoscalingDeleteTagsTask
    extends EucalyptusClientTask<AutoScalingMessage, AutoScaling> {
        private String tagKey = null;
        private String tagValue = null;
        private String asgName = null;

        private AutoscalingDeleteTagsTask(String tagKey, String tagValue, String asgName) {
            this.tagKey = tagKey;
            this.tagValue = tagValue;
            this.asgName = asgName;
        }

        private DeleteTagsType deleteTags() {
            DeleteTagsType req = new DeleteTagsType();
            Tags tags = new Tags();
            TagType tag = new TagType();
            tag.setKey(this.tagKey);
            tag.setValue(this.tagValue);
            tag.setPropagateAtLaunch(Boolean.valueOf(true));
            tag.setResourceType("auto-scaling-group");
            tag.setResourceId(this.asgName);
            tags.setMember(Lists.newArrayList((Object[])new TagType[]{tag}));
            req.setTags(tags);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteTags(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            DeleteTagsResponseType resp = (DeleteTagsResponseType)response;
        }
    }

    private class AutoScalingCreateLaunchConfigTask
    extends EucalyptusClientTask<AutoScalingMessage, AutoScaling> {
        private String imageId = null;
        private String instanceType = null;
        private String instanceProfileName = null;
        private String launchConfigName = null;
        private String securityGroup = null;
        private String keyName = null;
        private String userData = null;

        private AutoScalingCreateLaunchConfigTask(String imageId, String instanceType, String instanceProfileName, String launchConfigName, String sgroupName, String keyName, String userData) {
            this.imageId = imageId;
            this.instanceType = instanceType;
            this.instanceProfileName = instanceProfileName;
            this.launchConfigName = launchConfigName;
            this.securityGroup = sgroupName;
            this.keyName = keyName;
            this.userData = userData;
        }

        private CreateLaunchConfigurationType createLaunchConfiguration() {
            CreateLaunchConfigurationType req = new CreateLaunchConfigurationType();
            req.setImageId(this.imageId);
            req.setInstanceType(this.instanceType);
            if (this.instanceProfileName != null) {
                req.setIamInstanceProfile(this.instanceProfileName);
            }
            if (this.keyName != null) {
                req.setKeyName(this.keyName);
            }
            req.setLaunchConfigurationName(this.launchConfigName);
            SecurityGroups groups = new SecurityGroups();
            groups.setMember(Lists.newArrayList());
            groups.getMember().add(this.securityGroup);
            req.setSecurityGroups(groups);
            req.setUserData(this.userData);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.createLaunchConfiguration(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            CreateLaunchConfigurationResponseType resp = (CreateLaunchConfigurationResponseType)response;
        }
    }

    private class AutoScalingDescribeLaunchConfigsTask
    extends EucalyptusClientTask<AutoScalingMessage, AutoScaling> {
        private String launchConfigName = null;
        private LaunchConfigurationType result = null;

        private AutoScalingDescribeLaunchConfigsTask(String launchConfigName) {
            this.launchConfigName = launchConfigName;
        }

        private DescribeLaunchConfigurationsType describeLaunchConfigurations() {
            DescribeLaunchConfigurationsType req = new DescribeLaunchConfigurationsType();
            LaunchConfigurationNames names = new LaunchConfigurationNames();
            names.setMember(Lists.newArrayList((Object[])new String[]{this.launchConfigName}));
            req.setLaunchConfigurationNames(names);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.describeLaunchConfigurations(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            DescribeLaunchConfigurationsResponseType resp = (DescribeLaunchConfigurationsResponseType)response;
            try {
                this.result = (LaunchConfigurationType)resp.getDescribeLaunchConfigurationsResult().getLaunchConfigurations().getMember().get(0);
            }
            catch (Exception ex) {
                LOG.error((Object)"Launch configuration is not found from the response");
            }
        }

        private LaunchConfigurationType getResult() {
            return this.result;
        }
    }

    private class AutoScalingDeleteLaunchConfigTask
    extends EucalyptusClientTask<AutoScalingMessage, AutoScaling> {
        private String launchConfigName = null;

        private AutoScalingDeleteLaunchConfigTask(String launchConfigName) {
            this.launchConfigName = launchConfigName;
        }

        private DeleteLaunchConfigurationType deleteLaunchConfiguration() {
            DeleteLaunchConfigurationType req = new DeleteLaunchConfigurationType();
            req.setLaunchConfigurationName(this.launchConfigName);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteLaunchConfiguration(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            DeleteLaunchConfigurationResponseType resp = (DeleteLaunchConfigurationResponseType)response;
        }
    }

    private class AutoScalingDeleteGroupTask
    extends EucalyptusClientTask<AutoScalingMessage, AutoScaling> {
        private String groupName = null;
        private boolean terminateInstances = false;

        private AutoScalingDeleteGroupTask(String groupName, boolean terminateInstances) {
            this.groupName = groupName;
            this.terminateInstances = terminateInstances;
        }

        private DeleteAutoScalingGroupType deleteAutoScalingGroup() {
            DeleteAutoScalingGroupType req = new DeleteAutoScalingGroupType();
            req.setAutoScalingGroupName(this.groupName);
            req.setForceDelete(Boolean.valueOf(this.terminateInstances));
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteAutoScalingGroup(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            DeleteAutoScalingGroupResponseType resp = (DeleteAutoScalingGroupResponseType)response;
        }
    }

    private class AutoScalingCreateGroupTask
    extends EucalyptusClientTask<AutoScalingMessage, AutoScaling> {
        private String groupName = null;
        private List<String> availabilityZones = null;
        private int capacity = 1;
        private String launchConfigName = null;
        private String tagKey = null;
        private String tagValue = null;

        private AutoScalingCreateGroupTask(String groupName, List<String> zones, int capacity, String launchConfig, String tagKey, String tagValue) {
            this.groupName = groupName;
            this.availabilityZones = zones;
            this.capacity = capacity;
            this.launchConfigName = launchConfig;
            this.tagKey = tagKey;
            this.tagValue = tagValue;
        }

        private CreateAutoScalingGroupType createAutoScalingGroup() {
            CreateAutoScalingGroupType req = new CreateAutoScalingGroupType();
            req.setAutoScalingGroupName(this.groupName);
            AvailabilityZones zones = new AvailabilityZones();
            zones.setMember(Lists.newArrayList());
            zones.getMember().addAll(this.availabilityZones);
            req.setAvailabilityZones(zones);
            req.setDesiredCapacity(Integer.valueOf(this.capacity));
            req.setMaxSize(Integer.valueOf(this.capacity));
            req.setMinSize(Integer.valueOf(this.capacity));
            req.setHealthCheckType("EC2");
            req.setLaunchConfigurationName(this.launchConfigName);
            if (this.tagKey != null && this.tagValue != null) {
                Tags tags = new Tags();
                TagType tag = new TagType();
                tag.setKey(this.tagKey);
                tag.setValue(this.tagValue);
                tag.setPropagateAtLaunch(Boolean.valueOf(true));
                tag.setResourceType("auto-scaling-group");
                tag.setResourceId(this.groupName);
                tags.setMember(Lists.newArrayList((Object[])new TagType[]{tag}));
                req.setTags(tags);
            }
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.createAutoScalingGroup(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            CreateAutoScalingGroupResponseType resp = (CreateAutoScalingGroupResponseType)response;
        }
    }

    private class AutoScalingDescribeGroupsTask
    extends EucalyptusClientTask<AutoScalingMessage, AutoScaling> {
        private List<String> groupNames = null;
        private DescribeAutoScalingGroupsResponseType response = null;

        private AutoScalingDescribeGroupsTask(List<String> groupNames) {
            this.groupNames = groupNames;
        }

        private DescribeAutoScalingGroupsType describeAutoScalingGroup() {
            DescribeAutoScalingGroupsType req = new DescribeAutoScalingGroupsType();
            AutoScalingGroupNames names = new AutoScalingGroupNames();
            names.setMember(Lists.newArrayList());
            names.getMember().addAll(this.groupNames);
            req.setAutoScalingGroupNames(names);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.describeAutoScalingGroup(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            this.response = (DescribeAutoScalingGroupsResponseType)response;
        }

        public DescribeAutoScalingGroupsResponseType getResponse() {
            return this.response;
        }
    }

    private class AutoScalingUpdateGroupTask
    extends EucalyptusClientTask<AutoScalingMessage, AutoScaling> {
        private String groupName = null;
        private List<String> availabilityZones = null;
        private Integer capacity = null;
        private String launchConfigName = null;

        private AutoScalingUpdateGroupTask(String groupName, List<String> zones, Integer capacity, String launchConfig) {
            this.groupName = groupName;
            this.availabilityZones = zones;
            this.capacity = capacity;
            this.launchConfigName = launchConfig;
        }

        private UpdateAutoScalingGroupType updateAutoScalingGroup() {
            UpdateAutoScalingGroupType req = new UpdateAutoScalingGroupType();
            req.setAutoScalingGroupName(this.groupName);
            if (this.availabilityZones != null && this.availabilityZones.size() > 0) {
                AvailabilityZones zones = new AvailabilityZones();
                zones.setMember(Lists.newArrayList());
                zones.getMember().addAll(this.availabilityZones);
                req.setAvailabilityZones(zones);
            }
            if (this.capacity != null) {
                req.setDesiredCapacity(this.capacity);
                req.setMaxSize(this.capacity);
                req.setMinSize(this.capacity);
            }
            if (this.launchConfigName != null) {
                req.setLaunchConfigurationName(this.launchConfigName);
            }
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.updateAutoScalingGroup(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            UpdateAutoScalingGroupResponseType resp = (UpdateAutoScalingGroupResponseType)response;
        }
    }

    private class AutoScalingSetDesiredCapacityTask
    extends EucalyptusClientTask<AutoScalingMessage, AutoScaling> {
        private String groupName = null;
        private Integer capacity = null;

        private AutoScalingSetDesiredCapacityTask(String groupName, Integer capacity) {
            this.groupName = groupName;
            this.capacity = capacity;
        }

        private SetDesiredCapacityType setDesiredCapacity() {
            SetDesiredCapacityType req = new SetDesiredCapacityType();
            req.setAutoScalingGroupName(this.groupName);
            req.setDesiredCapacity(this.capacity);
            return req;
        }

        @Override
        void dispatchInternal(ClientContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.setDesiredCapacity(), callback);
        }

        @Override
        void dispatchSuccess(ClientContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            SetDesiredCapacityResponseType resp = (SetDesiredCapacityResponseType)response;
        }
    }

    private class AutoScalingContext
    extends AbstractClientContext<AutoScalingMessage, AutoScaling> {
        private AutoScalingContext(String userId) {
            super(userId, AutoScaling.class);
        }
    }
}

