/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.resources.client;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.resources.client.ClientContext;
import com.eucalyptus.util.DispatchingClient;
import com.eucalyptus.util.Exceptions;
import edu.ucsb.eucalyptus.msgs.BaseMessage;

public abstract class AbstractClientContext<TM extends BaseMessage, TC extends ComponentId>
implements ClientContext<TM, TC> {
    String userId = null;
    Class<TC> cls = null;

    protected AbstractClientContext(String userId, Class<TC> cls) {
        this.userId = userId;
        this.cls = cls;
    }

    @Override
    public String getUserId() {
        try {
            if (this.userId == null) {
                return Accounts.lookupSystemAdmin().getUserId();
            }
            return this.userId;
        }
        catch (AuthException ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    @Override
    public DispatchingClient<TM, TC> getClient() {
        try {
            DispatchingClient client = new DispatchingClient(this.getUserId(), this.cls);
            client.init();
            return client;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }
}

