/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.manifest;

import com.eucalyptus.imaging.manifest.FileType;
import com.eucalyptus.imaging.manifest.ImageManifest;
import com.eucalyptus.util.EucalyptusCloudException;
import java.io.IOException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public enum ImportImageManifest implements ImageManifest
{
    INSTANCE;

    private static Logger LOG;

    @Override
    public FileType getFileType() {
        return FileType.RAW;
    }

    @Override
    public String getPartsPath() {
        return "/manifest/import/parts/part";
    }

    @Override
    public String getPartUrlElement() {
        return "get-url";
    }

    @Override
    public boolean signPartUrl() {
        return false;
    }

    @Override
    public String getSizePath() {
        return "/manifest/import/size";
    }

    @Override
    public String getManifest(String location, int maximumSize) throws EucalyptusCloudException {
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
        GetMethod method = new GetMethod(location);
        String s = null;
        try {
            client.executeMethod((HttpMethod)method);
            s = method.getResponseBodyAsString(maximumSize);
            if (s == null) {
                throw new EucalyptusCloudException("Can't download manifest from " + location + " content is null");
            }
        }
        catch (IOException ex) {
            throw new EucalyptusCloudException("Can't download manifest from " + location, (Throwable)ex);
        }
        finally {
            method.releaseConnection();
        }
        return s;
    }

    @Override
    public String getBaseBucket(String location) {
        throw new UnsupportedOperationException();
    }

    static {
        LOG = Logger.getLogger(ImportImageManifest.class);
    }
}

