/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.manifest;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.HttpMethod;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.util.Hashes;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.crypto.Ciphers;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.Signatures;
import com.eucalyptus.imaging.common.UrlValidator;
import com.eucalyptus.imaging.manifest.DownloadManifestException;
import com.eucalyptus.imaging.manifest.FileType;
import com.eucalyptus.imaging.manifest.ImageManifestFile;
import com.eucalyptus.imaging.manifest.InvalidBaseManifestException;
import com.eucalyptus.objectstorage.client.EucaS3Client;
import com.eucalyptus.objectstorage.client.EucaS3ClientFactory;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.XMLParser;
import com.google.common.base.Function;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.net.URL;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DownloadManifestFactory {
    private static Logger LOG = Logger.getLogger(DownloadManifestFactory.class);
    private static final String uuid = Signatures.SHA256withRSA.trySign(Eucalyptus.class, "download-manifests".getBytes());
    public static String DOWNLOAD_MANIFEST_BUCKET_NAME = (uuid != null ? uuid.substring(0, 6) : "system") + "-download-manifests-v2";
    private static String DOWNLOAD_MANIFEST_PREFIX = "DM-";
    private static String MANIFEST_EXPIRATION = "expire";
    private static int DEFAULT_EXPIRE_TIME_HR = 3;

    public static String generateDownloadManifest(ImageManifestFile baseManifest, PublicKey keyToUse, String manifestName, boolean urlForNc) throws DownloadManifestException {
        return DownloadManifestFactory.generateDownloadManifest(baseManifest, keyToUse, manifestName, DEFAULT_EXPIRE_TIME_HR, urlForNc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String generateDownloadManifest(ImageManifestFile baseManifest, PublicKey keyToUse, String manifestName, int expirationHours, boolean urlForNc) throws DownloadManifestException {
        try (EucaS3Client s3Client = EucaS3ClientFactory.getEucaS3ClientForUser((User)Accounts.lookupAwsExecReadAdmin((boolean)true), (int)((int)TimeUnit.MINUTES.toSeconds(15L)));){
            if (!urlForNc) {
                s3Client.refreshEndpoint(true);
            }
            Date expiration = new Date();
            long msec = expiration.getTime() + (long)(3600000 * expirationHours);
            expiration.setTime(msec);
            if (DownloadManifestFactory.objectExist(s3Client, DOWNLOAD_MANIFEST_BUCKET_NAME, DOWNLOAD_MANIFEST_PREFIX + manifestName)) {
                LOG.debug((Object)("Manifest '" + DOWNLOAD_MANIFEST_PREFIX + manifestName + "' is already created and has not expired. Skipping creation"));
                URL s = s3Client.generatePresignedUrl(DOWNLOAD_MANIFEST_BUCKET_NAME, DOWNLOAD_MANIFEST_PREFIX + manifestName, expiration, HttpMethod.GET);
                String string = String.format("%s://imaging@%s%s?%s", s.getProtocol(), s.getAuthority(), s.getPath(), s.getQuery());
                return string;
            }
            LOG.debug((Object)("Manifest '" + DOWNLOAD_MANIFEST_PREFIX + manifestName + "' does not exist"));
            UrlValidator urlValidator = new UrlValidator();
            String manifest = baseManifest.getManifest();
            if (manifest == null) {
                throw new DownloadManifestException("Can't generate download manifest from null base manifest");
            }
            DocumentBuilder builder = XMLParser.getDocBuilder();
            final Document inputSource = builder.parse(new ByteArrayInputStream(manifest.getBytes()));
            if (!"manifest".equals(inputSource.getDocumentElement().getNodeName())) {
                LOG.error((Object)("Expected image manifest. Got " + DownloadManifestFactory.nodeToString(inputSource, false)));
                throw new InvalidBaseManifestException("Base manifest does not have manifest element");
            }
            StringBuilder signatureSrc = new StringBuilder();
            Document manifestDoc = builder.newDocument();
            Element root = manifestDoc.createElement("manifest");
            manifestDoc.appendChild(root);
            Element el = manifestDoc.createElement("version");
            el.appendChild(manifestDoc.createTextNode("2014-01-14"));
            signatureSrc.append(DownloadManifestFactory.nodeToString(el, false));
            root.appendChild(el);
            el = manifestDoc.createElement("file-format");
            el.appendChild(manifestDoc.createTextNode(baseManifest.getManifestType().getFileType().toString()));
            root.appendChild(el);
            signatureSrc.append(DownloadManifestFactory.nodeToString(el, false));
            final XPath xpath = XPathFactory.newInstance().newXPath();
            Function<String, String> xpathHelper = new Function<String, String>(){

                public String apply(String input) {
                    try {
                        return (String)xpath.evaluate(input, inputSource, XPathConstants.STRING);
                    }
                    catch (XPathExpressionException ex) {
                        return null;
                    }
                }
            };
            if (baseManifest.getManifestType().getFileType() == FileType.BUNDLE) {
                String encryptedKey = (String)xpathHelper.apply((Object)"/manifest/image/ec2_encrypted_key");
                String encryptedIV = (String)xpathHelper.apply((Object)"/manifest/image/ec2_encrypted_iv");
                String size = (String)xpathHelper.apply((Object)"/manifest/image/size");
                EncryptedKey encryptKey = DownloadManifestFactory.reEncryptKey(new EncryptedKey(encryptedKey, encryptedIV), keyToUse);
                el = manifestDoc.createElement("bundle");
                Element key = manifestDoc.createElement("encrypted-key");
                key.appendChild(manifestDoc.createTextNode(encryptKey.getKey()));
                Element iv = manifestDoc.createElement("encrypted-iv");
                iv.appendChild(manifestDoc.createTextNode(encryptKey.getIV()));
                el.appendChild(key);
                el.appendChild(iv);
                Element sizeEl = manifestDoc.createElement("unbundled-size");
                sizeEl.appendChild(manifestDoc.createTextNode(size));
                el.appendChild(sizeEl);
                root.appendChild(el);
                signatureSrc.append(DownloadManifestFactory.nodeToString(el, false));
            }
            el = manifestDoc.createElement("image");
            String bundleSize = (String)xpathHelper.apply((Object)baseManifest.getManifestType().getSizePath());
            if (bundleSize == null) {
                throw new InvalidBaseManifestException("Base manifest does not have size element");
            }
            Element size = manifestDoc.createElement("size");
            size.appendChild(manifestDoc.createTextNode(bundleSize));
            el.appendChild(size);
            Element partsEl = manifestDoc.createElement("parts");
            el.appendChild(partsEl);
            NodeList parts = (NodeList)xpath.evaluate(baseManifest.getManifestType().getPartsPath(), inputSource, XPathConstants.NODESET);
            if (parts == null) {
                throw new InvalidBaseManifestException("Base manifest does not have parts");
            }
            for (int i = 0; i < parts.getLength(); ++i) {
                String partKey;
                Node part = parts.item(i);
                String partIndex = part.getAttributes().getNamedItem("index").getNodeValue();
                String partDownloadUrl = partKey = ((Node)xpath.evaluate(baseManifest.getManifestType().getPartUrlElement(), part, XPathConstants.NODE)).getTextContent();
                if (baseManifest.getManifestType().signPartUrl()) {
                    GeneratePresignedUrlRequest generatePresignedUrlRequest = new GeneratePresignedUrlRequest(baseManifest.getBaseBucket(), partKey, HttpMethod.GET);
                    generatePresignedUrlRequest.setExpiration(expiration);
                    URL s = s3Client.generatePresignedUrl(generatePresignedUrlRequest);
                    partDownloadUrl = s.toString();
                } else if (!urlValidator.isEucalyptusUrl(partDownloadUrl)) {
                    throw new DownloadManifestException("Some parts in the manifest are not stored in the OS. Its location is outside Eucalyptus:" + partDownloadUrl);
                }
                Element aPart = manifestDoc.createElement("part");
                Element getUrl = manifestDoc.createElement("get-url");
                getUrl.appendChild(manifestDoc.createTextNode(partDownloadUrl));
                aPart.setAttribute("index", partIndex);
                aPart.appendChild(getUrl);
                partsEl.appendChild(aPart);
            }
            root.appendChild(el);
            signatureSrc.append(DownloadManifestFactory.nodeToString(el, false));
            String signatureData = signatureSrc.toString();
            Element signature = manifestDoc.createElement("signature");
            signature.setAttribute("algorithm", "RSA-SHA256");
            signature.appendChild(manifestDoc.createTextNode(Signatures.SHA256withRSA.trySign(Eucalyptus.class, signatureData.getBytes())));
            root.appendChild(signature);
            String downloadManifest = DownloadManifestFactory.nodeToString(manifestDoc, true);
            DownloadManifestFactory.createManifestsBucketIfNeeded(s3Client);
            DownloadManifestFactory.putManifestData(s3Client, DOWNLOAD_MANIFEST_BUCKET_NAME, DOWNLOAD_MANIFEST_PREFIX + manifestName, downloadManifest, expiration);
            URL s = s3Client.generatePresignedUrl(DOWNLOAD_MANIFEST_BUCKET_NAME, DOWNLOAD_MANIFEST_PREFIX + manifestName, expiration, HttpMethod.GET);
            String string = String.format("%s://imaging@%s%s?%s", s.getProtocol(), s.getAuthority(), s.getPath(), s.getQuery());
            return string;
        }
        catch (Exception ex) {
            LOG.error((Object)"Got an error", (Throwable)ex);
            throw new DownloadManifestException("Can't generate download manifest");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String generatePresignedUrl(String manifestName) throws DownloadManifestException {
        try (EucaS3Client s3Client = EucaS3ClientFactory.getEucaS3ClientForUser((User)Accounts.lookupAwsExecReadAdmin((boolean)true), (int)((int)TimeUnit.MINUTES.toSeconds(15L)));){
            long expirationHours = DEFAULT_EXPIRE_TIME_HR * 2;
            Date expiration = new Date();
            long msec = expiration.getTime() + 3600000L * expirationHours;
            expiration.setTime(msec);
            URL s = s3Client.generatePresignedUrl(DOWNLOAD_MANIFEST_BUCKET_NAME, DOWNLOAD_MANIFEST_PREFIX + manifestName, expiration, HttpMethod.GET);
            String string = String.format("%s://imaging@%s%s?%s", s.getProtocol(), s.getAuthority(), s.getPath(), s.getQuery());
            return string;
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to generate presigned url", (Throwable)ex);
            throw new DownloadManifestException("Failed to generate presigned url", ex);
        }
    }

    private static final String nodeToString(Node node, boolean addDeclaration) throws Exception {
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("encoding", "UTF-8");
        if (!addDeclaration) {
            tf.setOutputProperty("omit-xml-declaration", "yes");
        }
        StringWriter out = new StringWriter();
        tf.transform(new DOMSource(node), new StreamResult(out));
        return ((Object)out).toString();
    }

    private static EncryptedKey reEncryptKey(EncryptedKey in, PublicKey keyToUse) throws Exception {
        PrivateKey pk = SystemCredentials.lookup(Eucalyptus.class).getPrivateKey();
        Cipher cipher = Ciphers.RSA_PKCS1.get();
        cipher.init(2, (Key)pk, (SecureRandom)Crypto.getSecureRandomSupplier().get());
        byte[] key = cipher.doFinal(Hashes.hexToBytes((String)in.getKey()));
        byte[] iv = cipher.doFinal(Hashes.hexToBytes((String)in.getIV()));
        cipher.init(1, (Key)keyToUse, (SecureRandom)Crypto.getSecureRandomSupplier().get());
        return new EncryptedKey(Hashes.bytesToHex((byte[])cipher.doFinal(key)), Hashes.bytesToHex((byte[])cipher.doFinal(iv)));
    }

    private static void putManifestData(@Nonnull EucaS3Client s3Client, String bucketName, String objectName, String data, Date expiration) throws EucalyptusCloudException {
        int retries = 3;
        long backoffTime = 500L;
        for (int i = 0; i < retries; ++i) {
            try {
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put(MANIFEST_EXPIRATION, Long.toString(expiration.getTime()));
                String etag = s3Client.putObjectContent(bucketName, objectName, data, metadata);
                LOG.debug((Object)("Added manifest to " + bucketName + "/" + objectName + " Etag: " + etag));
                return;
            }
            catch (AmazonClientException e) {
                LOG.warn((Object)("Upload error while trying to upload manifest data. Attempt: " + String.valueOf(i + 1) + " of " + String.valueOf(retries)), (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn((Object)("Non-upload error while trying to upload manifest data. Attempt: " + String.valueOf(i + 1) + " of " + String.valueOf(retries)), (Throwable)e);
            }
            try {
                Thread.sleep(backoffTime);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted during backoff sleep for upload.", (Throwable)e);
                throw new EucalyptusCloudException((Throwable)e);
            }
            s3Client.refreshEndpoint();
            backoffTime *= 2L;
        }
        throw new EucalyptusCloudException("Failed to put manifest file: " + bucketName + "/" + objectName + ". Exceeded retry limit");
    }

    private static boolean objectExist(@Nonnull EucaS3Client s3Client, String bucketName, String objectName) throws EucalyptusCloudException {
        try {
            ObjectMetadata metadata = s3Client.getS3Client().getObjectMetadata(bucketName, objectName);
            if (metadata == null || metadata.getUserMetadata() == null) {
                return false;
            }
            Map userData = metadata.getUserMetadata();
            String expire = (String)userData.get(MANIFEST_EXPIRATION);
            if (expire == null) {
                return false;
            }
            Long currentTime = new Date().getTime();
            Long expireTime = Long.parseLong(expire);
            return expireTime > currentTime;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static void createManifestsBucketIfNeeded(@Nonnull EucaS3Client s3Client) throws EucalyptusCloudException {
        Bucket manifestBucket = null;
        try {
            s3Client.getBucketAcl(DOWNLOAD_MANIFEST_BUCKET_NAME);
        }
        catch (AmazonServiceException e1) {
            try {
                manifestBucket = s3Client.createBucket(DOWNLOAD_MANIFEST_BUCKET_NAME);
            }
            catch (Exception e) {
                LOG.error((Object)("Error creating manifest bucket " + DOWNLOAD_MANIFEST_BUCKET_NAME), (Throwable)e);
                throw new EucalyptusCloudException("Failed to create bucket " + DOWNLOAD_MANIFEST_BUCKET_NAME, (Throwable)e);
            }
        }
        BucketLifecycleConfiguration config = s3Client.getBucketLifecycleConfiguration(DOWNLOAD_MANIFEST_BUCKET_NAME);
        if (config.getRules() == null || config.getRules().size() != 1 || ((BucketLifecycleConfiguration.Rule)config.getRules().get(0)).getExpirationInDays() != 1 || !"enabled".equalsIgnoreCase(((BucketLifecycleConfiguration.Rule)config.getRules().get(0)).getStatus()) || !DOWNLOAD_MANIFEST_PREFIX.equals(((BucketLifecycleConfiguration.Rule)config.getRules().get(0)).getPrefix())) {
            try {
                BucketLifecycleConfiguration lc = new BucketLifecycleConfiguration();
                BucketLifecycleConfiguration.Rule expireRule = new BucketLifecycleConfiguration.Rule();
                expireRule.setId("Manifest Expiration Rule");
                expireRule.setPrefix(DOWNLOAD_MANIFEST_PREFIX);
                expireRule.setStatus("Enabled");
                expireRule.setExpirationInDays(1);
                lc = lc.withRules(new BucketLifecycleConfiguration.Rule[]{expireRule});
                s3Client.setBucketLifecycleConfiguration(manifestBucket.getName(), lc);
            }
            catch (Exception e) {
                throw new EucalyptusCloudException("Failed to set bucket lifecycle on bucket " + DOWNLOAD_MANIFEST_BUCKET_NAME, (Throwable)e);
            }
        }
        LOG.debug((Object)("Created bucket for download-manifests " + DOWNLOAD_MANIFEST_BUCKET_NAME));
    }

    private static class EncryptedKey {
        final String key;
        final String IV;

        public EncryptedKey(String key, String IV) {
            this.key = key;
            this.IV = IV;
        }

        public String getKey() {
            return this.key;
        }

        public String getIV() {
            return this.IV;
        }
    }
}

