/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.manifest;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.imaging.manifest.FileType;
import com.eucalyptus.imaging.manifest.ImageManifest;
import com.eucalyptus.objectstorage.client.EucaS3Client;
import com.eucalyptus.objectstorage.client.EucaS3ClientFactory;
import com.eucalyptus.util.EucalyptusCloudException;
import java.util.concurrent.TimeUnit;

public enum BundleImageManifest implements ImageManifest
{
    INSTANCE;


    @Override
    public FileType getFileType() {
        return FileType.BUNDLE;
    }

    @Override
    public String getPartsPath() {
        return "/manifest/image/parts/part";
    }

    @Override
    public String getPartUrlElement() {
        return "filename";
    }

    @Override
    public boolean signPartUrl() {
        return true;
    }

    @Override
    public String getSizePath() {
        return "/manifest/image/bundled_size";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getManifest(String location, int maximumSize) throws EucalyptusCloudException {
        String cleanLocation = location.replaceAll("^/*", "");
        int index = cleanLocation.indexOf(47);
        String bucketName = cleanLocation.substring(0, index);
        String manifestKey = cleanLocation.substring(index + 1);
        try (EucaS3Client s3Client = EucaS3ClientFactory.getEucaS3ClientForUser((User)Accounts.lookupAwsExecReadAdmin((boolean)true), (int)((int)TimeUnit.MINUTES.toSeconds(15L)));){
            String string = s3Client.getObjectContent(bucketName, manifestKey, maximumSize);
            return string;
        }
        catch (Exception e) {
            throw new EucalyptusCloudException("Failed to read manifest file: " + bucketName + "/" + manifestKey, (Throwable)e);
        }
    }

    @Override
    public String getBaseBucket(String location) {
        String cleanLocation = location.replaceAll("^/*", "");
        int index = cleanLocation.indexOf(47);
        return cleanLocation.substring(0, index);
    }
}

