/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.common;

import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.util.dns.DomainNames;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.xbill.DNS.Name;

public class UrlValidator {
    private final List<URI> osgUrls = new ArrayList<URI>();

    public UrlValidator() {
        List osgs = ServiceConfigurations.list(ObjectStorage.class);
        for (ServiceConfiguration conf : osgs) {
            this.osgUrls.add(conf.getUri());
        }
    }

    public boolean isEucalyptusUrl(String url) {
        URI in = null;
        if (url == null) {
            return false;
        }
        try {
            in = new URI(url.startsWith("http") ? url : "http://" + url);
        }
        catch (URISyntaxException e) {
            return false;
        }
        if (DomainNames.isSystemSubdomain((Name)Name.fromConstantString((String)(in.getHost() + ".")))) {
            return true;
        }
        for (URI u : this.osgUrls) {
            if (!u.getHost().equalsIgnoreCase(in.getHost())) continue;
            return true;
        }
        return false;
    }
}

