/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.common;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.euare.AddRoleToInstanceProfileResponseType;
import com.eucalyptus.auth.euare.AddRoleToInstanceProfileType;
import com.eucalyptus.auth.euare.CreateInstanceProfileResponseType;
import com.eucalyptus.auth.euare.CreateInstanceProfileType;
import com.eucalyptus.auth.euare.CreateRoleResponseType;
import com.eucalyptus.auth.euare.CreateRoleType;
import com.eucalyptus.auth.euare.DeleteInstanceProfileResponseType;
import com.eucalyptus.auth.euare.DeleteInstanceProfileType;
import com.eucalyptus.auth.euare.DeleteRolePolicyResponseType;
import com.eucalyptus.auth.euare.DeleteRolePolicyType;
import com.eucalyptus.auth.euare.DeleteRoleResponseType;
import com.eucalyptus.auth.euare.DeleteRoleType;
import com.eucalyptus.auth.euare.DeleteServerCertificateResponseType;
import com.eucalyptus.auth.euare.DeleteServerCertificateType;
import com.eucalyptus.auth.euare.EuareMessage;
import com.eucalyptus.auth.euare.GetRolePolicyResponseType;
import com.eucalyptus.auth.euare.GetRolePolicyResult;
import com.eucalyptus.auth.euare.GetRolePolicyType;
import com.eucalyptus.auth.euare.GetServerCertificateResponseType;
import com.eucalyptus.auth.euare.GetServerCertificateType;
import com.eucalyptus.auth.euare.InstanceProfileType;
import com.eucalyptus.auth.euare.ListInstanceProfilesResponseType;
import com.eucalyptus.auth.euare.ListInstanceProfilesType;
import com.eucalyptus.auth.euare.ListRolesResponseType;
import com.eucalyptus.auth.euare.ListRolesType;
import com.eucalyptus.auth.euare.PutRolePolicyResponseType;
import com.eucalyptus.auth.euare.PutRolePolicyType;
import com.eucalyptus.auth.euare.RemoveRoleFromInstanceProfileResponseType;
import com.eucalyptus.auth.euare.RemoveRoleFromInstanceProfileType;
import com.eucalyptus.auth.euare.RoleType;
import com.eucalyptus.auth.euare.ServerCertificateType;
import com.eucalyptus.auth.euare.UploadServerCertificateResponseType;
import com.eucalyptus.auth.euare.UploadServerCertificateType;
import com.eucalyptus.autoscaling.common.AutoScaling;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupNames;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingMessage;
import com.eucalyptus.autoscaling.common.msgs.AvailabilityZones;
import com.eucalyptus.autoscaling.common.msgs.CreateAutoScalingGroupResponseType;
import com.eucalyptus.autoscaling.common.msgs.CreateAutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.CreateLaunchConfigurationResponseType;
import com.eucalyptus.autoscaling.common.msgs.CreateLaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.CreateOrUpdateTagsResponseType;
import com.eucalyptus.autoscaling.common.msgs.CreateOrUpdateTagsType;
import com.eucalyptus.autoscaling.common.msgs.DeleteAutoScalingGroupResponseType;
import com.eucalyptus.autoscaling.common.msgs.DeleteAutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.DeleteLaunchConfigurationResponseType;
import com.eucalyptus.autoscaling.common.msgs.DeleteLaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.DeleteTagsResponseType;
import com.eucalyptus.autoscaling.common.msgs.DeleteTagsType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsType;
import com.eucalyptus.autoscaling.common.msgs.DescribeLaunchConfigurationsResponseType;
import com.eucalyptus.autoscaling.common.msgs.DescribeLaunchConfigurationsType;
import com.eucalyptus.autoscaling.common.msgs.DescribeTagsResponseType;
import com.eucalyptus.autoscaling.common.msgs.LaunchConfigurationNames;
import com.eucalyptus.autoscaling.common.msgs.LaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.SecurityGroups;
import com.eucalyptus.autoscaling.common.msgs.TagDescription;
import com.eucalyptus.autoscaling.common.msgs.TagType;
import com.eucalyptus.autoscaling.common.msgs.Tags;
import com.eucalyptus.autoscaling.common.msgs.UpdateAutoScalingGroupResponseType;
import com.eucalyptus.autoscaling.common.msgs.UpdateAutoScalingGroupType;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.BlockDeviceMappingItemType;
import com.eucalyptus.compute.common.ClusterInfoType;
import com.eucalyptus.compute.common.ComputeMessage;
import com.eucalyptus.compute.common.DeleteResourceTag;
import com.eucalyptus.compute.common.DescribeKeyPairsResponseItemType;
import com.eucalyptus.compute.common.EbsDeviceMapping;
import com.eucalyptus.compute.common.Filter;
import com.eucalyptus.compute.common.ImageDetails;
import com.eucalyptus.compute.common.InstanceNetworkInterfaceSetItemRequestType;
import com.eucalyptus.compute.common.IpPermissionType;
import com.eucalyptus.compute.common.ReservationInfoType;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.compute.common.Snapshot;
import com.eucalyptus.compute.common.SubnetType;
import com.eucalyptus.compute.common.TagInfo;
import com.eucalyptus.compute.common.VmTypeDetails;
import com.eucalyptus.compute.common.Volume;
import com.eucalyptus.compute.common.backend.AuthorizeSecurityGroupIngressResponseType;
import com.eucalyptus.compute.common.backend.AuthorizeSecurityGroupIngressType;
import com.eucalyptus.compute.common.backend.CreateSecurityGroupResponseType;
import com.eucalyptus.compute.common.backend.CreateSecurityGroupType;
import com.eucalyptus.compute.common.backend.CreateSnapshotResponseType;
import com.eucalyptus.compute.common.backend.CreateSnapshotType;
import com.eucalyptus.compute.common.backend.CreateTagsResponseType;
import com.eucalyptus.compute.common.backend.CreateTagsType;
import com.eucalyptus.compute.common.backend.CreateVolumeResponseType;
import com.eucalyptus.compute.common.backend.CreateVolumeType;
import com.eucalyptus.compute.common.backend.DeleteSecurityGroupResponseType;
import com.eucalyptus.compute.common.backend.DeleteSecurityGroupType;
import com.eucalyptus.compute.common.backend.DeleteVolumeResponseType;
import com.eucalyptus.compute.common.backend.DeleteVolumeType;
import com.eucalyptus.compute.common.backend.DescribeAvailabilityZonesResponseType;
import com.eucalyptus.compute.common.backend.DescribeAvailabilityZonesType;
import com.eucalyptus.compute.common.backend.DescribeImagesResponseType;
import com.eucalyptus.compute.common.backend.DescribeImagesType;
import com.eucalyptus.compute.common.backend.DescribeInstanceTypesResponseType;
import com.eucalyptus.compute.common.backend.DescribeInstanceTypesType;
import com.eucalyptus.compute.common.backend.DescribeInstancesResponseType;
import com.eucalyptus.compute.common.backend.DescribeInstancesType;
import com.eucalyptus.compute.common.backend.DescribeKeyPairsResponseType;
import com.eucalyptus.compute.common.backend.DescribeKeyPairsType;
import com.eucalyptus.compute.common.backend.DescribeSecurityGroupsResponseType;
import com.eucalyptus.compute.common.backend.DescribeSecurityGroupsType;
import com.eucalyptus.compute.common.backend.DescribeSnapshotsResponseType;
import com.eucalyptus.compute.common.backend.DescribeSnapshotsType;
import com.eucalyptus.compute.common.backend.DescribeSubnetsResponseType;
import com.eucalyptus.compute.common.backend.DescribeSubnetsType;
import com.eucalyptus.compute.common.backend.DescribeTagsType;
import com.eucalyptus.compute.common.backend.DescribeVolumesResponseType;
import com.eucalyptus.compute.common.backend.DescribeVolumesType;
import com.eucalyptus.compute.common.backend.RegisterImageResponseType;
import com.eucalyptus.compute.common.backend.RegisterImageType;
import com.eucalyptus.compute.common.backend.RevokeSecurityGroupIngressResponseType;
import com.eucalyptus.compute.common.backend.RevokeSecurityGroupIngressType;
import com.eucalyptus.compute.common.backend.RunInstancesResponseType;
import com.eucalyptus.compute.common.backend.RunInstancesType;
import com.eucalyptus.compute.common.backend.TerminateInstancesResponseType;
import com.eucalyptus.compute.common.backend.TerminateInstancesType;
import com.eucalyptus.empyrean.DescribeServicesResponseType;
import com.eucalyptus.empyrean.DescribeServicesType;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.empyrean.EmpyreanMessage;
import com.eucalyptus.empyrean.ServiceStatusType;
import com.eucalyptus.imaging.common.EucalyptusActivityException;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.DispatchingClient;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.Futures;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class EucalyptusActivityTasks {
    private static final Logger LOG = Logger.getLogger(EucalyptusActivityTask.class);
    private static EucalyptusActivityTasks _instance = new EucalyptusActivityTasks();

    private EucalyptusActivityTasks() {
    }

    public static EucalyptusActivityTasks getInstance() {
        return _instance;
    }

    public void terminateSystemInstance(String instanceId) {
        if (instanceId == null || instanceId.length() == 0) {
            throw new IllegalArgumentException("instanceId must not be null");
        }
        EucalyptusTerminateInstanceTask describeTask = new EucalyptusTerminateInstanceTask(instanceId);
        CheckedListenableFuture<Boolean> result = describeTask.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to terminate instances");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<RunningInstancesItemType> describeSystemInstances(List<String> instances) {
        if (instances.size() <= 0) {
            return Lists.newArrayList();
        }
        EucalyptusDescribeInstanceTask describeTask = new EucalyptusDescribeInstanceTask(instances);
        CheckedListenableFuture<Boolean> result = describeTask.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                List<RunningInstancesItemType> describe = describeTask.getResult();
                return describe;
            }
            throw new EucalyptusActivityException("failed to describe the instances");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<RunningInstancesItemType> describeUserInstances(String userId, List<String> instances) {
        if (instances.size() <= 0) {
            return Lists.newArrayList();
        }
        EucalyptusDescribeInstanceTask describeTask = new EucalyptusDescribeInstanceTask(instances);
        CheckedListenableFuture<Boolean> result = describeTask.dispatch(new EucalyptusUserActivity(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                List<RunningInstancesItemType> describe = describeTask.getResult();
                return describe;
            }
            throw new EucalyptusActivityException("failed to describe the instances");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<ServiceStatusType> describeServices(String componentType) {
        EucalyptusDescribeServicesTask serviceTask = new EucalyptusDescribeServicesTask(componentType);
        CheckedListenableFuture<Boolean> result = serviceTask.dispatch(new EmpyreanSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return serviceTask.getServiceDetais();
            }
            throw new EucalyptusActivityException("failed to describe services");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<VmTypeDetails> describeVMTypes() {
        EucalyptusDescribeVMTypesTask task = new EucalyptusDescribeVMTypesTask();
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusBaseSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                List<VmTypeDetails> describe = task.getVMTypes();
                return describe;
            }
            throw new EucalyptusActivityException("failed to describe the vm types");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<ClusterInfoType> describeAvailabilityZones(boolean verbose) {
        EucalyptusDescribeAvailabilityZonesTask task = new EucalyptusDescribeAvailabilityZonesTask(verbose);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                List<ClusterInfoType> describe = task.getAvailabilityZones();
                return describe;
            }
            throw new EucalyptusActivityException("failed to describe the availability zones");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void createSecurityGroup(String groupName, String groupDesc) {
        EucalyptusCreateGroupTask task = new EucalyptusCreateGroupTask(groupName, groupDesc);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue() && task.getGroupId() != null) {
                return;
            }
            throw new EucalyptusActivityException("failed to create the group " + groupName);
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteSecurityGroup(String groupName) {
        EucalyptusDeleteGroupTask task = new EucalyptusDeleteGroupTask(groupName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete the group " + groupName);
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<SecurityGroupItemType> describeSecurityGroups(List<String> groupNames) {
        EucalyptusDescribeSecurityGroupTask task = new EucalyptusDescribeSecurityGroupTask(groupNames);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResult();
            }
            throw new EucalyptusActivityException("failed to describe security groups");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void authorizeSecurityGroup(String groupName, String protocol, int portNum) {
        EucalyptusAuthorizeIngressRuleTask task = new EucalyptusAuthorizeIngressRuleTask(groupName, protocol, portNum);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException(String.format("failed to authorize:%s, %s, %d ", groupName, protocol, portNum));
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void revokeSecurityGroup(String groupName, String protocol, int portNum) {
        EucalyptusRevokeIngressRuleTask task = new EucalyptusRevokeIngressRuleTask(groupName, protocol, portNum);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException(String.format("failed to revoke:%s, %s, %d ", groupName, protocol, portNum));
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void createLaunchConfiguration(String imageId, String instanceType, String instanceProfileName, String launchConfigName, String securityGroup, String keyName, String userData) {
        AutoScalingCreateLaunchConfigTask task = new AutoScalingCreateLaunchConfigTask(imageId, instanceType, instanceProfileName, launchConfigName, securityGroup, keyName, userData);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to create launch configuration");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void createAutoScalingGroup(String groupName, List<String> availabilityZones, int capacity, String launchConfigName) {
        AutoScalingCreateGroupTask task = new AutoScalingCreateGroupTask(groupName, availabilityZones, capacity, launchConfigName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to create autoscaling group");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public LaunchConfigurationType describeLaunchConfiguration(String launchConfigName) {
        AutoScalingDescribeLaunchConfigsTask task = new AutoScalingDescribeLaunchConfigsTask(launchConfigName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue() && task.getResult() != null) {
                return task.getResult();
            }
            throw new EucalyptusActivityException("failed to describe launch configuration");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteLaunchConfiguration(String launchConfigName) {
        AutoScalingDeleteLaunchConfigTask task = new AutoScalingDeleteLaunchConfigTask(launchConfigName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete launch configuration");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteAutoScalingGroup(String groupName, boolean terminateInstances) {
        AutoScalingDeleteGroupTask task = new AutoScalingDeleteGroupTask(groupName, terminateInstances);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete autoscaling group");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public DescribeAutoScalingGroupsResponseType describeAutoScalingGroups(List<String> groupNames) {
        AutoScalingDescribeGroupsTask task = new AutoScalingDescribeGroupsTask(groupNames);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResponse();
            }
            throw new EucalyptusActivityException("failed to describe autoscaling groups");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void updateAutoScalingGroup(String groupName, List<String> zones, int capacity) {
        this.updateAutoScalingGroup(groupName, zones, capacity, null);
    }

    public void updateAutoScalingGroup(String groupName, List<String> zones, int capacity, String launchConfigName) {
        AutoScalingUpdateGroupTask task = new AutoScalingUpdateGroupTask(groupName, zones, capacity, launchConfigName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to enable zones in autoscaling group");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<RoleType> listRoles(String pathPrefix) {
        EuareListRolesTask task = new EuareListRolesTask(pathPrefix);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getRoles();
            }
            throw new EucalyptusActivityException("failed to list IAM roles");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public RoleType createRole(String roleName, String path, String assumeRolePolicy) {
        EuareCreateRoleTask task = new EuareCreateRoleTask(roleName, path, assumeRolePolicy);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getRole();
            }
            throw new EucalyptusActivityException("failed to create IAM role");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<SubnetType> describeSubnetsAsUser(String userId, Set<String> subnetIds) {
        try {
            DescribeSubnetsType describeSubnetsType = new DescribeSubnetsType();
            describeSubnetsType.setUserId(userId);
            describeSubnetsType.markPrivileged();
            Filter filter = new Filter();
            filter.setName("subnet-id");
            filter.setValueSet(Lists.newArrayList(subnetIds));
            describeSubnetsType.getFilterSet().add(filter);
            DescribeSubnetsResponseType response = (DescribeSubnetsResponseType)AsyncRequests.sendSync(Eucalyptus.class, (BaseMessage)describeSubnetsType);
            return response.getSubnetSet().getItem();
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<DescribeKeyPairsResponseItemType> describeKeyPairsAsUser(String userId, List<String> keyNames) {
        EucaDescribeKeyPairsTask task = new EucaDescribeKeyPairsTask(keyNames);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusUserActivity(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResult();
            }
            throw new EucalyptusActivityException("failed to describe keypairs");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<DescribeKeyPairsResponseItemType> describeKeyPairs(List<String> keyNames) {
        EucaDescribeKeyPairsTask task = new EucaDescribeKeyPairsTask(keyNames);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResult();
            }
            throw new EucalyptusActivityException("failed to describe keypairs");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public ServerCertificateType getServerCertificate(String userId, String certName) {
        EuareGetServerCertificateTask task = new EuareGetServerCertificateTask(certName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareUserActivity(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getServerCertificate();
            }
            throw new EucalyptusActivityException("failed to get server certificate");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteRole(String roleName) {
        EuareDeleteRoleTask task = new EuareDeleteRoleTask(roleName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete IAM role");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<InstanceProfileType> listInstanceProfiles(String pathPrefix) {
        EuareListInstanceProfilesTask task = new EuareListInstanceProfilesTask(pathPrefix);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getInstanceProfiles();
            }
            throw new EucalyptusActivityException("failed to delete IAM role");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public InstanceProfileType createInstanceProfile(String profileName, String path) {
        EuareCreateInstanceProfileTask task = new EuareCreateInstanceProfileTask(profileName, path);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getInstanceProfile();
            }
            throw new EucalyptusActivityException("failed to create IAM instance profile");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteInstanceProfile(String profileName) {
        EuareDeleteInstanceProfileTask task = new EuareDeleteInstanceProfileTask(profileName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete IAM instance profile");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void addRoleToInstanceProfile(String instanceProfileName, String roleName) {
        EuareAddRoleToInstanceProfileTask task = new EuareAddRoleToInstanceProfileTask(instanceProfileName, roleName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to add role to the instance profile");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void removeRoleFromInstanceProfile(String instanceProfileName, String roleName) {
        EuareRemoveRoleFromInstanceProfileTask task = new EuareRemoveRoleFromInstanceProfileTask(instanceProfileName, roleName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to remove role from the instance profile");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public GetRolePolicyResult getRolePolicy(String roleName, String policyName) {
        EuareGetRolePolicyTask task = new EuareGetRolePolicyTask(roleName, policyName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResult();
            }
            throw new EucalyptusActivityException("failed to get role's policy");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void putRolePolicy(String roleName, String policyName, String policyDocument) {
        EuarePutRolePolicyTask task = new EuarePutRolePolicyTask(roleName, policyName, policyDocument);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to put role's policy");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteRolePolicy(String roleName, String policyName) {
        EuareDeleteRolePolicyTask task = new EuareDeleteRolePolicyTask(roleName, policyName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete role's policy");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<ImageDetails> describeImages(List<String> imageIds, boolean verbose) {
        ArrayList requestedImageIds = Lists.newArrayList();
        if (imageIds != null) {
            requestedImageIds.addAll(imageIds);
        }
        if (verbose) {
            requestedImageIds.add("verbose");
        }
        EucaDescribeImagesTask task = new EucaDescribeImagesTask(imageIds);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResult();
            }
            throw new EucalyptusActivityException("failed to describe images");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void createTags(String tagKey, String tagValue, List<String> resources) {
        EucaCreateTagsTask task = new EucaCreateTagsTask(tagKey, tagValue, resources);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to create tags");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteTags(String tagKey, String tagValue, List<String> resources) {
        EucaDeleteTagsTask task = new EucaDeleteTagsTask(tagKey, tagValue, resources);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete tags");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void createOrUpdateAutoscalingTags(String tagKey, String tagValue, String asgName) {
        AutoscalingCreateOrUpdateTagsTask task = new AutoscalingCreateOrUpdateTagsTask(tagKey, tagValue, asgName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to create/update autoscaling tags");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteAutoscalingTags(String tagKey, String tagValue, String asgName) {
        AutoscalingDeleteTagsTask task = new AutoscalingDeleteTagsTask(tagKey, tagValue, asgName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete autoscaling tags");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void uploadServerCertificate(String certName, String certPath, String certBodyPem, String pkPem, String certChainPem) {
        UploadServerCertificateTask task = new UploadServerCertificateTask(certName, certPath, certBodyPem, pkPem, certChainPem);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to upload server certificate");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public ServerCertificateType getServerCertificate(String certName) {
        EuareGetServerCertificateTask task = new EuareGetServerCertificateTask(certName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getServerCertificate();
            }
            throw new EucalyptusActivityException("failed to get server certificate");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteServerCertificate(String certName) {
        DeleteServerCertificateTask task = new DeleteServerCertificateTask(certName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EuareSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete server certificate");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<TagInfo> describeTags(List<String> names, List<String> values) {
        DescribeTagsTask task = new DescribeTagsTask(names, values);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getTags();
            }
            throw new EucalyptusActivityException("failed to describe tags");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public String createVolumeAsUser(String userId, String availabilityZone, int size) {
        CreateVolumeTask task = new CreateVolumeTask(availabilityZone, size);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusUserActivity(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getVolumeId();
            }
            throw new EucalyptusActivityException("failed to create volume");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public String createVolume(String availabilityZone, int size) {
        CreateVolumeTask task = new CreateVolumeTask(availabilityZone, size);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getVolumeId();
            }
            throw new EucalyptusActivityException("failed to create volume");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<Volume> describeVolumesAsUser(String userId, List<String> volumeIds) {
        DescribeVolumesTask task = new DescribeVolumesTask(volumeIds);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusUserActivity(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getVolumes();
            }
            throw new EucalyptusActivityException("failed to describe volumes");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<Volume> describeVolumes(List<String> volumeIds) {
        DescribeVolumesTask task = new DescribeVolumesTask(volumeIds);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getVolumes();
            }
            throw new EucalyptusActivityException("failed to describe volumes");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<Volume> describeVolumes() {
        DescribeVolumesTask task = new DescribeVolumesTask();
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getVolumes();
            }
            throw new EucalyptusActivityException("failed to describe volumes");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<TagDescription> describeAutoScalingTags() {
        AutoScalingDescribeTagsTask task = new AutoScalingDescribeTagsTask();
        CheckedListenableFuture<Boolean> result = task.dispatch(new AutoScalingSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getTags();
            }
            throw new EucalyptusActivityException("failed to describe tags");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteVolumeAsUser(String userId, String volumeId) {
        DeleteVolumeTask task = new DeleteVolumeTask(volumeId);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusUserActivity(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete volume");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public void deleteVolume(String volumeId) {
        DeleteVolumeTask task = new DeleteVolumeTask(volumeId);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusSystemActivity());
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return;
            }
            throw new EucalyptusActivityException("failed to delete volume");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public String runInstancesAsUser(String userId, String imageId, Set<String> groupNames, String userData, String instanceType, String availabilityZone, String subnetId, String privateIp, boolean monitoring, String keyName) {
        if (userId == null || userId.length() <= 0) {
            throw new IllegalArgumentException("User ID is required");
        }
        if (imageId == null || imageId.length() <= 0) {
            throw new IllegalArgumentException("Image ID is required");
        }
        EucalyptusRunInstancesTask task = new EucalyptusRunInstancesTask(imageId);
        task.setGroupNames(groupNames);
        task.setUserData(userData);
        task.setInstanceType(instanceType);
        task.setAvailabilityZone(availabilityZone);
        task.setSubnetId(subnetId);
        task.setPrivateIp(privateIp);
        task.setMonitoring(monitoring);
        task.setKeyName(keyName);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusUserActivity(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getInstanceId();
            }
            throw new EucalyptusActivityException("failed to run instances");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<Snapshot> describeSnapshotsAsUser(String userId, List<String> snapshotIds) {
        EucalyptusDescribeSnapshotsTask task = new EucalyptusDescribeSnapshotsTask(snapshotIds);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusUserActivity(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getResult();
            }
            throw new EucalyptusActivityException("failed to describe snapshots");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public String registerEBSImageAsUser(String userId, String snapshotId, String imageName, String architecture, String platform, String description, boolean deleteOnTermination) {
        if (userId == null || userId.length() <= 0) {
            throw new IllegalArgumentException("User ID is required");
        }
        if (snapshotId == null || snapshotId.length() <= 0) {
            throw new IllegalArgumentException("Snapshot ID is required");
        }
        if (imageName == null || imageName.length() <= 0) {
            throw new IllegalArgumentException("Image name is required");
        }
        if (architecture == null) {
            architecture = "i386";
        }
        EucalyptusRegisterEBSImageTask task = new EucalyptusRegisterEBSImageTask(snapshotId, imageName, architecture);
        if (platform != null) {
            task.setPlatform(platform);
        }
        if (description != null) {
            task.setDescription(description);
        }
        task.setDeleteOnTermination(deleteOnTermination);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusUserActivity(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getImageId();
            }
            throw new EucalyptusActivityException("failed to register ebs image");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public String createSnapshotAsUser(String userId, String volumeId) {
        if (userId == null || userId.length() <= 0) {
            throw new IllegalArgumentException("User ID is required");
        }
        if (volumeId == null || volumeId.length() <= 0) {
            throw new IllegalArgumentException("Volume ID is required");
        }
        EucalyptusCreateSnapshotTask task = new EucalyptusCreateSnapshotTask(volumeId);
        CheckedListenableFuture<Boolean> result = task.dispatch(new EucalyptusUserActivity(userId));
        try {
            if (((Boolean)result.get()).booleanValue()) {
                return task.getSnapshotId();
            }
            throw new EucalyptusActivityException("failed to create snapshot");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    private abstract class EucalyptusActivityTask<TM extends BaseMessage, TC extends ComponentId> {
        private volatile boolean dispatched = false;

        protected EucalyptusActivityTask() {
        }

        final CheckedListenableFuture<Boolean> dispatch(final ActivityContext<TM, TC> context) {
            try {
                final CheckedListenableFuture future = Futures.newGenericeFuture();
                this.dispatchInternal(context, new Callback.Checked<TM>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void fireException(Throwable throwable) {
                        try {
                            EucalyptusActivityTask.this.dispatchFailure(context, throwable);
                        }
                        finally {
                            future.set((Object)false);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void fire(TM response) {
                        try {
                            EucalyptusActivityTask.this.dispatchSuccess(context, response);
                        }
                        finally {
                            future.set((Object)true);
                        }
                    }
                });
                this.dispatched = true;
                return future;
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                return Futures.predestinedFuture((Object)false);
            }
        }

        abstract void dispatchInternal(ActivityContext<TM, TC> var1, Callback.Checked<TM> var2);

        void dispatchFailure(ActivityContext<TM, TC> context, Throwable throwable) {
            LOG.error((Object)"Eucalyptus activity error", throwable);
        }

        abstract void dispatchSuccess(ActivityContext<TM, TC> var1, TM var2);
    }

    private class EucalyptusDescribeSecurityGroupTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private List<String> groups = null;
        private List<SecurityGroupItemType> result = null;

        EucalyptusDescribeSecurityGroupTask(List<String> groups) {
            this.groups = groups;
        }

        private DescribeSecurityGroupsType describeSecurityGroups() {
            DescribeSecurityGroupsType req = new DescribeSecurityGroupsType();
            req.setSecurityGroupSet(Lists.newArrayList(this.groups));
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.describeSecurityGroups(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            DescribeSecurityGroupsResponseType resp = (DescribeSecurityGroupsResponseType)response;
            this.result = resp.getSecurityGroupInfo();
        }

        public List<SecurityGroupItemType> getResult() {
            return this.result;
        }
    }

    private class EucalyptusDeleteGroupTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String groupName = null;

        EucalyptusDeleteGroupTask(String groupName) {
            this.groupName = groupName;
        }

        private DeleteSecurityGroupType deleteSecurityGroup() {
            DeleteSecurityGroupType req = new DeleteSecurityGroupType();
            req.setGroupName(this.groupName);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteSecurityGroup(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            DeleteSecurityGroupResponseType resp = (DeleteSecurityGroupResponseType)response;
        }
    }

    private class EucalyptusRevokeIngressRuleTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        String groupName = null;
        String protocol = null;
        int portNum = 1;

        EucalyptusRevokeIngressRuleTask(String groupName, String protocol, int portNum) {
            this.groupName = groupName;
            this.protocol = protocol;
            this.portNum = portNum;
        }

        private RevokeSecurityGroupIngressType revoke() {
            RevokeSecurityGroupIngressType req = new RevokeSecurityGroupIngressType();
            req.setGroupName(this.groupName);
            IpPermissionType perm = new IpPermissionType();
            perm.setFromPort(Integer.valueOf(this.portNum));
            perm.setToPort(Integer.valueOf(this.portNum));
            perm.setCidrIpRanges((Collection)Lists.newArrayList(Arrays.asList("0.0.0.0/0")));
            perm.setIpProtocol(this.protocol);
            req.setIpPermissions(Lists.newArrayList(Arrays.asList(perm)));
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.revoke(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            RevokeSecurityGroupIngressResponseType resp = (RevokeSecurityGroupIngressResponseType)response;
        }
    }

    private class EucalyptusAuthorizeIngressRuleTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        String groupName = null;
        String protocol = null;
        int portNum = 1;

        EucalyptusAuthorizeIngressRuleTask(String groupName, String protocol, int portNum) {
            this.protocol = protocol;
            this.groupName = groupName;
            this.portNum = portNum;
        }

        private AuthorizeSecurityGroupIngressType authorize() {
            AuthorizeSecurityGroupIngressType req = new AuthorizeSecurityGroupIngressType();
            req.setGroupName(this.groupName);
            IpPermissionType perm = new IpPermissionType();
            perm.setFromPort(Integer.valueOf(this.portNum));
            perm.setToPort(Integer.valueOf(this.portNum));
            perm.setCidrIpRanges((Collection)Lists.newArrayList(Arrays.asList("0.0.0.0/0")));
            perm.setIpProtocol(this.protocol);
            req.setIpPermissions(Lists.newArrayList(Arrays.asList(perm)));
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.authorize(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            AuthorizeSecurityGroupIngressResponseType resp = (AuthorizeSecurityGroupIngressResponseType)response;
        }
    }

    private class EucalyptusCreateGroupTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String groupName = null;
        private String groupDesc = null;
        private String groupId = null;

        EucalyptusCreateGroupTask(String groupName, String groupDesc) {
            this.groupName = groupName;
            this.groupDesc = groupDesc;
        }

        private CreateSecurityGroupType createSecurityGroup() {
            CreateSecurityGroupType req = new CreateSecurityGroupType();
            req.setGroupName(this.groupName);
            req.setGroupDescription(this.groupDesc);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.createSecurityGroup(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            CreateSecurityGroupResponseType resp = (CreateSecurityGroupResponseType)response;
            this.groupId = resp.getGroupId();
        }

        public String getGroupId() {
            return this.groupId;
        }
    }

    private class EucalyptusDescribeServicesTask
    extends EucalyptusActivityTask<EmpyreanMessage, Empyrean> {
        private String componentType = null;
        private List<ServiceStatusType> services = null;

        private EucalyptusDescribeServicesTask(String componentType) {
            this.componentType = componentType;
        }

        private DescribeServicesType describeServices() {
            DescribeServicesType req = new DescribeServicesType();
            req.setByServiceType(this.componentType);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<EmpyreanMessage, Empyrean> context, Callback.Checked<EmpyreanMessage> callback) {
            DispatchingClient<EmpyreanMessage, Empyrean> client = context.getClient();
            client.dispatch((BaseMessage)this.describeServices(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EmpyreanMessage, Empyrean> context, EmpyreanMessage response) {
            DescribeServicesResponseType resp = (DescribeServicesResponseType)response;
            this.services = resp.getServiceStatuses();
        }

        public List<ServiceStatusType> getServiceDetais() {
            return this.services;
        }
    }

    private class EucalyptusDescribeVMTypesTask
    extends EucalyptusActivityTask<BaseMessage, Eucalyptus> {
        private List<VmTypeDetails> types = null;

        private EucalyptusDescribeVMTypesTask() {
        }

        private DescribeInstanceTypesType describeVMTypes() {
            DescribeInstanceTypesType req = new DescribeInstanceTypesType();
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<BaseMessage, Eucalyptus> context, Callback.Checked<BaseMessage> callback) {
            DispatchingClient<BaseMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.describeVMTypes(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<BaseMessage, Eucalyptus> context, BaseMessage response) {
            DescribeInstanceTypesResponseType resp = (DescribeInstanceTypesResponseType)response;
            this.types = resp.getInstanceTypeDetails();
        }

        public List<VmTypeDetails> getVMTypes() {
            return this.types;
        }
    }

    private class EucalyptusDescribeAvailabilityZonesTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private List<ClusterInfoType> zones = null;
        private boolean verbose = false;

        private EucalyptusDescribeAvailabilityZonesTask(boolean verbose) {
            this.verbose = verbose;
        }

        private DescribeAvailabilityZonesType describeAvailabilityZones() {
            DescribeAvailabilityZonesType req = new DescribeAvailabilityZonesType();
            if (this.verbose) {
                req.setAvailabilityZoneSet(Lists.newArrayList((Object[])new String[]{"verbose"}));
            }
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.describeAvailabilityZones(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            DescribeAvailabilityZonesResponseType resp = (DescribeAvailabilityZonesResponseType)response;
            this.zones = resp.getAvailabilityZoneInfo();
        }

        public List<ClusterInfoType> getAvailabilityZones() {
            return this.zones;
        }
    }

    private class AutoScalingCreateLaunchConfigTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private String imageId = null;
        private String instanceType = null;
        private String instanceProfileName = null;
        private String launchConfigName = null;
        private String securityGroup = null;
        private String keyName = null;
        private String userData = null;

        private AutoScalingCreateLaunchConfigTask(String imageId, String instanceType, String instanceProfileName, String launchConfigName, String sgroupName, String keyName, String userData) {
            this.imageId = imageId;
            this.instanceType = instanceType;
            this.instanceProfileName = instanceProfileName;
            this.launchConfigName = launchConfigName;
            this.securityGroup = sgroupName;
            this.keyName = keyName;
            this.userData = userData;
        }

        private CreateLaunchConfigurationType createLaunchConfiguration() {
            CreateLaunchConfigurationType req = new CreateLaunchConfigurationType();
            req.setImageId(this.imageId);
            req.setInstanceType(this.instanceType);
            if (this.instanceProfileName != null) {
                req.setIamInstanceProfile(this.instanceProfileName);
            }
            if (this.keyName != null) {
                req.setKeyName(this.keyName);
            }
            req.setLaunchConfigurationName(this.launchConfigName);
            SecurityGroups groups = new SecurityGroups();
            groups.setMember(Lists.newArrayList());
            groups.getMember().add(this.securityGroup);
            req.setSecurityGroups(groups);
            req.setUserData(this.userData);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.createLaunchConfiguration(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            CreateLaunchConfigurationResponseType resp = (CreateLaunchConfigurationResponseType)response;
        }
    }

    private class AutoScalingDescribeLaunchConfigsTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private String launchConfigName = null;
        private LaunchConfigurationType result = null;

        private AutoScalingDescribeLaunchConfigsTask(String launchConfigName) {
            this.launchConfigName = launchConfigName;
        }

        private DescribeLaunchConfigurationsType describeLaunchConfigurations() {
            DescribeLaunchConfigurationsType req = new DescribeLaunchConfigurationsType();
            LaunchConfigurationNames names = new LaunchConfigurationNames();
            names.setMember(Lists.newArrayList((Object[])new String[]{this.launchConfigName}));
            req.setLaunchConfigurationNames(names);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.describeLaunchConfigurations(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            DescribeLaunchConfigurationsResponseType resp = (DescribeLaunchConfigurationsResponseType)response;
            try {
                this.result = (LaunchConfigurationType)resp.getDescribeLaunchConfigurationsResult().getLaunchConfigurations().getMember().get(0);
            }
            catch (Exception ex) {
                LOG.error((Object)"Launch configuration is not found from the response");
            }
        }

        private LaunchConfigurationType getResult() {
            return this.result;
        }
    }

    private class AutoScalingDeleteLaunchConfigTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private String launchConfigName = null;

        private AutoScalingDeleteLaunchConfigTask(String launchConfigName) {
            this.launchConfigName = launchConfigName;
        }

        private DeleteLaunchConfigurationType deleteLaunchConfiguration() {
            DeleteLaunchConfigurationType req = new DeleteLaunchConfigurationType();
            req.setLaunchConfigurationName(this.launchConfigName);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteLaunchConfiguration(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            DeleteLaunchConfigurationResponseType resp = (DeleteLaunchConfigurationResponseType)response;
        }
    }

    private class AutoScalingDeleteGroupTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private String groupName = null;
        private boolean terminateInstances = false;

        private AutoScalingDeleteGroupTask(String groupName, boolean terminateInstances) {
            this.groupName = groupName;
            this.terminateInstances = terminateInstances;
        }

        private DeleteAutoScalingGroupType deleteAutoScalingGroup() {
            DeleteAutoScalingGroupType req = new DeleteAutoScalingGroupType();
            req.setAutoScalingGroupName(this.groupName);
            req.setForceDelete(Boolean.valueOf(this.terminateInstances));
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteAutoScalingGroup(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            DeleteAutoScalingGroupResponseType resp = (DeleteAutoScalingGroupResponseType)response;
        }
    }

    private class AutoScalingCreateGroupTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private String groupName = null;
        private List<String> availabilityZones = null;
        private int capacity = 1;
        private String launchConfigName = null;
        private String tagKey = null;
        private String tagValue = null;

        private AutoScalingCreateGroupTask(String groupName, List<String> zones, int capacity, String launchConfig) {
            this.groupName = groupName;
            this.availabilityZones = zones;
            this.capacity = capacity;
            this.launchConfigName = launchConfig;
        }

        private AutoScalingCreateGroupTask(String groupName, List<String> zones, int capacity, String launchConfig, String tagKey, String tagValue) {
            this.groupName = groupName;
            this.availabilityZones = zones;
            this.capacity = capacity;
            this.launchConfigName = launchConfig;
            this.tagKey = tagKey;
            this.tagValue = tagValue;
        }

        private CreateAutoScalingGroupType createAutoScalingGroup() {
            CreateAutoScalingGroupType req = new CreateAutoScalingGroupType();
            req.setAutoScalingGroupName(this.groupName);
            AvailabilityZones zones = new AvailabilityZones();
            zones.setMember(Lists.newArrayList());
            zones.getMember().addAll(this.availabilityZones);
            req.setAvailabilityZones(zones);
            req.setDesiredCapacity(Integer.valueOf(this.capacity));
            req.setMaxSize(Integer.valueOf(this.capacity));
            req.setMinSize(Integer.valueOf(this.capacity));
            req.setHealthCheckType("EC2");
            req.setLaunchConfigurationName(this.launchConfigName);
            if (this.tagKey != null && this.tagValue != null) {
                Tags tags = new Tags();
                TagType tag = new TagType();
                tag.setKey(this.tagKey);
                tag.setValue(this.tagValue);
                tag.setPropagateAtLaunch(Boolean.valueOf(true));
                tag.setResourceType("auto-scaling-group");
                tag.setResourceId(this.groupName);
                tags.setMember(Lists.newArrayList((Object[])new TagType[]{tag}));
                req.setTags(tags);
            }
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.createAutoScalingGroup(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            CreateAutoScalingGroupResponseType resp = (CreateAutoScalingGroupResponseType)response;
        }
    }

    private class AutoScalingDescribeGroupsTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private List<String> groupNames = null;
        private DescribeAutoScalingGroupsResponseType response = null;

        private AutoScalingDescribeGroupsTask(List<String> groupNames) {
            this.groupNames = groupNames;
        }

        private DescribeAutoScalingGroupsType describeAutoScalingGroup() {
            DescribeAutoScalingGroupsType req = new DescribeAutoScalingGroupsType();
            AutoScalingGroupNames names = new AutoScalingGroupNames();
            names.setMember(Lists.newArrayList());
            if (this.groupNames != null) {
                names.getMember().addAll(this.groupNames);
            }
            req.setAutoScalingGroupNames(names);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.describeAutoScalingGroup(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            this.response = (DescribeAutoScalingGroupsResponseType)response;
        }

        public DescribeAutoScalingGroupsResponseType getResponse() {
            return this.response;
        }
    }

    private class AutoScalingUpdateGroupTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private String groupName = null;
        private List<String> availabilityZones = null;
        private Integer capacity = null;
        private String launchConfigName = null;

        private AutoScalingUpdateGroupTask(String groupName, List<String> zones, Integer capacity, String launchConfig) {
            this.groupName = groupName;
            this.availabilityZones = zones;
            this.capacity = capacity;
            this.launchConfigName = launchConfig;
        }

        private UpdateAutoScalingGroupType updateAutoScalingGroup() {
            UpdateAutoScalingGroupType req = new UpdateAutoScalingGroupType();
            req.setAutoScalingGroupName(this.groupName);
            if (this.availabilityZones != null && this.availabilityZones.size() > 0) {
                AvailabilityZones zones = new AvailabilityZones();
                zones.setMember(Lists.newArrayList());
                zones.getMember().addAll(this.availabilityZones);
                req.setAvailabilityZones(zones);
            }
            if (this.capacity != null) {
                req.setDesiredCapacity(this.capacity);
                req.setMaxSize(this.capacity);
                req.setMinSize(this.capacity);
            }
            if (this.launchConfigName != null) {
                req.setLaunchConfigurationName(this.launchConfigName);
            }
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.updateAutoScalingGroup(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            UpdateAutoScalingGroupResponseType resp = (UpdateAutoScalingGroupResponseType)response;
        }
    }

    private class AutoScalingDescribeTagsTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private List<TagDescription> result = null;

        private AutoScalingDescribeTagsTask() {
        }

        private com.eucalyptus.autoscaling.common.msgs.DescribeTagsType describeTags() {
            com.eucalyptus.autoscaling.common.msgs.DescribeTagsType req = new com.eucalyptus.autoscaling.common.msgs.DescribeTagsType();
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.describeTags(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            DescribeTagsResponseType resp = (DescribeTagsResponseType)response;
            if (resp.getDescribeTagsResult() != null && resp.getDescribeTagsResult().getTags() != null) {
                this.result = resp.getDescribeTagsResult().getTags().getMember();
            }
        }

        public List<TagDescription> getTags() {
            return this.result;
        }
    }

    private class EuareDeleteRolePolicyTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String roleName = null;
        private String policyName = null;

        private EuareDeleteRolePolicyTask(String roleName, String policyName) {
            this.roleName = roleName;
            this.policyName = policyName;
        }

        private DeleteRolePolicyType deleteRolePolicy() {
            DeleteRolePolicyType req = new DeleteRolePolicyType();
            req.setRoleName(this.roleName);
            req.setPolicyName(this.policyName);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteRolePolicy(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            DeleteRolePolicyResponseType resp = (DeleteRolePolicyResponseType)response;
        }
    }

    private class EuareGetRolePolicyTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String roleName = null;
        private String policyName = null;
        private GetRolePolicyResult result = null;

        private EuareGetRolePolicyTask(String roleName, String policyName) {
            this.roleName = roleName;
            this.policyName = policyName;
        }

        private GetRolePolicyType getRolePolicy() {
            GetRolePolicyType req = new GetRolePolicyType();
            req.setRoleName(this.roleName);
            req.setPolicyName(this.policyName);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.getRolePolicy(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            GetRolePolicyResponseType resp = (GetRolePolicyResponseType)response;
            this.result = resp.getGetRolePolicyResult();
        }

        GetRolePolicyResult getResult() {
            return this.result;
        }
    }

    private class EuarePutRolePolicyTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String roleName = null;
        private String policyName = null;
        private String policyDocument = null;

        private EuarePutRolePolicyTask(String roleName, String policyName, String policyDocument) {
            this.roleName = roleName;
            this.policyName = policyName;
            this.policyDocument = policyDocument;
        }

        private PutRolePolicyType putRolePolicy() {
            PutRolePolicyType req = new PutRolePolicyType();
            req.setRoleName(this.roleName);
            req.setPolicyName(this.policyName);
            req.setPolicyDocument(this.policyDocument);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.putRolePolicy(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            PutRolePolicyResponseType resp = (PutRolePolicyResponseType)response;
        }
    }

    private class EuareListRolesTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String pathPrefix = null;
        private List<RoleType> roles = Lists.newArrayList();

        private EuareListRolesTask(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        private ListRolesType listRoles() {
            ListRolesType req = new ListRolesType();
            req.setPathPrefix(this.pathPrefix);
            return req;
        }

        public List<RoleType> getRoles() {
            return this.roles;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.listRoles(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            ListRolesResponseType resp = (ListRolesResponseType)response;
            try {
                this.roles = resp.getListRolesResult().getRoles().getMember();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class EuareCreateRoleTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        String roleName = null;
        String path = null;
        String assumeRolePolicy = null;
        private RoleType role = null;

        private EuareCreateRoleTask(String roleName, String path, String assumeRolePolicy) {
            this.roleName = roleName;
            this.path = path;
            this.assumeRolePolicy = assumeRolePolicy;
        }

        private CreateRoleType createRole() {
            CreateRoleType req = new CreateRoleType();
            req.setRoleName(this.roleName);
            req.setPath(this.path);
            req.setAssumeRolePolicyDocument(this.assumeRolePolicy);
            return req;
        }

        public RoleType getRole() {
            return this.role;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.createRole(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            CreateRoleResponseType resp = (CreateRoleResponseType)response;
            try {
                this.role = resp.getCreateRoleResult().getRole();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class EuareDeleteRoleTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String roleName = null;

        private EuareDeleteRoleTask(String roleName) {
            this.roleName = roleName;
        }

        private DeleteRoleType deleteRole() {
            DeleteRoleType req = new DeleteRoleType();
            req.setRoleName(this.roleName);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteRole(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            DeleteRoleResponseType resp = (DeleteRoleResponseType)response;
        }
    }

    private class EuareCreateInstanceProfileTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String profileName = null;
        private String path = null;
        private InstanceProfileType instanceProfile = null;

        private EuareCreateInstanceProfileTask(String profileName, String path) {
            this.profileName = profileName;
            this.path = path;
        }

        private CreateInstanceProfileType createInstanceProfile() {
            CreateInstanceProfileType req = new CreateInstanceProfileType();
            req.setInstanceProfileName(this.profileName);
            req.setPath(this.path);
            return req;
        }

        public InstanceProfileType getInstanceProfile() {
            return this.instanceProfile;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.createInstanceProfile(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            CreateInstanceProfileResponseType resp = (CreateInstanceProfileResponseType)response;
            try {
                this.instanceProfile = resp.getCreateInstanceProfileResult().getInstanceProfile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class EuareListInstanceProfilesTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String pathPrefix = null;
        private List<InstanceProfileType> instanceProfiles = null;

        private EuareListInstanceProfilesTask(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        private ListInstanceProfilesType listInstanceProfiles() {
            ListInstanceProfilesType req = new ListInstanceProfilesType();
            req.setPathPrefix(this.pathPrefix);
            return req;
        }

        public List<InstanceProfileType> getInstanceProfiles() {
            return this.instanceProfiles;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.listInstanceProfiles(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            ListInstanceProfilesResponseType resp = (ListInstanceProfilesResponseType)response;
            try {
                this.instanceProfiles = resp.getListInstanceProfilesResult().getInstanceProfiles().getMember();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class EuareRemoveRoleFromInstanceProfileTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String instanceProfileName = null;
        private String roleName = null;

        private EuareRemoveRoleFromInstanceProfileTask(String instanceProfileName, String roleName) {
            this.instanceProfileName = instanceProfileName;
            this.roleName = roleName;
        }

        private RemoveRoleFromInstanceProfileType removeRoleFromInstanceProfile() {
            RemoveRoleFromInstanceProfileType req = new RemoveRoleFromInstanceProfileType();
            req.setRoleName(this.roleName);
            req.setInstanceProfileName(this.instanceProfileName);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.removeRoleFromInstanceProfile(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            RemoveRoleFromInstanceProfileResponseType resp = (RemoveRoleFromInstanceProfileResponseType)response;
        }
    }

    private class EuareAddRoleToInstanceProfileTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String instanceProfileName = null;
        private String roleName = null;

        private EuareAddRoleToInstanceProfileTask(String instanceProfileName, String roleName) {
            this.instanceProfileName = instanceProfileName;
            this.roleName = roleName;
        }

        private AddRoleToInstanceProfileType addRoleToInstanceProfile() {
            AddRoleToInstanceProfileType req = new AddRoleToInstanceProfileType();
            req.setRoleName(this.roleName);
            req.setInstanceProfileName(this.instanceProfileName);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.addRoleToInstanceProfile(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            AddRoleToInstanceProfileResponseType resp = (AddRoleToInstanceProfileResponseType)response;
        }
    }

    private class EuareDeleteInstanceProfileTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String profileName = null;

        private EuareDeleteInstanceProfileTask(String profileName) {
            this.profileName = profileName;
        }

        private DeleteInstanceProfileType deleteInstanceProfile() {
            DeleteInstanceProfileType req = new DeleteInstanceProfileType();
            req.setInstanceProfileName(this.profileName);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteInstanceProfile(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            DeleteInstanceProfileResponseType resp = (DeleteInstanceProfileResponseType)response;
        }
    }

    private class EuareGetServerCertificateTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String certName = null;
        private ServerCertificateType certificate = null;

        private EuareGetServerCertificateTask(String certName) {
            this.certName = certName;
        }

        private GetServerCertificateType getRequest() {
            GetServerCertificateType req = new GetServerCertificateType();
            req.setServerCertificateName(this.certName);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.getRequest(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            GetServerCertificateResponseType resp = (GetServerCertificateResponseType)response;
            if (resp.getGetServerCertificateResult() != null) {
                this.certificate = resp.getGetServerCertificateResult().getServerCertificate();
            }
        }

        public ServerCertificateType getServerCertificate() {
            return this.certificate;
        }
    }

    private class EucaDescribeKeyPairsTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private List<String> keyNames = null;
        private List<DescribeKeyPairsResponseItemType> result = null;

        private EucaDescribeKeyPairsTask() {
        }

        private EucaDescribeKeyPairsTask(String keyName) {
            this.keyNames = Lists.newArrayList((Object[])new String[]{keyName});
        }

        private EucaDescribeKeyPairsTask(List<String> keyNames) {
            this.keyNames = keyNames;
        }

        private DescribeKeyPairsType describeKeyPairs() {
            DescribeKeyPairsType req = new DescribeKeyPairsType();
            if (this.keyNames != null) {
                req.setKeySet(new ArrayList<String>(this.keyNames));
            }
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.describeKeyPairs(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            DescribeKeyPairsResponseType resp = (DescribeKeyPairsResponseType)response;
            this.result = resp.getKeySet();
        }

        List<DescribeKeyPairsResponseItemType> getResult() {
            return this.result;
        }
    }

    private class EucaCreateTagsTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String tagKey = null;
        private String tagValue = null;
        private List<String> resources = null;

        private EucaCreateTagsTask(String tagKey, String tagValue, List<String> resources) {
            this.tagKey = tagKey;
            this.tagValue = tagValue;
            this.resources = resources;
        }

        private CreateTagsType createTags() {
            CreateTagsType req = new CreateTagsType();
            req.setResourcesSet(Lists.newArrayList(this.resources));
            ResourceTag tag = new ResourceTag();
            tag.setKey(this.tagKey);
            tag.setValue(this.tagValue);
            req.setTagSet(Lists.newArrayList((Object[])new ResourceTag[]{tag}));
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.createTags(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            CreateTagsResponseType resp = (CreateTagsResponseType)response;
        }
    }

    private class EucaDeleteTagsTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String tagKey = null;
        private String tagValue = null;
        private List<String> resources = null;

        private EucaDeleteTagsTask(String tagKey, String tagValue, List<String> resources) {
            this.tagKey = tagKey;
            this.tagValue = tagValue;
            this.resources = resources;
        }

        private com.eucalyptus.compute.common.backend.DeleteTagsType deleteTags() {
            com.eucalyptus.compute.common.backend.DeleteTagsType req = new com.eucalyptus.compute.common.backend.DeleteTagsType();
            req.setResourcesSet(Lists.newArrayList(this.resources));
            DeleteResourceTag tag = new DeleteResourceTag();
            tag.setKey(this.tagKey);
            tag.setValue(this.tagValue);
            req.setTagSet(Lists.newArrayList((Object[])new DeleteResourceTag[]{tag}));
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteTags(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            com.eucalyptus.compute.common.backend.DeleteTagsResponseType resp = (com.eucalyptus.compute.common.backend.DeleteTagsResponseType)response;
        }
    }

    private class AutoscalingCreateOrUpdateTagsTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private String tagKey = null;
        private String tagValue = null;
        private String asgName = null;

        private AutoscalingCreateOrUpdateTagsTask(String tagKey, String tagValue, String asgName) {
            this.tagKey = tagKey;
            this.tagValue = tagValue;
            this.asgName = asgName;
        }

        private CreateOrUpdateTagsType createOrUpdateTags() {
            CreateOrUpdateTagsType req = new CreateOrUpdateTagsType();
            Tags tags = new Tags();
            TagType tag = new TagType();
            tag.setKey(this.tagKey);
            tag.setValue(this.tagValue);
            tag.setPropagateAtLaunch(Boolean.valueOf(true));
            tag.setResourceType("auto-scaling-group");
            tag.setResourceId(this.asgName);
            tags.setMember(Lists.newArrayList((Object[])new TagType[]{tag}));
            req.setTags(tags);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.createOrUpdateTags(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            CreateOrUpdateTagsResponseType resp = (CreateOrUpdateTagsResponseType)response;
        }
    }

    private class AutoscalingDeleteTagsTask
    extends EucalyptusActivityTask<AutoScalingMessage, AutoScaling> {
        private String tagKey = null;
        private String tagValue = null;
        private String asgName = null;

        private AutoscalingDeleteTagsTask(String tagKey, String tagValue, String asgName) {
            this.tagKey = tagKey;
            this.tagValue = tagValue;
            this.asgName = asgName;
        }

        private DeleteTagsType deleteTags() {
            DeleteTagsType req = new DeleteTagsType();
            Tags tags = new Tags();
            TagType tag = new TagType();
            tag.setKey(this.tagKey);
            tag.setValue(this.tagValue);
            tag.setPropagateAtLaunch(Boolean.valueOf(true));
            tag.setResourceType("auto-scaling-group");
            tag.setResourceId(this.asgName);
            tags.setMember(Lists.newArrayList((Object[])new TagType[]{tag}));
            req.setTags(tags);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<AutoScalingMessage, AutoScaling> context, Callback.Checked<AutoScalingMessage> callback) {
            DispatchingClient<AutoScalingMessage, AutoScaling> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteTags(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<AutoScalingMessage, AutoScaling> context, AutoScalingMessage response) {
            DeleteTagsResponseType resp = (DeleteTagsResponseType)response;
        }
    }

    private class EucaDescribeImagesTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private List<String> imageIds = null;
        private List<ImageDetails> result = null;

        private EucaDescribeImagesTask(List<String> imageIds) {
            this.imageIds = imageIds;
        }

        private DescribeImagesType describeImages() {
            DescribeImagesType req = new DescribeImagesType();
            if (this.imageIds != null && this.imageIds.size() > 0) {
                req.setImagesSet(new ArrayList<String>(this.imageIds));
            }
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.describeImages(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            DescribeImagesResponseType resp = (DescribeImagesResponseType)response;
            this.result = resp.getImagesSet();
        }

        List<ImageDetails> getResult() {
            return this.result;
        }
    }

    private class UploadServerCertificateTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String certName = null;
        private String certPath = "/";
        private String certPem = null;
        private String pkPem = null;
        private String certChain = null;

        private UploadServerCertificateTask(String certName, String certPath, String certPem, String pkPem, String certChain) {
            this.certName = certName;
            if (certPath != null) {
                this.certPath = certPath;
            }
            this.certPem = certPem;
            this.pkPem = pkPem;
            this.certChain = certChain;
        }

        private UploadServerCertificateType uploadServerCertificate() {
            UploadServerCertificateType req = new UploadServerCertificateType();
            req.setServerCertificateName(this.certName);
            req.setPath(this.certPath);
            req.setCertificateBody(this.certPem);
            req.setPrivateKey(this.pkPem);
            if (this.certChain != null) {
                req.setCertificateChain(this.certChain);
            }
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.uploadServerCertificate(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            UploadServerCertificateResponseType resp = (UploadServerCertificateResponseType)response;
        }
    }

    private class DeleteServerCertificateTask
    extends EucalyptusActivityTask<EuareMessage, Euare> {
        private String certName = null;

        private DeleteServerCertificateTask(String certName) {
            this.certName = certName;
        }

        private DeleteServerCertificateType deleteServerCertificate() {
            DeleteServerCertificateType req = new DeleteServerCertificateType();
            req.setServerCertificateName(this.certName);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<EuareMessage, Euare> context, Callback.Checked<EuareMessage> callback) {
            DispatchingClient<EuareMessage, Euare> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteServerCertificate(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<EuareMessage, Euare> context, EuareMessage response) {
            DeleteServerCertificateResponseType resp = new DeleteServerCertificateResponseType();
        }
    }

    private class DescribeTagsTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private List<String> names = null;
        private List<String> values = null;
        private List<TagInfo> tags = null;

        private DescribeTagsTask(List<String> names, List<String> values) {
            this.names = names;
            this.values = values;
        }

        private DescribeTagsType describeTags() {
            if (this.names.size() != this.values.size()) {
                throw Exceptions.toUndeclared((Throwable)new Exception("Names and values don't match"));
            }
            DescribeTagsType req = new DescribeTagsType();
            ArrayList filterSet = Lists.newArrayList();
            for (int i = 0; i < this.names.size(); ++i) {
                String name = this.names.get(i);
                String value = this.values.get(i);
                Filter f = new Filter();
                f.setName(name);
                f.setValueSet(Lists.newArrayList((Object[])new String[]{value}));
                filterSet.add(f);
            }
            req.setFilterSet(filterSet);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.describeTags(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            com.eucalyptus.compute.common.backend.DescribeTagsResponseType resp = (com.eucalyptus.compute.common.backend.DescribeTagsResponseType)response;
            this.tags = resp.getTagSet();
        }

        public List<TagInfo> getTags() {
            return this.tags;
        }
    }

    private class DescribeVolumesTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private List<String> volumeIds = null;
        private List<Volume> result = null;

        private DescribeVolumesTask() {
            this.volumeIds = null;
        }

        private DescribeVolumesTask(List<String> volumeIds) {
            this.volumeIds = volumeIds;
        }

        private DescribeVolumesType describeVolumes() {
            DescribeVolumesType req = new DescribeVolumesType();
            if (this.volumeIds != null && this.volumeIds.size() > 0) {
                req.setVolumeSet(Lists.newArrayList(this.volumeIds));
            }
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.describeVolumes(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            DescribeVolumesResponseType resp = (DescribeVolumesResponseType)response;
            this.result = resp.getVolumeSet();
        }

        public List<Volume> getVolumes() {
            return this.result;
        }
    }

    private class CreateVolumeTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String availabilityZone = null;
        private String snapshotId = null;
        private int size = -1;
        private String volumeId = null;

        private CreateVolumeTask(String availabilityZone, int size) {
            this.availabilityZone = availabilityZone;
            this.size = size;
        }

        private CreateVolumeTask(String availabilityZone, int size, String snapshotId) {
            this(availabilityZone, size);
            this.snapshotId = snapshotId;
        }

        private CreateVolumeType createVolume() {
            CreateVolumeType req = new CreateVolumeType();
            req.setAvailabilityZone(this.availabilityZone);
            req.setSize(Integer.toString(this.size));
            if (this.snapshotId != null) {
                req.setSnapshotId(this.snapshotId);
            }
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.createVolume(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            CreateVolumeResponseType resp = (CreateVolumeResponseType)response;
            Volume vol = resp.getVolume();
            if (vol != null && !"error".equals(vol.getStatus())) {
                this.volumeId = vol.getVolumeId();
            }
        }

        public String getVolumeId() {
            return this.volumeId;
        }
    }

    private class DeleteVolumeTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String volumeId = null;

        private DeleteVolumeTask(String volumeId) {
            this.volumeId = volumeId;
        }

        private DeleteVolumeType deleteVolume() {
            DeleteVolumeType req = new DeleteVolumeType();
            req.setVolumeId(this.volumeId);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.deleteVolume(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            DeleteVolumeResponseType resp = (DeleteVolumeResponseType)response;
        }
    }

    private class EucalyptusDescribeInstanceTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private final List<String> instanceIds;
        private final AtomicReference<List<RunningInstancesItemType>> result = new AtomicReference();

        private EucalyptusDescribeInstanceTask(List<String> instanceId) {
            this.instanceIds = instanceId;
        }

        private DescribeInstancesType describeInstances() {
            DescribeInstancesType req = new DescribeInstancesType();
            req.setInstancesSet(Lists.newArrayList(this.instanceIds));
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.describeInstances(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            DescribeInstancesResponseType resp = (DescribeInstancesResponseType)response;
            ArrayList resultInstances = Lists.newArrayList();
            for (ReservationInfoType res : resp.getReservationSet()) {
                resultInstances.addAll(res.getInstancesSet());
            }
            this.result.set(resultInstances);
        }

        public List<RunningInstancesItemType> getResult() {
            return this.result.get();
        }
    }

    private class EucalyptusRunInstancesTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String imageId = null;
        private Set<String> groupNames = Collections.emptySet();
        private String userData = null;
        private String instanceType = null;
        private String availabilityZone = null;
        private String subnetId = null;
        private String privateIp = null;
        private boolean monitoringEnabled = false;
        private String keyName = null;
        private String instanceId = null;

        private EucalyptusRunInstancesTask(String imageId) {
            this.imageId = imageId;
        }

        private void setGroupNames(Set<String> groupNames) {
            this.groupNames = groupNames;
        }

        private void setUserData(String userData) {
            this.userData = userData;
        }

        private void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        private void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        private void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        private void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        private void setMonitoring(boolean monitoring) {
            this.monitoringEnabled = monitoring;
        }

        private void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        private RunInstancesType runInstances() {
            RunInstancesType req = new RunInstancesType();
            req.setImageId(this.imageId);
            req.setUserData(this.userData);
            req.setInstanceType(this.instanceType);
            req.setKeyName(this.keyName);
            req.setMonitoring(Boolean.valueOf(this.monitoringEnabled));
            req.setMinCount(1);
            req.setMaxCount(1);
            if (this.subnetId != null) {
                InstanceNetworkInterfaceSetItemRequestType networkInterface = req.primaryNetworkInterface(true);
                networkInterface.setSubnetId(this.subnetId);
                networkInterface.setPrivateIpAddress(this.privateIp);
            } else {
                req.setGroupSet(Lists.newArrayList(this.groupNames));
                req.setAvailabilityZone(this.availabilityZone);
            }
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.runInstances(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            RunInstancesResponseType resp = (RunInstancesResponseType)response;
            try {
                this.instanceId = ((RunningInstancesItemType)resp.getRsvInfo().getInstancesSet().get(0)).getInstanceId();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getInstanceId() {
            return this.instanceId;
        }
    }

    private class EucalyptusDescribeSnapshotsTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private List<String> snapshots = null;
        private List<Snapshot> results = null;

        private EucalyptusDescribeSnapshotsTask(List<String> snapshots) {
            this.snapshots = snapshots;
        }

        private DescribeSnapshotsType describeSnapshots() {
            DescribeSnapshotsType req = new DescribeSnapshotsType();
            req.setSnapshotSet(Lists.newArrayList(this.snapshots));
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.describeSnapshots(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            DescribeSnapshotsResponseType resp = (DescribeSnapshotsResponseType)response;
            this.results = resp.getSnapshotSet();
        }

        public List<Snapshot> getResult() {
            return this.results;
        }
    }

    private class EucalyptusRegisterEBSImageTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String snapshotId = null;
        private String description = null;
        private String name = null;
        private String architecture = null;
        private String platform = null;
        private String imageId = null;
        private boolean deleteOnTermination = false;
        private static final String ROOT_DEVICE_NAME = "/dev/sda";

        private EucalyptusRegisterEBSImageTask(String snapshotId, String name, String architecture) {
            this.snapshotId = snapshotId;
            this.architecture = architecture;
            this.name = name;
        }

        private void setDescription(String description) {
            this.description = description;
        }

        private void setPlatform(String platform) {
            this.platform = platform;
        }

        private void setDeleteOnTermination(boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        private RegisterImageType register() {
            RegisterImageType req = new RegisterImageType();
            req.setRootDeviceName(ROOT_DEVICE_NAME);
            BlockDeviceMappingItemType device = new BlockDeviceMappingItemType();
            device.setDeviceName(ROOT_DEVICE_NAME);
            EbsDeviceMapping ebsMap = new EbsDeviceMapping();
            ebsMap.setSnapshotId(this.snapshotId);
            ebsMap.setDeleteOnTermination(Boolean.valueOf(this.deleteOnTermination));
            device.setEbs(ebsMap);
            req.setBlockDeviceMappings(Lists.newArrayList((Object[])new BlockDeviceMappingItemType[]{device}));
            req.setArchitecture(this.architecture);
            if (this.description != null) {
                req.setDescription(this.description);
            }
            req.setName(this.name);
            if ("windows".equals(this.platform)) {
                req.setKernelId("windows");
            }
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.register(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            RegisterImageResponseType resp = (RegisterImageResponseType)response;
            this.imageId = resp.getImageId();
        }

        public String getImageId() {
            return this.imageId;
        }
    }

    private class EucalyptusCreateSnapshotTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String volumeId = null;
        private String snapshotId = null;

        private EucalyptusCreateSnapshotTask(String volumeId) {
            this.volumeId = volumeId;
        }

        private CreateSnapshotType createSnapshot() {
            CreateSnapshotType req = new CreateSnapshotType();
            req.setVolumeId(this.volumeId);
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.createSnapshot(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            CreateSnapshotResponseType resp = (CreateSnapshotResponseType)response;
            try {
                this.snapshotId = resp.getSnapshot().getSnapshotId();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }
    }

    private class EucalyptusTerminateInstanceTask
    extends EucalyptusActivityTask<ComputeMessage, Eucalyptus> {
        private String instanceId = null;

        private EucalyptusTerminateInstanceTask(String instanceId) {
            this.instanceId = instanceId;
        }

        private TerminateInstancesType terminate() {
            TerminateInstancesType req = new TerminateInstancesType();
            req.setInstancesSet(Lists.newArrayList((Object[])new String[]{this.instanceId}));
            return req;
        }

        @Override
        void dispatchInternal(ActivityContext<ComputeMessage, Eucalyptus> context, Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = context.getClient();
            client.dispatch((BaseMessage)this.terminate(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext<ComputeMessage, Eucalyptus> context, ComputeMessage response) {
            TerminateInstancesResponseType resp = (TerminateInstancesResponseType)response;
        }
    }

    private class EucalyptusUserActivity
    implements ActivityContext<ComputeMessage, Eucalyptus> {
        private String userId = null;

        private EucalyptusUserActivity(String userId) {
            this.userId = userId;
        }

        @Override
        public String getUserId() {
            return this.userId;
        }

        @Override
        public DispatchingClient<ComputeMessage, Eucalyptus> getClient() {
            try {
                DispatchingClient client = new DispatchingClient(this.getUserId(), Eucalyptus.class);
                client.init();
                return client;
            }
            catch (Exception e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }

    private class EucalyptusBaseSystemActivity
    implements ActivityContext<BaseMessage, Eucalyptus> {
        private EucalyptusBaseSystemActivity() {
        }

        @Override
        public String getUserId() {
            try {
                return Accounts.lookupSystemAdmin().getUserId();
            }
            catch (AuthException ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        @Override
        public DispatchingClient<BaseMessage, Eucalyptus> getClient() {
            try {
                DispatchingClient client = new DispatchingClient(this.getUserId(), Eucalyptus.class);
                client.init();
                return client;
            }
            catch (Exception e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }

    private class EucalyptusSystemActivity
    implements ActivityContext<ComputeMessage, Eucalyptus> {
        private EucalyptusSystemActivity() {
        }

        @Override
        public String getUserId() {
            try {
                return Accounts.lookupSystemAdmin().getUserId();
            }
            catch (AuthException ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        @Override
        public DispatchingClient<ComputeMessage, Eucalyptus> getClient() {
            try {
                DispatchingClient client = new DispatchingClient(this.getUserId(), Eucalyptus.class);
                client.init();
                return client;
            }
            catch (Exception e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }

    private class EmpyreanSystemActivity
    implements ActivityContext<EmpyreanMessage, Empyrean> {
        private EmpyreanSystemActivity() {
        }

        @Override
        public String getUserId() {
            try {
                return Accounts.lookupSystemAdmin().getUserId();
            }
            catch (AuthException ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        @Override
        public DispatchingClient<EmpyreanMessage, Empyrean> getClient() {
            try {
                DispatchingClient client = new DispatchingClient(this.getUserId(), Empyrean.class);
                client.init();
                return client;
            }
            catch (Exception e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }

    private class AutoScalingSystemActivity
    implements ActivityContext<AutoScalingMessage, AutoScaling> {
        private AutoScalingSystemActivity() {
        }

        @Override
        public String getUserId() {
            try {
                return Accounts.lookupSystemAdmin().getUserId();
            }
            catch (AuthException ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        @Override
        public DispatchingClient<AutoScalingMessage, AutoScaling> getClient() {
            try {
                DispatchingClient client = new DispatchingClient(this.getUserId(), AutoScaling.class);
                client.init();
                return client;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    private class EuareUserActivity
    implements ActivityContext<EuareMessage, Euare> {
        private String userId = null;

        private EuareUserActivity(String userId) {
            this.userId = userId;
        }

        @Override
        public String getUserId() {
            return this.userId;
        }

        @Override
        public DispatchingClient<EuareMessage, Euare> getClient() {
            try {
                DispatchingClient client = new DispatchingClient(this.getUserId(), Euare.class);
                client.init();
                return client;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    private class EuareSystemActivity
    implements ActivityContext<EuareMessage, Euare> {
        private EuareSystemActivity() {
        }

        @Override
        public String getUserId() {
            try {
                return Accounts.lookupSystemAdmin().getUserId();
            }
            catch (AuthException ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        @Override
        public DispatchingClient<EuareMessage, Euare> getClient() {
            try {
                DispatchingClient client = new DispatchingClient(this.getUserId(), Euare.class);
                client.init();
                return client;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    private static interface ActivityContext<TM extends BaseMessage, TC extends ComponentId> {
        public String getUserId();

        public DispatchingClient<TM, TC> getClient();
    }
}

