/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;

@ConfigurableClass(root="services.imaging", description="Parameters controlling import tasks")
public class ImportTaskProperties {
    @ConfigurableField(displayName="task_expiration_hours", description="expiration hours of import volume/instance tasks", readonly=false, initial="168", type=ConfigurableFieldType.KEYVALUE, changeListener=NumberValidationListener.class)
    public static String IMPORT_TASK_EXPIRATION_HOURS = "168";
    @ConfigurableField(displayName="task_timeout_minutes", description="expiration time in minutes of import tasks", readonly=false, initial="180", type=ConfigurableFieldType.KEYVALUE, changeListener=NumberValidationListener.class)
    public static String IMPORT_TASK_TIMEOUT_MINUTES = "180";

    public static class NumberValidationListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                Integer.parseInt(newValue);
            }
            catch (NumberFormatException ex) {
                throw new ConfigurablePropertyException("Invalid number");
            }
        }
    }
}

