/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging;

import com.eucalyptus.autoscaling.common.msgs.AutoScalingGroupType;
import com.eucalyptus.autoscaling.common.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.autoscaling.common.msgs.LaunchConfigurationType;
import com.eucalyptus.autoscaling.common.msgs.TagDescription;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.DependsLocal;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.ClusterInfoType;
import com.eucalyptus.compute.common.DescribeKeyPairsResponseItemType;
import com.eucalyptus.compute.common.ImageDetails;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.imaging.common.EucalyptusActivityTasks;
import com.eucalyptus.imaging.common.ImagingBackend;
import com.eucalyptus.util.DNSProperties;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.fsm.TransitionRecord;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.net.HostSpecifier;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

@ConfigurableClass(root="services.imaging.worker", description="Parameters controlling image conversion service")
public class ImagingServiceProperties {
    private static Logger LOG = Logger.getLogger(ImagingServiceProperties.class);
    @ConfigurableField(displayName="image", description="EMI containing imaging worker", initial="NULL", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=EmiChangeListener.class)
    public static String IMAGE = "NULL";
    @ConfigurableField(displayName="instance_type", description="instance type for imaging worker", initial="m1.small", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=InstanceTypeChangeListener.class)
    public static String INSTANCE_TYPE = "m1.small";
    @ConfigurableField(displayName="availability_zones", description="availability zones for imaging worker", initial="", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=AvailabilityZonesChangeListener.class)
    public static String AVAILABILITY_ZONES = "";
    @ConfigurableField(displayName="keyname", description="keyname to use when debugging imaging worker", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=KeyNameChangeListener.class)
    public static String KEYNAME = null;
    @ConfigurableField(displayName="ntp_server", description="address of the NTP server used by imaging worker", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=NTPServerChangeListener.class)
    public static String NTP_SERVER = null;
    @ConfigurableField(displayName="log_server", description="address/ip of the server that collects logs from imaging wokrers", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=LogServerAddressChangeListener.class)
    public static String LOG_SERVER = null;
    @ConfigurableField(displayName="log_server_port", description="UDP port that log server is listerning to", readonly=false, initial="514", type=ConfigurableFieldType.KEYVALUE, changeListener=LogServerPortChangeListener.class)
    public static String LOG_SERVER_PORT = "514";
    @ConfigurableField(displayName="enabled", description="enabling imaging worker healthcheck", initial="true", readonly=false, type=ConfigurableFieldType.BOOLEAN)
    public static Boolean HEALTHCHECK = true;
    @ConfigurableField(displayName="expiration_days", description="the days after which imaging work VMs expire", initial="180", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=VmExpirationDaysChangeListener.class)
    public static String EXPIRATION_DAYS = "180";
    @ConfigurableField(displayName="init_script", description="bash script that will be executed before service configuration and start up", readonly=false, type=ConfigurableFieldType.KEYVALUE, changeListener=InitScriptChangeListener.class)
    public static String INIT_SCRIPT = null;
    public static final String DEFAULT_LAUNCHER_TAG = "euca-internal-imaging-workers";
    static final Set<String> configuredZones = Sets.newHashSet();

    public static String getCredentialsString() {
        String credStr = String.format("euca-%s:%s", B64.standard.encString((String)"setup-credential"), EXPIRATION_DAYS);
        return credStr;
    }

    public static String getWorkerUserData(String ntpServer, String logServer, String logServerPort, String initScript) {
        HashMap<String, String> kvMap = new HashMap<String, String>();
        if (ntpServer != null) {
            kvMap.put("ntp_server", ntpServer);
        }
        if (logServer != null) {
            kvMap.put("log_server", logServer);
        }
        if (logServerPort != null) {
            kvMap.put("log_server_port", logServerPort);
        }
        kvMap.put("imaging_service_url", String.format("imaging.%s", DNSProperties.DOMAIN));
        kvMap.put("euare_service_url", String.format("euare.%s", DNSProperties.DOMAIN));
        kvMap.put("compute_service_url", String.format("compute.%s", DNSProperties.DOMAIN));
        StringBuilder sb = new StringBuilder("#!/bin/bash").append("\n");
        if (initScript != null && initScript.length() > 0) {
            sb.append(initScript);
        }
        sb.append("\n#System generated Imaging worker config\n");
        sb.append("mkdir -p /etc/eucalyptus-imaging-worker/\n");
        sb.append("yum -y --disablerepo \\* --enablerepo eucalyptus-service-image install eucalyptus-imaging-worker\n");
        sb.append("echo \"");
        for (String key : kvMap.keySet()) {
            String value = (String)kvMap.get(key);
            sb.append(String.format("\n%s=%s", key, value));
        }
        sb.append("\" > /etc/eucalyptus-imaging-worker/imaging-worker.conf");
        sb.append("\ntouch /var/lib/eucalyptus-imaging-worker/ntp.lock");
        sb.append("\nchown -R imaging-worker:imaging-worker /etc/eucalyptus-imaging-worker");
        sb.append("\nservice eucalyptus-imaging-worker start");
        return sb.toString();
    }

    private static void onPropertyChange(String emi, String instanceType, String keyname, String ntpServers, String logServer, String logServerPort, String initScript) throws EucalyptusCloudException {
        block47: {
            if (!Bootstrap.isFinished().booleanValue() || !Topology.isEnabled(Eucalyptus.class)) {
                return;
            }
            if (emi != null) {
                try {
                    List<ImageDetails> images = EucalyptusActivityTasks.getInstance().describeImages(Lists.newArrayList((Object[])new String[]{emi}), false);
                    if (images == null || images.size() <= 0) {
                        throw new EucalyptusCloudException("No such EMI is found in the system");
                    }
                    if (!images.get(0).getImageId().toLowerCase().equals(emi.toLowerCase())) {
                        throw new EucalyptusCloudException("No such EMI is found in the system");
                    }
                }
                catch (EucalyptusCloudException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new EucalyptusCloudException("Failed to verify EMI in the system");
                }
            }
            if (instanceType != null) {
                // empty if block
            }
            if (keyname != null && !keyname.equals("")) {
                try {
                    List<DescribeKeyPairsResponseItemType> keypairs = EucalyptusActivityTasks.getInstance().describeKeyPairs(Lists.newArrayList((Object[])new String[]{keyname}));
                    if (keypairs == null || keypairs.size() <= 0) {
                        throw new EucalyptusCloudException("No such keypair is found in the system");
                    }
                    if (!keypairs.get(0).getKeyName().equals(keyname)) {
                        throw new EucalyptusCloudException("No such keypair is found in the system");
                    }
                }
                catch (EucalyptusCloudException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new EucalyptusCloudException("Failed to verify the keyname in the system");
                }
            }
            if (ntpServers != null) {
                // empty if block
            }
            if (emi != null && emi.length() > 0 || instanceType != null && instanceType.length() > 0 || keyname != null && keyname.length() > 0 || ntpServers != null && ntpServers.length() > 0 || logServer != null && logServer.length() > 0 || logServerPort != null && logServerPort.length() > 0 || initScript != null) {
                String asgName = null;
                LOG.warn((Object)"Changing launch configuration");
                try {
                    List<TagDescription> tags = EucalyptusActivityTasks.getInstance().describeAutoScalingTags();
                    for (TagDescription tag : tags) {
                        if (!DEFAULT_LAUNCHER_TAG.equals(tag.getValue())) continue;
                        asgName = tag.getResourceId();
                        break;
                    }
                }
                catch (Exception ex) {
                    return;
                }
                if (asgName == null) {
                    return;
                }
                try {
                    AutoScalingGroupType asgType = null;
                    try {
                        DescribeAutoScalingGroupsResponseType resp = EucalyptusActivityTasks.getInstance().describeAutoScalingGroups(Lists.newArrayList((Object[])new String[]{asgName}));
                        if (resp.getDescribeAutoScalingGroupsResult() != null && resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups() != null && resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember() != null && resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember().size() > 0) {
                            asgType = (AutoScalingGroupType)resp.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember().get(0);
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)("can't find autoscaling group named " + asgName));
                        return;
                    }
                    if (asgType == null) break block47;
                    String lcName = asgType.getLaunchConfigurationName();
                    LaunchConfigurationType lc = EucalyptusActivityTasks.getInstance().describeLaunchConfiguration(lcName);
                    String tmpLaunchConfigName = null;
                    while ((tmpLaunchConfigName = String.format("lc-euca-internal-imaging-%s", UUID.randomUUID().toString().substring(0, 8))).equals(asgType.getLaunchConfigurationName())) {
                    }
                    String newEmi = emi != null ? emi : lc.getImageId();
                    String newType = instanceType != null ? instanceType : lc.getInstanceType();
                    String newKeyname = keyname != null ? keyname : lc.getKeyName();
                    String newUserdata = lc.getUserData();
                    if (ntpServers != null) {
                        newUserdata = B64.standard.encString((String)String.format("%s\n%s", ImagingServiceProperties.getCredentialsString(), ImagingServiceProperties.getWorkerUserData(ntpServers, LOG_SERVER, LOG_SERVER_PORT, INIT_SCRIPT)));
                    }
                    if (logServer != null) {
                        newUserdata = B64.standard.encString((String)String.format("%s\n%s", ImagingServiceProperties.getCredentialsString(), ImagingServiceProperties.getWorkerUserData(NTP_SERVER, logServer, LOG_SERVER_PORT, INIT_SCRIPT)));
                    }
                    if (logServerPort != null) {
                        newUserdata = B64.standard.encString((String)String.format("%s\n%s", ImagingServiceProperties.getCredentialsString(), ImagingServiceProperties.getWorkerUserData(NTP_SERVER, LOG_SERVER, logServerPort, INIT_SCRIPT)));
                    }
                    if (initScript != null) {
                        newUserdata = B64.standard.encString((String)String.format("%s\n%s", ImagingServiceProperties.getCredentialsString(), ImagingServiceProperties.getWorkerUserData(NTP_SERVER, LOG_SERVER, LOG_SERVER_PORT, initScript)));
                    }
                    try {
                        EucalyptusActivityTasks.getInstance().createLaunchConfiguration(newEmi, newType, lc.getIamInstanceProfile(), tmpLaunchConfigName, (String)lc.getSecurityGroups().getMember().get(0), newKeyname, newUserdata);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Failed to create temporary launch config", (Throwable)ex);
                        throw new EucalyptusCloudException("failed to create temporary launch config", (Throwable)ex);
                    }
                    try {
                        EucalyptusActivityTasks.getInstance().updateAutoScalingGroup(asgName, null, asgType.getDesiredCapacity(), tmpLaunchConfigName);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Failed to update the autoscaling group", (Throwable)ex);
                        throw new EucalyptusCloudException("failed to update the autoscaling group", (Throwable)ex);
                    }
                    try {
                        EucalyptusActivityTasks.getInstance().deleteLaunchConfiguration(asgType.getLaunchConfigurationName());
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"unable to delete the old launch configuration", (Throwable)ex);
                    }
                    try {
                        EucalyptusActivityTasks.getInstance().createLaunchConfiguration(newEmi, newType, lc.getIamInstanceProfile(), asgType.getLaunchConfigurationName(), (String)lc.getSecurityGroups().getMember().get(0), newKeyname, newUserdata);
                    }
                    catch (Exception ex) {
                        throw new EucalyptusCloudException("unable to create the new launch config", (Throwable)ex);
                    }
                    try {
                        EucalyptusActivityTasks.getInstance().updateAutoScalingGroup(asgName, null, asgType.getDesiredCapacity(), asgType.getLaunchConfigurationName());
                    }
                    catch (Exception ex) {
                        throw new EucalyptusCloudException("failed to update the autoscaling group", (Throwable)ex);
                    }
                    try {
                        EucalyptusActivityTasks.getInstance().deleteLaunchConfiguration(tmpLaunchConfigName);
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"unable to delete the temporary launch configuration", (Throwable)ex);
                    }
                    try {
                        List<ImageDetails> images = EucalyptusActivityTasks.getInstance().describeImages(Lists.newArrayList((Object[])new String[]{emi}), false);
                        for (ResourceTag tag : images.get(0).getTagSet()) {
                            EucalyptusActivityTasks.getInstance().createOrUpdateAutoscalingTags(tag.getKey(), tag.getValue(), asgName);
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"unable to propogate tags from image to ASG", (Throwable)ex);
                    }
                    LOG.debug((Object)String.format("autoscaling group '%s' was updated", asgName));
                }
                catch (EucalyptusCloudException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new EucalyptusCloudException("Unable to update the autoscaling group", (Throwable)ex);
                }
            }
        }
    }

    public static List<String> listConfiguredZones() throws Exception {
        if (configuredZones.size() <= 0) {
            ArrayList allZones = Lists.newArrayList();
            try {
                List<ClusterInfoType> clusters = EucalyptusActivityTasks.getInstance().describeAvailabilityZones(false);
                for (ClusterInfoType c : clusters) {
                    allZones.add(c.getZoneName());
                }
            }
            catch (Exception ex) {
                throw new Exception("failed to lookup availability zones", ex);
            }
            if (AVAILABILITY_ZONES != null && AVAILABILITY_ZONES.length() > 0) {
                if (AVAILABILITY_ZONES.contains(",")) {
                    String[] tokens;
                    for (String zone : tokens = AVAILABILITY_ZONES.split(",")) {
                        if (!allZones.contains(zone)) continue;
                        configuredZones.add(zone);
                    }
                } else if (allZones.contains(AVAILABILITY_ZONES)) {
                    configuredZones.add(AVAILABILITY_ZONES);
                }
            } else {
                configuredZones.addAll(allZones);
            }
        }
        return Lists.newArrayList(configuredZones);
    }

    public static class VmExpirationDaysChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                int newExp = Integer.parseInt(newValue);
                if (newExp <= 0) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                throw new ConfigurablePropertyException("The value must be number type and bigger than 0");
            }
        }
    }

    public static class NTPServerChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                if (newValue instanceof String) {
                    if (newValue.contains(",")) {
                        String[] addresses = newValue.split(",");
                        if (addresses.length - 1 != StringUtils.countOccurrencesOf((String)newValue, (String)",")) {
                            throw new EucalyptusCloudException("Invalid address");
                        }
                        for (String address : addresses) {
                            if (HostSpecifier.isValid((String)String.format("%s.com", address))) continue;
                            throw new EucalyptusCloudException("Invalid address");
                        }
                    } else {
                        String address = newValue;
                        if (address != null && !address.equals("") && !HostSpecifier.isValid((String)String.format("%s.com", address))) {
                            throw new EucalyptusCloudException("Invalid address");
                        }
                    }
                } else {
                    throw new EucalyptusCloudException("Address is not string type");
                }
                ImagingServiceProperties.onPropertyChange(null, null, null, newValue, null, null, null);
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change ntp server address", (Throwable)e);
            }
        }
    }

    public static class KeyNameChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                if (newValue instanceof String && t.getValue() != null && !t.getValue().equals(newValue)) {
                    ImagingServiceProperties.onPropertyChange(null, null, (String)newValue, null, null, null, null);
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change key name", (Throwable)e);
            }
        }
    }

    public static class InstanceTypeChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                if (newValue instanceof String) {
                    if (newValue == null || ((String)newValue).equals("")) {
                        throw new EucalyptusCloudException("Instance type cannot be unset");
                    }
                    if (t.getValue() != null && !t.getValue().equals(newValue)) {
                        ImagingServiceProperties.onPropertyChange(null, (String)newValue, null, null, null, null, null);
                    }
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change instance type", (Throwable)e);
            }
        }
    }

    public static class EmiChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                if (t.getValue() != null && !t.getValue().equals(newValue) && newValue.length() > 0) {
                    ImagingServiceProperties.onPropertyChange(newValue, null, null, null, null, null, null);
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change EMI ID", (Throwable)e);
            }
        }
    }

    public static class InitScriptChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                if (t.getValue() != null && !t.getValue().equals(newValue)) {
                    ImagingServiceProperties.onPropertyChange(null, null, null, null, null, null, newValue);
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change init script", (Throwable)e);
            }
        }
    }

    public static class LogServerPortChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                Integer.parseInt(newValue);
                if (t.getValue() != null && !t.getValue().equals(newValue) && newValue.length() > 0) {
                    ImagingServiceProperties.onPropertyChange(null, null, null, null, null, newValue, null);
                }
            }
            catch (NumberFormatException ex) {
                throw new ConfigurablePropertyException("Invalid number");
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change log server port to " + newValue, (Throwable)e);
            }
        }
    }

    public static class LogServerAddressChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValue) throws ConfigurablePropertyException {
            try {
                InetAddress.getByName(newValue);
                if (t.getValue() != null && !t.getValue().equals(newValue) && newValue.length() > 0) {
                    ImagingServiceProperties.onPropertyChange(null, null, null, null, newValue, null, null);
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Could not change log server to " + newValue, (Throwable)e);
            }
        }
    }

    public static class AvailabilityZonesChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                String zones = (String)newValue;
                if (zones.length() == 0) {
                    return;
                }
                ArrayList availabilityZones = Lists.newArrayList();
                if (zones.contains(",")) {
                    String[] tokens = zones.split(",");
                    if (tokens.length - 1 != StringUtils.countOccurrencesOf((String)zones, (String)",")) {
                        throw new EucalyptusCloudException("Invalid availability zones");
                    }
                    for (String zone : tokens) {
                        availabilityZones.add(zone);
                    }
                } else {
                    availabilityZones.add(zones);
                }
                try {
                    List<ClusterInfoType> clusters = EucalyptusActivityTasks.getInstance().describeAvailabilityZones(false);
                    ArrayList clusterNames = Lists.newArrayList();
                    for (ClusterInfoType cluster : clusters) {
                        clusterNames.add(cluster.getZoneName());
                    }
                    for (String zone : availabilityZones) {
                        if (clusterNames.contains(zone)) continue;
                        throw new ConfigurablePropertyException(zone + " is not found in availability zones");
                    }
                }
                catch (Exception ex) {
                    throw new ConfigurablePropertyException("Faield to check availability zones", (Throwable)ex);
                }
            }
            catch (ConfigurablePropertyException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ConfigurablePropertyException("Failed to check availability zones", (Throwable)ex);
            }
        }
    }

    @Provides(value=ImagingBackend.class)
    @RunDuring(value=Bootstrap.Stage.Final)
    @DependsLocal(value={ImagingBackend.class})
    public static class ImagingBackendServicePropertyBootstrapper
    extends Bootstrapper.Simple {
        private static ImagingBackendServicePropertyBootstrapper singleton;
        private static final Callable<String> imageNotConfiguredFaultRunnable;
        private static int CheckCounter;
        private static boolean EmiCheckResult;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Bootstrapper getInstance() {
            Class<ImagingBackendServicePropertyBootstrapper> clazz = ImagingBackendServicePropertyBootstrapper.class;
            synchronized (ImagingBackendServicePropertyBootstrapper.class) {
                if (singleton == null) {
                    singleton = new ImagingBackendServicePropertyBootstrapper();
                    LOG.info((Object)"Creating Imaging Bootstrapper instance.");
                } else {
                    LOG.debug((Object)"Returning Imaging Balancing Bootstrapper instance.");
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return singleton;
            }
        }

        public boolean check() throws Exception {
            if (CloudMetadatas.isMachineImageIdentifier((String)IMAGE)) {
                if (CheckCounter >= 3 && Topology.isEnabled(Eucalyptus.class)) {
                    try {
                        List<ImageDetails> emis = EucalyptusActivityTasks.getInstance().describeImages(Lists.newArrayList((Object[])new String[]{IMAGE}), false);
                        EmiCheckResult = IMAGE.equals(emis.get(0).getImageId());
                    }
                    catch (Exception ex) {
                        EmiCheckResult = false;
                    }
                    CheckCounter = 0;
                } else {
                    ++CheckCounter;
                }
                return EmiCheckResult;
            }
            try {
                ServiceConfiguration localService = Components.lookup(ImagingBackend.class).getLocalServiceConfiguration();
                Faults.CheckException ex = Faults.failure((ServiceConfiguration)localService, (String[])new String[]{imageNotConfiguredFaultRunnable.call().split("\n")[1]});
                Faults.submit((ServiceConfiguration)localService, (TransitionRecord)localService.lookupStateMachine().getTransitionRecord(), (Faults.CheckException)ex);
            }
            catch (Exception e) {
                LOG.debug((Object)e);
            }
            return false;
        }

        public boolean enable() throws Exception {
            return super.enable();
        }

        static {
            imageNotConfiguredFaultRunnable = Faults.forComponent(ImagingBackend.class).havingId(1015).logOnFirstRun();
            CheckCounter = 0;
            EmiCheckResult = true;
        }
    }
}

