/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.postgresql;

import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.Database;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.util.SSLSocketFactoryWrapper;
import com.eucalyptus.crypto.util.SimpleClientX509TrustManager;
import com.eucalyptus.crypto.util.SslUtils;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class PostgreSQLSSLSocketFactory
extends SSLSocketFactoryWrapper {
    private static final String PROP_POSTGRESQL_SSL_PROVIDER = "com.eucalyptus.postgresql.sslProvider";
    private static final String PROP_POSTGRESQL_SSL_PROTOCOL = "com.eucalyptus.postgresql.sslProtocol";
    private static final String PROP_POSTGRESQL_SSL_CIPHER_SUITES = "com.eucalyptus.postgresql.sslCipherSuites";
    private static final String DEFAULT_CIPHER_STRINGS = "RSA+AES:+SHA:!EXPORT:!EXPORT1025:!MD5";
    private static final String DEFAULT_PROTOCOL = "TLS";
    private final List<String> cipherSuites = ImmutableList.copyOf((Object[])SslUtils.getEnabledCipherSuites((String)PostgreSQLSSLSocketFactory.getCipherStrings(), (String[])this.getSupportedCipherSuites()));

    public PostgreSQLSSLSocketFactory() {
        super(Suppliers.ofInstance((Object)PostgreSQLSSLSocketFactory.buildDelegate()));
    }

    protected Socket notifyCreated(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            sslSocket.setEnabledCipherSuites((String[])Iterables.toArray(this.cipherSuites, String.class));
        }
        return socket;
    }

    private static String getCipherStrings() {
        return System.getProperty(PROP_POSTGRESQL_SSL_CIPHER_SUITES, DEFAULT_CIPHER_STRINGS);
    }

    private static SSLSocketFactory buildDelegate() {
        String provider = System.getProperty(PROP_POSTGRESQL_SSL_PROVIDER);
        String protocol = System.getProperty(PROP_POSTGRESQL_SSL_PROTOCOL, DEFAULT_PROTOCOL);
        try {
            SSLContext sslContext = provider != null ? SSLContext.getInstance(protocol, provider) : SSLContext.getInstance(protocol);
            SimpleClientX509TrustManager trustManager = new SimpleClientX509TrustManager(SystemCredentials.lookup(Database.class).getCertificate(), false);
            sslContext.init(null, new TrustManager[]{trustManager}, (SecureRandom)Crypto.getSecureRandomSupplier().get());
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (KeyManagementException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (NoSuchProviderException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

