/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.loadbalancing.service;

import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.ServiceDispatchException;
import com.eucalyptus.loadbalancing.common.LoadBalancingBackend;
import com.eucalyptus.loadbalancing.common.backend.msgs.LoadBalancingBackendMessage;
import com.eucalyptus.loadbalancing.common.backend.msgs.LoadBalancingServoBackendMessage;
import com.eucalyptus.loadbalancing.common.msgs.LoadBalancingMessage;
import com.eucalyptus.loadbalancing.service.LoadBalancingAuthorizationException;
import com.eucalyptus.loadbalancing.service.LoadBalancingClientException;
import com.eucalyptus.loadbalancing.service.LoadBalancingException;
import com.eucalyptus.loadbalancing.service.LoadBalancingInvalidConfigurationException;
import com.eucalyptus.loadbalancing.service.LoadBalancingUnavailableException;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.FailedRequestException;
import com.eucalyptus.ws.EucalyptusRemoteFault;
import com.eucalyptus.ws.EucalyptusWebServiceException;
import com.eucalyptus.ws.Role;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.BaseMessages;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.mule.component.ComponentException;

public class LoadBalancingService {
    public LoadBalancingMessage dispatchAction(LoadBalancingMessage request) throws EucalyptusCloudException {
        Context ctx = Contexts.lookup();
        AuthContextSupplier user = ctx.getAuthContext();
        if (!Permissions.perhapsAuthorized((String)"elasticloadbalancing", (String)RestrictedTypes.getIamActionByMessageType((BaseMessage)request), (AuthContextSupplier)user)) {
            throw new LoadBalancingAuthorizationException("UnauthorizedOperation", "You are not authorized to perform this operation.");
        }
        String error = (String)Iterables.getFirst(request.validate().values(), null);
        if (error != null) {
            throw new LoadBalancingClientException("InvalidConfigurationRequest", error);
        }
        try {
            LoadBalancingBackendMessage backendRequest = (LoadBalancingBackendMessage)BaseMessages.deepCopy((BaseMessage)request, (Class)LoadBalancingService.getBackendMessageClass((BaseMessage)request));
            if (backendRequest instanceof LoadBalancingServoBackendMessage) {
                LoadBalancingServoBackendMessage servoOut = (LoadBalancingServoBackendMessage)backendRequest;
                InetSocketAddress remoteAddr = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
                String remoteHost = remoteAddr.getAddress().getHostAddress();
                servoOut.setSourceIp(remoteHost);
            }
            BaseMessage backendResponse = LoadBalancingService.send(backendRequest);
            LoadBalancingMessage response = (LoadBalancingMessage)BaseMessages.deepCopy((BaseMessage)backendResponse, request.getReply().getClass());
            response.setCorrelationId(request.getCorrelationId());
            return response;
        }
        catch (Exception e) {
            this.handleRemoteException(e);
            Exceptions.findAndRethrow((Throwable)e, EucalyptusWebServiceException.class, EucalyptusCloudException.class);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    private static Class getBackendMessageClass(BaseMessage request) throws ClassNotFoundException {
        return Class.forName(request.getClass().getName().replace(".common.msgs.", ".common.backend.msgs."));
    }

    private static BaseMessage send(LoadBalancingBackendMessage request) throws Exception {
        try {
            return AsyncRequests.sendSyncWithCurrentIdentity((ServiceConfiguration)Topology.lookup(LoadBalancingBackend.class, (Partition[])new Partition[0]), (BaseMessage)((BaseMessage)request));
        }
        catch (NoSuchElementException e) {
            throw new LoadBalancingUnavailableException("Service Unavailable");
        }
        catch (ServiceDispatchException e) {
            ComponentException componentException = (ComponentException)Exceptions.findCause((Throwable)e, ComponentException.class);
            if (componentException != null && componentException.getCause() instanceof Exception) {
                throw (Exception)componentException.getCause();
            }
            throw e;
        }
        catch (FailedRequestException e) {
            if (((BaseMessage)request).getReply().getClass().isInstance(e.getRequest())) {
                return e.getRequest();
            }
            throw e.getRequest() == null ? e : new LoadBalancingException("InternalError", Role.Receiver, "Internal error " + e.getRequest().getClass().getSimpleName() + ":false");
        }
    }

    private void handleRemoteException(Exception e) throws EucalyptusCloudException {
        EucalyptusRemoteFault remoteFault = (EucalyptusRemoteFault)Exceptions.findCause((Throwable)e, EucalyptusRemoteFault.class);
        if (remoteFault != null) {
            HttpResponseStatus status = (HttpResponseStatus)Objects.firstNonNull((Object)remoteFault.getStatus(), (Object)HttpResponseStatus.INTERNAL_SERVER_ERROR);
            String code = remoteFault.getFaultCode();
            String message = remoteFault.getFaultDetail();
            switch (status.getCode()) {
                case 400: {
                    throw new LoadBalancingClientException(code, message);
                }
                case 403: {
                    throw new LoadBalancingAuthorizationException(code, message);
                }
                case 409: {
                    throw new LoadBalancingInvalidConfigurationException(code, message);
                }
                case 503: {
                    throw new LoadBalancingUnavailableException(message);
                }
            }
            throw new LoadBalancingException(code, Role.Receiver, message);
        }
    }
}

