/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.objectstorage.providers.walrus;

import com.amazonaws.auth.BasicAWSCredentials;
import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.context.ServiceDispatchException;
import com.eucalyptus.objectstorage.exceptions.ObjectStorageException;
import com.eucalyptus.objectstorage.exceptions.s3.AccessDeniedException;
import com.eucalyptus.objectstorage.exceptions.s3.BucketNotEmptyException;
import com.eucalyptus.objectstorage.exceptions.s3.InternalErrorException;
import com.eucalyptus.objectstorage.exceptions.s3.NoSuchBucketException;
import com.eucalyptus.objectstorage.exceptions.s3.NoSuchKeyException;
import com.eucalyptus.objectstorage.exceptions.s3.NotImplementedException;
import com.eucalyptus.objectstorage.exceptions.s3.PreconditionFailedException;
import com.eucalyptus.objectstorage.exceptions.s3.S3Exception;
import com.eucalyptus.objectstorage.msgs.AbortMultipartUploadResponseType;
import com.eucalyptus.objectstorage.msgs.AbortMultipartUploadType;
import com.eucalyptus.objectstorage.msgs.CompleteMultipartUploadResponseType;
import com.eucalyptus.objectstorage.msgs.CompleteMultipartUploadType;
import com.eucalyptus.objectstorage.msgs.CopyObjectResponseType;
import com.eucalyptus.objectstorage.msgs.CreateBucketResponseType;
import com.eucalyptus.objectstorage.msgs.DeleteObjectResponseType;
import com.eucalyptus.objectstorage.msgs.DeleteObjectType;
import com.eucalyptus.objectstorage.msgs.DeleteVersionResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketAccessControlPolicyResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketLocationResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketLoggingStatusResponseType;
import com.eucalyptus.objectstorage.msgs.GetBucketLoggingStatusType;
import com.eucalyptus.objectstorage.msgs.GetBucketVersioningStatusType;
import com.eucalyptus.objectstorage.msgs.HeadBucketResponseType;
import com.eucalyptus.objectstorage.msgs.InitiateMultipartUploadResponseType;
import com.eucalyptus.objectstorage.msgs.InitiateMultipartUploadType;
import com.eucalyptus.objectstorage.msgs.ListAllMyBucketsResponseType;
import com.eucalyptus.objectstorage.msgs.ListVersionsType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataRequestType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageDataResponseType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageRequestType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageResponseType;
import com.eucalyptus.objectstorage.msgs.PostObjectResponseType;
import com.eucalyptus.objectstorage.msgs.PostObjectType;
import com.eucalyptus.objectstorage.msgs.SetBucketAccessControlPolicyResponseType;
import com.eucalyptus.objectstorage.msgs.SetBucketAccessControlPolicyType;
import com.eucalyptus.objectstorage.msgs.SetBucketLoggingStatusResponseType;
import com.eucalyptus.objectstorage.msgs.SetObjectAccessControlPolicyResponseType;
import com.eucalyptus.objectstorage.msgs.SetObjectAccessControlPolicyType;
import com.eucalyptus.objectstorage.providers.ObjectStorageProviders;
import com.eucalyptus.objectstorage.providers.s3.S3ProviderClient;
import com.eucalyptus.objectstorage.providers.walrus.MessageMapper;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.SynchronousClient;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.walrus.WalrusBackend;
import com.eucalyptus.walrus.exceptions.WalrusException;
import com.eucalyptus.walrus.msgs.CopyObjectType;
import com.eucalyptus.walrus.msgs.CreateBucketType;
import com.eucalyptus.walrus.msgs.DeleteBucketResponseType;
import com.eucalyptus.walrus.msgs.DeleteBucketType;
import com.eucalyptus.walrus.msgs.DeleteVersionType;
import com.eucalyptus.walrus.msgs.GetBucketAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.GetBucketLocationType;
import com.eucalyptus.walrus.msgs.GetBucketVersioningStatusResponseType;
import com.eucalyptus.walrus.msgs.GetObjectAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.GetObjectAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.HeadBucketType;
import com.eucalyptus.walrus.msgs.ListAllMyBucketsType;
import com.eucalyptus.walrus.msgs.ListBucketResponseType;
import com.eucalyptus.walrus.msgs.ListBucketType;
import com.eucalyptus.walrus.msgs.ListVersionsResponseType;
import com.eucalyptus.walrus.msgs.SetBucketLoggingStatusType;
import com.eucalyptus.walrus.msgs.SetBucketVersioningStatusResponseType;
import com.eucalyptus.walrus.msgs.SetBucketVersioningStatusType;
import com.eucalyptus.walrus.msgs.SetRESTBucketAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetRESTBucketAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.SetRESTObjectAccessControlPolicyResponseType;
import com.eucalyptus.walrus.msgs.SetRESTObjectAccessControlPolicyType;
import com.eucalyptus.walrus.msgs.WalrusDataRequestType;
import com.eucalyptus.walrus.msgs.WalrusDataResponseType;
import com.eucalyptus.walrus.msgs.WalrusRequestType;
import com.eucalyptus.walrus.msgs.WalrusResponseType;
import com.eucalyptus.ws.EucalyptusRemoteFault;
import com.google.common.base.Objects;
import java.net.URI;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

@ObjectStorageProviders.ObjectStorageProviderClientProperty(value="walrus")
public class WalrusProviderClient
extends S3ProviderClient {
    private static Logger LOG = Logger.getLogger(WalrusProviderClient.class);
    private static User systemAdmin = null;

    @Override
    protected URI getUpstreamEndpoint() {
        return Topology.lookup(WalrusBackend.class, (Partition[])new Partition[0]).getUri();
    }

    @Override
    protected boolean doUsePathStyle() {
        return true;
    }

    @Override
    public void initialize() throws EucalyptusCloudException {
        super.initialize();
        try {
            systemAdmin = Accounts.lookupSystemAdmin();
        }
        catch (AuthException e) {
            LOG.error((Object)"Failed to lookup system admin account. Cannot initialize Walrus provider client.", (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    @Override
    public void check() throws EucalyptusCloudException {
        if (Topology.lookup(WalrusBackend.class, (Partition[])new Partition[0]) == null) {
            throw new EucalyptusCloudException("No ENABLED WalrusBackend found. Cannot initialize fully.");
        }
        super.check();
    }

    protected WalrusClient getEnabledWalrusClient() throws ObjectStorageException {
        try {
            WalrusClient c = new WalrusClient();
            c.init();
            return c;
        }
        catch (SynchronousClient.SynchronousClientException e) {
            LOG.error((Object)"Error initializing client for walrus pass-thru", (Throwable)e);
            throw new ObjectStorageException("Could not initialize walrus client");
        }
    }

    @Override
    protected BasicAWSCredentials mapCredentials(User requestUser) throws AuthException, IllegalArgumentException {
        List eucaAdminKeys = systemAdmin.getKeys();
        if (eucaAdminKeys != null && eucaAdminKeys.size() > 0) {
            return new BasicAWSCredentials(((AccessKey)eucaAdminKeys.get(0)).getAccessKey(), ((AccessKey)eucaAdminKeys.get(0)).getSecretKey());
        }
        LOG.error((Object)("No key found for user " + requestUser.getUserId() + " . Cannot map credentials for call to WalrusBackend backend for data operation"));
        throw new AuthException("No access key found for backend call to WalrusBackend for UserId: " + requestUser.getUserId());
    }

    private <ObjResp extends ObjectStorageResponseType, ObjReq extends ObjectStorageRequestType, WalResp extends WalrusResponseType, WalReq extends WalrusRequestType> ObjResp proxyRequest(ObjReq request, Class<WalReq> walrusRequestClass, Class<WalResp> walrusResponseClass) throws EucalyptusCloudException {
        Object osge;
        block6: {
            osge = null;
            try {
                WalrusClient c = this.getEnabledWalrusClient();
                WalReq walrusRequest = MessageMapper.INSTANCE.proxyWalrusRequest(walrusRequestClass, request);
                Object walrusResponse = c.sendSyncA(walrusRequest);
                Object reply = MessageMapper.INSTANCE.proxyWalrusResponse(request, walrusResponse);
                return (ObjResp)reply;
            }
            catch (ServiceDispatchException e) {
                Throwable rootCause = e.getRootCause();
                if (rootCause == null) break block6;
                if (rootCause instanceof WalrusException) {
                    osge = MessageMapper.INSTANCE.proxyWalrusException((WalrusException)rootCause);
                }
                throw new EucalyptusCloudException(rootCause);
            }
            catch (Exception e) {
                EucalyptusRemoteFault remoteFault = (EucalyptusRemoteFault)Exceptions.findCause((Throwable)e, EucalyptusRemoteFault.class);
                if (remoteFault != null) {
                    WalrusProviderClient.handleRemoteFault(remoteFault);
                }
                throw new EucalyptusCloudException((Throwable)e);
            }
        }
        if (osge != null) {
            throw osge;
        }
        throw new EucalyptusCloudException("Unable to obtain reply from dispatcher.");
    }

    private static S3Exception mapWalrusExceptionToS3Exception(EucalyptusCloudException ex) {
        if (ex instanceof S3Exception) {
            return (S3Exception)((Object)ex);
        }
        LOG.debug((Object)"Mapping exception from Walrus to 500-InternalError", (Throwable)ex);
        InternalErrorException s3Ex = new InternalErrorException();
        s3Ex.initCause((Throwable)ex);
        return s3Ex;
    }

    private <ObjResp extends ObjectStorageDataResponseType, ObjReq extends ObjectStorageDataRequestType, WalResp extends WalrusDataResponseType, WalReq extends WalrusDataRequestType> ObjResp proxyDataRequest(ObjReq request, Class<WalReq> walrusRequestClass, Class<WalResp> walrusResponseClass) throws EucalyptusCloudException {
        Object osge;
        block6: {
            osge = null;
            try {
                WalrusClient c = this.getEnabledWalrusClient();
                WalReq walrusRequest = MessageMapper.INSTANCE.proxyWalrusDataRequest(walrusRequestClass, request);
                Object walrusResponse = c.sendSyncADataReq(walrusRequest);
                Object reply = MessageMapper.INSTANCE.proxyWalrusDataResponse(request, walrusResponse);
                return (ObjResp)reply;
            }
            catch (ServiceDispatchException e) {
                Throwable rootCause = e.getRootCause();
                if (rootCause == null) break block6;
                if (rootCause instanceof WalrusException) {
                    osge = MessageMapper.INSTANCE.proxyWalrusException((WalrusException)rootCause);
                }
                throw new EucalyptusCloudException(rootCause);
            }
            catch (Exception e) {
                EucalyptusRemoteFault remoteFault = (EucalyptusRemoteFault)Exceptions.findCause((Throwable)e, EucalyptusRemoteFault.class);
                if (remoteFault != null) {
                    WalrusProviderClient.handleRemoteFault(remoteFault);
                }
                throw new EucalyptusCloudException((Throwable)e);
            }
        }
        if (osge != null) {
            throw osge;
        }
        throw new EucalyptusCloudException("Unable to obtain reply from dispatcher.");
    }

    protected static void handleRemoteFault(EucalyptusRemoteFault remoteFault) throws S3Exception {
        HttpResponseStatus status = (HttpResponseStatus)Objects.firstNonNull((Object)remoteFault.getStatus(), (Object)HttpResponseStatus.INTERNAL_SERVER_ERROR);
        String code = remoteFault.getFaultCode();
        String message = remoteFault.getFaultDetail();
        String exceptionType = remoteFault.getFaultString();
        if (HttpResponseStatus.NOT_ACCEPTABLE.equals((Object)status)) {
            if (exceptionType.contains("BucketNotEmpty")) {
                throw new BucketNotEmptyException(message);
            }
            if (exceptionType.contains("NoSuchBucket")) {
                throw new NoSuchBucketException(message);
            }
            if (exceptionType.contains("NoSuchKey")) {
                throw new NoSuchKeyException(message);
            }
            if (exceptionType.contains("AccessDenied")) {
                throw new AccessDeniedException(message);
            }
            throw new InternalErrorException(message);
        }
        if (HttpResponseStatus.CONFLICT.equals((Object)status)) {
            throw new BucketNotEmptyException(message);
        }
        if (HttpResponseStatus.PRECONDITION_FAILED.equals((Object)status)) {
            throw new PreconditionFailedException(message);
        }
        if (HttpResponseStatus.FORBIDDEN.equals((Object)status)) {
            throw new AccessDeniedException(message);
        }
        if (HttpResponseStatus.NOT_FOUND.equals((Object)status)) {
            if (exceptionType.contains("Bucket")) {
                throw new NoSuchBucketException(message);
            }
            if (exceptionType.contains("Key")) {
                throw new NoSuchKeyException(message);
            }
        }
        throw new S3Exception(code, message, status);
    }

    @Override
    public ListAllMyBucketsResponseType listAllMyBuckets(com.eucalyptus.objectstorage.msgs.ListAllMyBucketsType request) throws S3Exception {
        try {
            return (ListAllMyBucketsResponseType)this.proxyRequest(request, ListAllMyBucketsType.class, com.eucalyptus.walrus.msgs.ListAllMyBucketsResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public CreateBucketResponseType createBucket(com.eucalyptus.objectstorage.msgs.CreateBucketType request) throws S3Exception {
        try {
            return (CreateBucketResponseType)this.proxyRequest(request, CreateBucketType.class, com.eucalyptus.walrus.msgs.CreateBucketResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public com.eucalyptus.objectstorage.msgs.DeleteBucketResponseType deleteBucket(com.eucalyptus.objectstorage.msgs.DeleteBucketType request) throws S3Exception {
        try {
            return (com.eucalyptus.objectstorage.msgs.DeleteBucketResponseType)this.proxyRequest(request, DeleteBucketType.class, DeleteBucketResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public HeadBucketResponseType headBucket(com.eucalyptus.objectstorage.msgs.HeadBucketType request) throws S3Exception {
        try {
            return (HeadBucketResponseType)this.proxyRequest(request, HeadBucketType.class, com.eucalyptus.walrus.msgs.HeadBucketResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public GetBucketAccessControlPolicyResponseType getBucketAccessControlPolicy(com.eucalyptus.objectstorage.msgs.GetBucketAccessControlPolicyType request) throws S3Exception {
        try {
            return (GetBucketAccessControlPolicyResponseType)this.proxyRequest(request, GetBucketAccessControlPolicyType.class, com.eucalyptus.walrus.msgs.GetBucketAccessControlPolicyResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public com.eucalyptus.objectstorage.msgs.ListBucketResponseType listBucket(com.eucalyptus.objectstorage.msgs.ListBucketType request) throws S3Exception {
        try {
            return (com.eucalyptus.objectstorage.msgs.ListBucketResponseType)this.proxyRequest(request, ListBucketType.class, ListBucketResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public SetBucketAccessControlPolicyResponseType setBucketAccessControlPolicy(SetBucketAccessControlPolicyType request) throws S3Exception {
        try {
            return (SetBucketAccessControlPolicyResponseType)this.proxyRequest(request, SetRESTBucketAccessControlPolicyType.class, SetRESTBucketAccessControlPolicyResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public GetBucketLocationResponseType getBucketLocation(com.eucalyptus.objectstorage.msgs.GetBucketLocationType request) throws S3Exception {
        try {
            return (GetBucketLocationResponseType)this.proxyRequest(request, GetBucketLocationType.class, com.eucalyptus.walrus.msgs.GetBucketLocationResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public SetBucketLoggingStatusResponseType setBucketLoggingStatus(com.eucalyptus.objectstorage.msgs.SetBucketLoggingStatusType request) throws S3Exception {
        try {
            return (SetBucketLoggingStatusResponseType)this.proxyRequest(request, SetBucketLoggingStatusType.class, com.eucalyptus.walrus.msgs.SetBucketLoggingStatusResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public GetBucketLoggingStatusResponseType getBucketLoggingStatus(GetBucketLoggingStatusType request) throws S3Exception {
        try {
            return (GetBucketLoggingStatusResponseType)this.proxyRequest(request, com.eucalyptus.walrus.msgs.GetBucketLoggingStatusType.class, com.eucalyptus.walrus.msgs.GetBucketLoggingStatusResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public com.eucalyptus.objectstorage.msgs.GetBucketVersioningStatusResponseType getBucketVersioningStatus(GetBucketVersioningStatusType request) throws S3Exception {
        try {
            return (com.eucalyptus.objectstorage.msgs.GetBucketVersioningStatusResponseType)this.proxyRequest(request, com.eucalyptus.walrus.msgs.GetBucketVersioningStatusType.class, GetBucketVersioningStatusResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public com.eucalyptus.objectstorage.msgs.SetBucketVersioningStatusResponseType setBucketVersioningStatus(com.eucalyptus.objectstorage.msgs.SetBucketVersioningStatusType request) throws S3Exception {
        try {
            return (com.eucalyptus.objectstorage.msgs.SetBucketVersioningStatusResponseType)this.proxyRequest(request, SetBucketVersioningStatusType.class, SetBucketVersioningStatusResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public com.eucalyptus.objectstorage.msgs.ListVersionsResponseType listVersions(ListVersionsType request) throws S3Exception {
        try {
            return (com.eucalyptus.objectstorage.msgs.ListVersionsResponseType)this.proxyRequest(request, com.eucalyptus.walrus.msgs.ListVersionsType.class, ListVersionsResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public DeleteVersionResponseType deleteVersion(com.eucalyptus.objectstorage.msgs.DeleteVersionType request) throws S3Exception {
        try {
            return (DeleteVersionResponseType)this.proxyRequest(request, DeleteVersionType.class, com.eucalyptus.walrus.msgs.DeleteVersionResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public PostObjectResponseType postObject(PostObjectType request) throws S3Exception {
        throw new NotImplementedException("PostObject");
    }

    @Override
    public CopyObjectResponseType copyObject(com.eucalyptus.objectstorage.msgs.CopyObjectType request) throws S3Exception {
        try {
            return (CopyObjectResponseType)this.proxyRequest(request, CopyObjectType.class, com.eucalyptus.walrus.msgs.CopyObjectResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public DeleteObjectResponseType deleteObject(DeleteObjectType request) throws S3Exception {
        try {
            DeleteObjectResponseType response = (DeleteObjectResponseType)this.proxyRequest(request, com.eucalyptus.walrus.msgs.DeleteObjectType.class, com.eucalyptus.walrus.msgs.DeleteObjectResponseType.class);
            if (response.getStatus() == null && response.getStatusMessage().equals("NO CONTENT")) {
                response.setStatus(HttpResponseStatus.NO_CONTENT);
            }
            return response;
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public com.eucalyptus.objectstorage.msgs.GetObjectAccessControlPolicyResponseType getObjectAccessControlPolicy(com.eucalyptus.objectstorage.msgs.GetObjectAccessControlPolicyType request) throws S3Exception {
        try {
            return (com.eucalyptus.objectstorage.msgs.GetObjectAccessControlPolicyResponseType)this.proxyRequest(request, GetObjectAccessControlPolicyType.class, GetObjectAccessControlPolicyResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public SetObjectAccessControlPolicyResponseType setObjectAccessControlPolicy(SetObjectAccessControlPolicyType request) throws S3Exception {
        try {
            return (SetObjectAccessControlPolicyResponseType)this.proxyRequest(request, SetRESTObjectAccessControlPolicyType.class, SetRESTObjectAccessControlPolicyResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public InitiateMultipartUploadResponseType initiateMultipartUpload(InitiateMultipartUploadType request) throws S3Exception {
        try {
            return (InitiateMultipartUploadResponseType)this.proxyDataRequest(request, com.eucalyptus.walrus.msgs.InitiateMultipartUploadType.class, com.eucalyptus.walrus.msgs.InitiateMultipartUploadResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public CompleteMultipartUploadResponseType completeMultipartUpload(CompleteMultipartUploadType request) throws S3Exception {
        try {
            return (CompleteMultipartUploadResponseType)this.proxyDataRequest(request, com.eucalyptus.walrus.msgs.CompleteMultipartUploadType.class, com.eucalyptus.walrus.msgs.CompleteMultipartUploadResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    @Override
    public AbortMultipartUploadResponseType abortMultipartUpload(AbortMultipartUploadType request) throws S3Exception {
        try {
            return (AbortMultipartUploadResponseType)this.proxyDataRequest(request, com.eucalyptus.walrus.msgs.AbortMultipartUploadType.class, com.eucalyptus.walrus.msgs.AbortMultipartUploadResponseType.class);
        }
        catch (EucalyptusCloudException e) {
            LOG.debug((Object)"Error response from WalrusBackend", (Throwable)e);
            throw WalrusProviderClient.mapWalrusExceptionToS3Exception(e);
        }
    }

    protected static class WalrusClient
    extends SynchronousClient<WalrusRequestType, WalrusBackend> {
        WalrusClient() {
            super(systemAdmin.getUserId(), WalrusBackend.class);
        }

        public <REQ extends WalrusRequestType, RES extends WalrusResponseType> RES sendSyncA(REQ request) throws Exception {
            request.setUser(systemAdmin);
            request.setUserId(systemAdmin.getUserId());
            return (RES)((WalrusResponseType)AsyncRequests.sendSync((ServiceConfiguration)this.configuration, request));
        }

        public <REQ extends WalrusDataRequestType, RES extends WalrusDataResponseType> RES sendSyncADataReq(REQ request) throws Exception {
            request.setUser(systemAdmin);
            request.setUserId(systemAdmin.getUserId());
            return (RES)((WalrusDataResponseType)AsyncRequests.sendSync((ServiceConfiguration)this.configuration, request));
        }
    }
}

